// mainDlg.cpp : implementation file
//

#include "stdafx.h"
#include "main.h"
#include "mainDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif




//////////////////     //////////////////
DWORD WINAPI HandleThreadRecv( LPVOID lparam )
{

	CMainDlg *dlg	= (CMainDlg *) lparam; //CWnd::FromHandle( HWND( lparam ) );
	HWND hWnd = dlg->m_hWnd;

	TRACE("Recv Thread ( from server ) start with %d port!\r\n", dlg->m_port );


	///@note     UPD  
	NLSocket *server	= new NLSocket();
	
	server->Create( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
	server->Bind( dlg->m_port );
	server->ChkErr();

	fd_set ReadSet;
	sockaddr_in remote_addr;
	int nRecv, nCount, addr_len;
	
	char *pRecvBuffer;
	
	memset( &ReadSet, 0, sizeof( ReadSet ) );
	TRACE("%d", MAX_UDP_BUFFER );


	///@note  ͸ Ѵ.
	while ( 1 ) {
		FD_ZERO( &ReadSet );
		FD_SET( server->m_socket, &ReadSet );
		nCount = select( server->m_socket + 1, &ReadSet, NULL, NULL, NULL );
		if ( nCount == 0 )					{ /** timeout */ }
		else if ( nCount == SOCKET_ERROR )	{ /** error */ }
		if ( ! ( FD_ISSET( server->m_socket, &ReadSet ) ) ) {
			/** error:  б ȣ ߻,    server->m_socket  ƴϴ. */
			TRACE("ERROR: FD_ISSET()");
		}
		addr_len = sizeof ( remote_addr );

		///@todo must be delete[]'ed after process.
		pRecvBuffer = new char[MAX_UDP_BUFFER];
		memset( pRecvBuffer, 0, sizeof( pRecvBuffer ) );
		nRecv	= recvfrom( server->m_socket, pRecvBuffer, MAX_UDP_BUFFER,
			0, (sockaddr *)&remote_addr, &addr_len );

		if ( nRecv == SOCKET_ERROR || nRecv < PACKET_DATA_HEADER_SIZE ) {
			//  Ȳ
			server->ChkErr();
			TRACE("ERROR:: SOCKET_ERROR or may be ...");
		}

		PACKET_DATA *packet = (PACKET_DATA *) pRecvBuffer;

		// ޼ 
		::SendMessage( hWnd, WM_RECVFROMSVR, (WPARAM) pRecvBuffer, nRecv );
	}
	return 0;
}










/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainDlg dialog

CMainDlg::CMainDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMainDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainDlg)
	m_ID = _T("");
	m_PW = _T("");
	m_Name = _T("");
	m_Mail = _T("");
	m_Out = _T("");
	m_IP = _T("");
	m_NewPW = _T("");
	m_Port = _T("");
	m_Chat = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMainDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlg)
	DDX_Text(pDX, IDC_ID, m_ID);
	DDX_Text(pDX, IDC_PW, m_PW);
	DDX_Text(pDX, IDC_ID2, m_Name);
	DDX_Text(pDX, IDC_MAIL, m_Mail);
	DDX_Text(pDX, IDC_OUTPUT, m_Out);
	DDX_Text(pDX, IDC_EDIT1, m_IP);
	DDX_Text(pDX, IDC_EDIT2, m_NewPW);
	DDX_Text(pDX, IDC_ID3, m_Port);
	DDX_Text(pDX, IDC_EDIT3, m_Chat);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMainDlg, CDialog)
	//{{AFX_MSG_MAP(CMainDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_MESSAGE(WM_RECVFROMSVR, OnRecvFromServer)
	ON_BN_CLICKED(IDC_LOGIN, OnLogin)
	ON_BN_CLICKED(IDC_SIGNUP, OnSignup)
	ON_BN_CLICKED(IDC_CHECKSERVER, OnCheckserver)
	ON_BN_CLICKED(IDC_UNSIGN, OnUnsign)
	ON_BN_CLICKED(IDC_USERMODIFY, OnUsermodify)
	ON_BN_CLICKED(IDC_PORTCHANGE, OnPortchange)
	ON_BN_CLICKED(IDC_MsgToAll, OnMsgToAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainDlg message handlers

BOOL CMainDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here




	//  Ŷ ۽ 
	m_socket = new NLSocket();
	m_socket->Create( AF_INET, SOCK_DGRAM, IPPROTO_UDP );
	m_socket->ChkErr();

	// Ŭ̾Ʈ ǻ  
	char pHostName[64];
	gethostname( pHostName, sizeof( pHostName ) );
	hostent *pHostent = gethostbyname( pHostName );
	ZeroMemory( &m_addr_local, sizeof( m_addr_local ) );
	m_addr_local.sin_family	= AF_INET;
	m_addr_local.sin_port		= htons( UDP_CLIENT_RECV_PORT );
	CopyMemory( &m_addr_local.sin_addr, pHostent->h_addr, sizeof( in_addr ) );

	m_UserUniqNo = 0;
	
	// Ʈȣ. 缳 IP  , Ʈ 浹  IP   Ŭ  ش.
	// ׷, UDP  缳 IP     Ѵ.
	//@todo  ǻͿ  Ŭ̾Ʈ  ؽ ذؼ Ʈ ȣ Ѵ.
	m_port	= UDP_CLIENT_RECV_PORT + CheckPrivateIP( inet_ntoa( m_addr_local.sin_addr ) ) ;
	m_Port.Format("%d", m_port);


	m_Out.Format("My PORT: %d ", + m_port);
	UpdateData(FALSE);

	//   Ŷ  
	//   ϰ  ־Ѵ.
	

	
	m_thread_id;
	m_hThread = CreateThread(NULL, 0, HandleThreadRecv, this, 0, &m_thread_id);
	


	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMainDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMainDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMainDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}




LONG CMainDlg::OnRecvFromServer(WPARAM wParam, LPARAM lParam)
{
	UpdateData();
	

	LPVOID	lp	= (LPVOID) wParam;
	int		len	= (int) lParam;
	
	PACKET	packet;
	PACKET_DATA_MSGTOALL d;
	CString m;
	

	memcpy( &packet, lp, len );

	if ( packet.resultcode == packetrc::OK ) {
		// û .
		switch ( packet.command )
		{
		case packetcommand::LOGIN		:
			m_UserUniqNo = packet.useruniqno;
			AfxMessageBox("α OK! ");
			break;
		case packetcommand::SIGNUP		:
			AfxMessageBox("ȸ  OK! ");
			break;
		case packetcommand::UNSIGN		:
			AfxMessageBox("ȸ Ż OK! ");
			break;
		case packetcommand::PING		:
			m_Out = "PING OK! " + m_Out;
			break;
		case packetcommand::USERMOD		:
			AfxMessageBox("ȸ   OK! ");
			break;
		case packetcommand::MSGTOALL	:
			memcpy( &d, packet.data, sizeof ( packet.data ) );
			if ( packet.retvar == 0 ) {
				m_Out = "ü ޼  OK!\r\n" + m_Out;
				break;
			}
			m	= d.message;
			m	+= "\r\n";
			m_Out = m + m_Out;
			m.Format("%s(%s) %s", d.id, d.name, d.mail);
			m_Out = m + ": " + m_Out;
			break;
		default							:
			m_Out = "Ȯε ʴ  Ŷ   ߽ϴ.\r\n" + m_Out;
			break;
		}

		UpdateData(FALSE);

		return 0L;
	}


	CString errstr;
	switch ( packet.resultcode )
	{
	case packetrc::NO_USER		:
		errstr = "̵ Ʋϴ, Ǵ  ̵ ڸ ã  ϴ.";
		break;
	case packetrc::INVALID_PW		:
		errstr = "йȣ Ʋϴ.";
		break;
	case packetrc::INVALID_DATA	:
		errstr = "û Ŷ  κ ߸Ǿϴ.";
		break;
	case packetrc::USER_ID_EXIST		:
		errstr = " ̵ ڰ մϴ.";
		break;
	case packetrc::DATABASE_IO_ERROR	:
		errstr = " ͺ̽ ó  ߻߽ϴ.";
		break;
	default			:
		errstr.Format("[%d]       ڵ带 ޾ҽϴ.", packet.resultcode );
		break;
	}

	//AfxMessageBox( errstr );
	m_Out = errstr + "\r\n" + m_Out;
	
	UpdateData(FALSE);


	delete []lp;
	lp = NULL;
	return 0L;
}

void CMainDlg::OnLogin() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	PACKET_DATA packet;
	packet.command		= packetcommand::LOGIN;
	packet.returnport	= m_port; // htons() ó  ʿ .
	packet.useruniqno	= m_UserUniqNo;
	PACKET_DATA_LOGIN login;

	
	packet.length = sizeof ( login );
	memcpy( login.id, m_ID, m_ID.GetLength() );
	memcpy( login.pw, m_PW, m_PW.GetLength() );
	memcpy( packet.data, &login, sizeof( login ) );
	packet.length = sizeof (login);

	m_socket->SendTo( m_socket->m_socket, &packet, PACKET_DATA_HEADER_SIZE + sizeof( login ),
		m_IP, UDP_SERVER_RECV_PORT );
}

void CMainDlg::OnSignup() 
{
	// TODO: Add your control notification handler code here

	UpdateData();
	PACKET_DATA packet;
	packet.command		= packetcommand::SIGNUP;
	packet.returnport	= m_port;
	packet.useruniqno	= m_UserUniqNo;
	PACKET_DATA_SIGNUP signup;

	

	packet.length = sizeof ( signup );
	memcpy( signup.id, m_ID, m_ID.GetLength() );
	memcpy( signup.pw, m_PW, m_PW.GetLength() );
	memcpy( signup.name, m_Name, m_Name.GetLength() );
	memcpy( signup.mail, m_Mail, m_Mail.GetLength() );
	memcpy( packet.data, &signup, sizeof( signup ) );

	m_socket->SendTo( m_socket->m_socket, &packet, PACKET_DATA_HEADER_SIZE + sizeof( signup ),
		m_IP, UDP_SERVER_RECV_PORT );

}



void CMainDlg::OnCheckserver() 
{
	// TODO: Add your control notification handler code here

	UpdateData();

	PACKET packet;
	packet.command		= packetcommand::PING;
	packet.returnport	= m_port;
	packet.useruniqno	= m_UserUniqNo;
	packet.retvar		= 0;
	m_socket->SendTo( m_socket->m_socket, (char *) &packet, PACKET_HEADER_SIZE,
		m_IP, UDP_SERVER_RECV_PORT );
}


/**
@param const char *p
	IP ּ ڿ̴.
@return	 IP 缳 IP̸ D Ŭ ڸ Ѵ. ⺻ Ʈȣ ؼ εѴ.

@note Ŭ  IP
	A CLASS		10.0.0.0 
	B CLASS		172.16.0.0 - 172.31.0.0 
	C CLASS		192.168.0.0 - 192.168.255.0 
*/
int CMainDlg::CheckPrivateIP( const char *p ) {

	if ( p == NULL ) return 0;

	CString ip=p;
	if ( ip.Left(3) != "10." && ip.Left(7) != "172.16." && ip.Left(7) != "192.168" ) {
		return 0;
	}
	int d		= atoi( ip.Right ( ip.GetLength() - ip.ReverseFind( '.' ) - 1 ) );
	return d;

}

void CMainDlg::OnUnsign() 
{
	// TODO: Add your control notification handler code here

	
	UpdateData();

	PACKET packet;
	PACKET_DATA_UNSIGN u;
	packet.command		= packetcommand::UNSIGN;
	packet.returnport	= m_port;
	packet.useruniqno	= m_UserUniqNo;
	memcpy( &u.id, (const char *)m_ID, m_ID.GetLength());
	memcpy( &u.pw, (const char *)m_PW, m_PW.GetLength());
	memcpy( &packet.data, &u, sizeof ( u ) );
	
	m_socket->SendTo( m_socket->m_socket, (char *) &packet
		, PACKET_HEADER_SIZE + sizeof( PACKET_DATA_UNSIGN )
		, m_IP, UDP_SERVER_RECV_PORT );
}

void CMainDlg::OnUsermodify() 
{
	// TODO: Add your control notification handler code here

	UpdateData();
	
	PACKET p;
	PACKET_DATA_USERMOD d;

	p.command		= packetcommand::USERMOD;
	p.returnport	= m_port;
	p.useruniqno	= m_UserUniqNo;
	memcpy( &d.id,		(const char *)m_ID,		m_ID.GetLength());
	memcpy( &d.pw,		(const char *)m_PW,		m_PW.GetLength());
	memcpy( &d.newpw,	(const char *)m_NewPW,	m_NewPW.GetLength());
	memcpy( &d.name,	(const char *)m_Name,	m_Name.GetLength());
	memcpy( &d.mail,	(const char *)m_Mail,	m_Mail.GetLength());

	memcpy( &p.data, &d, sizeof ( d ) );
	
	m_socket->SendTo( m_socket->m_socket, (char *) &p
		, PACKET_HEADER_SIZE + sizeof( d )
		, m_IP, UDP_SERVER_RECV_PORT );
}

void CMainDlg::OnPortchange() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	m_port = atoi(m_Port);

	TerminateThread( m_hThread, 0 );
	m_hThread = CreateThread(NULL, 0, HandleThreadRecv, this, 0, &m_thread_id);	
}

void CMainDlg::OnMsgToAll() 
{
	// TODO: Add your control notification handler code here
	
	UpdateData();

	PACKET p;
	PACKET_DATA_MSGTOALL d;

	p.command		= packetcommand::MSGTOALL;
	p.returnport	= m_port;
	p.useruniqno	= m_UserUniqNo;
	memcpy( &d.id,		(const char *)m_ID,		m_ID.GetLength());
	memcpy( &d.name,	(const char *)m_Name,	m_Name.GetLength());
	memcpy( &d.mail,	(const char *)m_Mail,	m_Mail.GetLength());
	memcpy( &d.message,	(const char *)m_Chat,	m_Chat.GetLength());

	memcpy( &p.data, &d, sizeof ( d ) );
	
	m_socket->SendTo( m_socket->m_socket, (char *) &p
		, PACKET_HEADER_SIZE + sizeof( d )
		, m_IP, UDP_SERVER_RECV_PORT );
}
