<?php
/**
 * Abstract Model Class (with PDO)
 *
 * @author kim tae il <tactful@phpkr.com>
 * @copyright Copyleft 2000-2007 PHPKR (http://www.phpkr.com)
 * @since 2007.10.04
 *
 * @filesource
 */
?>
<?php
/**
 * Model [Class]
 *
 * @author kim tae il <tactful@phpkr.com>
 * @version 1.0.0
 * @package base
 * @subpackage model
 * 
 * @example
 * # database
 * define('DBDSN', 'mysql:host=localhost;port=3306;dbname=testdb');
 * define('DBUSER', 'test');
 * define('DBPASS', 'testpw');
 * 
 * @link http://kr.php.net/manual/en/ref.pdo.php
 * @see PDO, PDOStatement
 */
abstract class Model {
	private $connector = null;
	private $entity = null;
	private $entities = array();

	public function __construct($entity = null, $connector = null) {
		$this->entity = is_null($entity) ? new BaseTestEntity() : $entity;
		$this->connector = is_null($connector) ? new PDO(DBDSN, DBUSER, DBPASS) : $connector;
	}
	
	public function retrieveAll() {}
	
	public function retrieveByPK($pk) {}
	
	public function searchFromEntity($entity) {}
	
	public function insertFromEntity($entity) {}
	
	public function editFromEntity($entity) {}
	
	public function deleteFromEntity($entity) {}
	
	public function deleteByPK($pk) {}
}
?>