#pragma once

#include "LVariableItem.h"

#include <list>
#include <stack>
using namespace std;

class LVarContainer
{
public:
	list<LVariableItem*> m_listVarItem;

	LVarContainer();
	~LVarContainer();

	bool PushVarItem(string& strName, int nType);
	bool PushVarItem(string& strName, int nType, long long llValue);
	bool PopVarItem();
	bool SetVarItem(string& strName, long long llValue);
	void Clear();
	LVariableItem* FindVarItem(string& strName);

};

LVarContainer::LVarContainer()
{
}

LVarContainer::~LVarContainer()
{
	Clear();
}

bool LVarContainer::PushVarItem(string& strName, int nType)
{
	list<LVariableItem*>::iterator it = m_listVarItem.begin();
	while( it != m_listVarItem.end() )
	{
		if( strName == (*it)->GetName() )
		{
			printf( "Error : Same name variable is already exist\n" );
			printf( "Variable Name : %s ", strName );
			//exit(-1);
			return false;
		}
	}

	m_listVarItem.push_front( new LVariableItem( strName, nType ) );
	return true;
}

bool LVarContainer::PushVarItem(string& strName, int nType, long long llValue)
{
	list<LVariableItem*>::iterator it = m_listVarItem.begin();
	while( it != m_listVarItem.end() )
	{
		if( strName == (*it)->GetName() )
		{
			printf( "Error : Same name variable is already exist\n" );
			printf( "Variable Name : %s ", strName );
			//exit(-1);
			return false;
		}
	}
	LVariableItem *pVarItem = new LVariableItem( strName, nType );
	pVarItem->SetValue( &llValue, nType );

	m_listVarItem.push_front( pVarItem );
	return true;
}

bool LVarContainer::PopVarItem()
{
	if( m_listVarItem.empty() == false )
	{
		delete ( m_listVarItem.front() );
		m_listVarItem.pop_front();
		return true;
	}
	return false;
}

bool LVarContainer::SetVarItem(string& strName, long long llValue)
{
	list<LVariableItem*>::iterator it = m_listVarItem.begin();
	while( it != m_listVarItem.end() )
	{
		if( strName == (*it)->GetName() )
		{
			(*it)->SetValue( &llValue, (*it)->GetType() );
			return true;
		}
	}

	return false;
}

void LVarContainer::Clear()
{
	while( m_listVarItem.empty() == false )
	{
		delete ( m_listVarItem.front() );
		m_listVarItem.pop_front();
	}
	m_listVarItem.clear();
}

LVariableItem* LVarContainer::FindVarItem(string& strName)
{
	list<LVariableItem*>::iterator it = m_listVarItem.begin();
	while( it != m_listVarItem.end() )
	{
		if( strName == (*it)->GetName() )
		{
			return (*it);
		}
	}
	return NULL;
}