// CheckReliability.cpp: implementation of the CCheckReliability class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "psat.h"
#include "CheckReliability.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define MEMBER_WIGHT		7
#define	GUEST_WIGHT			3
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCheckReliability::CCheckReliability()
{

}

CCheckReliability::~CCheckReliability()
{

}

int CCheckReliability::GetReliability( unsigned int nAccessCount, 
									  unsigned int nReportCount, 
									  unsigned int nMemberCount )
{
	if ( !nAccessCount )
	{
		return 50;
	}
	int nReliability;
	nReliability = 50 - ( nReportCount * 10 ) 
		+ MyRound( (double)( ( nAccessCount ) * 100 / ( 4 * nMemberCount * ( nReportCount + 1 ) ) ) );

	if ( nReliability < 0 )
	{
		return 0;
	}
	else if ( nReliability > 100 ) 
	{
		return 100;
	}
	return nReliability;
}

int CCheckReliability::GetTotalReliability( unsigned int nGestAccessCount, 
											unsigned int nGestReportCount, 
											unsigned int nMemberAccessCount, 
											unsigned int nMemberReportCount,
											unsigned int nMemberCount )
{
	return ( MEMBER_WIGHT * GetReliability( nMemberAccessCount, nMemberReportCount, nMemberCount ) +
		   GUEST_WIGHT * GetReliability( nGestAccessCount, nGestReportCount, nMemberCount ) )
		   / ( MEMBER_WIGHT + GUEST_WIGHT );	
}

int CCheckReliability::GetTotalReliability( int nMemberReliability, int nGuestReliability )
{
	return ( MEMBER_WIGHT * nMemberReliability + GUEST_WIGHT * nGuestReliability ) / ( MEMBER_WIGHT + GUEST_WIGHT );	
}


CString CCheckReliability::GetCombinedString( unsigned int nAccessCount, unsigned int nReportCount )
{
	char szTemp[15];
	memset ( szTemp, 0, sizeof ( szTemp ) );
	sprintf( szTemp, " %05d / %05d", nReportCount, nAccessCount );
	return (LPSTR)szTemp; 
}


int CCheckReliability::MyRound( double i )
{
	return floor ( i + 0.5 );
}
