// LoginDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PSAT.h"
#include <fstream>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLoginDlg dialog
#define FILE_PATH "C:\\WINDOWS\\system32\\psatdat.dat"
#define ONINIT_TIMER 1

CLoginDlg::CLoginDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CLoginDlg::IDD, pParent) , m_rtTitleBar ( 1, 1, 254, 25 )
{
	//{{AFX_DATA_INIT(CLoginDlg)
	m_strId = _T("");
	m_strPass = _T("");
	//}}AFX_DATA_INIT
	m_bFirst = TRUE;
}


void CLoginDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLoginDlg)
	DDX_Control(pDX, IDC_BUTTON_CLOSE, m_btnClose);
	DDX_Control(pDX, IDC_BUTTON_LOGIN, m_btnLoginUser);
	DDX_Control(pDX, IDC_BUTTON_GUEST, m_btnLoginGuest);
	DDX_Control(pDX, IDC_BUTTON_JOIN_MEMBER, m_btnJoinMember);
	DDX_Control(pDX, IDC_CHECK_RECORD_ID, m_btnIsReportId);
	DDX_Control(pDX, IDC_EDT_PASS, m_edtPass);
	DDX_Control(pDX, IDC_EDT_ID, m_edtId);
	DDX_Text(pDX, IDC_EDT_ID, m_strId);
	DDX_Text(pDX, IDC_EDT_PASS, m_strPass);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLoginDlg, CDialog)
	//{{AFX_MSG_MAP(CLoginDlg)
	ON_BN_CLICKED(IDC_BUTTON_GUEST, OnButtonGuest)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BUTTON_JOIN_MEMBER, OnButtonJoinMember)
	ON_BN_CLICKED(IDC_BUTTON_LOGIN, OnButtonLogin)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, OnButtonClose)
	ON_WM_PAINT()
	ON_WM_CTLCOLOR()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLoginDlg message handlers


BOOL CLoginDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 
	if ( m_bFirst ) 
	{
		m_bmBackground.LoadBitmap ( IDB_LOGINDLG_BACKGROUND );

		m_btnClose.LoadBitmaps ( IDB_SDLG_CLOSE_NORMAL , IDB_SDLG_CLOSE_CLICK , IDB_SDLG_CLOSE_OVER );
		m_btnLoginUser.LoadBitmaps ( IDB_LOGINDLG_BTN_CONNECT_NORMAL , IDB_LOGINDLG_BTN_CONNECT_CLICK , IDB_LOGINDLG_BTN_CONNECT_NORMAL );
		m_btnLoginGuest.LoadBitmaps ( IDB_LOGINDLG_BTN_GEUST_NORMAL , IDB_LOGINDLG_BTN_GUEST_CLICK , IDB_LOGINDLG_BTN_GEUST_NORMAL );
		m_btnJoinMember.LoadBitmaps ( IDB_LOGINDLG_BTN_JOIN_NORMAL , IDB_LOGINDLG_BTN_JOIN_CLICK , IDB_LOGINDLG_BTN_JOIN_CLICK );
		m_bFirst = FALSE;
	}

	m_btnClose.SetWindowPos ( NULL , 232, 5, 16, 16, NULL );
	m_btnLoginUser.SetWindowPos ( NULL , 33, 79, 85, 22, NULL );
	m_btnLoginGuest.SetWindowPos ( NULL , 140, 79, 85, 22, NULL );
	m_btnJoinMember.SetWindowPos ( NULL , 57, 107, 133, 12, NULL );
	m_edtPass.SetWindowText("");
	m_edtId.SetWindowText("");
	m_edtId.SetFocus();

	ifstream fin(FILE_PATH);
	if ( fin ) 
	{
		char szTempId[12];
		BOOL bCheck = FALSE;
		memset ( szTempId, 0, sizeof ( szTempId ) );

		fin >> bCheck;
		m_btnIsReportId.SetCheck( bCheck );

		if ( bCheck ) 
		{
			fin >> szTempId;
			m_edtId.SetWindowText( (LPSTR)szTempId );
			SetTimer( ONINIT_TIMER, 3, 0 );
		}
	}
	fin.close();

	SetWindowPos(NULL, m_ptPosition.x, m_ptPosition.y, 255, 125, NULL );

#ifdef _DEBUG
	m_edtId.SetWindowText( "1234" );
	m_edtPass.SetWindowText( "1234" );
	//OnButtonGuest();
#endif

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLoginDlg::OnButtonGuest()
{
	ofstream fout(FILE_PATH);

	m_strId = _T("guest");
	UpdateData ( FALSE );

	fout << "0";

	fout.close();

	CDialog::OnOK();
}

void CLoginDlg::OnTimer(UINT nIDEvent) 
{
	switch ( nIDEvent ) 
	{
	case ONINIT_TIMER : 
		KillTimer( ONINIT_TIMER );
		m_edtPass.SetFocus();
		break;
	}
	CDialog::OnTimer(nIDEvent);
}

void CLoginDlg::OnButtonJoinMember() 
{
	CPoint ptPosition; 
	WINDOWPLACEMENT WindowPlace;
	GetWindowPlacement( &WindowPlace );
	ptPosition.x = WindowPlace.rcNormalPosition.left;
	ptPosition.y = WindowPlace.rcNormalPosition.top;
	m_MemberJoinDlg.SetWindowPosition( ptPosition );

	if ( m_MemberJoinDlg.DoModal() == IDOK ) 
	{
		m_edtId.SetWindowText( m_MemberJoinDlg.m_strId );
		m_edtPass.SetFocus();
	}
}

void CLoginDlg::OnButtonLogin() 
{
	UpdateData(TRUE);

	if( m_strId == "" )
	{
		KMessageBox( "ID Էּ.", "α" );
		m_edtId.SetWindowText(_T(""));
		m_edtPass.SetWindowText(_T(""));
		m_edtId.SetFocus();
		return;
	}
	else if ( m_strId != "guest" && m_strPass == "" ) 
	{
		KMessageBox( "Password Էּ.", "α" );
		m_edtPass.SetWindowText(_T(""));
		m_edtPass.SetFocus();
		return;
	}

	ofstream fout(FILE_PATH);

	if ( m_btnIsReportId.GetCheck() ) 
	{
		fout << "1 " << (LPSTR)(LPCSTR)m_strId;
	}
	else 
	{
		fout << "0";
	}

	fout.close();
	CDialog::OnOK();
}

void CLoginDlg::OnButtonClose() 
{
	m_btnClose.m_bOver = 0;
	CDialog::OnCancel();	
}

void CLoginDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CLoginDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	if ( pOldBitmap != NULL ) 
	{
		cdc.SelectObject ( pOldBitmap );
	}
}

void CLoginDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 127;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 62;
}

HBRUSH CLoginDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	switch ( pWnd->GetDlgCtrlID() ) 
	{
	case IDC_CHECK_RECORD_ID :
		{
			pDC->SetBkMode ( TRANSPARENT );
			return (HBRUSH)(::GetStockObject( NULL_BRUSH ));
		}
	}
	return hbr;
}

void CLoginDlg::SetWnd(HWND hwnd)
{
	m_MemberJoinDlg.SetWnd( hwnd );
}

void CLoginDlg::SetSocket( CClientSocket* pClientSocket )
{
	m_MemberJoinDlg.SetSocket( pClientSocket );
}

void CLoginDlg::GiveJoinMemberAck ( int nResult )
{
	m_MemberJoinDlg.GiveJoinMemberAck ( nResult );
}

void CLoginDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		WINDOWPLACEMENT WindowPlace;
		GetWindowPlacement( &WindowPlace );
		m_ptWindowPosition.x = WindowPlace.rcNormalPosition.left;
		m_ptWindowPosition.y = WindowPlace.rcNormalPosition.top; 

		m_ptWindowMove.x = point.x;
		m_ptWindowMove.y = point.y;
		m_nMouseState = MOUSE_STATE_LDOWN;
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
		SetCapture();
	}	
	
	CDialog::OnLButtonDown(nFlags, point);
}

void CLoginDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if ( m_nMouseState == MOUSE_STATE_LDOWN ) 
	{
		m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
		m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
		SetWindowPos( NULL , m_ptWindowPosition.x, m_ptWindowPosition.y, 255, 125, NULL);
		m_nMouseState = MOUSE_STATE_NULL;
		m_ptWindowMove.x = 0;
		m_ptWindowMove.y = 0;
		ReleaseCapture();
	}
	
	CDialog::OnLButtonUp(nFlags, point);
}

void CLoginDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
	if ( m_rtTitleBar.PtInRect( point ) )
	{
		m_pCursor = IDC_SIZEALL;
		HCURSOR hCursor = LoadCursor ( NULL , m_pCursor );
		::SetCursor ( hCursor );
	}

	if ( m_nMouseState == MOUSE_STATE_LDOWN )
	{
		if ( !( ( m_ptWindowMove.x == point.x ) && ( m_ptWindowMove.y == point.y ) ) )
		{				
			m_ptWindowPosition.x += ( point.x - m_ptWindowMove.x );
			m_ptWindowPosition.y += ( point.y - m_ptWindowMove.y );
			MoveWindow( m_ptWindowPosition.x, m_ptWindowPosition.y, 255, 125 );
		}
	}

	CDialog::OnMouseMove(nFlags, point);
}

int	CLoginDlg::KMessageBox( CString strMessage, CString strTitle, UINT nType )
{
	KMessageBoxDlg dlg;
	CPoint ptPosition; 
	WINDOWPLACEMENT WindowPlace;
	GetWindowPlacement( &WindowPlace );
	ptPosition.x = WindowPlace.rcNormalPosition.left;
	ptPosition.y = WindowPlace.rcNormalPosition.top;
	dlg.SetWindowPosition( ptPosition );
	dlg.SetData( strMessage, strTitle, nType );

	return dlg.DoModal();
}
