// CheckSoftware.h: interface for the CCheckSoftware class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CHECKSOFTWARE_H__C2F47E25_D829_41AB_AAF3_602AEE4E0F60__INCLUDED_)
#define AFX_CHECKSOFTWARE_H__C2F47E25_D829_41AB_AAF3_602AEE4E0F60__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "SecureHash.h"
#include <list>

using namespace std;

template <typename T>
struct LessByPointedToValue : std::binary_function<T const *, T const *, bool>
{
	bool operator()(T const * x, T const * y) const
	{ 
		return *x < *y; 
//		return less<T>()(*x, *y); 
	}
};


class CSoftwareFileInfo
{
public:
	CSoftwareFileInfo()
	{
		memset ( this , 0x0 , sizeof ( *this ) );
	}

	~CSoftwareFileInfo()
	{
	}

	bool operator< ( const CSoftwareFileInfo& Info )
	{
		int nLengthA = strlen ( m_szFileName );
		int nLengthB = strlen ( Info.m_szFileName );

		if ( nLengthA < nLengthB )
		{
			return TRUE;
		}
		else if ( nLengthA > nLengthB )
		{
			return FALSE;
		}
		else 
		{
			int nRet = memcmp ( m_szFileName , Info.m_szFileName , nLengthA );
			if ( nRet < 0 )
			{
				return TRUE;
			}
			else if ( nRet > 0 )
			{
				return FALSE;
			}
		}
		return TRUE;
	}

public:
	unsigned long m_lFileSize;
	char m_szFileName[512];
	char m_szFilePath[512];
	char m_szFileUpperPath[512];
};

struct std::greater<class CSoftwareFileInfo*>
{
	bool operator()(CSoftwareFileInfo* first, CSoftwareFileInfo* second)
	{
		return *first < *second;
	}
};

typedef list<CSoftwareFileInfo*>	LIST_CS_FILE;
typedef LIST_CS_FILE::iterator		LIST_CS_ITER;


class CCheckSoftware  
{
public:
	CCheckSoftware();
	virtual ~CCheckSoftware();

	int	GetHashType();
	void SetHashType ( int nHashType );

	BOOL GetHashValueFromFile ( char* pszFileName , unsigned char szOutput[32] );
	BOOL GetHashValueFromDirectory ( char* pszPath , unsigned char szOutput[32] );
	
	void DestroyPtrList();
	BOOL FindDirectory( CString strDir );

	void SetWnd(HWND hwnd);

protected:
	BOOL CreateFileList ( char* pszPath , LIST_CS_FILE* pList );
	BOOL IsBanFile( char* pszFile ); 

	
protected:
	HWND			m_pHwnd;
	int				m_nHashType;
	char			m_szFilePath[512];
	CSecureHash		m_SecureHash;
	LIST_CS_FILE	m_listFile;
};

#endif // !defined(AFX_CHECKSOFTWARE_H__C2F47E25_D829_41AB_AAF3_602AEE4E0F60__INCLUDED_)
