// KMessageBoxDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "KMessageBoxDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// KMessageBoxDlg dialog


KMessageBoxDlg::KMessageBoxDlg(CWnd* pParent /*=NULL*/)
	: CDialog(KMessageBoxDlg::IDD, pParent)
{
	m_strMessage = _T("");
	m_strTitle = _T("");
	m_nType = MB_OK;
	m_ptPosition.x = 0;
	m_ptPosition.y = 0;

//	m_MenuBackFont.CreateFont ( 0, 6, 0, 0, 1000, FW_BOLD, FALSE, FALSE, DEFAULT_CHARSET, 
//		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "" );
	m_MenuForeFont.CreateFont ( 0, 4, 0, 0, 1000, FALSE, FALSE, FALSE, DEFAULT_CHARSET, 
		OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "" );

	//{{AFX_DATA_INIT(KMessageBoxDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void KMessageBoxDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(KMessageBoxDlg)
	DDX_Control(pDX, IDC_STATIC_MESSAGE, m_staticMessage);
	DDX_Control(pDX, IDC_BUTTON_YES, m_btnYes);
	DDX_Control(pDX, IDC_BUTTON_OK, m_btnOk);
	DDX_Control(pDX, IDC_BUTTON_NO, m_btnNo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(KMessageBoxDlg, CDialog)
	//{{AFX_MSG_MAP(KMessageBoxDlg)
	ON_BN_CLICKED(IDC_BUTTON_NO, OnButtonNo)
	ON_BN_CLICKED(IDC_BUTTON_OK, OnButtonOk)
	ON_BN_CLICKED(IDC_BUTTON_YES, OnButtonYes)
	ON_WM_PAINT()
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// KMessageBoxDlg message handlers

BOOL KMessageBoxDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	if ( m_strTitle == "˻" ) 
	{
		m_bmBackground.LoadBitmap ( IDB_KMB_BG_VERTIFICATION );
	}
	else if ( m_strTitle == "Ű" ) 
	{
		m_bmBackground.LoadBitmap ( IDB_KMB_BG_REPORT );
	}
	else if ( m_strTitle == "" )
	{
		m_bmBackground.LoadBitmap ( IDB_KMB_BG_REGISTER );
	}
	else if ( m_strTitle == "ãƺ" )
	{
		m_bmBackground.LoadBitmap ( IDB_KMB_BG_SEARCH );
	}

	m_btnYes.SetWindowPos ( NULL , 44, 82, 75, 22, NULL );
	m_btnYes.LoadBitmaps ( IDB_KMB_YES_NORMAL , IDB_KMB_YES_CLICK , IDB_KMB_YES_NORMAL );
	m_btnNo.SetWindowPos ( NULL , 138, 82, 75, 22, NULL );
	m_btnNo.LoadBitmaps ( IDB_KMB_NO_NORMAL , IDB_KMB_NO_CLICK , IDB_KMB_NO_NORMAL );
	m_btnOk.SetWindowPos ( NULL , 90, 84, 75, 22, NULL );
	m_btnOk.LoadBitmaps ( IDB_KMB_OK_NORMAL , IDB_KMB_OK_CLICK , IDB_KMB_OK_NORMAL );
	m_staticMessage.SetWindowPos ( NULL , 40, 45, 176, 25, NULL );
	if ( m_nType == MB_OK ) 
	{
		m_btnOk.ShowWindow( TRUE );
	}
	else if ( m_nType == MB_YESNO ) 
	{
		m_btnNo.ShowWindow( TRUE );
		m_btnYes.ShowWindow( TRUE );
	}

	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 255, 125, NULL);

	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void KMessageBoxDlg::OnButtonNo() 
{
	CDialog::OnCancel();
}

void KMessageBoxDlg::OnButtonOk() 
{
	CDialog::OnOK();
}

void KMessageBoxDlg::OnButtonYes() 
{
	CDialog::OnOK();
}

void KMessageBoxDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
//		DrawText ( pDrawDC );
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );

//	pDC->SetBkColor( RGB( 224, 236, 254 ) );
//	pDC->TextOut( 34, 5, m_strTitle );
	m_staticMessage.SetWindowText( m_strMessage );
//	pDC->SetBkColor( RGB( 255, 255, 255 ) );
//	pDC->TextOut( 35, 45, m_strMessage );

//	CFont* pOldFont;
//	int nOldMode = pDC->SetBkMode ( TRANSPARENT );
	//pDC->SetTextColor( RGB( 0, 255, 0 ) );
	//pOldFont = ( CFont *) pDC->SelectObject ( &m_MenuBackFont );
	//pDC->DrawText ( m_strTitle, CRect ( 34, 4, 90, 20 ) , DT_VCENTER );
	//pDC->SelectObject ( pOldFont );
	
//	pDC->SetTextColor( RGB( 0, 0, 0 ) );
//	pOldFont = ( CFont *) pDC->SelectObject ( &m_MenuForeFont );
//	pDC->DrawText ( m_strTitle , CRect ( 36, 5, 90, 20 ) , DT_VCENTER );
//	pDC->SelectObject ( pOldFont );
//	pDC->SetBkMode ( nOldMode );
}

void KMessageBoxDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	cdc.SelectObject ( pOldBitmap );

//	pDC->TextOut( 0, 0,"asdfdasf");

//	COLORREF crOldText = pDC->SetTextColor ( RGB( 0, 0, 0 ) );
//	pDC->TextOut ( 50, 50, m_strTitle );
//	pDC->DrawText ( "TEXT", -1, CRect(50, 50, 100, 100 ), DT_CALCRECT );
//	pDC->SetTextColor ( crOldText );
}

void KMessageBoxDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 127;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 62;
}

void KMessageBoxDlg::SetData( CString strMessage, CString strTitle, UINT nType )
{
	m_strMessage = strMessage;
	m_strTitle = strTitle;
	m_nType = nType;
}

HBRUSH KMessageBoxDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	if ( nCtlColor == CTLCOLOR_STATIC ) 
	{
		pDC->SetBkMode ( TRANSPARENT );
		return (HBRUSH)(::GetStockObject( NULL_BRUSH ));
	}	
	// TODO: Return a different brush if the default is not desired
	return hbr;
}
