#pragma once
#pragma pack(1)

#define MAX_ID_LEN						16
#define MAX_PASSWORD_LEN				16
#define MAX_MAILADDR_LEN				50
#define MAX_PROGRAM_KEY_LEN				65
#define MAX_PROGRAM_NAME_LEN			50
#define MAX_PROGRAM_COMPANY_LEN			50
#define MAX_PROGRAM_VERSION_LEN			50
#define MAX_PROGRAM_DESCRIPTION_LEN		50
#define MAX_REPLY_CONTENTS_LEN			256
#define MAX_REPORT_CONTENTS_LEN			256
#define RECORD_LEN						14

/** packet type **/
enum 
{
	MESSAGE_TYPE_MEMBER_JOIN = 0,
	MESSAGE_TYPE_MEMBER_LOGIN, 
	MESSAGE_TYPE_MEMBER_LOGOUT,
	MESSAGE_TYPE_MEMBER_JOIN_ACK,
	MESSAGE_TYPE_MEMBER_LOGIN_ACK, 

	MESSAGE_TYPE_VERIFICATION,
	MESSAGE_TYPE_VERIFICATION_ACK, 

	MESSAGE_TYPE_PROGRAM_REGISTER,
	MESSAGE_TYPE_PROGRAM_REGISTER_ACK,

	MESSAGE_TYPE_REPORT_REQUEST, 
	MESSAGE_TYPE_REPORT_REGISTER,
	MESSAGE_TYPE_REPORT_MODIFY,
	MESSAGE_TYPE_REPORT_REMOVE,
	MESSAGE_TYPE_REPORT_LIST,
	MESSAGE_TYPE_REPORT_REGISTER_ACK,
	MESSAGE_TYPE_REPORT_REMOVE_ACK,

	MESSAGE_TYPE_REPLY_REQUEST,
	MESSAGE_TYPE_REPLY_REGISTER,
	MESSAGE_TYPE_REPLY_MODIFY,
	MESSAGE_TYPE_REPLY_REMOVE,
	MESSAGE_TYPE_REPLY_LIST,
	MESSAGE_TYPE_REPLY_REGISTER_ACK,
	MESSAGE_TYPE_REPLY_REMOVE_ACK,
};

class KPacket  
{
public:
	int		m_nPacketSize;
	unsigned int	m_nPacketType;
	KPacket()
	{
		m_nPacketSize = sizeof ( *this );
	}
};


/**** Client -> Server ****/ 
/** Member **/
class KJoinMemberPacket : public KPacket // ȸ  Ŷ 
{
public : 
	char	m_szId[MAX_ID_LEN];
	char	m_szPassword[MAX_PASSWORD_LEN];
	char	m_szMailAddress[MAX_MAILADDR_LEN];
	
	KJoinMemberPacket() 
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_MEMBER_JOIN;
	}
};

class KLoginPacket : public KPacket // α Ŷ (ԽƮ  : id = "guest", Password Ȯ )
{
public : 
	char	m_szId[MAX_ID_LEN];
	char	m_szPassword[MAX_PASSWORD_LEN];
	
	KLoginPacket() 
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_MEMBER_LOGIN;
	}
};

class KLogoutPacket : public KPacket // α׾ƿ Ŷ (ش id α׾ƿ)
{
public : 
	KLogoutPacket() 
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_MEMBER_LOGOUT;
	}
};



/** Verification **/
class KVerificationPacket : public KPacket // ˻ Ŷ (ش  ش Ű ˻, ԽƮ id = "guest")
{
public : 
	char	m_szProgramKey[MAX_PROGRAM_KEY_LEN];

	KVerificationPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_VERIFICATION;
	}
};



/** Report **/ 
class KRequestReportPacket : public KPacket	// Ű   û Ŷ
{
public : 
	char	m_szProgramKey[MAX_PROGRAM_KEY_LEN];

	KRequestReportPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPORT_REQUEST;
	}
};

class KReportRegisterPacket : public KPacket // Ű   Ŷ (ش  ش Ű Ű, ԽƮ id = "guest") 
{
public : 
	char	m_szProgramKey[MAX_PROGRAM_KEY_LEN];
	char	m_szContents[MAX_REPORT_CONTENTS_LEN];

	KReportRegisterPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPORT_REGISTER;
	}
};

class KReportModifyPacket : public KPacket // Ű   Ŷ
{
public : 
	unsigned int		m_nId;
	char	m_szContents[MAX_REPORT_CONTENTS_LEN];

	KReportModifyPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPORT_MODIFY;
	}
};

class KReportRemovePacket : public KPacket  // Ű   Ŷ 
{
public : 
	unsigned int		m_nId;

	KReportRemovePacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPORT_REMOVE;
	}
};


/** Program Register **/ 
class KProgramRegisterPacket : public KPacket // α׷  Ŷ 
{
public : 
	char	m_szProgramKey[MAX_PROGRAM_KEY_LEN];
	char	m_szProgramName[MAX_PROGRAM_NAME_LEN];
	char	m_szProgramCompany[MAX_PROGRAM_COMPANY_LEN];
	char	m_szProgramVersion[MAX_PROGRAM_VERSION_LEN];
	char	m_szProgramDescription[MAX_PROGRAM_DESCRIPTION_LEN];

	KProgramRegisterPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_PROGRAM_REGISTER;
	}
};


/** Reply **/ 
class KRequestReplyPacket : public KPacket //    û Ŷ
{
public : 
	char	m_szProgramKey[MAX_PROGRAM_KEY_LEN];

	KRequestReplyPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPLY_REQUEST;
	}
};

class KReplyRegisterPacket : public KPacket //   Ŷ
{
public : 
	char	m_szProgramKey[MAX_PROGRAM_KEY_LEN];
	char	m_szContents[MAX_REPLY_CONTENTS_LEN];

	KReplyRegisterPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPLY_REGISTER;
	}
};

class KReplyModifyPacket : public KPacket //   Ŷ
{
public : 
	unsigned int		m_nReplyNum;
	char	m_szContents[MAX_REPLY_CONTENTS_LEN];

	KReplyModifyPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPLY_MODIFY;
	}
};

class KReplyRemovePacket : public KPacket  //   Ŷ 
{
public : 
	unsigned int		m_nId;

	KReplyRemovePacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPLY_REMOVE;
	}
};





/**** Server -> Client ****/ 
/** Member **/
enum 
{
	MEMBER_JOIN_SUCCESS = 0, 
	MEMBER_JOIN_ERROR_DUPLE, // ش ̵ ̹  
};
class KJoinMemberAck : public KPacket // ȸ  
{
public : 
	int m_nResult;

	KJoinMemberAck() 
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_MEMBER_JOIN_ACK;
	}
};

enum 
{
	MEMBER_LOGIN_SUCCESS = 0,  
	MEMBER_LOGIN_ERROR, // ̵ Ȥ н尡 ߸
};
class KLoginAck : public KPacket // α  
{
public : 
	int m_nResult;
	
	KLoginAck() 
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_MEMBER_LOGIN_ACK;
	}
};


/** Verification **/
enum
{
	VERIFICATION_ACK_NOT_INFO = 0, //   ʰ Űִ° ( α׷ NULLΰ)
	VERIFICATION_ACK_EXIST_INFO, //   ϴ  
};
class KVerificationAck : public KPacket // Ŭ̾Ʈ ˻   (شŰ شϴ )
{
public : 
	int		m_nResult; 
	char	m_szProgramKey[MAX_PROGRAM_KEY_LEN];
	char	m_szProgramName[MAX_PROGRAM_NAME_LEN];
	char	m_szProgramCompany[MAX_PROGRAM_COMPANY_LEN];
	char	m_szProgramVersion[MAX_PROGRAM_VERSION_LEN];
	char	m_szProgramDescription[MAX_PROGRAM_DESCRIPTION_LEN];
	char	m_szRegisterId[MAX_ID_LEN];
	char	m_szRecordTime[RECORD_LEN];
	unsigned int		m_nMemberAccessCount;
	unsigned int		m_nMemberReportCount;
	unsigned int		m_nGuestAccessCount;
	unsigned int		m_nGuestReportCount;
	unsigned int		m_nReplyCount;

	KVerificationAck()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_VERIFICATION_ACK;
	}
};


/** Report **/
enum
{
	REPORT_REGISER_SUCCESS = 0, 
	REPORT_REGISER_ERROR_DUPLE, // ̹ Ű (  α׷  Űϴ 츦  )
};
class KReportRegisterAck : public KPacket // Ű 
{
public : 
	int m_nResult;

	KReportRegisterAck()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPORT_REGISTER_ACK;
	}
};

enum
{
	REPORT_REMOVE_SUCCESS = 0, 
	REPORT_REMOVE_ERROR_NOT_EXIST, // ش Ű    
};
class KReportRemoveAck : public KPacket // Ű 
{
public : 
	int m_nResult;

	KReportRemoveAck()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPORT_REMOVE_ACK;
	}
};


class KReportListPacket : public KPacket // Ű  ϴ Ŷ
{
public:
	unsigned int		m_nId; 
	char				m_szRegisterId[MAX_ID_LEN];
	char				m_szProgramKey[MAX_PROGRAM_KEY_LEN];
	char				m_szContents[MAX_REPORT_CONTENTS_LEN];
	char				m_szRecordTime[RECORD_LEN];

	KReportListPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPORT_LIST;
	}
};


/** Program Register **/ 
enum
{
	PROGRAM_REGISTER_SUCCESS = 0, 
	PROGRAM_REGISTER_ERROR_DUPLE, // ش Ű   ̹  
};
class KProgramRegisterAck : public KPacket // α׷   
{
public : 
	int m_nResult;

	KProgramRegisterAck()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_PROGRAM_REGISTER_ACK;
	}
};


/** Reply **/ 
class KReplyListPacket : public KPacket //   ϴ Ŷ
{
public:
	unsigned int		m_nId; 
	char				m_szRegisterId[MAX_ID_LEN];
	char				m_szProgramKey[MAX_PROGRAM_KEY_LEN];
	char				m_szContents[MAX_REPLY_CONTENTS_LEN];
	char				m_szRecordTime[RECORD_LEN];

	KReplyListPacket()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPLY_LIST;
	}
};

enum
{
	REPLY_REGISER_SUCCESS = 0, 
	REPLY_REGISER_ERROR_DUPLE, 
};
class KReplyRegisterAck : public KPacket //  Ͻ 
{
public : 
	int m_nResult;

	KReplyRegisterAck()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPLY_REGISTER_ACK;
	}
};

enum
{
	REPLY_REMOVE_SUCCESS = 0, 
	REPLY_REMOVE_ERROR_NOT_EXIST, // ش ۳   
};
class KReplyRemoveAck : public KPacket //    
{
public : 
	int m_nResult;

	KReplyRemoveAck()
	{
		memset ( this, 0, sizeof ( *this ) );
		m_nPacketSize = sizeof ( *this );
		m_nPacketType = MESSAGE_TYPE_REPLY_REMOVE_ACK;
	}
};

#pragma pack()