
#if !defined(AFX_YButton_H__0D1C2D1E_B537_4CD5_993F_49555F1360FC__INCLUDED_)
#define AFX_YButton_H__0D1C2D1E_B537_4CD5_993F_49555F1360FC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// YButton.h : header file
//
#define					TIMER_ID_BUTTON_OVER					1
#define					TIMER_BUTTON_OVER_TIME_OUT				100
/////////////////////////////////////////////////////////////////////////////
// YButton window

#define DRAW_IMAGE_LIST(nX,nY,nWidth,nHeight,bm,crColorKey,pDC) \
		imageList.Create ( nWidth , nHeight , ILC_COLOR32 | ILC_MASK , 0 , 1);\
		imageList.Add ( &bm , crColorKey );\
		imageList.Draw ( pDC , 0 , CPoint ( nX , nY ) , ILD_TRANSPARENT );\
		imageList.DeleteImageList();\

class YButton : public CButton
{
// Construction
public:
	YButton();


// Attributes
public:
	UINT	m_uiBitmapResource;
	UINT	m_uiBitmapResourceSel;
	UINT	m_uiBitmapResourceOver;
	UINT	m_uiBitmapResourceActive;
	UINT	m_uiCurrentBitmap;

	char*	m_pCursor;

	BOOL	m_bOver;

	BOOL	m_bActive;

	int			m_nWidth;
	int			m_nHeight;

	BOOL		m_bColorKey;
	COLORREF	m_crColorKey;

	CImageList	m_imageList;

// Operations
public:
	void StartTimer();
	void StopTimer();
	BOOL PtInButtonRect();

	void SetActive ( BOOL bActive );

	void SetColorKey ( COLORREF crColorKey );

	BOOL LoadBitmaps ( UINT uiBitmapResource , UINT uiBitmapResourceSel , 
						UINT uiBitmapResourceOver , UINT uiBitmapResourceActive = 0 );

	int	GetWidth()	{ return m_nWidth; }
	int	GetHeight()	{ return m_nHeight; }

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(YButton)
	public:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~YButton();

	// Generated message map functions
protected:
	//{{AFX_MSG(YButton)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_YButton_H__0D1C2D1E_B537_4CD5_993F_49555F1360FC__INCLUDED_)
