// ReplyListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "ReplyListDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReplyListDlg dialog


CReplyListDlg::CReplyListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CReplyListDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReplyListDlg)
	m_strWriteReply = _T("");
	//}}AFX_DATA_INIT
	m_nListIndex	= 0;
	m_strProgramKey	= _T("");
	m_bIsFirst		= TRUE; 
}


void CReplyListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReplyListDlg)
	DDX_Control(pDX, IDC_EDIT_WRITE_TEXT, m_edtWriteReply);
	DDX_Control(pDX, IDC_BUTTON_CLOSE, m_btnClose);
	DDX_Control(pDX, IDC_BUTTON_REGISTER_RELPY, m_btnRegisterReply);
	DDX_Control(pDX, IDC_BUTTON_REMOVE_REPLY, m_btnRemoveReply);
	DDX_Control(pDX, IDC_BUTTON_RIGHT_MOVE, m_btnRightList);
	DDX_Control(pDX, IDC_BUTTON_LEFT_MOVE, m_btnLeftList);
	DDX_Control(pDX, IDC_EDIT_READ_TEXT, m_edtReadReply);
	DDX_Control(pDX, IDC_LIST_REPLY, m_listReplyList);
	DDX_Text(pDX, IDC_EDIT_WRITE_TEXT, m_strWriteReply);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CReplyListDlg, CDialog)
	//{{AFX_MSG_MAP(CReplyListDlg)
	ON_BN_CLICKED(IDC_BUTTON_LEFT_MOVE, OnButtonLeftMove)
	ON_BN_CLICKED(IDC_BUTTON_REGISTER_RELPY, OnButtonRegisterRelpy)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE_REPLY, OnButtonRemoveReply)
	ON_BN_CLICKED(IDC_BUTTON_RIGHT_MOVE, OnButtonRightMove)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, OnButtonClose)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CReplyListDlg message handlers

void CReplyListDlg::OnButtonLeftMove() 
{
	
}

void CReplyListDlg::OnButtonRegisterRelpy() 
{
	UpdateData( TRUE );	
	
	
//	if ( m_cClientSocket.IsConnected() )
	{
//		m_cClientSocket.SendData ( pPacket );
	}


	m_strWriteReply = "";
	UpdateData( FALSE );	
}

void CReplyListDlg::OnButtonRemoveReply() 
{
	
}

void CReplyListDlg::OnButtonRightMove() 
{
	
}

void CReplyListDlg::SetWnd(HWND hwnd)
{
	m_pHwnd = hwnd;
}

BOOL CReplyListDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	if ( m_bIsFirst ) 
	{
		m_bmBackground.LoadBitmap ( IDB_REPLYLIST_BACKGROUND );
		m_btnClose.LoadBitmaps ( IDB_SDLG_CLOSE_NORMAL , IDB_SDLG_CLOSE_CLICK , IDB_SDLG_CLOSE_OVER );
		m_btnRegisterReply.LoadBitmaps ( IDB_REPLYLIST_REGISTER_NORMAL , IDB_REPLYLIST_REGISTER_CLICK , IDB_REPLYLIST_REGISTER_NORMAL );
		m_btnRemoveReply.LoadBitmaps ( IDB_REPLYLIST_REMOVE_NORMAL , IDB_REPLYLIST_REMOVE_CLICK , IDB_REPLYLIST_REMOVE_NORMAL );
		m_btnRightList.LoadBitmaps ( IDB_REPLYLIST_RIGHT_CUR_NORMAL , IDB_REPLYLIST_RIGHT_CUR_CLICK , IDB_REPLYLIST_RIGHT_CUR_NORMAL );
		m_btnLeftList.LoadBitmaps ( IDB_REPLYLIST_LEFT_CUR_NORMAL , IDB_REPLYLIST_LEFT_CUR_CLICK , IDB_REPLYLIST_LEFT_CUR_NORMAL );	
		m_bIsFirst = FALSE;
	}
	m_btnClose.SetWindowPos ( NULL , 514, 5, 16, 16, NULL );
	m_btnRegisterReply.SetWindowPos ( NULL , 462, 54, 42, 22, NULL );
	m_btnRemoveReply.SetWindowPos ( NULL , 492, 248, 21, 86, NULL );
	m_btnRightList.SetWindowPos ( NULL , 287, 206, 18, 18, NULL );
	m_btnLeftList.SetWindowPos ( NULL , 218, 206, 18, 18, NULL );
	m_edtWriteReply.SetWindowPos ( NULL , 68, 55, 387, 21, NULL );
	m_listReplyList.SetWindowPos ( NULL , 23, 96, 488, 107, NULL );
	m_edtReadReply.SetWindowPos ( NULL , 26, 263, 460, 60, NULL );
	
	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 537, 348, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CReplyListDlg::SetSocket( CClientSocket* pClientSocket ) 
{
	m_pClientSocket = pClientSocket;
}

void CReplyListDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CReplyListDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	if ( pOldBitmap != NULL ) 
	{
		cdc.SelectObject ( pOldBitmap );
	}
}

void CReplyListDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 268;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 174;
}

void CReplyListDlg::OnButtonClose() 
{
	m_btnClose.m_bOver = 0;
	CDialog::OnCancel();	
}
