// KeyMakingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "KeyMakingDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CKeyMakingDlg dialog

#define MAX_CHAR_SIZE	30
#define MIN_FILE_SIZE	1000

CKeyMakingDlg::CKeyMakingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CKeyMakingDlg::IDD, pParent)
{
	m_lMaxSize	= 0;
	m_lCurSize	= 0;
	m_nPrevPer	= 0;
	m_strPath	= _T(" Ʈ  ...");	 
	m_strPer	= _T("0%");
	m_bIsFirst	= TRUE;
	//{{AFX_DATA_INIT(CKeyMakingDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CKeyMakingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CKeyMakingDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	DDX_Control(pDX, IDC_STATIC_PATH, m_staticPath);
	DDX_Control(pDX, IDC_STATIC_PER, m_staticPer);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CKeyMakingDlg, CDialog)
	//{{AFX_MSG_MAP(CKeyMakingDlg)
	ON_WM_PAINT()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CKeyMakingDlg message handlers
#define READY_BACKBUFFER(hwnd,pDC,pDrawDC,BackColor) \
	CDC _MACRO_dc;\
	CBitmap _MACRO_bitmap;\
	CBitmap	* _MACRO_pOldBitmap;\
	CRect _MACRO_client;\
	CRect _MACRO_clip;\
	pDrawDC = pDC;\
	pDC->GetClipBox(_MACRO_clip);\
	::GetClientRect(hwnd,&_MACRO_client);\
	if (!pDC->IsPrinting()) { \
		if (_MACRO_dc.CreateCompatibleDC(pDC))	{ \
			if (_MACRO_bitmap.CreateCompatibleBitmap(pDC, _MACRO_client.Width(), _MACRO_client.Height())) {\
				pDrawDC = &_MACRO_dc;\
				_MACRO_pOldBitmap = _MACRO_dc.SelectObject(&_MACRO_bitmap);\
				_MACRO_dc.FillSolidRect(_MACRO_clip,BackColor);\
  			}\
		}\
	}\

#define BLIT_OPAQUE_BACKBUFFER(pDC,pDrawDC) \
		if (pDrawDC != pDC) {\
		pDC->LPtoDP(&_MACRO_clip);\
		pDC->SetViewportOrg(0, 0);\
		pDC->SetWindowOrg(0,0);\
		pDC->SetMapMode(MM_TEXT);\
		_MACRO_dc.SetViewportOrg(0, 0);\
		_MACRO_dc.SetWindowOrg(0,0);\
		_MACRO_dc.SetMapMode(MM_TEXT);\
		pDC->BitBlt(_MACRO_clip.left, _MACRO_clip.top, _MACRO_clip.Width(), _MACRO_clip.Height(),\
			&_MACRO_dc,_MACRO_clip.left, _MACRO_clip.top, SRCCOPY);\
		_MACRO_dc.SelectObject(_MACRO_pOldBitmap);\
	}\

void CKeyMakingDlg::SetMaxSize( unsigned long lMaxSize ) 
{
	m_lMaxSize = lMaxSize;
}

void CKeyMakingDlg::SetCurSize( unsigned long lCurSize ) 
{
	m_lCurSize = lCurSize;

	if ( m_lCurSize && m_lMaxSize ) 
	{
		int nTempPer = m_lCurSize * 100 / m_lMaxSize; 
		if ( m_nPrevPer == nTempPer ) 
		{
			m_nPrevPer = nTempPer;
			return;
		}
		m_nPrevPer = nTempPer;
		m_strPer.Format( "%d%%", nTempPer );
	}

	PrintSize();
}

void CKeyMakingDlg::SetCurPath( char* szPath )
{
	if ( strlen ( szPath ) <  MAX_CHAR_SIZE ) 
	{
		m_strPath = (LPSTR)(LPCSTR)szPath; 
	}
	else
	{
		m_strPath = "";
		
		int i = strlen ( szPath ) - MAX_CHAR_SIZE;
		m_strPath.Insert( 0, ( szPath + i ) );
		m_strPath.Insert( i + strlen ( szPath ), "..." );
	}
	PrintPath();
}

void CKeyMakingDlg::PrintProgress()
{	
	OnPaint();
	PrintPath();
	PrintSize();
}

void CKeyMakingDlg::PrintPath()
{
	m_staticPath.SetWindowText( m_strPath );
}

void CKeyMakingDlg::PrintSize()
{
	if ( m_lCurSize == 0 ) 
	{
		m_staticPer.SetWindowText( "0%" );
	}
	else
	{
		m_staticPer.SetWindowText( m_strPer );
	}
}

void CKeyMakingDlg::SetDefault()
{
	m_lMaxSize	= 0;
	m_lCurSize	= 0;
	m_nPrevPer	= 0;
	m_strPath	= _T(" Ʈ  ...");	 
	m_strPer	= _T("0%");

	PrintProgress();
}

BOOL CKeyMakingDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 
	if ( m_bIsFirst ) 
	{
		m_bmBackground.LoadBitmap ( IDB_KEYMAKINGDLG_BACKGROUND );
		m_bIsFirst = FALSE;
	}
	m_staticPath.SetWindowPos( NULL, 12, 100, 232, 17, NULL );
	m_staticPer.SetWindowPos( NULL, 122, 37, 28, 15, NULL );
	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 256, 125, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CKeyMakingDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CKeyMakingDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	cdc.SelectObject ( pOldBitmap );
}

void CKeyMakingDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 127;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 62;
}

void CKeyMakingDlg::OnTimer(UINT nIDEvent) 
{
	switch ( nIDEvent ) 
	{
	case 0 :
		break;
	default : 
		break;
	}
	
	CDialog::OnTimer(nIDEvent);
}
