<?php
/**
 * SOAPS default library file
 *
 * This script holds default things for SOAPS implementation.
 * 
 * //trans
 * 이 스크립트는 XML-RPC 바탕의 Site API 구현을 위한 서버와 클라이언트간에 필요한 라이브러리를 보관한다.
 * Site API 에 대한 함수, XML-RPC for PHP 소스와 관련된 함수, XML-RPC 통신 관련 함수 등이 존재한다.
 * 단, Site API 의 정보 규격 변환에 대한 함수는 siteapi_dataspec_library.php 파일을 참고한다.
 */


/**
 * site url (homepage address)
 */
if ( isset($_SERVER['HTTP_HOST']) )
{
	$pp = pathinfo($_SERVER['PHP_SELF']);
	$url = "http://".$_SERVER['HTTP_HOST'].$pp['dirname'];
	$url = substr($url, 0, strpos($url,"/siteapi"));
//	$url = str_replace("/siteapi", "", $url);
}
else $url = '.';
/**
 * @deprecated @since 2007/01/01
 */
define ("_url", $url, true);
/**
 * SOAPS 가 설치된 경로에서 한 디렉토리 위, 즉 홈페이지 루트 디렉토리의 URL 을 가진다.
 */
define ("urlRoot", $url, true);
define ("urlHomepage", urlRoot, true);


/**
 * 사용자에게 사용을 허가할 메소드 리스트.
 *
 * 서버로 사용될때에만 가능하다.
 */
if ( isset($dispatch_map) )
{
	$arrayListMethods = array();
	foreach ( $dispatch_map as $k => $v )
	{
		$arrayListMethods[] = $k;
	}
	$siteMethods=&$arrayListMethods;
}

/**
 * system message definitions.
 *
 *
 */
define(	'message_db_connection_failed',		"failed to connection database(database file). check the useranme and password for the database.");



/**
 * HTML 문서에서 사용할 문잣셋.
 *
 */
function htmlcharset()
{
	return 'utf-8';
}


/**
 * XML 데이터 관련 함수
 * xmlrpcval 객체를 만들기가 쉽지가 않다. 아래의 함수를 이용하면 보다 편리하게 관련 객체를 생성할 수 있다.
 *
 * @example
 unset($pa);
$kvs				= array('title'=> xs('s a b'), 'title cond'=>xs('OR'), 'description'=>xs('s l '), 'description cond'=>xs('AND'), 'writer'=>xs('y'));
$limit			= xas(array('fromNumber' => 0, 'toNumber' => -1, 'fromDate'=> '20061113T01:01:01', 'toDate'=>'20061113T13:46:01'));
$pa[]				= new xmlrpcval('lopy', 'string');
$pa[]				= new xmlrpcval(md5('1111'), 'string');
$pa[]				= xa(array('readme', 'bbs'));
$pa[]				= new xmlrpcval($kvs, 'struct');
$pa[]				= $limit;

*/


/**
 * 인자의 값을 빈 값으로 전달하거나 생략하는 방법
 *
 * string 값을 빈 값으로 전달하려면, xs(''); 와 같이 값을 만들어 낸다. 이 함수는 아래의 XML 코드를 만든다.
 * 
	<param>
 		<value>
 			<string></string>
 		</value>
	</param>
 * 
 * 연관 배열을 xas(array('')) 로 빈 인자를 만들어 전달하면, 이에 해당하는 다음의 XML 코드가 만들어진다. 숙지하고 문서화가 필요하다.
	<param>
		<value>
			<struct>
				<member>
					<name>0</name>
					<value><string></string></value>
				</member>
			</struct>
		</value>
	</param>
 */


/**
 * 입력된 값을 'string' 형 xmlrpcval 객체로 리턴한다.
 *
 * @note 모든 문자열 관련 인코딩은 이 함수를 통해서 이루어진다. 그래야 일관성을 부여할 수 있다.
 * @note 이 함수에서 문자셋 변환을 한다. $GLOALS['db_charset'] 에 표시된 값이 utf8 이 아니면 utf8 로 변환을 한다.
 * @param string $var XML 데이터에 <string> 형으로 담겨질 문자열
 * @return xmlrpcval
 * @todo 문자열 처리가 올바르지 않다. string 형의 값에 UTF-8 코드를 적용한다. 올바로 실행이 되는지 체크를 해야한다.
 */
function xs($var)
{
	/**
	 * @since 2007/01/05 문자셋 처리
	 * @see siteapi_charset.php
	 */
	if ( isset($GLOBALS['db_charset']) && $GLOBALS['db_charset'] != 'UTF-8' )
	{
		/** $var 값은 문자열이다. 그러나 바이너리 문자열의 경우 컨버젼이 실패할 수 있다. */
		$conv = @iconv($GLOBALS['db_charset'], "UTF-8", $var);
		if ( $conv ) $var = &$conv;
	}
	$obj = new xmlrpcval($var, 'string');

//	__attachfile("test.log", $obj->serialize() . "\r\n");
	return $obj;
}
function rxs($var) { return new xmlrpcresp( xs($var) ); }
function xi ($var)
{
	return new xmlrpcval($var, 'int');
}
function xd ($var)
{
	return new xmlrpcval($var, 'dateTime.iso8601');
}
function xb ($var)
{
	return new xmlrpcval($var, 'boolean');
}
function rxb($var) { return new xmlrpcresp( xb($var) ); }


function x64($var)
{
	return new xmlrpcval($var, 'base64');
}


/**
 * XML 데이터에 <struct> 형태의 값을 넣는다.
 *
 * 입력된 연관 배열 변수 $as의 값 부분을 xmlrpcval('', 'string') 값으로 만들어 리턴한다.
 * @param associative-array $as
 * @return xmlrpcval 객체를 리턴한다.
 * @example return new xmlrpcresp( xas($result) ); 와 같이 리턴 값을 바로 객체로 사용할 수 있다.
 */
function xas ($as)
{
	foreach ($as as $k=>$v)
	{
		$ar[$k] = xs($v);
	}
	return new xmlrpcval($ar, 'struct');
}
function rxas($as) { return new xmlrpcresp( xas( $as ) ); }

/**
 * XML 데이터에 <array> 형의 값을 넣는다.
 *
 * 주의: 이 함수는 문자 배열의 경우에만 사용이 가능하다. 업데이트가 필요하다.
 * @param array $a 배열 변수
 * @return xmlrpcval
 */
function xa ($a)
{
 	$ar = array(); // @todo check 가 필요하다. 이 값이 있으면 xa(array('')); 가 아니고 xa(array()) 로 되나?
	foreach ($a as $v)
	{
		$ar[] = xs($v);
	}
	return new xmlrpcval($ar, 'array');
}
function xaas($aas)
{
	$ar = array();
	foreach ( $aas as $as )
	{
		$ar[] = xas($as);
	}
	return new xmlrpcval( $ar, 'array' );
}
/**
 * 2차원 배열(각 요소 연관 배열)을 입렵받아 array of structs 로 인코딩한 다음 xmlrpcresp 객체로 리턴.
 *
 * string 데이터 형으로 인코딩한다. 다른 형으로 인코딩하기 위해서 업데이트가 필요하다.
 *
 */
function rxaas($aas)
{
	return new xmlrpcresp( xaas($aas) );
}


/**
 * 잘못된 설치에 대한 메세지 출력. siteapi 디렉토리를 엉뚱한 곳에 업로드 한 경우이다. 
 *
 * @todo SOAPS 체계가 완전히 잡히지 않은 느낌이어서 함수로 제공을 한다. 체계가 완전히 잡히면 독립 파일로 떼어내야한다.
 */
function install_failed()
{
	$message = <<<EOH
<style>
body {font-size:11pt;}
</style>
<title>SOAPS(Site Open API PHP Server) http://siteapi.kldp.net http://jangnans.com</title>
<b>SOAPS 설치실패</b><br>
<br>
아래의 내용을 주의 깊게 읽으세요.
<br>
<br>
본 메세지는 SOAPS 의 설치가 올바로 되지 않았거나 지원되지 않는 홈페이지여서 나타납니다.<br>
<br>
SOAPS 관련 파일은 게시판 프로그램 디렉토리 바로 밑에 "siteapi" 라는 이름의 디렉토리에 보관이 되어야합니다.<br>
<br>
예를 들어, /home/jangnans/public_html 가 홈페이지 이고, 도메인이 jangnans.com 이라면, 홈페이지 주소는 http://jangnans.com 이 될 것입니다.<br>
중요한 점은 <b>홈페이지 게시판 프로그램 바로 다음에 /siteapi/ 디렉토리가 위치</b>하게 하는 것입니다.<br>
홈페이지 게시판 주소가 http://jangnans.com 이므로 이런 경우 SOAPS 관련 파일은 /home/jangnans/public_html/siteapi/ 디렉토리에 업로드되어야합니다.<br>
그러나 모든 경우가 이렇지는 않습니다.<br>
/home/jangnans/public_html/bbs 에 게시판 프로그램이 설치되었고,홈페이지는 여전히 http://jangnans.com/ 일 수 있습니다.<br>
이 경우에는 SOAPS 관련 파일이 /home/jangnans/public_html/bbs/siteapi/ 디렉토리에 업로드되어야합니다.<br>
그리고 홈페이지 주소가 아닌,게시판 프로그램 주소 다음이 siteapi 주소입니다. 즉, http://jangnans.com/bbs/siteapi/ 가 siteapi 주소입니다.<br>
<br>
본 페이지를 보시게된 이유는 두가지 중에 하나입니다.<br>
1. SOAPS 가 지원하지 않는 홈페이지 프로그램에 설치되었거나,<br>
2. SOAPS 관련 파일이 잘못 업로드되었을 경우입니다. (이 경우, 위에 설명한 것처럼 홈페이지 게시판 프로그램 밑에 siteapi 디렉토리를 만들어 관련 파일을 업로드하세요.)
<br>
<br>
궁금한 점이 계시다면 주저없이 SOA 커뮤니티에 문을 두드리세요.<br>
<a target=_blank href='http://jangnans.com/'>http://jangnans.com</a><br>
http://siteapi.kldp.net<br>

EOH;
	show ($message);
}

/**
 * 웹브라우저로 siteapi 서버에 접속한 경우,
 *
 * 사용자가 웹브라우저나 기타 잘못된 방법으로 본 서버(이 스크립트)에 접속을 하였을 경우 이 함수가 실행된다.
 * 웹브라우저로 접속하기 보다, SOA 클라이언트로 접속을 해야한다고 알려줄 필요성이 있다.
 * @since 2007/01/03 본 함수가 각 datalayer 마다 존재해서 일관성이 없다. 따라서 $GLOBALS['env'] 변수를 바탕으로 siteapi_default_library.php 에서 처리를 한다.
 * @see siteapi_default_library.php
 * @since 2007/01/03 site.getEnvironment 를 자체적으로 호출해서 결과를 체크해본다.
 */
function serverPage()
{
	global $env;


	$message = NULL;

// ------------------------------------------------------------
	$endpoint = "http://$_SERVER[HTTP_HOST]$_SERVER[PHP_SELF]";
	$client		= new xmlrpc_client( $endpoint );
	$msg			= new xmlrpcmsg("site.getEnvironment");
	$re				= $client->send( $msg );
	$fc				= $re->faultCode();
	
	
	$tm = NULL;
	if ( $fc )
	{
		$fs = $re->faultString();
		$message = "수행: site.getEnvironment 결과: 실패<br>오류 코드=$fc<br>오류 내용=$fs<br>";
	}
	else
	{
		$tm .= "site.getEnvrionment OK<br>";
	}
// ------------------------------------------------------------
	$pa[]			= xs('');
	$pa[]			= xs('');
	$pa[]			= xs("#CATEGORY");
	$msg			= new xmlrpcmsg("site.getCount", $pa);
	$re				= $client->send( $msg );
	$fc				= $re->faultCode();
	if ( $fc )
	{
			$fs = $re->faultString();
			$message .= "수행: site.getCount(#CATEGORY) 결과: 실패<br>오류 코드=$fc<br>오류 내용=$fs";
	}
	else $tm .= "site.getCount(#CATEGORY) OK<br>";
	
	if ( empty($fc) )
	{
		$message = <<<EOH
$env[site_name] 용 Site Open API version $env[api_version] 서버에 접속하신것을 환영합니다.<br>
웹브라우저로 본 화면이 나타나면 올바로 설치가된 것입니다.<br>
Site API 는 홈페이지의 정보를 보다 손 쉽게 이용하기 위한 도구입니다.<br>
사용법에 대해서는 홈페이지를 참고하여 주시거나 웹마스터와 연락을 해 주십시오.<br>
Site API 에 대한 자세한 내용은 http://siteapi.kldp.net 와 http://jangnans.com 에서 확인을 하실 수 있습니다.<br>
감사합니다.<br>
<br>
<br>
You are welcomed to be connected into Site Open API version $env[api_version] Server for $env[site_name].<br>
You are now read this message because you just have accessed this page using a webbrowser. And it seems to be installed okay.
If you have any request, contact to the master. or drop by http://siteapi.kldp.net, http://jangnans.com and see what we have things for you.<br>
Thank you for your reading... bye.
<br>
<br>
<br>
charset: $env[charset]<br>
developer_name: $env[developer_name]<br>
developer_homepage: $env[developer_homepage]<br>
<br>
$tm
EOH;
}


	$out = NULL;
	$title = "Site Open API version $env[api_version] for $env[site_name]";
	$out .= "<title>$title</title>
<meta http-equiv=Content-Type content='text/html;charset=euc-kr'>
<style>
body {font-size:12pt;}
</style>
<b>$title</b><br><br>
";
	if ( $fc ) $out .= "<font color=darkred><b>문제 발생.</b></font> 설치는 올바르게 진행이 되었으나, SOAPS 내부적 오류가 발생했습니다.<br>";
	$out .= $message;
	$out .= "<br><br>설치, 사용, 활용에 대한 문제는 http://jangnans.com 으로 연락을 하십시오.";
	
	$out .= "<br><br><br><br>";
	$out .= "<b>데이터베이스 문자셋 설정</b> (혹시 not well-formed 관련 에러가 발생한다면, 문자셋을 바꿔보십시오.)<br>";
	$out .= "<br>";
	$out .= "현제 SOAPS 가 사용하는 문자셋은 <b><font color=blue>".charset()."</font></b> 입니다.<br>";
	$out .= "다음 중 하나를 선택할 수 있습니다. (아래의 문자셋을 클릭하면 새로운 문자셋 처리를 합니다.)<br>";
	$out .= "<br>";
	//$enciso = urlencode('ISO-8859-1');
	//$out .= "[<a href='?charset=UTF-8'>UTF-8</a> | <a href='?charset=$enciso'>ISO-8859-1</a>| <a href='?charset=US-ASCII'>US-ASCII</a>]";
	/** @note 문자셋은 시스템에서 사용되는 것으로 표현되어야한다. */
	$out .= "
		[ <a href='?charset=UTF-8'>UTF-8</a> | <a href='?charset=EUC-KR'>EUC-KR</a>
		| <a href='?charset=ISO-8859-1'>ISO-8859-1</a>
		| <a href='?charset=US-ASCII'>US-ASCII</a>
		]
	";
	$out .= "<br><br><br>";
	
	show($out);
}





function show($message)
{
	$charset = htmlcharset();
	echo "<meta http-equiv=Content-Type content='text/html;charset=$charset'>";
	echo $message;
}
?>
