<?php
/**
 * TECHNOTE6.9P (http://technote.co.kr) 소프트웨어를 위한 SOA datalayer 이다.
 *
 * 자세한 내용은 siteapi_datalayer_jangnan_hometools.php 를 참고한다.
 *
 * 모든 작업이 다 마찬가지이듯, datalayer 를 작성하기 위해서는 해당 소프트웨어의 분석이 필요하다.
 * 특히 테크노트는 소스 인코딩을 해서, 소스 참고가 되지 않아 작업이 더 어렵다.
 * @todo 시스템 설정에 따라서 설정 파일과 데이터 저장 공간이 틀려진다. 이것은 테크노트 뿐만아니라 datalayer 를 가진 스크립트에서 전반적으로 작업이 필요하다.
 * @todo 하나의 데이터베이스에 여러개의 테크노트가 설치되는 경우 lib.php 에 그 정보가 기록된다. 그렇다고 lib.php 를 참조하기도 힘들다. 물론 이런 부분은 타 소프트웨어도 마찬가지이다. 이런 경우에 대한 기본적인 처리에 대한 기준이 필요하다.
 *
 * 테크노트 DB 분석.
 *
 * 사용자 테이블: a_tn3_memberboard_list
 * 영역 정보 보관 테이블: a_tn1_root_cnt
 *
 *
 * a_tn1_root_cnt.RC_cnt1 : 총 글 수
 * a_tn1_root_cnt.RC_cnt3 : 총 답변글 수. 즉 RC_cnt1 - RC_cnt3 하면 총 시작글 수가 나온다.
 * a_tn2_...._ad.se3_3 where no = 2 가 정보의 접근 범위를 표한하는 값이라고 단정을 짓는다.
 * wdate 항목이 글이 작성(수정)된 시간으로 단정을 한다.
 * a_tn3_memberboard_list.mdate 항목이 가입한 시간으로 단정한다.
 * a_tn3_memberboard_list.memview 가 1 이면 회원 정보를 비공개로한다.
 *
 * 사용자가 게시판에 글 쓰기 권한이 있는지에 대한 결정은 _ad 테이블과 _memberboard_list 테이블로 한다.
 * 게시판의 등급(레벨)은 se3_3 포인트는 tx3_3 로 한다.
 * 사용자의 등급은 a_tn3_memberboard_list.m_level, 포인트는 .point1 로 체크한다.
 * 테크노트의 권한 체크는 등급은 =, >= 로 표현을 하지만, 포인트는 어떻게 표현을 하는지 나타나지 않는다. 따라서 포인트는 그냥 >= 로 계산을 한다.
 * 등급과 포인트의 AND, OR 연산이 있다. 등급의 >=, = 의 결정은 se3_3_1 로 하고, AND OR 연산은 se3_3_2 로 결정을 한다.
 * se3_3_1=1 이면 그리고(AND)의 조건이며, 2 이면 OR 의 조건이다.
 * se3_3_2=1 이면 등급이 이상(>=)의 조건이며 2 이면 동일의 조건이다.
 * 테크노트의 dl_authority 에서는 글 쓰기만 체크를 한다. DB 구조가 어려워서 읽기까지는 표현을 못하겠다. (사실은, ... 지겨워서... )
 *
 * 파일 첨부는 한 게시물 당 2개로 제한이 되는 것 같다. 블로그 API 에는 게시물당 첨부파일이 무제한이다. 따라서 이미지 업로드는 zb4 와 같이 SOA 규격을 따른다.
 *
 * 카테고리_ad.tx6_8 where no=1 과 a_tn1_root_ad.RC_cnt1 이 .... 글을 리스트하는데 사용하는 정보인것 같아보인다.
 * @doc 그누보드와 마찬가지로 글 작업과 관련된 포인트 조정은 생략한다.
 */
/**
 * 에러 리포팅을 최대로 한다.
 */
error_reporting(E_ALL);
/**
 * 문자셋 처리
 *
 * @see database
 * @link http://phpxmlrpc.sourceforge.net/doc-2/ch08s02.html#d0e2742
 */
/** @moved to siteapi_server.php */
//$GLOBALS['xmlrpc_internalencoding']='UTF-8';


// 기본 테이블 접두어
//
define('tblCategory',		'a_tn1_root_cnt',	true);
define('tblBoard',			'a_tn2',		true);
define('tblUser',				'a_tn3_memberboard_list',		true);


/**
 * 서버 설정 변수
 *
 * 이 변수는 전역 변수로서 다른 곳에서 사용이되므로, 반드시 변수 명칭이 $env 이어야한다.
 * 이 변수가 가지는 모든 값은 US-ASCII 코드로만 표현을 해야한다. 한글이나 외국어를 입력하지 않고, 영어,숫자,기호로만 입력되어야한다.
 */
$env = array();
$env['api_version']					= '0.4.4';		// 지원하는 Site OpenAPI 의 버젼
$env['password_type']				= 'text';			// 클라이언트가 인코딩해야할 비밀번호 (인코딩)형식
$env['charset']							= 'utf8';			// 출력하는 데이터의 문자셋
$env['site_name']						= 'jangnans.com';
$env['site_address']				= 'http://jangnans.com';
$env['server_name']					= 'Site Open API PHP Server';
$env['build_date']					= '2006/12/19';
$env['developer_name']			= 'ky(thruthesky)';
$env['developer_email']			= 'thruthesky@yahoo.co.kr';
$env['developer_homepage']	= 'http://jangnans.com';
$env['developer_memo']			= "Please refer, http://jangnans.com, XML-RPC on http://xmlrpc.com , Site API on http://siteapi.kldp.net";
$env['default_return_numberOfRecords']		= default_return_numberOfRecords;

/**
 * 각 사이트의 필요한 라이브러리를 연결. 필요할 때, 라이브러리 로드
 */

/**
 * 데이터베이스 연결을 리턴.
 */
function database() { return dl_database(); }
/**
 * 데이터베이스 에러 메세지
 *
 * 데이터베이스 에러가 발새할 경우, 에러 메세지를 화면으로 출력한다.
 * @param string $q 데이터베이스 질의 문장
 */
function database_errstr($q='') { dl_dberrstr($q); }




/**
 * 웹브라우저로 접속한 경우.
 *
 * 사용자가 웹브라우저나 기타 잘못된 방법으로 본 서버(이 스크립트)에 접속을 하였을 경우 이 함수가 실행된다.
 *
 * 잘못된 접속을 했다는 경고 메세지를 사용자에게 보여주어야한다.
 * @return faultCode
 */
function wrongAccess()
{
	serverPage();
	return _wrongAccess;
}


/**
 * 데이터 저장소의 (최상위)경로를 리턴한다.
 *
 * 모든 파일 관련 작업을 이 함수를 호출해서 작업을 해야한다. 단, 예외는 있다. soaps 가 다루는 파일 체계와 시스템 체계가 맞지 않는 경우에는 이 함수에서 별도의 작업을 해야한다.
 * @todo 이 함수를 이용하도록 수정을 한다.
 * @return string
 */
function repository() { return "../data"; }





/**
 * 테크노트 비밀번호 비교 함수
 *
 * 테크노트의 소스 스크립트는 인코딩(컴파일)이 되어 있는 것 같다. 소스를 볼 수 없어서 아래와 같이 비밀번호 비교 함수를 대충 찍어서 만들었다.
 */
function check_crypt_std_des($password, $en_password)
{
	@define('CRYPT_STD_DES', 1);
	$enc = crypt($password,substr($en_password, 0, 2));
	return $enc == $en_password;
}

///////////////////////////////////////////////////////////////////////////////
//
// (SQL 관련) 내부 함수
//
///////////////////////////////////////////////////////////////////////////////
/**
 * 정보의 접근 범위를 결정하는 SQL 쿼리 구문을 리턴한다.
 *
 * @see dl::jangnan
 *
 * 해당 카테고리(테이블,게시판)의 se3_3 필드가 1 이상의 값을 가질 경우, 사용자에게 글 쓰기가 제한이된다.
 */
function qminState($state)
{
	if ( $state != 'public' && $state != 'user')
    return;
  if ( $state=='public')
		$re = "(se3_3=0)";
	else
		$re = "(se3_3>=0)";
	return $re;
}

/**
 * siteapi_datalayer 에 있는 범용 함수 qMakeOrder 를 사용하기 위해서 필요한 항목을 조정한다.
 *
 */
function qAdjustPostOrder($order)
{
	chgKv($order, 'writer', 'name');
	chgKv($order, 'title', 'subject');
	chgKv($order, 'description', 'tbody');
	chgKv($order, 'dateTime', 'wdate');
	return $order;
}

/**
 * siteapi_datalayer 에 있는 함수 qMakeDate 함수를 사용해서 SQL 문장을 얻기 위한, 날짜 항목의 값을 조정한다.
 *
 * 장난 홈페이지 소프트웨어의 날짜 기록 형식은 Site Open API 의 날짜 표현 형식과 틀리다.
 * 이러한 서로 다른 날짜 형식을 동일하게 하여 SQL 조건 문장에 사용할 수 있도록 조정하는 것이다.
 *
 */
function qAdjustDate(&$limit)
{
	if ( isset($limit['fromDate']) ) $limit['fromDate'] = encodeStamp($limit['fromDate']);
	if ( isset($limit['toDate']) ) $limit['toDate'] = encodeStamp($limit['toDate']);
	return $limit;
}




/**
 * 홈페이지에서 제공할 Site Open API 서버에 대한 정보를 돌려준다.
 *
 * @param associative-array &$result 스크립트의 처음에 설명된 것과 동일
 * @return faultCode 스크립트의 처음에 설명된 것과 동일
 * @see _siteGetEnvironment
 */
function getEnvironment(&$result)
{
	$result = $GLOBALS['env'];
	return _ok;
}

/**
 * Site API 서버(본 스크립트)에서 사용(지원) 가능한 메소드 리스트를 알려준다.
 *
 * @param associative-array &$result
 * @return faultCode
 * @see _siteListMethods
 */
function listMethods(&$result)
{
	$result = $GLOBALS['siteMethods'];
	return _ok;
}

/**
 * 클라이언트 개발자에게 도움이 될만한 내용을 전달한다.
 *
 * 자세한 내용은 Site API 규격과 _siteHelp 함수를 참고한다.
 *
 * @param associative-array &$result
 * @return faultCode
 * @see _siteHelp
 */
function help(&$result)
{
	$result = "Site Open API 서버입니다. Site Open API 에 대한 내용과 Site Open API 개발, 홈페이지 적용과 관련된 내용은 http://siteapi.kldp.net 로 연락을 주십시오.";
	return _ok;
}



/**
 * 사용자 정보를 리턴한다.
 *
 * 아이디와 필드를 입력받아서 해당 아디디의 해당 필드의 값을 리턴한다.
 * @see dl::jangnan
 */
function userif($id, $field)
{
	$db = database();
	$db->query("SELECT * FROM ".tblUser." WHERE m_id='$id'");
	$user = $db->row();
	return $user[$field];
}

/**
 * 입력된 아이디의 사용자(정보)가 존재하는지 체크한다.
 *
 * @param string $id 사용자 아이디
 * @return faultCode ok on user exists, otherwise error code.
 */
function userExist($id)
{
	$db = database();
	$idx = $db->result("SELECT no FROM ".tblUser." WHERE m_id='$id'");
	if ( $idx ) return _ok;
	return _wrongID;
}



/**
 * 사용자 인증(로그인) 여부를 판단한다.
 *
 * 이 함수는 홈페이지 정보를 관리할 때 사용자의 비밀번호를 어떻게 보관할지 여부와 site.getEnvironment 에서 클라이언트로 전달한 password_type 의 값과 연관이 있다. 예를 들어 site.getEnvironment 응답을 할 때, password_type=md5 로 전달을 했으면 클라이언트에서 데이터를 보낼때 비밀번호를 md5 인코딩을 해서 전송을 한다.
 * 
 * @note dl_password 함수를 직접적으로 사용해도된다. dl_password 함수의 경우 클라이언트가 md5 인코딩을 하지 않고 비밀번호를 전송해도 처리를 할 수 있다.
 * @param string id 사용자 아이디
 * @param string pw 사용자 비밀번호 ( 비밀번호의 인코딩 타입은 site.getEnvironment 의 응답에 따라 다르다. )
 *
 * @return int faultCode 다음과 같은 값 리턴된다.
 *	_ok on authentication is okay.
 *	_wrongPassword on wrong password.
 *	_wrongID on id does not exists ( or wrong id has given ).
 *	_emptyID on id is empty.
 * @uses user,userExist
 */
function userLogin($id, $pw)
{
	if ( empty($id) ) return _emptyID;
	
	// get user's password
	$userPw = userif($id, 'm_pass');

	// check the password with the given.
	
	if ( check_crypt_std_des($pw, $userPw) )
		return _ok;
	else
	{
		// 비밀번호가 틀리면,
		if ( userExist($id) )
			return _wrongID;
		return _wrongPassword;
	}
	return _unknown;
}

/**
 * 클라이언트로부터의 요청 받은 정보의 처리 영역(카테고리)이 어느 (기본)카테고리에 속해 있는지 판별해서 '기본 카테고리 명칭'을 리턴한다.
 *
 * 예를 들어, '자유토론' 의 경우 기본 카테고리는 '#BBS' (게시판) 이다. '자유토론' 의 명칭만으로 어떤 기본 카테고리에 속해있는지 판별을 할 수 없을 경우, 이 함수가 사용될 수 있다.
 *
 * @see Site Open API 규격
 * @param string $cate 카테고리
 * @return string 기본 카테고리 명칭을 리턴한다. 입력 값 자체가 #CATEGORY, #BBS 와 같이 기본 카테고리 일 경우, 그냥 그대로 리턴한다. 따라서 이런 기본 카테고리가 각 함수로 전달 될 때 적절한 처리가 있어야한다.
 * @note 만약, 기본 카테고리에 속하지 않는 경우 입력된 카테고리를 그대로 리턴한다.
 */
function typeCategory($cate)
{
	if ( substr($cate,0,1) == '#' )
		return $cate;



	$db = database();
	$q	= "SELECT no FROM ".tblCategory." WHERE RC_board_name='$cate'";
	$no = $db->result($q);
	if ( $no ) return '#BBS';
	
	return $cate;
}


/**
 * 게시판 이름을 배열로 담아서 리턴
 */
function getBBSNames()
{
	$db=database();
	$db->query("SELECT RC_board_name FROM ".tblCategory);
	while ( $row = $db->row() )
	{
		$names[] = $row['RC_board_name'];
	}
	return $names;
}

/**
 * 입력 조건에 따라 글(게시물, 포스트, 각종 내용물)을 검색하여 리턴한다.
 *
 * 이 함수는 한개의 BBS (입력된 $bbsid 변수)에 대해서 (또는 #BBS 전체) 검색을 한다. 만약 $bbsid 값이 #BBS 일 경우 검색 가능한 모든 글의 전체를 한번에 검색하는 것이다.
 * @param string $bbsid 글의 카테고리(게시판의 이름 등). #BBS 가 입력될 수 있으면 이것은 전체 검색 가능한 카테고리(전체 게시판 + 블로그 + 갤러리 등)를 나타낸다.
 * @param int $errno 에러가 있을 경우 이 변수에 에러 코드를 기록해서 돌려준다.
 * @param associative-array $kvs 검색 항목과 검색어, 그리고 검색 조건을 가지고 있는 배열
 * @param associative-array $limit 검색 제한 값을 가지고 있는 배열
 * @param string $state 사용자의 정보 접근 범위. public 이면 공개 정보를 검색. user 이면 회원 정보를 검색한다. 따라서 검색(읽기) 가능한 정보인지는 별도의 사용자 등급 관련 정보를 입력할 필요 없이, 사용자 인증만 하면 된다.
 * @internal MySQL 데이터베이스에서 날짜 검색을 할 때, iso8601 시간 형식은 바로 비교 연산이 가능하다.
 * $limit 변수가 가지는 값을 예. $limit = array('fromNumber' => 0, 'toNumber' => -1, 'fromDate'=> '20061113T01:01:01', 'toDate'=>'20061113T13:46:01');
 * @return array 각 요소는 하나의 글(게시물,포스트) 정보를 표현하는 associative array 이다. 글 정보를 표현하는 associative array 는 Site API 정보 규격에 맞는 항목과 그 값을 가지고 있어야한다.
 * @uses iconvAs
 */
function searchBBS($bbsid, $kvs, $limit, $order, $state, &$errno)
{
	/**
	 * 입력된 $kvs, $limit, $state 값을 바탕으로 검색을 하기 위한 조건식을 만든다.
	 */
	$cond = array();
	
	$qLimit = qMakeLimit($limit);
	$qDate	= qMakeDate(qAdjustDate($limit), 'wdate');
	if ( $qDate ) $cond[] = $qDate;
	$qOrder	= qMakeOrder(qAdjustPostOrder($order));
	chgKv($kvs, 'writer', 'name');
	chgKv($kvs, 'writer cond', 'name cond');
	chgKv($kvs, 'title', 'subject');
	chgKv($kvs, 'title cond', 'subject cond');
	chgKv($kvs, 'description', 'tbody');
	chgKv($kvs, 'description cond', 'tbody cond');
	$rs = qMakeCondFields($kvs);
	if ( $rs ) $cond[] = $rs;
	$qState = qminState($state);
	
	
	// state 에 따른 검색 분류.
	// 회원 로그인이 올바를 경우 user, public 두가지 정보를 모두 검색하게 하고,
	// 회원 인증을 생략할 경우, public 정보만 검색하게 한다.
	// 게시판 검색은 회원 인증과 비인증 두 가지 경우 뿐이다.
	//
	if ( empty($qState) )
	{
		$errno = fault(_wrongInput, "state(접근 영역 제한자)의 값이 잘못 지정되었습니다.");
		return;
	}

//////////	
	/**
	 * 여기서 pulbic, state 한 정보에 대해서 처리를 해야한다.
	 * 
	 * 사용자 인증(회원 로그인)을 마친 상태면 그에 대한 권한이 있는지 여부에 대해셔, 인증을 하지 않았으면 그에 대한 권한이 있는지 여부를 따져서 내용을 만들어야한다.
	 */
	$qCond = NULL;
	if ( $bbsid == '#BBS' )
	{
		$arNames = getBBSNames();
		if ($cond)
		{
			$qCond = implode(" AND ", $cond);
			$qCond = trim($qCond);
			if ( $qCond ) $qCond = "WHERE " . $qCond;
		}
		foreach ( $arNames as $name )
		{
			$sel[] = "(SELECT CONCAT('$name', '') as bbsid, no, subject, tbody, name, wdate, hit FROM ".tblBoard."_$name"."_list $qCond)";
		}
		$q = implode("UNION ALL", $sel);
		$q .= " $qOrder $qLimit";
	}
	else
	{
		if ($cond)
		{
			$qCond = implode(" AND ", $cond);
			$qCond = trim($qCond);
			if ( $qCond ) $qCond = "WHERE " . $qCond;
		}
		$q = "SELECT CONCAT('$bbsid', '') as bbsid, no, subject, tbody, name, wdate, hit FROM ".tblBoard."_$bbsid"."_list $qCond $qOrder $qLimit";
	}
///////////////
	
	
	//@todo qMakeState
	//$qCond = implode(" AND ", $cond);
	// $q = "SELECT * FROM post WHERE $qCond $qOrder $qLimit";
	// dbg($q);
	// echo "\nTEST Query String: $q\n";
	
	//@문서화:
	// 데이터베이스 질의 과정에서 에러가 발생한 경우, 스크립트 에러를 내면서 종료시키는 것 보다 지정된 faultCode 와 faultString 을 클라이언트로 전달하게 한다.
	//
	//스크립트 작성 과정에서 쿼리 구문에 문제가 있을 수 있지만, 클라이언트의 입력에 문제가 있는 경우도 있다.
	// 여기서 문제가 발생하는 경우는 해결이 쉽지 않을 수 있다. 먼저 클라이언트 관리자에게 연락을 하고
	// 클라이언트 관리자가 서버 관리자에게 연락을 해야한다.
	//
	$db = database();
	$db->query($q);
	//dbg($q);
	if ( ! $db->result )
	{
		$errno = fault(_unknownErrorOnDB, database_errstr($q));
		return;
	}
	
	//@note 최대 길이 255 자로 제한
	$asAr = array();
	while ( $row = $db->row() )
	{
		$data['dataid']				= "#BBS.$row[bbsid].$row[no]";
		$data['category']			= $row['bbsid'];
		$data['writer']				= $row['name'];
		$data['url']					= urlHomepage."/board.php?board=$row[bbsid]&command=body&no=$row[no]";
		$data['title']				= substr($row['subject'],0,255);
		$data['description']	= substr($row['tbody'],0,255);
		$data['dateTime']			= encodeDateTime($row['wdate']);
		$asAr[] = $data;
	}
	return $asAr;
}


/**
 * 카테고리 정보를 검색해서 돌려준다. $kvs, $limit, $state 조건에 맞는 값을 배열로 리턴한다.
 *
 * @param associative-array $kvs same as search()
 * @param associative-array $limit same as search()
 * @param associative-array $order same as search()
 * @param string $state same as search()
 * @param int $errno same as search()
 * @return array same as search()
 * @see 리턴 값에 대해서는 규격 파일을 참조한다.
 * @since v0.1 검색을 할 때, 정렬을 할 수 있다.
 * @see dl::jangnan
 *
 * a_tn1_root_cnt 테이블에 카테고리 리스트가 존재한다고 단정짓는다.
 *
 * @note a_tn1_root_cnt.RC_date 가 생성된 날짜 비슷한 것 같은데, 알 수가 없다. 날짜 관련 검색은 생략을 한다.
 * @note 카테고리 정보에 대한 접근 범위의 표시가 각 카테고리의 정보 영역에 보관된다. 따라서 2중 쿼리가 필요하다.
 *
 */
function searchCategory($kvs, $limit, $order, $state, &$errno)
{
	$cond = array();
	$qWhere	= NULL;
	$qLimit = qMakeCondLimit($limit);
	
	/** @note 날짜 관련 정보는 좀 더 정밀한 분석을 한 다음 적용한다. */
	$qDate = "";
	/*
		$qDate = qMakeDate(qAdjustDate($limit));
		if ( $qDate ) $cond[] = $qDate;
	 */


	// ================================== 검색 필드 조정
	chgKv($kvs, 'title', 'RC_board_nick');
	//chgKv($kvs, 'description', 'RC_board_nick');
	delKv($kvs,'writer');
	delKv($kvs,'dateTime');
	delKv($kvs,'description');
	
	$rs = qMakeCondFields($kvs);
	if ( $rs ) $cond[] = $rs;

	/**
	 * 카테고리의 접근 범위의 결정. 2중 쿼리를 해야한다.
	 */
	/**
	$qState = qminState($state);
	$cond[] = $qState;
	*/
	if ( $cond )
	{
		$qCond = implode(" AND ", $cond);
		$qWhere = "WHERE $qCond";
	}
	// ================================== 정렬 필드 조정
	chgKv($order, 'title', 'RC_board_nick');
	delKv($order,'writer');
	delKv($order,'dateTime');
	delKv($order,'description');
	$qOrder	= qMakeOrder($order);

		
	$db = database();
	$q = "SELECT * FROM ".tblCategory." $qWhere $qOrder $qLimit";
	$db->query($q, false);


	// 에러처리
	if ( ! $db->result )
	{
		$errno = fault(_unknownErrorOnDB, database_errstr($q));
		return;
	}
	$asAr = array();
	while ( $row = $db->row() )
	{
		$access = $db->result("SELECT se3_3 FROM ".tblBoard."_$row[RC_board_name]"."_ad WHERE no=2");
		if ( $state == 'public' )
		{// 비회원일 경우,
				// 쓰기 권한이 없으면, 카테고리를 보여주지 않는다.
				if ( $access != '0' ) continue;
		}// 회원인 경우 그냥 다 보여 준다.

		$row['RC_board_nick']	= strip_tags($row['RC_board_nick']);
		$row['RC_board_name']	= strip_tags($row['RC_board_name']);
		$data['dataid']				= "#CATEGORY.$row[no]";
		$data['category']			= "#CATEGORY";
		$data['writer']				= '';
		$data['url']					= urlHomepage."/board.php?board=$row[RC_board_name]";
		$data['id']						= $row['RC_board_name'];
		if ( $access == 0 ) $data['state'] = 'public';
		else $data['state'] = 'user';
		$data['dateTime']			= '';//$row['dateTime'];
		$data['type']					= '#BBS';//$row['type'];
		$data['title']				= $row['RC_board_nick'];
		$data['description']	= $row['RC_board_nick'];
		$data['records']			= $row['RC_cnt1'];
		$asAr[] = $data;
	}
	return $asAr;
}

function searchDefault($cate, $kvs, $limit, $state)
{
//	echo "_serachDefault($cate)\n";
}


/**
 * 사용자 정보를 검색해서 돌려준다. $kvs, $limit, $state 조건에 맞는 값을 배열로 리턴한다.
 * 입/출력값은 search() 와 동일
 * @ses search()
 * @note 회원 정보 취급은 주의해야한다. 특히 연락처 관련된 부분(홈페이지,메일,주소,전화번호 등)은 더욱 조심해야한다.
 */
function searchUser($kvs, $limit, $order, $state, &$errno)
{
	$asAr = array();
	/**
	 * 회원 인증이 안된 경우,
	 *
	 */
	if ( $state == 'public' )
	{
		$errno = _accessDenied;
		return ;
	}

	$qLimit = qMakeCondLimit($limit);
	$qDate = qMakeDate(qAdjustDate($limit), 'm_date'); if ( $qDate ) $cond[] = $qDate;
	
	/**
	 * 사용자 정보에서 제목 검색을 하면, 그냥 리턴한다. 사용자 정보에는 제목 항목이 없다.
	 * @see 규격 파일 참고.
	 */
	if ( isset( $kvs['title'] ) ) return $asAr;
	chgKv($kvs, 'name', 'm_name');
	chgKv($kvs, 'name cond', 'm_name cond');
	chgKv($kvs, 'id', 'm_id');
	chgKv($kvs, 'id cond', 'm_id cond');
	chgKv($kvs, 'city', 'juso');
	chgKv($kvs, 'city cond', 'juso cond');
	$qF = qMakeCondFields($kvs); if ( $qF ) $cond[] = $qF;
	
	$qState = "(memview>=2)";
	$cond[] = $qState;
	
	if ( $cond )
	{
		$qCond = implode(" AND ", $cond);
		$qWhere = "WHERE $qCond";
	}
	
	
	chgKv($order,'name', 'm_name');
	chgKv($order,'dateTime', 'm_date');
	delKv($order,'description');
	$qOrder	= qMakeOrder($order);
	
	$q = "SELECT * FROM ".tblUser." $qWhere $qOrder $qLimit";
	//
	$db = database();
	$db->query($q, false);
	
	if ( ! $db->result )
	{
		$errno = fault(_unknownErrorOnDB, "technote::searchUser ".database_errstr($q));
		return;
	} // 에러처리
	
	while ( $row = $db->row() )
	{
		$data['dataid']		= "#USER.$row[no]";			// 전체 사이트 정보에서 고유한 아이디
		$data['category'] = "#USER";
		$data['url']			= '';//urlHomepage."";
		$data['id']				= $row['m_id'];
		$data['name']			= $row['m_name'];
		$data['birth']		= $row['birth'];
		if ( $row['sex'] == '1' ) $data['sex'] = 'M';
		else $data['sex'] = 'F';
		$data['title']		= $row['m_name'];
		$data['dateTime']	= encodeDateTime($row['m_date']);
		$asAr[] = $data;
	}
	return $asAr;
}




/**
 * 주소(우편번호) 정보를 검색해서 돌려준다. $kvs, $limit, $state 조건에 맞는 값을 배열로 리턴한다.
 * 입/출력값은 search() 와 동일
 * @ses search()
 * @see Site API 정보 규격 참고
 */
function searchZipcode($kvs, $limit, $order, $state, &$errno)
{
	$errno = _serviceUnavailable;
	return _serviceUnavailable;
	moveElem($kvs, 'city', 'GUGUN');
	moveElem($kvs, 'city cond', 'GUGUN cond');
	
	moveElem($kvs, 'street', 'DONG');
	moveElem($kvs, 'street cond', 'DONG cond');
	
	moveElem($order, 'city', 'GUGUN');
	moveElem($order, 'street', 'DONG');
	
	
		
	$qLimit = qMakeCondLimit($limit);
	$qDate = qMakeDate(qAdjustDate($limit)); if ( $qDate ) $cond[] = $qDate;
	$qF = qMakeCondFields($kvs); if ( $qF ) $cond[] = $qF;
//	$qState = qMakeState($state); $cond[] = $qState;
	if ( $cond )
	{
		$qCond = implode(" AND ", $cond);
		$qWhere = "WHERE $qCond";
	}
	
	
	$qOrder	= qMakeOrder($order);
	
	
	$q = "SELECT * FROM zipcode $qWhere $qOrder $qLimit";
//	echo "\nDebug on searchZipcode. Query: $q\n";
	//
	$db = database();
	$db->query($q);
	if ( ! $db->result )
	{
		$errno = fault(_unknownErrorOnDB, database_errstr($q));
		return;
	} // 에러처리
	$asAr = array();
	while ( $row = $db->row() )
	{
		$ar['zipcode'] = $row['ZIPCODE'];
		$ar['address'] = "$row[SIDO] $row[GUGUN] $row[DONG] $row[BUNJI]";
		$asAr[] = $ar;
		
	}
	return $asAr;
}


/**
 * 사이트 정보 공간에 총 몇개의 카테고리가 존재하는지 알려준다.
 *
 * 이에 대한 처리는 사이트마다 틀리다.
 * @param string $state 접근 범위
 * @param int $result 정보의 수
 * @return resultCode
 */
function getCountCategory($state, &$result)
{
	$db = database();
	$result = $db->result("SELECT count(*) FROM ".tblCategory);
	return _ok;
}


/**
 * 클라이언트의 주소 - 우편 번호 카테고리에 몇개의 정보가 존재하는지 알려준다.
 *
 * @param string $state 접근 범위
 * @param int &$result 정보의 수
 * @return resultCode
 * @note 주소(우편 번호)는 공개 정보이다. 서버에서는 이 정보를 제공할지 말지를 결정하여 처리를 할 수 있다.
 */
function getCountZipcode($state, &$result)
{
	return _serviceUnavailable;
	$db = database();
	$result = $db->result("SELECT count(*) FROM zipcode");
	return _ok;
}

/**
 * (Site) API 와는 별도로 사이트의 정책에 따라 홈페이지 사용자(회원)의 수를 알려줄지 말지를 결정한다. 여기서는 사용자 인증이 올바를 경우 전체 사용자의 수를 알려준다.
 *
 * @param string $state 접근 범위
 * @param int &$result 결과값을 담을 변수
 * @return resultCode
 */
function getCountUser($state,&$result)
{
	if ( $state == 'public' )
		return _accessDenied;
	$db = database();
	$result = $db->result("SELECT count(*) FROM ".tblUser);
	return _ok;
}


/**
 * 글(게시물, 각종 포스트) 정보 영역에서 카테고리 별로 존재하는 글의 수를 리턴한다.
 *
 * @param string $cate 글의 카테고리
 * @param string $state 정보의 접근 범위
 * @return int resultCode
 * @todo $state 는 정보의 공개/비공개 를 판변하는 값이 입력된다. 이 값에 따라 게시물의 수를 판별하도록 고친다. 현제는 카테고리 내의 전체의 갯수를 리턴한다.
 */
function getCountBBS($cate, $state, &$result)
{
	$db = database();
	if ( $cate == '#BBS' )
	{
		$result = dl_countBBSALL();
	}
	else
	{
		$result = $db->result("SELECT RC_cnt1 FROM ".tblCategory." WHERE RC_board_name='$cate'");
	}
	
	return _ok;
}

/**
 * 글을 구성하는 전체 내용을 돌려준다.
 *
 * 글(게시물, 각 종 포스트)에 대한 정보를 돌려준다. 각 글은 접근 제한을 할 수 있다.
 * @since 2006/12/27 입력된 $id 값을 바탕으로 권한을 체크하고 해당 결과를 돌려준다.
 *
 * @param mixed $id 사용자 아이디 또는 사용자 정보 배열
 * $id 변수의 형식이 is_array 이면, 사용자 아이디가 아닌, 사용자 정보를 담는 연관배열로 인식한다.
 * @param string $state 사용자의 인증 여부. $state 가 public 인 경우는 인증이 생략되었다는 뜻이다.
 * @param string $idx 게시물 번호
 * @param associative-array $result 결과를 담을 연관 배열
 * @return int resultCode
 * @since 2006/12/27 $id 에 값이 있을 경우, 자신의 글만 가져올 수 있도록 처리를 했다.
 * @todo 게시물에 접근하는 것에는 읽기 있는가와 자신의 글인가를 체크해야한다. 비밀글이거나 적합하지 않은 경우에는 보여주면 안된다.
 */
function getBBSData($id, $state, $idx, &$result)
{
	$db = database();
	if ( is_array($id) )
	{
		$user = &$id;
	}
	else
	{
		$db->query("SELECT * FROM ".tblUser." WHERE m_id='$id'");
		$user = $db->row();
	}
	$ar = dataid($idx);
	/**
	 * @note 자신의 글, 공개글을 보여준다.
	 */
	$db->query("SELECT * FROM ".tblBoard."_$ar[id]"."_list WHERE no=$ar[idx] AND (id='$user[m_id]' OR secret = 0)");
	$row = $db->row();
	if ( empty($row) ) { $result = array(); return _ok; }
	
	$data['category']					= $ar['id'];
	$data['dataid']						= "#BBS.$ar[id].$ar[idx]";
	$data['writer_id']				= $row['id'];
	$data['writer']						= $row['name'];
	//$data['writer_sex']				= $row['sex'];
	//$data['writer_birth']			= $row['birth'];
	$data['writer_email']			= $row['wmail'];
	$data['writer_homepage']	= $row['home'];
	//$data['tags']							= $row['tags'];
	$data['title']						= $row['subject'];
	$data['description']			= $row['tbody'];
	$data['dateTime']					= encodeDateTime($row['wdate']);
	$data['hits']							= $row['hit'];
	$data['url']							= urlHomepage . "/board.php?board=$ar[id]&command=body&no=$ar[idx]";
	
	$result = $data;
	return _ok;
}





























































///////////////////////////////////////////////////////////////////////////////
//
//
// SOA > 0.4 규격
//
//
///////////////////////////////////////////////////////////////////////////////


/**@+
 * Blogger API 처리
 *
 * 처리 결과의 형태(형식)는 각 표준 문서에 나타나는 변수형에 맞는 PHP 변수형이어야한다. 예를 들어 struct 의 결과를 가지는 API 의 메소드 경우, 리턴값이 associative array 이어야한다.
 * 자세한 것은 XML-RPC 문서와 Blogger API 문서를 참고하기 바란다.
 *
 * @param string $id	사용자 이름(아이디)
 * @param string $pw	비밀번호
 * @param ref &$result
 * @return faultCode
 */
/**
 * blogger.getUserInfo 에 대한 처리를 한다.
 *
 */
function blogger_getUserInfo($id, $pw, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;

	$data['url']				= _url;
	$data['userid']			= $id;
	$data['email']			= $user['m_mail'];
	$data['nickname']		= $user['m_name'];
	$data['firstname']	= _firstName($user['m_name']);
	$data['lastename']	= _lastName($user['m_name']);
	
	$result = $data;
	return _ok;
}
/**
 * blogger.getUsersBlogs 에 대한 처리
 *
 * 자신의 블로그를 리스트한다. 블로그 카테고리를 리스하는 것과 같다. 이것은 metaWeblog 에서 동일하게 이용될 수 있다. Site Open API 에서는 게시판 카테고리를 리턴한다.
 * @return array an array of <struct>'s containing the ID (blogid), name (blogName), and URL (url) of each blog.
 */
function blogger_getUsersBlogs($id, $pw, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	$rs = searchCategory(array(), array('toNumber'=>-1), array(), 'user', $fc);
	if ( $fc ) return $fc;
	
	foreach ( $rs as $ar )
	{
		$re['url']			= $ar['url'];
		$re['blogid']		= $ar['id'];
		$re['blogName']	= $ar['title'];
		$result[] = $re;
	}
	return _ok;
}
/**
 * blogger.getRecentPosts 에 대한 처리
 *
 * blogid 는 카테고리 아이디이다. postid 는 '#BBS.글번호' 형식이다.
 * @see 입출력에 대한 자세한 내용은 규격 파일을 참고한다.
 * @see 규격문서
 * @fix 2007/01/01 자신의 글만 보여준다. 오류 체크하지 않았음.
 */
function blogger_getRecentPosts($blogid, $id, $pw, $number, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	if ( empty($blogid) ) $blogid = '#BBS';
	if ( empty($number) ) $number = _numberOfRecords;
	$rs = searchBBS($blogid, array('id'=>$user['m_id'], 'idx cond'=>'='),
						array('fromNumber'=>0,'toNumber'=>$number), array('wdate'=>'DESC'), 'user', $fc);
	if ( $fc ) return $fc;
	$result = array();
	foreach( $rs as $ar )
	{
		// link, permaLink, title, description 은 사실상 전달할 필요없는 값들이다. 그래도 description 을 제외한 값은 전달해 준다.
		$re['link']					= $ar['url'];
		$re['permaLink']		= $ar['url'];
		$re['title']				= $ar['title'];
		//$re['description']	= $ar['description'];
		$re['userid']				= $user['m_id'];
		$re['postid']				= $ar['dataid'];
		$re['content']			= $ar['description'];
		$re['dateCreated']	= $ar['dateTime'];
		$result[]						= $re;
	}
	return _ok;
}
/**
 * blogger.getPost 에 대한 처리
 *
 * @see blogger.getRecentPosts 와 마찬가지로 표준이 아닌 메소드이다.
 * @note 이 함수는 각 datalayer 에서 userid 정도만 수정하면된다.
 */
function blogger_getPost($postid, $id, $pw, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	getBBSData($user, 'user', $postid, $rs);
	if ( empty($rs) ) return fault(_noData, 'blogger_getPost:: ');
	
	$result['link']					= $rs['url'];
	$result['permaLink']		= $rs['url'];
	$result['title']				= $rs['title'];
	$result['userid']				= $user['m_id'];
	$result['postid']				= $rs['dataid'];
	$result['content']			= $rs['description'];
	$result['dateCreated']	= $rs['dateTime'];
	return _ok;
}
/**
 * blogger.newPost 처리
 *
 */
function blogger_newPost($blogid, $id, $pw, $content, $publish, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	if ( ! ($category = dl_category($blogid)) ) return fault(_wrongCategory, "blogger.newPost::");
	$fc = dl_authority($user, $category, 'w'); if ( $fc ) return $fc;
	$bbs['id']						= $blogid;
	$post['description']	= $content;
	$post['publish']			= $publish;
	$post['title']				= _tagContent('title', $post['description']);
	if ( empty($post['title']) ) $post['title'] = "No title. written by Site Open API Client.";
	$post['dateCreated']	= '';
	$fc = dl_newPost($bbs, $user, $post, $rs);
	if ( $fc ) return $fc;
	
	$result = "#BBS.$blogid.$rs[postid]";
	return _ok;
}
/**
 * blogger.editPost 처리
 *
 * 수정을 할때에는 본인 인증을 한다. 자신을 글만 수정 가능.
 * 직접 인증 처리를 해야한다. $fc = blogger_getPost($postid, $id, $pw, $post); 와 같이 돌려서 하는 것은 안된다.
 * @note 성공이면 $result 에 1 을 기록
 */
function blogger_editPost($postid, $id, $pw, $content, $publish, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	$bbs	= dataid($postid);
	$post = dl_post($bbs['idx'], $bbs['id']);
	if ( empty($post) ) return fault(_noData, "blogger_editPost");
	if ( $post['id'] != $user['m_id'] ) return fault(_accessDenied, "blogger_editPost");
	
	$data['description']	= $content;
	$data['publish']			= $publish;
	$data['title']				= _tagContent('title', $data['description']);
	if ( empty($data['title']) ) $data['title'] = "No title. written by Site Open API Client.";
	$data['dateCreated']	= '';
	$fc = dl_editPost($bbs, $user, $data);
	if ( $fc ) return $fc;
	$result = 1;
	return _ok;
}
/**
 *
 */
function blogger_deletePost($postid, $id, $pw)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	$bbs = dataid($postid);
	$post = dl_post( $bbs['idx'], $bbs['id'] );
	if ( empty($post) ) return fault(_noData, "blogger_deletePost");
	if ( $post['id'] != $user['m_id'] ) return fault(_accessDenied, "blogger_deletePost");
	return dl_deletePost($bbs['idx'], $bbs['id']);
}
/**@-*/
/**@+
 * Meta Weblog API 처리
 *
 */
/**
 * metaWeblog.getCategories 처리
 *
 * @param string $blogid 블로그 섹션 아이디.
 * @see $blogid 입력 변수는 SOA 스펙 문서를 참고해야한다.
 */
function metaWeblog_getCategories($blogid, $id, $pw, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	$rs = searchCategory(array(), array('toNumber'=>-1), array(), 'user', $fc);
	if ( $fc ) return $fc;
	
	foreach ( $rs as $ar )
	{
		$re['htmlUrl']				= $ar['url'];
		$re['rssUrl']					= '';
		$re['title']					= $ar['title'];
		$re['categoryId']			= $ar['id'];
		$re['categoryName']		= $ar['title'];
		$re['description']		= $ar['id'];
		$result[] = $re;
	}
	return _ok;
}
/**
 * @see SOA 규격 문서
 */
function metaWeblog_getRecentPosts($blogid, $id, $pw, $number, &$result)
{
	$result = array();
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	if ( empty($blogid) ) $blogid = '#BBS';
	if ( empty($number) ) $number = _numberOfRecords;
	$rs = searchBBS($blogid,
						array('id'=>$user['m_id'], 'id cond'=>'='),
						array('fromNumber'=>0,'toNumber'=>$number),
						array('dateTime'=>'DESC'), 'user', $fc);
	if ( $fc ) return $fc;
	foreach( $rs as $ar )
	{
		$re['dateCreated']	= $ar['dateTime'];
		$re['title']				= $ar['title'];
		$re['description']	= $ar['description'];
		$re['userid']				= $user['m_id'];
		$re['postid']				= $ar['dataid'];
		$re['link']					= $ar['url'];
		$re['permaLink']		= $ar['url'];
		$re['categories']		= array();
		$result[]						= $re;
	}
	return _ok;
}
function metaWeblog_getPost($postid, $id, $pw, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	getBBSData($user, 'user', $postid, $rs);
	if ( empty($rs) ) return fault(_noData, 'metaWeblog_getPost:: ');
	$result['dateCreated']	= $rs['dateTime'];
	$result['title']				= $rs['title'];
	$result['description']	= $rs['description'];
	$result['userid']				= $user['m_id'];
	$result['postid']				= $rs['dataid'];
	$result['link']					= $rs['url'];
	$result['permaLink']		= $rs['url'];
	$result['categories']		= array();
	return _ok;
}
/**
 * @note MS Windows Live Writer 가 dateCreated 값을 전달하지 않는다. PHP-Notice 메세지가 발생해서 올바로 수행이되지 않는다. 따라서 에러 처리를 했다.
 */
function metaWeblog_newPost($blogid, $id, $pw, $struct, $publish, &$result)
{
	$fc = dl_password($id, $pw, $user); if ( $fc ) return $fc;
	if ( ! ($category = dl_category($blogid)) ) return fault(_wrongCategory, "metaWeblog.newPost::");
	$fc = dl_authority($user, $category, 'w'); if ( $fc ) return $fc;
	$bbs['id']						= $blogid;
	$post['dateCreated']	= $struct['dateCreated'];
	$post['title']				= $struct['title'];
	$post['description']	= &$struct['description'];
	$post['publish']			= $publish;
	$fc = dl_newPost($bbs, $user, $post, $rs);
	if ( $fc ) return $fc;
	$result = "#BBS.$blogid.$rs[postid]";
	$bbs['idx'] = $rs['postid'];
	hookup_mediaObject($bbs);
	return _ok;
}
function metaWeblog_editPost($postid, $id, $pw, $struct, $publish, &$result)
{
	$fc		= dl_password($id, $pw, $user); if ( $fc ) return $fc;
	$bbs	= dataid($postid);
	$post = dl_post( $bbs['idx'], $bbs['id'] );
	if ( empty($post) ) return fault(_noData, "metaWeblog_editPost::no data by that dataid-$postid($post_idx)");
	if ( $post['id'] != $user['m_id'] ) return fault(_accessDenied, "::metaWeblog_editPost::$post[mb_id] != $user[mb_id]");
	if ( isset($struct['dateCreated']) ) $post['dateCreated']	= $struct['dateCreated'];
	else $post['dateCreated'] = encodeDateTime(time());
	$post['title']				= $struct['title'];
	$post['description']	= &$struct['description'];
	$post['publish']			= $publish;
	$fc = dl_editPost($bbs, $user, $post);
	if ( $fc ) return $fc;
	$result = 1;
	hookup_mediaObject($bbs);
	return _ok;
}
/**
 * 테크보드에는 첨부 파일을 갯수에 제한이 있다. 따라서 SOA 규격을 따라서 파일을 저장한다.
 * @see dl::zb4
 * @see SOA 규격 문서
 */
function metaWeblog_newMediaObject($blogid, $id, $pw, $struct, &$result)
{
	
	if ( !check($struct, array('name', 'type', 'bits') ) ) return fault(_wrongInput, "The client - $_SERVER[HTTP_USER_AGENT] sent wrong data. You sould use another one.");
	$fc = dl_password($id, $pw, $user); if ( $fc ) return fault($fc, "datalayer_jangnan_hometools::metaWeblog_newMediaObject");
	if ( ! ($category = dl_category($blogid)) ) return fault(_wrongCategory, "datalayer_jangnan_hometools::metaWeblog_newMediaObject");
	$fc = dl_authority($user, $category, 'w'); if ( $fc ) return fault($fc, "datalayer_jangnan_hometools::metaWeblog_newMediaObject");
	
	/**
	 * 파일 데이터를 저장할 디렉토리 준비
	 */
	$dir = repository() . "/board/api";
	if ( ! is_dir($dir) ) if ( ! _mkdirEx($dir) ) return fault(_diskAccess, 'newMdediaObject::파일 업로드를 위한 디렉토리 생성에 실패하였습니다.');
	
	$file['name']					= $struct['name'];
	$file['size']					= strlen($struct['bits']);
	$file['type']					= $struct['type'];
	if ( strpos($file['type'], "image") === false ) return fault(_wrongInput, "/newMediaObject::The type '$file[type]' does not allowed to be uploaded");
	$file['ip']						= _inet_addr($_SERVER['REMOTE_ADDR']);
	$pp			= pathinfo($file['name']);
	$ext		= $pp['extension'];
	$no			= 1;
	$name		= $blogid.'.'.time().'.'.$file['ip'].".$no.$ext";
	$to			= "$dir/$name";
	// 동일한 파일이 존재하지 않도록 번호를 매겨서 저장.
	while ( file_exists($to) )
	{
		$no ++;
		$name		= $blogid.'.'.time().'.'.$file['ip'].".$no.$ext";
		$to			= "$dir/$name";
	}
	if (! writeContent($to, $struct['bits']) ) return fault(_diskAccess, 'newMdediaObject::파일 업로드를 위한 파일 생성에 실패하였습니다.');
	$result['url'] = urlHomepage . "/data/board/api/$name"; /**@todo 디렉토리 연결이 매끄럽지 못하다.*/
	return _ok;
}
/**
 * 시스템의 저장소 구조와 API 규격의 저장소 구조가 틀리다.
 * @see SOA 규격파일
 * @see 개발자노트
 * @see dl::zb4
 */
function hookup_mediaObject($idx)
{
	//
}
/**@-*/
///////////////////////////////////////////////////////////////////////////////
//
// EO 블로그 API
//
///////////////////////////////////////////////////////////////////////////////
?>
