<?php
/**
 * Site Open API ԰ ó
 *
 * Site API   ó κ ô ũƮμ Ŭ̾Ʈ û Ȩ(Ʈ)  ؼ Site API ԰ݿ ° óϴ Ȱ Ѵ.
 *  , metaWeblog.newPost  ǥ ԰ݿ dateCreated ׸ ޵Ǿϴµ,    ʴ Ŭ̾Ʈ   ִ.  ִ.  ̷ ʱⰪ ϴ   ũƮ ó  ִ.
 *  ũƮ  DB ó ϴ Լ ȣѴ.
 *   siteapi_server.php -> siteapi_procedure.php -> siteapi_datalayer.php ->  Ʈ datalayer.php
 *  Ʈ   ͺ̽ ó    Ʈ(, Ȩ) siteapi_datalayer_[sitename].php   ̸ Ͽ ũƮ  ۼϿ ҽ ڵ Ѵ.  ũƮ DB Ӱ  κ   ⺻ DB   ó  ʿ κ  Ҵ. ̸  ũƮ   ʰ siteapi_data_[sitename].php ũƮ  ϳ  ϸ  ۾   Ҵ. ׷ ʿ   ũƮ  Ӹ ƴ϶ ü ũƮ     Ѵٸ   ۼ   ̴.  ۼ ߴ Site API ԰ݿ  Ǵ ̴.
 *  Լ ⺻  ó Լ  ִ.
 * ⿡ ִ Լ    ϴ.   qMakeCondFields   ˻ ׸ 鶧  Լ Ѵ.  Ʈ  ԰ ׸    . ׷  Լ ؼ ˻ ׸ .  Լ Է° ѱ , ó ϸȴ.
 *
 * @author thruthesky <thruthesky@yahoo.co.kr>
 * @version 0.1
 * @note Site API   ó  ϴ ֱ   ۾
 * @note  ũƮ Ʈ  Site API ԰ݿ µ ϴ ۾ Ѵ.  ũƮ ٺ ׽Ʈ  ۼ , Site API  ֽ     (ؼ)ϰ ִ.  ʿ κи Ͽ ״ Ȱ ϸ ȴ.
 * @note '_site'  ϴ Լ ״  Ǿϸ    ȴ ùٶѴ.
 *   Լ  (,߰,) ϴ.
 *
 * @note  Լ   ùٸ  _ok  ϸ Է  $result    ؾѴ.
 * ,    Լ faultCode  ؾϸ, faultCode  شϴ  siteapi_code.php  ϵǾ ִ.
 *
 * @note ó ׽Ʈ ۾ ϱ  Ʈ  ӽ Ͽ    ˻ϴ  ߴµ, ʹ ȿ̾. Ư  ˻ ־ Site API ԰ 䱸 ߱Ⱑ  ʾҴ. ͺ̽ ̿ SQL  ۼϿ ˻ ϴ ξ ߴ. ׸   Ȯ  php   Ʈ 󿡼   ֵ ߴ.
 * @note  ũƮ ۼǾ ִ Լ  Ȱϱ⸦ ٶ.
 * @see siteapi_datalayer_test.php
 * @note Է° @param ref &$result      ؼ ޹  ̴.
 * @note ϰ faultCode    _ok, н faultCode  ϵ Ѵ.
 * @todo search()  $kvs  ˻ ׸ ˻, ˻  . īװ   ִ. ⺻ īװ ˻  ׸ ̸  Ƿ ̸ üũ    ִ. ׷   ʴ.     .
 * @note site.search     ذϱ ؼ order by   Է   ߰ߴ.
 * site.getCategoryList  site.getUserList    ʾҴ.
 *
 * @note qMake ø Լ SQL ()  , Ű  ( false, 0, empty )   н ϵ ߴ. ̰ Ŭ̾Ʈ ͸  ,   Ҷ   ִ.
 * @note ʿ , debug_print_backtrace()   Ȱ϶.
 */



/**
 * Ư ׸() ؼ ùٸ   üũ Ѵ.
 *
 *  , Ư 迭 Ư ׸ ϴ ˻縦 ϱ ؼ ȴ.
 * @param mixed $in
 * @param mixed $ch
 * $in  $ch  is_array()  ϸ, $in  迭, $chk  迭 ν ϰ, $chk   ׸ $in  ϴ üũ Ѵ.
 * @return boolean ùٸ ̸ , ƴϸ .
 * @code if ( !check($struct, array('name', 'type', 'bits') ) ) return fault(_wrongInput, "Ŭ̾Ʈ ùٸ ͸  ߽ϴ.");
 */
function check($in, $ch)
{
	if ( is_array($in) && is_array($ch) )
	{
		foreach( $ch as $k )
		{
			if ( ! array_key_exists($k, $in) ) return false;
		}
		return true;
	}
}


/**
 * dataid ϼ ֱ ؼ Լ ۼ.
 *
 *  ȣ ϼ οϱ ؼ̴.
 * Էµ ڿ .  0̸, ۹ȣ, 1̸, ԽǾ̵.۹ȣ, 2̸ #BBS.ԽǾ̵.۹ȣ̴.
 * @note siteapi_datalayer_zb4.php   ۼߴ.
 * @see siteapi_datalayer_zb4.php::parse_dataid
 */
function dataid($dataid)
{
	$ar = explode(".", $dataid);
	if ( count($ar) == 1 ) return array('idx'=>$ar[0]);
	else if ( count($ar) == 2 ) return array('id'=>$ar[0], 'idx'=>$ar[1]);
	else if ( count($ar) == 3 ) return array('type'=>$ar[0], 'id'=>$ar[1], 'idx'=>$ar[2]);
}




/**
 * Էµ  迭 ׸ Ű Ѵ.
 *
 * @param associative-array &$kvs ׸ Ű  ִ  迭 .   ׼Ѵ.
 * @param string $k1  ̸ ( ų  Ű)
 * @param string $k2  ̸ (Ǿ   Ű)
 * @example chgKv($kvs, 'id', 'mb_id');   ȣϸ $kvs 迭 'id' ׸ ϸ  ׸ Ű 'id'  'mb_id'  Ų.
 * @see moveElem Լ  Ȱ ϴ  . ̺귯 ü谡 ̴  ̴.
 */
function chgKv(&$kvs, $k1, $k2)
{
	if( isset($kvs[$k1]) )
	{
		$kvs[$k2]				= $kvs[$k1];
		unset($kvs[$k1]);
	}
}
/**
 *  迭 ׸(Ű) ٸ ̸  Ѵ.
 * @see chgKv
 */
function moveElem( &$assoc, $src, $dst )
{
	if ( isset($assoc[$src]) )
	{
		$assoc[$dst] = $assoc[$src];
		unset ($assoc[$src]);
	}
}

// 迭 ش Ű() Ѵ.
function delKv(&$kvs, $k)
{
	if(isset($kvs[$k]))unset($kvs[$k]);
}
	
 
/**
 * site.search() ޼ҵ 䱸  ó ϱ ؼ SQL ˻   .
 * Է  $kvs  struct keys_values   Է ,  Լ  Ǳ , DB  ùٸ   ̸ ó ǾѴ.
 * @note SQL  ۼ Լ
 * @uses qMakeCondFields
 * @see searchBBS
 * @param associativ-array $kvs ˻ ׸ ˻, ˻ ׸ ˻ ()   迭̴.   Ŭ̾Ʈ    ״θ  ȴ.
 * @param string $field Է  $kvs   ׸ ˻ ׸ ̸ Էµȴ.
 * @return string  ׸(Է° $field ׸) ؼ ˻   ִ () ϵȴ.
 */
function qMakeCondField($kvs, $field)
{
	
	// ˻ ׸񿡼 ˻ ˻()  , ˻   ʰ, ׳ Ѵ.
	//  Ŭ̾Ʈ Է°  , ̷ 찡 ߻  ִ.
	// @see : siteapi_client.php
	if ( ! isset ($kvs[$field]) ) return;
	
	$string = trim($kvs[$field]);
	
	isset($kvs["$field cond"]) ? $cond = $kvs["$field cond"] : $cond='';
	
	$cond = strtoupper($cond);
	switch ( $cond )
	{
		case ''			:
			$rs = "$field LIKE '%".$string."%'";
			break;
		case 'OR'		:
			$words = explode(' ', $string);
			foreach ( $words as $word )
			{
				$ar[] = "($field LIKE '%$word%')";
			}
			$rs = implode (' OR ', $ar);
			$rs = "($rs)";
			break;
		case 'AND'	:
			$words = explode(' ', $string);
			foreach ( $words as $word )
			{
				$ar[] = "($field LIKE '%$word%')";
			}
			$rs = implode (' AND ', $ar);
			$rs = "($rs)";
			break;
		default :
			
		default :
			$rs = "$field $cond '$string'";
			break;
	}
	
	return $rs;
}

/**
 * ˻ ʵ, ,  Է ޾Ƽ SQL    .
 *
 * 
 * Է  $kvs  site.search()  struct keys_values ˻  ̴.   Site API  ԰ݿ ´ Է  ִ.
 * ش Ʈ () ԰ݰ ߱ ؼ  ʿϴ. ̷   ļ  qMakeCondField Լ Ѵ.
 *
 * @note    Ʈ Ʋ.   Ʈ  ϴ ũƮ  Լ  Ȱ ϴ  ۼؾѴ.
 *  ʿ ʵ writer, title, description 3̴.
 * 
 * @param indexed-array $kvs ˻ ׸ ˻, ˻ ׸ ˻ ()   迭̴.   Ŭ̾Ʈ    ״θ  ȴ.
 * @return string Էµ ˻ ׸ ǵ鿡 ؼ  ˻   ִ SQL   Ѵ.
 * @since 2007/01/17   AND, OR ɼ ó , jangnan Ʈ óϴ   Դ.
 * @see searchBBS
 */
function qMakeCondFields($kvs)
{
	foreach ( $kvs as $k => $v )
	{
		if ( strstr($k, ' ') ) continue;
		if ( ! $k ) continue;		//@note ˻ϰ ϴ Ű(׸)  ùٸ  н
		
		$cond[] = qMakeCondField($kvs, $k);
	}
	
	
	/**
	 * This code borrowed from jangnan-hometools software.
	 *
	 * if $kvs[exp code] is set to something binary expression (like OR, AND), then it will produce SQL syntax with the given binary code.
	 *
	 */
	if ( isset($cond) && !empty($cond) )
	{
		if ( isset($kvs['exp cond']) ) return "(" . implode(" ".$kvs['exp cond']." ", $cond) . ")";
		else return "(" . implode(" AND ", $cond) . ")";
	}
	/*
	if ( isset($cond) )
		return "(" . implode(" AND ", $cond) . ")";
	*/
}

/**
 * 
 * @see qMakeCondLimit
 */
function qMakeLimit($limit) { return qMakeCondLimit($limit); }

/**
 * site.search ޼ҵ 䱸 ؼ struct limit  ˻     ִ SQL  .
 *
 * κ ͺ̽ LIMIT  ̿밡ϴ.   Լ 𼭵, ״    ִ.
 * @param associative-array $limit ˻ 
 * @return string ˻   ϴ SQL LIMIT 
 * @see searchBBS
 * 
 */
function qMakeCondLimit($limit)
{
	if ( ! isset( $limit['toNumber'] ) || empty($limit['toNumber']))
		$limit['toNumber'] = 0;
	if ( ! isset( $limit['fromNumber'] ) || empty($limit['fromNumber']) )
		$limit['fromNumber'] = 0;
	
	if ( $limit['toNumber'] == -1 )
	{
		$qLimit = '';
	}
	else if ( $limit['fromNumber'] || $limit['toNumber'] )
	{
		$qLimit = "LIMIT $limit[fromNumber], $limit[toNumber]";
	}
	else
	{
		$qLimit = "LIMIT 0, " . _numberOfRecords;
	}
	return $qLimit;
}

/**
 * @see qMakeCondDate
 * @param string $field ⺻  dateTime ʵ ̸ .
 */
function qMakeDate($limit, $field='dateTime') { return qMakeCondDate($limit, $field); }

/**
 * site.search ޼ҵ 䱸  struct limit  ¥ ѿ  ó   ִ SQL   Ѵ.
 *
 *  Լ ¥ ؼ     ִ SQL  ۼؼ Ѵ.
 * ¥    Ǵ  ڿ̴.  Լ ͺ̽ ¥  ̷ ̶  ϰ   ؼ ˻()  SQL  Ѵ.   Լ ϱ ؼ ¥   Ǵ  ڿ̾Ѵ.
 * @param associative-array $limit ˻ 
 * @return string Էµ ǿ  ¥  ϴ SQL  
 * @see searchBBS
 * @note @mod 11/23/2006  ߻ ¥ ʵ尡 'dateTime' ̰ iso8601  string  ¥      Լ 밡ϴ.
 * ׷ κ  ̿   ̴.      ִ ȸ ִ.
 * κ DB     ϸ, ܼ ʵ  Է μ ذ ϴ.
 * @code qMakeDate($limit, 'field-name');
 */
function qMakeCondDate($limit, $field='dateTime')
{
	if ( isset($limit['fromDate']) )
	{
		$cond[] = "($field>='$limit[fromDate]')";
	}
	if ( isset($limit['toDate']) )
	{
		$cond[] = "($field<='$limit[toDate]')";
	}
	
	
	if ( isset($cond) )
		return "(" . implode(" AND ", $cond) . ")";
}

/**
 *   
 *
 * ȸ (α)  ο     public, user ΰ Ѵ.
 *
 * @deprecated 2006/12/19 Լ  ϴ.    ̾ ̵Ѵ. Լ Ī qminState ̾Ѵ.
 * @param string $state public( ) ̳ user( )   ϳ   ִ.    ˻   Ѵ.
 * @return string $state  public Ǵ user  ߿ ϳ  ƴϸ empty  Ѵ.
 */
function qMakeState($state)
{
	if ( $state != 'public' && $state != 'user')
    return;
  if ( $state=='public')
		$re = "(state='public')";
	else
		$re = "(state='public' OR state='user')";
	return $re;
}



/**
 *  ϴ, SQL   .
 *
 */
function qMakeOrder($order)
{
	
	if ( empty($order) ) return '';
	
	foreach( $order as $field => $how )
	{
		if ( ! $field ) continue;									//@note ˻ϰ ϴ Ű(׸)  ùٸ  н
		$q[] = "$field $how";
	}
	$qs = '';
	if ( isset($q) )
	{
		$qs = implode(",", $q);
		$qs = "ORDER BY $qs";
	}
	return $qs;
}
	






  
function checkSearchFields($kvs)
{
}
	

/**
 * site.search ޼ҵ ۾ óѴ.
 *
 * @param string $id  ̵
 * @param string $pw  йȣ
 *	$id  $pw     Ѵ. ʿ        ´.
 *	 Էµ $id  empty  ,  ϴ κ ϸ,   Ѵ.
 *	$id  empty  ƴϰ,  ùٸ    Ѵ.
 *
 * @param array $categories	īװ ̸() Էµȴ.
 * @param associative-array $kvs ˻ ׸ ˻ ׸ ˻   ִ.
 * @param associative-array $limit ˻   , ¥   ִ.
 * @note ˻  ڼ Է¿ ؼ siteapi_spec, siteapi_dataspec  Ѵ.
 * @param associative-array $result $result  迭 ̴. 迭  Ҵ associative-array 迭μ ϳ (ڵ) Ÿ  Ű  ش  ׸  Ÿ(ǥ).
 * @return faultCode   ߻  faultCode  ϵȴ.
 * @note	ùٷ    _ok  ϸ, $result    ϵȴ. ùٸ   ʾ    Ѵ.    ٸ '_site'  ۵Ǵ Լ  ϵǴ  faultCode ̸   siteapi_code  ϵǾ ִ.
 * @note $kvs, $limit  empty    迭  ش.
 * @note īװ Է   , ϳ ˻ Ѵ.
 *  , '', '' ΰ īװ ˻ , ѹ ϴϾ ˻ Ѵ.
 * ̶, Ŭ̾Ʈ  10  , ׿  ó    ó κп ޷ȴ.
 *  #BBS   īװ ѹ ΰ īװ ˻ص   ʰڳ?   Ѵٸ ణ  κ ִ.
 * Ŭ̾Ʈ īװ Է #BBS  '' #USER    īװ ΰ ÿ ˻  ִ.
 * ̿  , ѹ ϳ īװ ˻ϴ   ̴.
 */
function _siteSearch( $id, $pw, $categories, $kvs, $limit, $order, &$result )
{

	// ʱȭ
	$result = array();												//@
	if ( empty($limit) ) $limit = array();
	if ( empty($kvs) ) $kvs = array();

	//
	
	//dbg("$id, $pw, $ret");
	if ( $re = checkA( $id, $pw, $state ) ) return $re;

	
	// $categories  empty   #CATEGORY  ϳ ־ش.
	if ( empty($categories) || count($categories) == 0 )
		$categories[] = '#CATEGORY';

	// ˻.  īװ ˻ Ѵ.
	foreach($categories as $cate)
	{
		$asAr = search($cate, $kvs, $limit, $order, $state, $errno);

		if ( $errno != _ok )
		{
			return $errno;
		}
		if ( $asAr )
			$result = array_merge($result, $asAr);
	}
	return _ok;
}

/**
 * Ŭ̾Ʈ site.getCategoryList û  ó ϴ Լ
 * @note site.search(... '#CATEGORY')  ϴ.
 * @param string $id  ̵
 * @param string $pw  йȣ
 * @param associative-array &$result   
 * @return resultCode
 */
function _siteGetCategoryList($id, $pw, &$result)
{
	$limit = array('toNumber' => -1);
	return _siteSearch($id, $pw, array("#CATEGORY"), array(), $limit, array(), $result);
}


/**
 * ܼ site.search()    ˻ ־   ؼ غ Լ.
 *
 *
 */
function _siteGetUserList($id, $pw, $kvs, $limit, &$result)
{
	$result = array();
	return _siteSearch($id, $pw, array("#USER"), $kvs, $limit, array(), $result);
}
	

/**
 * site.search() ޼ҵ 䱸  ó ϴ Լ̴.
 *
 *@param string $cate īװ.   Ÿ ⺻ īװ ü Էµ  ִ.
 *@param associative-array $kvs ˻ ׸ ˻, ׸ ˻   ִ 迭
 *@param associative-array $limit ˻    ִ 迭. ڼ  Site API ԰ Ѵ.
 *@param string $state  ޼ҵ û Ŭ̾Ʈ (α) θ ǴϿ    public Ǵ user   ˻Ѵ.
 *@param int $errno       ڵ带 ؼ ش.
 *@return array īװ ˻   array  Ѵ. Ѱ ҿ Ѱ (ڵ) ϴ associative-array  ϵȴ. Ű   ׸ ̴.
 *@uses typeCategory
 */
function search($cate, $kvs, $limit, $order, $state, &$errno)
{
	$errno = _ok;
	$asAr = array();

	switch ( typeCategory($cate) )
	{
		case '#CATEGORY'				:
			$asAr = searchCategory($kvs, $limit, $order, $state, $errno);
			break;
		case '#BBS'							:
			$asAr = searchBBS($cate, $kvs, $limit, $order, $state, $errno);
			break;
		case '#USER'						:
			$asAr = searchUser($kvs, $limit, $order, $state, $errno);
			break;
		case '#ZIPCODE'					:
			$asAr = searchZipcode($kvs, $limit, $order, $state, $errno);
			break;
		default:
			$asAr = searchDefault($cate, $kvs, $limit, $order, $state, $errno);
			break;
	}
	
	
	return $asAr;
}




/**
 *   ο    (public or user) Ѵ.
 *
 *  (α) θ ǴϿ,  ùٸ  'public'  Է  $state  Ͽ ϸ  ùٸ   'user'  Է  $state  Ͽ ش.  Լ ϸ   ùٸ Ȥ  Ǿ   ִ.  Լ   $state == 'public' ̸   $state == 'user' ̸  ̴.
 *   θ Ǵϰ    userLogin() Լ ȣؾѴ. Է° $id  empty   userLogin()  _emptyID    Լ _ok  Ѵ.
 *@param string $id  ̵
 *@param string $pw  йȣ
 *@param string &$state     
 *@return int resultCode
 * α Ʋ , _wrongPassword, _wrongID  ϵȴ.
 * α ùٸ _ok  Ѵ.
 * $state  ȣ Լ state  ˾ƺ  ִ.
 * Էµ $id  empty   $state  'public'  , α ùٸ $state  'user'  .
 *@see Site API ԰  
 *@see userLogin
 *@note Լ Check Access Control  ؼϸȴ.
 */
function checkA ($id, $pw, &$state)
{
	$state	= '';
	$ret		= userLogin($id,$pw);
	
	
	if ( $ret == _wrongPassword || $ret == _wrongID )
	{
		return $ret;
	}
	else if ( $ret == _emptyID )
	{
		$state = "public";
		return _ok;
	}
	else if ( $ret == _ok )
	{
		$state = "user";
		return _ok;
	}
	return _unknown;
}
/** 
 * site.getCount û  ó ϴ Լμ Էµ īװ   ϴ ˷ش.
 *
 * Է  $cate  ⺻ īװ  ,  īװ ִ.  īװ  ó ؾѴ.
 * @param string $id  ̵
 * @param string $pw  йȣ
 * @param string $cate īװ ⺻ īװ Ī ״ Էµ  ִ.
 * @param int &$result īװ     ش.
 * @return int  _ok, н faultCode  ϵȴ. ϵǴ faultCode   .
 *	_wrongPassword on wrong password.
 *	_wrongID on wrong id.
 * @todo faultCode _wrongCategory   ó  ʰ ִ.  ʿϴ.
 * @see site.getCount on Site API spec.
 * @uses getCount 
 */
function _siteGetCount($id, $pw, $cate, &$result)
{
	$result = -1;
	if ( $re = checkA( $id, $pw, $state ) ) return $re;
	return getCount($cate, $state, $result);
}

/**
 * īװ ϴ   
 *
 * @param string $cate	īװ
 * @param string $state	 
 * @param int &$result ó ( )  
 * @return int  _ok, н faultCode
 * @see _siteGetCount
 * @todo ⺻ īװ  ʴ īװ? ó   ԰   Ȯ ؾѴ.
 */
function getCount($cate, $state, &$result)
{
	
	switch ( typeCategory($cate) )
	{
		case	''						:
		case	'#CATEGORY'		:
			return getCountCategory($state, $result);
		case	'#USER'				:
			return getCountUser($state, $result);
		case	'#BBS'				:
			return getCountBBS($cate, $state, $result);
		case	'#ZIPCODE'		:
			return getCountZipcode($state, $result);
	}
}




/**
 * Ŭ̾Ʈ site.getEnvironment û  ó Ѵ.
 *@param associative-array $result   
 *@return int resultCode
 */
function _siteGetEnvironment(&$result)
{
	getEnvironment($result);
	return _ok;
}




/**
 *   ش.
 *
 * @todo dataid   ó  ̹Ƿ  datalayer  ó ϵ ؾѴ.
 * ̷ ϱ ؼ getBBSData Լ ȣϴ  ƴ getData Լ ٷ ȣϵ ؾѴ.
 *
 * @param string $id  ̵
 * @param string $pw  йȣ
 * @param string $dataid  ̵
 * @param associative-array &$result   迭
 * @return int resultCode
 * @since 2006/12/23 getBBSData  īװ   ѰѴ. ׷   ˼ ִ. $dataid   īװ  ԵǾ, #BBS.abc.3   , #BBS  abc  3  ̶ ̴.
 */
function _siteGetData($id, $pw, $dataid, &$result)
{
	if ( $re = checkA( $id, $pw, $state ) ) return $re;
	list ($cate, $idx) = explode(".", $dataid,2);
	if ( empty($cate) || empty($idx) ) return fault(_wrongInput, "Mallformed dataid - '$dataid'.");
	switch( typeCategory($cate) )
	{
		case '#BBS'			:
			return getBBSData($id, $state, $idx, $result);
			break;
	}
	return _serviceUnavailable;
}


/**
 * Ŭ̾Ʈ site.help û óѴ.
 *
 *@param string $result  ´.
 *@return faultCode
 */
function _siteHelp(&$result)
{
	help($result);
	return _ok;
}

/**
 * 밡 ޼ҵ Ʈ Ѵ.
 *
 */
function _siteListMethods(&$result)
{
	return listMethods($result);
}



/**@+
 * Blogger API ó
 *
 * ⼭     ʴ´. ,  Լ   ó ؾѴ.
 * @return faultCode
 */
/**
 *
 * @param ref &$result
 */
function _bloggerGetUserInfo($id, $pw, &$result)
{
	return blogger_getUserInfo($id, $pw, $result);
}
/**
 * blogger.getUsersBlogs ó
 */
function _bloggerGetUsersBlogs($id, $pw, &$result)
{
	return blogger_getUsersBlogs($id, $pw, $result);
}
/**
 * blogger.getUsersBlogs ó
 */
function _bloggerGetRecentPosts($blogid, $id, $pw, $number, &$result)
{
	return blogger_getRecentPosts($blogid, $id, $pw, $number, $result);
}
/**
 * blogger.getPost ó
 */
function _bloggerGetPost($postid, $id, $pw, &$result)
{
	return blogger_getPost($postid, $id, $pw, $result);
}
function _bloggerNewPost($blogid, $id, $pw, $content, $publish, &$result)
{
	return blogger_newPost($blogid, $id, $pw, $content, $publish, $result);
}
function _bloggerEditPost($postid, $id, $pw, $content, $publish, &$result)
{
	return blogger_editPost($postid, $id, $pw, $content, $publish, $result);
}
function _bloggerDeletePost($postid, $id, $pw)
{
	return blogger_deletePost($postid, $id, $pw);
}
/**@-*/
/**@+
 * Meta Weblog API ó
 *
 */
/**
 *
 */
function _metaWeblogGetCategories($blogid, $id, $pw, &$result)
{
	return metaWeblog_getCategories($blogid, $id, $pw, $result);
}
function _metaWeblogGetRecentPosts($blogid, $id, $pw, $number, &$result)
{
	return metaWeblog_getRecentPosts($blogid, $id, $pw, $number, $result);
}
function _metaWeblogGetPost($postid, $id, $pw, &$result)
{
	return metaWeblog_getPost($postid, $id, $pw, $result);
}
function _metaWeblogNewPost($blogid, $id, $pw, $struct, $publish, &$result)
{
	/** @note Windows Live Writer  dateCreated  ȳѱ. ǥ Ű ʴ´. ⺻  ó Ѵ. */
	if ( ! isset($struct['dateCreated']) ) $struct['dateCreated'] = encodeDateTime(time());
	return metaWeblog_newPost($blogid, $id, $pw, $struct, $publish, $result);
}
function _metaWeblogEditPost($postid, $id, $pw, $struct, $publish, &$result)
{
	return metaWeblog_editPost($postid, $id, $pw, $struct, $publish, $result);
}
function _metaWeblogNewMediaObject($blogid, $id, $pw, $struct, &$result)
{
	/**
	 * @since 2007/01/05 Zoundry  type ׸   ʴ´. ǥ Ű ʴ, ׷鼭  ̴ α Ŭ̾Ʈ  Ӹ .
	 *   ⺻ ó Ѵ.
	 */
	if ( ! isset($struct['type']) ) $struct['type'] = 'image/jpeg';
	return metaWeblog_newMediaObject($blogid, $id, $pw, $struct, $result);
}
/**@-*/
?>
