<?php
/**
 * Site API 작업에 필요한 각종 코드(에러 코드, 에러 문자열 등)를 기록한다.
 * 오류 코드를 리턴할때에는 부가적인 정보를 faultString 에 {} 괄호로 감싸서 담을 수 있다. 예를 들면, _wrongCategory 오류 코드를 발생할 때에는 그 카테고리 이름을 {} 로 감싸주어야한다.
 * 
 */



define ("default_return_numberOfRecords",				10,		true);
define ("_numberOfRecords",											default_return_numberOfRecords, true);


if ( ! defined("_ok") ) define ("_OK", 					0,		true);
//if ( defined('ok') ) define ("ok",						_OK,	true); // @since 2006/12/19 다른 스크립트에서 충돌 발생


define ("_wrongAccess",									404, true);
$faultString[_wrongAccess]							= "You have accessed this page in a bizarre way."; // wrong connection

define ("_unknown",											999, true);
define ("_unknownErrorOnDB",						1010, true);
define ("_dberror",											_unknownErrorOnDB, true);
$faultString[_unknown]									= "unknown exception has occurred on the server";
$faultString[_unknownErrorOnDB]					= "Unknown error happend on database work. Please contact to the client master!";


define ("_notWellFormed",								1200, true);

define ("_wrongInput",									1210, true);
$faultString[_wrongInput]								= "Wrong input.";
//$faultString[_wrongInput]								= "There is something wrong in the request.";


define ("_wrongID",											2010, true);		// ID does not exist
define ("_emptyID", 										2013, true);
define ("_wrongPassword",								2020, true);
$faultString[_wrongID]									= "You submitted wrong ID or the ID does not exist";
$faultString[_emptyID]									= "ID is empty string";
$faultString[_wrongPassword]						= "You have got the worng password";


define ("_wrongCategory",								2220, true);
$faultString[_wrongCategory]						= "You have submitted wrong category name or the category does not exist";
define ("_wrongDataID",									2221, true);
$faultString[_wrongDataID]							= "You have got the wrong dataid.";


define ("_denied",											3001, true);			// 거부됨 (#권한 제어 리스트 참조 )
define ("_accessDenied",								_denied, true);		// 권한 거부
$faultString[_denied]										= "You do not have permmision on this information.";

define ("_serviceUnavailable",					3002, true);
$faultString[_serviceUnavailable]				= "The service(methods) you just have requested does not available at this moment.";

define ("_init",												3100, true);
$faultString[_init]											= "Init failed.";

define ("_noData",											3200, true);
$faultString[_noData]										= "Cound not get data. There might be no data by that dataid(postid), or you have no permission on that data.";

define ("_diskAccess",									3300, true);
$faultString[_diskAccess]								= "Failed to access disk file.";



/**
 * 이 스크립트에 정의된 기본 적인 에러 코드와 문자열 외에 개발자가 직접 본 에러 문자열을 추가하기 위한 함수이다.
 *
 * $_faultExString 변수에 추가 에러 문자열을 기록한다.
 * @param int $code 오류 코드
 * @param string $string 오류 문자열(기본 오류 코드 문자열에 추가될 문자열)
 * @return midxed $code 또는 전 호출시의 문자열 값을 리턴한다.
 * @code	if ( empty($no) ) return fault(_wrongInput, "Mallformed data number 'dataid'.");
 * @note 만약 $code 값이 empty 이면 이전 호출로 기록된 $_faultExString의 값을 리턴한다. 추가된 문자열은 \n과{} 로 감싸진다. 이 문자열을 기준으로 기본 오류 메세지와 구분을 한다. $code 에 값이 있고 입력 변수 $string 이 empty 이면, 해당 code 에 대한 faultString 과 오류 메세지로 기록된 $_faultExString 을 같이 리턴한다.
 * <code>
 * $re = _siteGetCategoryList($id, $pw, $result);
 * if ( $re != _ok )
 * {
 * 	echo "Error> faultCode: $re, faultString:".fault($re);
 * 	exit;
 * }
 * </code>
 */
function fault($code='', $string='')
{
	global $_faultExString, $faultString, $env;
	if ( empty($code) ) return "$_faultExString";
	if ( $code && empty($string) ) return "Site Open API Version $env[api_version] for ".SOFTWARE." by $env[developer_name] ::$faultString[$code] $_faultExString";
	$_faultExString .= $string;
	return $code;
}





?>
