<?php
/**
 * Site API 클라이언트
 *
 * @see http://siteapi.kldp.net
 * @note 본 스크립트는 PHPXMLRPC 라이브러리를 이용한다. 본 스크립트는 이 라이브러리의 (클라이언트 적인 면에서)사용법을 자세히 다룬다.
 * @note Site API 의 PHP 버젼을 제작하기 위한 테스트 클라이언트 스크립트이다.
 * @note Site API Server 를 작성한 다음 최종적으로 본 스크립트를 웹에서 액세스하여 확인을 할 수 있다. 물론 질의에 필요한 값들은 수정을 해야한다.
 *
 * @note 테스트 과정
 *	- 먼저 해당 siteapi_datalayer_{site}.php 스크립트를 작성하고
 *	- siteapi_datalayer_test.php 를 통해서 작업 체크를 한다.
 *	- 그리고 난 후 본 스크립트를 사용해서 작업의 결과를 최종 확인한다.
 * @note 입력값이 틀리면 여러 형태로 에러가 발생할 수 있다. 문자셋의 오류도 그 중 하나의 예이다.
 * 
 * @note 인자를 빈 값으로 호출할 수는 있어도, 생략하면 서버 internal error 가 발생한다.
 *
 */

include("xmlrpc-2.1/lib/xmlrpc.inc");
include("siteapi_default_library.php");
include("siteapi_dataspec_library.php");
include("libetc.php");


list($endpoint,$_trash) = split("siteapi_client.php","http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
echo "<h1>Site API</h1>";
echo "<font color=blue><b>end point:</b></font> $endpoint<br>";
$client = new xmlrpc_client( $endpoint );
//$GLOBALS['xmlrpc_internalencoding']='UTF-8';
//$client->return_type = 'xmlrpcvals';



$msg				= new xmlrpcmsg("site.getEnvironment");
//$client->setDebug(1);
$re = rpcQueryStruct($msg, false);

echo "<font color=blue><b>site:</b></font> $re[site_name]<br>";
echo "<font color=blue><b>api_version :</b></font> $re[api_version]<br>";
echo "<font color=blue><b>password_type:</b></font> $re[password_type]<br>";
echo "<br><hr><br>";





if ( $re['password_type'] == 'md5' ) {
	//	$id = 'thesky'; $pw = md5('1234');	//필요한 경우, 비밀번호는 md5 로 인코딩 되어야한다.
	//	$id = 'lopy'; $pw = md5('1111');
}
else
{
	$id = 'thruthesky'; $pw = '1111';
	$id = 'admin'; $pw = '1111'; //gnuboard4
	$id = 'thruthesky'; $pw = '1111'; //gnuboard4
}

if ( $re['charset'] == 'utf8')
{
	echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
	$GLOBALS['xmlrpc_internalencoding']='UTF-8';
}
else
{
echo '<meta http-equiv="Content-Type" content="text/html; charset=euc-kr" />';
}
echo '<font size=2>';
echo "<b>$id : $pw</b><br>";


// site.GetEnvironment() 예제
echo "[Request: site.getEnvironment()]";
$re = rpcQueryStruct($msg);


// setDebug 를 통해서 서버의 각종 스크립트 에러 체크를 할 수 있다. 필요할 때, 아래와 같이 사용한다.
$cate = '#CATEGORY';				// 기본 카테고리 중 하나이다. 자세한 것은 규격을 참고
// 예제 1) site.getCount
echo "[Request: site.getCount($cate)]";
$pa[]			= new xmlrpcval($id,'string');
$pa[]			= new xmlrpcval($pw,'string');
$pa[]			= xs($cate);	// new xmlrpcval($cate,'string'); 과 동일. 간편하게 사용을 하기 위해서 함수화
$msg			= new xmlrpcmsg("site.getCount", $pa);

$resp			= $client->send( $msg );

// 아래와 같이 XML 데이터를 직접 살펴볼 수 있다.
//echox($msg->serialize());				// 요청 XML 데이터
//echox($resp->serialize());			// 응답 XML 데이터
//$client->setDebug(1);
printResultString($resp);		// 반복된 출력 문장들을 함수화.


// 예제 2) site.getCount
unset($pa);
$cate = '#USER';
echo "[Request: site.getCount($cate)]";
$pa[]			= xs($id);
$pa[]			= xs($pw);
$pa[]			= xs($cate);
$msg			= new xmlrpcmsg("site.getCount", $pa);

$resp			= $client->send( $msg );
printResultString($resp);




///////////////////////////////////////////////////////////////////////////////
//
//@example #CATEGORY 검색 예.
echo "<br>[Request: site.search(#CATEGORY)]";
// 입력 예11)
// 입력 예12)
// 입력 예13)
unset($pa);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa(array('#CATEGORY'));
$pa[]				= xas(array(''));
$pa[]				= xas(array('toNumber'=>10));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
$arCate = rpcQuery($msg);

///////////////////////////////////////////////////////////////////////////////

//
echo "[Request: site.search()]";

unset($pa);
$limit			= xas(array('fromNumber' => 0, 'toNumber' => -1, 'fromDate'=> '20060113T01:01:01'));//, 'toDate'=>'20061113T13:46:01'));
$kvs				= xas(array('title'=>'다 자 테 기 다 는', 'title cond'=>'OR'));//, 'description'=>'운동 다이어트 비만', 'description cond'=>'AND'));
$pa[]				= xs($id);
$pa[]				= xs($pw);

foreach ( $arCate as $e )
{
	$ar [] = $e['category'];
}
$pa[]				= xa( $ar );

$pa[]				= $kvs;
$pa[]				= $limit;
$pa[]				= xas(array('dateTime'=>'ASC'));
$msg				= new xmlrpcmsg("site.search", $pa);
//echox( $msg->serialize() );
//$client->setDebug(1);
//dbg($ar);
rpcQuery($msg);







//입력 예2.
unset($pa);
echo "[Request: site.search(#BBS)]";
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa(array("#BBS"));
$pa[]				= xas(array(''));
$pa[]				= xas(array(''));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
rpcQuery($msg);

	

//입력 예3. 인자 2개를 빈 값으로 전달
unset($pa);
echo "[Request: site.search(#BBS) 2]";
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa(array("#BBS"));
$pa[]				= xas(array(''));							//@note 특정 입력값을 생략하는 것은 이렇게 한다.
$pa[]				= xas(array('toNumber'=>-1));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
rpcQuery($msg);


//입력 예4. 질의 테스트
echo "[Request: site.search( categories : Query TEST )]";
unset($pa); unset($ar);
foreach ( $arCate as $e )
{
	$ar [] = $e['category'];
}
if ( count($ar) > 1 ) array_pop($ar);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa($ar);
$pa[]				= xas(array('title'=>'새 다', 'title cond'=>'OR'));
$pa[]				= xas(array(''));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
rpcQuery($msg);



//입력 예5. #USER 와 #BBS 혼용
unset($pa);
echo "[Request: site.search( #BBS, #USER )]";
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa(array('#BBS','#USER'));
$pa[]				= xas(array(''));
$pa[]				= xas(array('toNumber'=>-1, 'fromDate'=>'20061126T00:00:00'));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
rpcQuery($msg);


// 입력 예14)
echo "[Request: site.search(#CATEGORY)]";
unset($pa);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa(array('#CATEGORY'));
$pa[]				= xas(array('title'=>'자 공 질', 'title cond'=>'OR'));//, 'state'=>'user'));
$pa[]				= xas(array('toNumber'=>20));
$pa[]				= xas(array('title'=>'ASC', 'dateTime'=>'DESC'));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
rpcQuery($msg);




// ///////////////////////////////////////////////////////////////////////////////
// @note -- 우편 번호 검색 예.
// @see siteapi_dataspec.txt
echo "[Request: site.search('#ZIPCODE')]";

// 예제 21) 우편 번호 검색 입력 
unset($pa);
$pa[]				= xs('');
$pa[]				= xs('');
$pa[]				= xa(array('#ZIPCODE'));
$pa[]				= xas(array(''));
$pa[]				= xas(array('toNumber'=>20));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
rpcQuery($msg);

// 예제 22) 우편 번호 검색 입력 
echo "[Request: site.search('#ZIPCODE')]";
unset($pa);
$pa[]				= xs('');
$pa[]				= xs('');
$pa[]				= xa(array('#ZIPCODE'));
$pa[]				= xas(array('city'=>'김해', 'street'=>'상동 대동 한림 주촌', 'street cond'=>'OR'));
$pa[]				= xas(array('fromNumber'=>10, 'toNumber'=>20));
$pa[]				= xas(array('street'=>'ASC'));
$msg				= new xmlrpcmsg("site.search", $pa);
rpcQuery($msg);


// -------------------------
// 회원 정보 검색 입력 예
echo "[Request: site.search(#USER)]";
unset($pa);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa(array('#USER'));
$pa[]				= xas(array(''));
$pa[]				= xas(array('toNumber'=>-1));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
rpcQuery($msg);

// 예) 42
echo "[Request: site.search(#USER)] 2";
unset($pa);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[]				= xa(array('#USER'));
$pa[]				= xas(array('id'=>'p m 4', 'id cond'=>'OR'));
$pa[]				= xas(array('toNumber'=>-1));
$pa[]				= xas(array(''));
$msg				= new xmlrpcmsg("site.search", $pa);
//$client->setDebug(1);
rpcQuery($msg);






echo "[Reqeust: site.help()]";
unset($pa);
$msg				= new xmlrpcmsg("site.help");
$re					= $client->send( $msg );
//$client->setDebug(1);
printResultString($re);

echo "[Request: site.echo]";
unset($pa);
$pa[] = xs("abcdefg hijk lmn op^^");
$msg				= new xmlrpcmsg("site.echo", $pa);		// 인자를 1개 넘길때라도 xmlrpcmsg 인자로 넣을 때에는 배열 변수에 넣어야한다.
$re					= $client->send( $msg );
printResultString($re);

echo "[Request: site.getServerDateTime]";
unset($pa);
$msg				= new xmlrpcmsg("site.getServerDateTime");
$re					= $client->send( $msg );
printResultString($re);


echo "[Request: site.listMethods]";
$msg				= new xmlrpcmsg("site.listMethods");
//echox($msg->serialize());
rpcQueryArray($msg);



// 
echo "[Request: site.getCategoryList()]";
unset($pa);
//
$pa[] = xs($id);
$pa[] = xs($pw);
$msg				= new xmlrpcmsg("site.getCategoryList", $pa);
rpcQuery($msg);






echo "[Request: site.getUserList()]";
unset($pa);

$pa[]		= xs($id);
$pa[]		= xs($pw);
$pa[]		= xas(array(''));
$pa[]		= xas(array(''));
$msg		= new xmlrpcmsg("site.getUserList", $pa);
rpcQuery($msg);


echo "[Request: site.getUserList(Wrong id pw)]";
unset($pa);
$pa[]		= xs('1111');
$pa[]		= xs(md5('2222'));
$pa[]		= xas(array(''));
$pa[]		= xas(array(''));
$msg		= new xmlrpcmsg("site.getUserList", $pa);
//$client->setDebug(1);
rpcQuery($msg);










// 예제 71) site.getData
echo "[Request: site.getData(ERROR TEST)]";
unset($pa);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[] 			= xs('#BBS.');
$msg				= new xmlrpcmsg("site.getData", $pa);
//$client->setDebug(1);
rpcQueryStruct($msg);
echo "[Request: site.getData(ERROR TEST)]";
unset($pa);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[] 			= xs('#BBS.user.');
$msg				= new xmlrpcmsg("site.getData", $pa);
//$client->setDebug(1);
rpcQueryStruct($msg);


echo "[Request: site.getData()]";

unset($pa);
$pa[]				= xs($id);
$pa[]				= xs($pw);
$pa[] 			= xs('#BBS.user.7');
$msg				= new xmlrpcmsg("site.getData", $pa);
//$client->setDebug(1);
rpcQueryStruct($msg);










echo "<br>The End.";




























function printResultString($resp)
{
	echo " Query ";
	$fc				= $resp->faultCode();
	if ( $fc )
	{
		$fs = $resp->faultString();
		echo "Failed. faultCode=>$fc faultString=>$fs";
	}
	else
	{
		$val		= $resp->value();
		echo "Successs. " . $val->scalarval();
	}
	echo "<br>";
}


// printResultString($resp); 와 같은 역활을 한다.
// 틀린점은 직접 요청 메세지를 받아서 서버로 질의를 하고 결과는 array{associative-arrays} 로 받아서
// 화면으로 출력한다.
// @return 서버로부터 응답값을 array { associative-array } 2 차원 배열로 리턴한다.
function rpcQuery($msg)
{
	global $client;
	echo " Response... ";
//	$client->setDebug(1);
	$re					= $client->send( $msg );
	$fc					= $re->faultCode();
	if ( $fc )
	{
			$fs = $re->faultString();
			echo "Failed. faultCode=>$fc, faultString=>$fs";
	}
	else
	{
		echo "Success.";
		$val = $re->value();
		$n = $val->arraysize();
		
		echo " $n records.<br>";
	//	echox($val->serialize());
		
		if ( $n )
		{
			for($i=0; $i<$val->arraysize(); $i++)
			{
				$e = $val->arraymem($i);
				$as = array();
				while(list($k,$v) = $e->structeach())
				{
					$as[$k] = $v->scalarval();
				}
				$posts[] = $as;
			}
			foreach ($posts as $e)
			{
				if ( isset($e['url']) && !empty($e['url'])) echo "<a href='$e[url]' target=_blank>";
				echo "[". $e[category] ."] dataid: $e[dataid], writer: $e[writer], title:".strip_tags($e[title])."";
				echo " dateTime: $e[dateTime] ";
				if ( isset($e['url']) && !empty($e['url'])) echo "</a>";
				echo "<br>";
			}
		}
	}
	echo "<br>";
	return $posts;
} // eo rpcQuery


/**
 *
 * @param bool $pr 메세지를 웹브라우저로 출력할지 여부를 결정한다.
 * @return associative-array 서버로 부터의 응답을 연관 배열로 리턴
 */
function rpcQueryStruct($msg, $pr = true)
{
	global $client;
	if ($pr) echo " Response... ";
	
	$re					= $client->send( $msg );
	$fc					= $re->faultCode();
	if ( $fc )
	{
			$fs = $re->faultString();
			echo "Failed. faultCode=>$fc, faultString=>$fs";
	}
	else
	{
		if ( $pr ) echo "Success.";
		$val = $re->value();
		while(list($k,$v) = $val->structeach())
		{
			$en[$k] = $v->scalarval();
		}
		if ( $pr ) {
			foreach ($en as $k => $v )
			{
				echo "<div style='float:left; width:250; color:darkred'>$k</div><div style=''>$v</div>
				<div style='clear:both;'></div>";
			}
			//dbg($en);
		}
		return $en;
	}
	echo "<br>";
} // eo rpcQueryStruct


function rpcQueryArray($msg)
{
	global $client;
	echo " Response... ";
	
	$re					= $client->send( $msg );
	$fc					= $re->faultCode();
	if ( $fc )
	{
			$fs = $re->faultString();
			echo "Failed. faultCode=>$fc, faultString=>$fs";
	}
	else
	{
		echo "Success.";
		echo "<br>";
		$val = $re->value();
		$n = $val->arraysize();
	
		for($i=0; $i<$val->arraysize(); $i++)
		{
			$e = $val->arraymem($i);
			echo $e->scalarval()."<br>";
		}
	}
	echo "<br>";
} // eo rpcQueryStruct

?>
