{=======================================================}
{                                                       }
{  Boru Main Unit Beta Ver.                             }
{                                                       }
{  Made by Mingyu Kim(walbum123@gmail.com)              }
{                                                       }
{  This program and All units follows MPL 1.1           }
{                                                       }
{  Apple Computers, Inc. has all icons' copyright.    }
{                                                       }
{=======================================================}
// To do list
//

unit Main;

//----------------------------//
interface
//----------------------------//

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, PNGImage, StdCtrls, TlHelp32, Buttons, Registry,
  ComCtrls, Md5sum, Gauges, CDBManager, CFunctions, URLMon, CheckLst, PsApi,
  ztvBase, ztvUnBH, ztvregister, ztvBlakHole;

type
  TScanThread = class(TThread)
  private
    Procedure Scan;
  protected
    Procedure Execute; override;
end;
type
  TLoadThread = class(TThread)
  private
    Function FileNumber(Folder, Extension: String): Boolean;
  protected
    Procedure Execute; override;
end;
type
  TMainForm = class(TForm)
    Logo: TImage;
    Menu: TImage;
    Ops: TMemo;
    Lang: TMemo;
    Pages: TNotebook;
    Info: TLabel;
    Ver: TMemo;
    PrcButton: TLabel;
    PrvButton: TLabel;
    OpmButton: TLabel;
    UpdButton: TLabel;
    LsButton: TLabel;
    CcButton: TLabel;
    LangLabel: TLabel;
    SkinLabel: TLabel;
    EngineLabel: TLabel;
    Prc: TLabel;
    Prv: TLabel;
    Opm: TLabel;
    Upd: TLabel;
    Ls: TLabel;
    Cc: TLabel;
    Line: TImage;
    PrcPL: TLabel;
    RTSImage: TImage;
    RTSStat: TMemo;
    OptionsGB: TGroupBox;
    OptNB: TLabel;
    DateNB: TLabel;
    Line2: TImage;
    Line3: TImage;
    SkinNB: TLabel;
    LangNB: TLabel;
    Update: TLabel;
    EnptNB: TLabel;
    EnSz: TLabel;
    BsSz: TLabel;
    OpSz: TLabel;
    PrvPL: TLabel;
    OptPL: TLabel;
    Line4: TImage;
    Line5: TImage;
    Line6: TImage;
    Line7: TImage;
    Line8: TImage;
    SSet: TMemo;
    DateGB: TGroupBox;
    Log: TLabel;
    Scanbox: TGroupBox;
    ScanStart: TButton;
    Cancel: TButton;
    Option: TLabel;
    Drives: TListBox;
    ScanList: TListBox;
    MyFolder: TEdit;
    Cure: TButton;
    Delete: TButton;
    UpdProg: TGauge;
    UpdCl: TButton;
    Status: TLabel;
    IFileList: TCheckListBox;
    BakupFiles: TListBox;
    Language: TComboBox;
    Skin: TComboBox;
    Engine: TComboBox;
    OKButton: TButton;
    ResultGB: TGroupBox;
    AllFile: TLabel;
    LoadFile: TLabel;
    ScanProc: TLabel;
    LoadProc: TLabel;
    BakupLists: TListBox;
    BakupConts: TListBox;
    Restore: TButton;
    UnBh1: TUnBh;
    MD5: TEdit;
    Md5Open: TOpenDialog;
    Click: TButton;
    procedure FormCreate(Sender: TObject);
    procedure PrcClick(Sender: TObject);
    procedure PrcButtonClick(Sender: TObject);
    procedure PrvClick(Sender: TObject);
    procedure PrvButtonClick(Sender: TObject);
    procedure OpmButtonClick(Sender: TObject);
    procedure OpmClick(Sender: TObject);
    procedure UpdClick(Sender: TObject);
    procedure UpdButtonClick(Sender: TObject);
    procedure LsClick(Sender: TObject);
    procedure LsButtonClick(Sender: TObject);
    procedure CcClick(Sender: TObject);
    procedure CcButtonClick(Sender: TObject);
    procedure PrcMouseEnter(Sender: TObject);
    procedure PrcButtonMouseEnter(Sender: TObject);
    procedure PrcMouseLeave(Sender: TObject);
    procedure PrcButtonMouseLeave(Sender: TObject);
    procedure PrvMouseEnter(Sender: TObject);
    procedure PrvButtonMouseEnter(Sender: TObject);
    procedure PrvMouseLeave(Sender: TObject);
    procedure PrvButtonMouseLeave(Sender: TObject);
    procedure OpmMouseEnter(Sender: TObject);
    procedure OpmButtonMouseEnter(Sender: TObject);
    procedure OpmMouseLeave(Sender: TObject);
    procedure OpmButtonMouseLeave(Sender: TObject);
    procedure UpdMouseEnter(Sender: TObject);
    procedure UpdButtonMouseEnter(Sender: TObject);
    procedure UpdMouseLeave(Sender: TObject);
    procedure UpdButtonMouseLeave(Sender: TObject);
    procedure LsMouseEnter(Sender: TObject);
    procedure LsButtonMouseEnter(Sender: TObject);
    procedure LsMouseLeave(Sender: TObject);
    procedure LsButtonMouseLeave(Sender: TObject);
    procedure CcMouseEnter(Sender: TObject);
    procedure CcButtonMouseEnter(Sender: TObject);
    procedure CcMouseLeave(Sender: TObject);
    procedure CcButtonMouseLeave(Sender: TObject);
    procedure RTSStatMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure RTSStatEnter(Sender: TObject);
    procedure RTSStatMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure RTSStatDblClick(Sender: TObject);
    procedure RTSStatStartDrag(Sender: TObject; var DragObject: TDragObject);
    procedure ScanStartClick(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CureClick(Sender: TObject);
    procedure DeleteClick(Sender: TObject);
    procedure DrivesClick(Sender: TObject);
    procedure ScanListClick(Sender: TObject);
    procedure MyFolderClick(Sender: TObject);
    procedure UpdClClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure ClickClick(Sender: TObject);
  private
    ScanThread: TThread;
    LoadThread: TThread;
  public
  end;
var
  FileList: TStringList;
  InfectedFile: TStringList;
  IFileType: TStringList;
  UpdtList: TStringList;
  MainForm: TMainForm;
  SkinDir: String;
  ScanFolder: String;
  CancelIf: Boolean;
  PrcIf: Boolean;
  PrvIf: Boolean;
  OpmIf: Boolean;
  UpdIf: Boolean;
  LsIf: Boolean;
  CcIf:  Boolean;
  ScanEnd: Boolean;
  UpdYeobu: Boolean;
  Scan: TFileStream;
  FileIndex: Integer;
  ScanCount: Integer;
  CDBLoad: TCDBManager;
  LoadEnd: Boolean;
  Scan2: String;

//----------------------------//
implementation

{$R *.dfm}
//----------------------------//

procedure TMainForm.FormCreate(Sender: TObject);
var
  OpenFile: Integer;
  FSizeHigh: DWORD;
  FSizeLow: DWORD;
begin
  Pages.PageIndex := 0;
  Prc.font.Color := $000080;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [fsBold];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [];
  Ls.font.Style := [];
  Cc.font.Style := [];
  PrcIf := True;
  PrvIf := False;
  OpmIf := False;
  UpdIf := False;
  LsIf := False;
  CcIf := False;
  ScanEnd := True;
  // ҷ
  Try
    Ops.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Option.cst')
  Except
    Showmessage('Load Error!(No Option File)');
    Application.Terminate;
  end;
  CDBLoad := TCDBManager.Create(ExtractFilePath(Application.ExeName)+ 'Database\' + copy(Ops.lines[4], 10, Length(Ops.lines[4])));
  CDBLoad.Connect;
  SkinDir := copy(Ops.lines[2], 8, Length(Ops.lines[2]));
  // ҷ
  Try
    Ver.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Version.cst')
  Except
    Application.Terminate;
  end;
  // ҷ
  Try
    Lang.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Lang\' + copy(Ops.lines[3], 8, Length(Ops.lines[3])));
  Except
    Application.Terminate;
  end;
  Try
    SSet.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '.cst');
  Except
    Application.Terminate;
  end;
  RTSStat.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0])));
  OptionsGB.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0])));
  DateGB.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0]))); 
  IFileList.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0])));
  Pages.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0])));  
  BakupFiles.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0])));
  BakupLists.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0])));
  BakupConts.Color := StringToColor(copy(SSet.lines[0], 12, Length(SSet.lines[0])));
  Logo.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Logo.png');
  Menu.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Menu.png');
  Line.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  Line2.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  Line3.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  Line4.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  Line5.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  Line6.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  Line7.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  Line8.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ 'Skin\' + SkinDir + '\Line.png');
  //ĸ 
  MainForm.Caption := copy(Utf8Decode(Lang.lines[0]), 9, Length(Utf8Decode(Lang.lines[0])));
  Prc.Caption := copy(Utf8Decode(Lang.lines[3]), 19, Length(Utf8Decode(Lang.lines[3])));
  Prv.Caption := copy(Utf8Decode(Lang.lines[4]), 8, Length(Utf8Decode(Lang.lines[4])));
  Opm.Caption := copy(Utf8Decode(Lang.lines[5]), 12, Length(Utf8Decode(Lang.lines[5])));
  Upd.Caption := copy(Utf8Decode(Lang.lines[6]), 11, Length(Utf8Decode(Lang.lines[6])));
  Update.Caption := copy(Utf8Decode(Lang.lines[6]), 11, Length(Utf8Decode(Lang.lines[6])));
  Ls.Caption := copy(Utf8Decode(Lang.lines[7]), 14, Length(Utf8Decode(Lang.lines[7])));
  Cc.Caption :=  copy(Utf8Decode(Lang.lines[8]), 12, Length(Utf8Decode(Lang.lines[8])));
  PrcPL.Caption := copy(Utf8Decode(Lang.lines[3]), 19, Length(Utf8Decode(Lang.lines[3])));
  OptNB.Caption := copy(Utf8Decode(Lang.lines[13]), 12, Length(Utf8Decode(Lang.lines[13])));
  DateNB.Caption := copy(Utf8Decode(Lang.lines[14]), 12, Length(Utf8Decode(Lang.lines[14])));
  SkinNB.Caption := copy(Utf8Decode(Lang.lines[15]), 8, Length(Utf8Decode(Lang.lines[15]))) + copy(Utf8Decode(Ops.lines[2]), 8, Length(Utf8Decode(Ops.lines[2])));
  LangNB.Caption := copy(Utf8Decode(Lang.lines[16]), 8, Length(Utf8Decode(Lang.lines[16]))) + copy(Utf8Decode(Ops.lines[3]), 8, Length(Utf8Decode(Ops.lines[3])));
  EnptNB.Caption := copy(Utf8Decode(Lang.lines[18]), 10, Length(Utf8Decode(Lang.lines[18]))) + copy(Utf8Decode(Ops.lines[4]), 10, Length(Utf8Decode(Ops.lines[4])));
  SkinLabel.Caption := copy(Utf8Decode(Lang.lines[15]), 8, Length(Utf8Decode(Lang.lines[15])));
  LangLabel.Caption := copy(Utf8Decode(Lang.lines[16]), 8, Length(Utf8Decode(Lang.lines[16])));
  EngineLabel.Caption := copy(Utf8Decode(Lang.lines[18]), 10, Length(Utf8Decode(Lang.lines[18])));
  Info.Caption := copy(Utf8Decode(Lang.lines[1]), 11, Length(Utf8Decode(Lang.lines[1]))) + copy(Utf8Decode(Ver.lines[0]), 15, Length(Utf8Decode(Ver.lines[0]))) + '   ' + copy(Utf8Decode(Lang.lines[2]), 10, Length(Utf8Decode(Lang.lines[2]))) + CDBLoad.Version;
  OpenFile := FileOpen(ExtractFilePath(Application.ExeName) + '\Database\' + copy(Utf8Decode(Ops.lines[4]), 10, Length(Utf8Decode(Ops.lines[4]))), fmOpenRead+fmShareDenyNone);
  FSizeLow := GetFileSize(OpenFile, @FSizehigh);
  FileClose(OpenFile);
  EnSz.Caption := copy(Utf8Decode(Lang.lines[19]), 14, Length(Utf8Decode(Lang.lines[19]))) + IntToStr((FSizehigh shl 16) or FSizelow);
  OpenFile := FileOpen(ExtractFilePath(Application.ExeName) + '\Boru.exe', fmOpenRead+fmShareDenyNone);
  FSizeLow := GetFileSize(OpenFile, @FSizehigh);
  FileClose(OpenFile);
  BsSz.Caption := copy(Utf8Decode(Lang.lines[20]), 12, Length(Utf8Decode(Lang.lines[20]))) + IntToStr((FSizehigh shl 16) or FSizelow);
  OpenFile := FileOpen(ExtractFilePath(Application.ExeName) + '\Option.cst', fmOpenRead+fmShareDenyNone);
  FSizeLow := GetFileSize(OpenFile, @FSizehigh);
  FileClose(OpenFile);
  OpSz.Caption := copy(Utf8Decode(Lang.lines[21]), 18, Length(Utf8Decode(Lang.lines[21]))) + IntToStr((FSizehigh shl 16) or FSizelow);
  OpenFile := FileOpen(ExtractFilePath(Application.ExeName) + '\CLog.cst', fmOpenRead+fmShareDenyNone);
  FSizeLow := GetFileSize(OpenFile, @FSizehigh);
  FileClose(OpenFile);
  PrvPL.Caption := copy(Utf8Decode(Lang.lines[4]), 8, Length(Utf8Decode(Lang.lines[4])));
  OptPL.Caption := copy(Utf8Decode(Lang.lines[5]), 12, Length(Utf8Decode(Lang.lines[5])));
  ScanStart.Caption := copy(Utf8Decode(Lang.lines[23]), 13, Length(Utf8Decode(Lang.lines[23])));
  Cure.Caption := copy(Utf8Decode(Lang.lines[24]), 8, Length(Utf8Decode(Lang.lines[24])));
  Delete.Caption := copy(Utf8Decode(Lang.lines[25]), 10, Length(Utf8Decode(Lang.lines[25])));
  Cancel.Caption := copy(Utf8Decode(Lang.lines[26]), 10, Length(Utf8Decode(Lang.lines[26])));
  Log.Caption := copy(Utf8Decode(Lang.lines[7]), 14, Length(Utf8Decode(Lang.lines[7])));
  UpdCl.Caption := copy(Utf8Decode(Lang.lines[40]), 10, Length(Utf8Decode(Lang.lines[40])));
  Option.Caption := copy(Utf8Decode(Lang.lines[8]), 12, Length(Utf8Decode(Lang.lines[8])));
  OKButton.Caption := copy(Utf8Decode(Lang.lines[27]), 10, Length(Utf8Decode(Lang.lines[27])));
  Skin.Text := copy(Utf8Decode(Ops.lines[2]), 8, Length(Utf8Decode(Ops.lines[2])));
  Language.Text := copy(Utf8Decode(Ops.lines[3]), 8, Length(Utf8Decode(Ops.lines[3])));
  Engine.Text := copy(Utf8Decode(Ops.lines[4]), 10, Length(Utf8Decode(Ops.lines[4])));
  InfectedFile := TStringList.Create;
  IFileType := TStringList.Create;
  FileList := TStringList.Create;
  //ǽð  üũ
  If processExists('CecrScan.exe') then begin
    RTSImage.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ '\Skin\' + SkinDir + '\Green.png');
    RTSStat.Lines.add(copy(Utf8Decode(Lang.lines[9]), 9, Length(Utf8Decode(Lang.lines[9]))));
    RTSStat.Lines.add('');
    RTSStat.Lines.add(copy(Utf8Decode(Lang.lines[10]), 13, Length(Utf8Decode(Lang.lines[10]))));
  end
  else begin
    RTSImage.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+ '\Skin\' + SkinDir + '\Red.png');
    RTSStat.Lines.add(copy(Utf8Decode(Lang.lines[11]), 10, Length(Utf8Decode(Lang.lines[11]))));
    RTSStat.Lines.add('');
    RTSStat.Lines.add(copy(Utf8Decode(Lang.lines[12]), 14, Length(Utf8Decode(Lang.lines[12]))));
  end;

end;

procedure TMainForm.PrcClick(Sender: TObject);
begin
If PrcIf = False then begin
  Prc.font.Color := $000080;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [fsBold];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [];
  Ls.font.Style := [];
  Cc.font.Style := [];
  Pages.PageIndex := 0;
  PrcIf := True;
  PrvIf := False;
  OpmIf := False;
  UpdIf := False;
  LsIf := False;
  CcIf := False;
end
end;

procedure TMainForm.PrcButtonClick(Sender: TObject);
begin
If PrcIf = False then begin
  Prc.font.Color := $000080;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [fsBold];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [];
  Ls.font.Style := [];
  Cc.font.Style := [];
  Pages.PageIndex := 0;
  PrcIf := True;
  PrvIf := False;
  OpmIf := False;
  UpdIf := False;
  LsIf := False;
  CcIf := False;
end
end;

procedure TMainForm.PrvClick(Sender: TObject);
var
	i: integer;
   DriveName: Array[0..26] of char;
begin
DriveName := '';
If PrvIf = False then begin
  If ScanEnd = true then begin
  	If Assigned(ScanThread) then begin
   	FreeAndNil(ScanThread);
    If Assigned(LoadThread) then begin
   	FreeAndNil(LoadThread);
   end;
  end;
  If Assigned(ScanThread) then begin
  	Pages.PageIndex := 6;
  	Prc.font.Color := $FFFFFF;
  	Prv.Font.color := $000080;
  	Opm.Font.Color := $FFFFFF;
  	Upd.Font.Color := $FFFFFF;
  	Ls.Font.Color := $FFFFFF;
  	Cc.Font.Color := $FFFFFF;
  	Prc.font.Style := [];
  	Prv.font.Style := [fsBold];
  	Opm.font.Style := [];
  	Upd.font.Style := [];
  	Ls.font.Style := [];
  	Cc.font.Style := [];
  	PrcIf := False;
  	PrvIf := True;
  	OpmIf := False;
  	UpdIf := False;
  	LsIf := False;
  	CcIf := False;
  end
  else begin
  	Drives.Clear;
  	DriveName := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  	Prc.font.Color := $FFFFFF;
  	Prv.Font.color := $000080;
  	Opm.Font.Color := $FFFFFF;
  	Upd.Font.Color := $FFFFFF;
  	Ls.Font.Color := $FFFFFF;
  	Cc.Font.Color := $FFFFFF;
  	Prc.font.Style := [];
  	Prv.font.Style := [fsBold];
  	Opm.font.Style := [];
  	Upd.font.Style := [];
  	Ls.font.Style := [];
  	Cc.font.Style := [];
  	Pages.PageIndex := 1;
  	PrcIf := False;
  	PrvIf := True;
  	OpmIf := False;
  	UpdIf := False;
  	LsIf := False;
  	CcIf := False;
  For i := 1 to 27 do
	if GetDriveType(PChar(DriveName[i] + ':\')) = DRIVE_FIXED then
   begin
   	Drives.Items.Add(DriveName[i] + ':\');
  	end;
  end;
  end;
  end;
end;

procedure TMainForm.PrvButtonClick(Sender: TObject);
var
	i: integer;
   DriveName: Array[0..26] of char;
begin
DriveName := '';
If PrvIf = False then begin
  If ScanEnd = true then begin
  	If Assigned(ScanThread) then begin
   	FreeAndNil(ScanThread);
    If Assigned(LoadThread) then begin
   	FreeAndNil(LoadThread);
   end;
  end;
  If Assigned(ScanThread) or Assigned(LoadThread) then begin
  	Pages.PageIndex := 6;
  	Prc.font.Color := $FFFFFF;
  	Prv.Font.color := $000080;
  	Opm.Font.Color := $FFFFFF;
  	Upd.Font.Color := $FFFFFF;
  	Ls.Font.Color := $FFFFFF;
  	Cc.Font.Color := $FFFFFF;
  	Prc.font.Style := [];
  	Prv.font.Style := [fsBold];
  	Opm.font.Style := [];
  	Upd.font.Style := [];
  	Ls.font.Style := [];
  	Cc.font.Style := [];
  	PrcIf := False;
  	PrvIf := True;
  	OpmIf := False;
  	UpdIf := False;
  	LsIf := False;
  	CcIf := False;
  end
  else begin
  	Drives.Clear;
  	DriveName := 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  	Prc.font.Color := $FFFFFF;
  	Prv.Font.color := $000080;
  	Opm.Font.Color := $FFFFFF;
  	Upd.Font.Color := $FFFFFF;
  	Ls.Font.Color := $FFFFFF;
  	Cc.Font.Color := $FFFFFF;
  	Prc.font.Style := [];
  	Prv.font.Style := [fsBold];
  	Opm.font.Style := [];
  	Upd.font.Style := [];
  	Ls.font.Style := [];
  	Cc.font.Style := [];
  	Pages.PageIndex := 1;
  	PrcIf := False;
  	PrvIf := True;
  	OpmIf := False;
  	UpdIf := False;
  	LsIf := False;
  	CcIf := False;
  For i := 1 to 27 do
	if GetDriveType(PChar(DriveName[i] + ':\')) = DRIVE_FIXED then
   begin
   	Drives.Items.Add(DriveName[i] + ':\');
  	end;
  end;
  end;
  end;
end;

procedure TMainForm.OpmClick(Sender: TObject);
begin
If OpmIf = False then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $000080;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [fsBold];
  Upd.font.Style := [];
  Ls.font.Style := [];
  Cc.font.Style := [];
  Pages.PageIndex := 2;
  PrcIf := False;
  PrvIf := False;
  OpmIf := True;
  UpdIf := False;
  LsIf := False;
  CcIf := False;
end
end;

procedure TMainForm.OpmButtonClick(Sender: TObject);
begin
If OpmIf = False then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $000080;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [fsBold];
  Upd.font.Style := [];
  Ls.font.Style := [];
  Cc.font.Style := [];
  Pages.PageIndex := 2;
  PrcIf := False;
  PrvIf := False;
  OpmIf := True;
  UpdIf := False;
  LsIf := False;
  CcIf := False;
end
end;

procedure TMainForm.UpdClick(Sender: TObject);
begin
If UpdIf = False then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $000080;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [fsBold];
  Ls.font.Style := [];
  Cc.font.Style := [];
  Pages.PageIndex := 3;
  PrcIf := False;
  PrvIf := False;
  OpmIf := False;
  UpdIf := True;
  LsIf := False;
  CcIf := False;
UpdYeobu := False;
UrlDownloadToFile(nil,PChar('http://toheart123.com.ne.kr/Cecr/vFile.txt'), PChar(ExtractFilePath(Application.ExeName) + '\temp.txt'), 0, nil);
UpdtList := TStringList.Create;
Status.Caption := copy(Utf8Decode(Lang.lines[28]), 15, Length(Utf8Decode(Lang.lines[28])));
UpdtList.LoadFromFile(ExtractFilePath(Application.ExeName)+'\temp.txt');
If StrToInt(copy(CDBLoad.Version, 5, Length(CDBLoad.Version))) < StrToInt(UpdtList.Strings[0]) then begin
	UpdYeobu := True;
	Status.Caption := copy(Utf8Decode(Lang.lines[29]), 12, Length(Utf8Decode(Lang.lines[29])));
  UpdCl.Caption := copy(Utf8Decode(Lang.lines[31]), 10, Length(Utf8Decode(Lang.lines[31])));
end
else If StrToInt(copy(CDBLoad.Version, 5, Length(CDBLoad.Version))) >= StrToInt(UpdtList.Strings[0]) then begin
	UpdtList.Free;
  UpdProg.Progress := 100;
	Status.Caption := copy(Utf8Decode(Lang.lines[30]), 11, Length(Utf8Decode(Lang.lines[30])));
  UpdCl.Caption := copy(Utf8Decode(Lang.lines[27]), 10, Length(Utf8Decode(Lang.lines[27])));
end;
end;
end;

procedure TMainForm.UpdButtonClick(Sender: TObject);
begin
If UpdIf = False then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $000080;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [fsBold];
  Ls.font.Style := [];
  Cc.font.Style := [];
  Pages.PageIndex := 3;
  PrcIf := False;
  PrvIf := False;
  OpmIf := False;
  UpdIf := True;
  LsIf := False;
  CcIf := False;
UpdYeobu := False;
UrlDownloadToFile(nil,PChar('http://toheart123.com.ne.kr/Cecr/vFile.txt'), PChar(ExtractFilePath(Application.ExeName) + '\temp.txt'), 0, nil);
UpdtList := TStringList.Create;
Status.Caption := copy(Utf8Decode(Lang.lines[28]), 15, Length(Utf8Decode(Lang.lines[28])));
UpdtList.LoadFromFile(ExtractFilePath(Application.ExeName)+'\temp.txt');
If StrToInt(copy(CDBLoad.Version, 5, Length(CDBLoad.Version))) < StrToInt(UpdtList.Strings[0]) then begin
	UpdYeobu := True;
	Status.Caption := copy(Utf8Decode(Lang.lines[29]), 12, Length(Utf8Decode(Lang.lines[29])));
  UpdCl.Caption := copy(Utf8Decode(Lang.lines[31]), 10, Length(Utf8Decode(Lang.lines[31])));
end
else If StrToInt(copy(CDBLoad.Version, 5, Length(CDBLoad.Version))) >= StrToInt(UpdtList.Strings[0]) then begin
	UpdtList.Free;
  UpdProg.Progress := 100;
	Status.Caption := copy(Utf8Decode(Lang.lines[30]), 11, Length(Utf8Decode(Lang.lines[30])));
  UpdCl.Caption := copy(Utf8Decode(Lang.lines[27]), 10, Length(Utf8Decode(Lang.lines[27])));
end;
end;
end;

procedure TMainForm.LsClick(Sender: TObject);
begin
If LsIf = False then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $000080;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [];
  Ls.font.Style := [fsBold];
  Cc.font.Style := [];
  Pages.PageIndex := 4;
  PrcIf := False;
  PrvIf := False;
  OpmIf := False;
  UpdIf := False;
  LsIf := True;
  CcIf := False;
end
end;

procedure TMainForm.LsButtonClick(Sender: TObject);
begin
If LsIf = False then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $000080;
  Cc.Font.Color := $FFFFFF;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [];
  Ls.font.Style := [fsBold];
  Cc.font.Style := [];
  Pages.PageIndex := 4;
  PrcIf := False;
  PrvIf := False;
  OpmIf := False;
  UpdIf := False;
  LsIf := True;
  CcIf := False;
end
end;

procedure TMainForm.CcClick(Sender: TObject);  
var
  SR: TSearchRec;
begin
If CcIf = False then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $000080;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [];
  Ls.font.Style := [];
  Cc.font.Style := [fsBold];
  Pages.PageIndex := 5;
  PrcIf := False;
  PrvIf := False;
  OpmIf := False;
  UpdIf := False;
  LsIf := False;
  CcIf := True;
end;
  Language.Clear;
  Skin.Clear;
  Engine.Clear;
  Skin.Text := copy(Utf8Decode(Ops.lines[2]), 8, Length(Utf8Decode(Ops.lines[2])));
  Language.Text := copy(Utf8Decode(Ops.lines[3]), 8, Length(Utf8Decode(Ops.lines[3])));
  Engine.Text := copy(Utf8Decode(Ops.lines[4]), 10, Length(Utf8Decode(Ops.lines[4])));
  Try
   If FindFirst(ExtractFilePath(Application.ExeName)+'\Lang\*.lng', faAnyFile, SR) = 0 then
    repeat
       If (SR.Attr <> faDirectory) then begin
       	Language.Items.Add(SR.Name);
       end;
    Until (FindNext(SR)<>0);
    FindClose(SR);
   If FindFirst(ExtractFilePath(Application.ExeName)+'\Database\*.cen', faAnyFile, SR) = 0 then
    repeat
       If (SR.Attr <> faDirectory) then begin
       	Engine.Items.Add(SR.Name);
       end;
    Until (FindNext(SR)<>0);
    FindClose(SR);
   If FindFirst(ExtractFilePath(Application.ExeName)+'\Skin\*.*', faAnyFile, SR) = 0 then
    repeat
       If copy(SR.Name,0,1) <> '.' then begin
       If (SR.Attr = faDirectory) then begin
       	Skin.Items.Add(SR.Name);
       end;
       end;
    Until (FindNext(SR)<>0);
    FindClose(SR);
  Except
  	 Application.Terminate;
  end;
end;

procedure TMainForm.CcButtonClick(Sender: TObject);
var
  SR: TSearchRec;
begin
If CcIf = False Then begin
  Prc.font.Color := $FFFFFF;
  Prv.Font.color := $FFFFFF;
  Opm.Font.Color := $FFFFFF;
  Upd.Font.Color := $FFFFFF;
  Ls.Font.Color := $FFFFFF;
  Cc.Font.Color := $000080;
  Prc.font.Style := [];
  Prv.font.Style := [];
  Opm.font.Style := [];
  Upd.font.Style := [];
  Ls.font.Style := [];
  Cc.font.Style := [fsBold];
  Pages.PageIndex := 5;
  PrcIf := False;
  PrvIf := False;
  OpmIf := False;
  UpdIf := False;
  LsIf := False;
  CcIf := True;
end;
  Language.Clear;
  Skin.Clear;
  Engine.Clear;
  Skin.Text := copy(Utf8Decode(Ops.lines[2]), 8, Length(Utf8Decode(Ops.lines[2])));
  Language.Text := copy(Utf8Decode(Ops.lines[3]), 8, Length(Utf8Decode(Ops.lines[3])));
  Engine.Text := copy(Utf8Decode(Ops.lines[4]), 10, Length(Utf8Decode(Ops.lines[4])));
  Try
   If FindFirst(ExtractFilePath(Application.ExeName)+'\Lang\*.lng', faAnyFile, SR) = 0 then
    repeat
       If (SR.Attr <> faDirectory) then begin
       	Language.Items.Add(SR.Name);
       end;
    Until (FindNext(SR)<>0);
    FindClose(SR);
   If FindFirst(ExtractFilePath(Application.ExeName)+'\Database\*.cen', faAnyFile, SR) = 0 then
    repeat
       If (SR.Attr <> faDirectory) then begin
       	Engine.Items.Add(SR.Name);
       end;
    Until (FindNext(SR)<>0);
    FindClose(SR);
   If FindFirst(ExtractFilePath(Application.ExeName)+'\Skin\*.*', faAnyFile, SR) = 0 then
    repeat
       If copy(SR.Name,0,1) <> '.' then begin
       If (SR.Attr = faDirectory) then begin
       	Skin.Items.Add(SR.Name);
       end;
       end;
    Until (FindNext(SR)<>0);
    FindClose(SR);
  Except
  	 Application.Terminate;
  end;
end;

procedure TMainForm.PrcMouseEnter(Sender: TObject);
begin
If PrcIf = False then begin
  Prc.font.Color := $000080;
end
end;

procedure TMainForm.PrcButtonMouseEnter(Sender: TObject);
begin
If PrcIf = False then begin
  Prc.font.Color := $000080;
end
end;

procedure TMainForm.PrcMouseLeave(Sender: TObject);
begin
If PrcIf = False then begin
  Prc.font.Color := $FFFFFF;
end
end;

procedure TMainForm.PrcButtonMouseLeave(Sender: TObject);
begin
If PrcIf = False then begin
  Prc.font.Color := $FFFFFF;
end
end;

procedure TMainForm.PrvMouseEnter(Sender: TObject);
begin
If PrvIf = False then begin
  Prv.font.Color := $000080;
end
end;

procedure TMainForm.PrvButtonMouseEnter(Sender: TObject);
begin
If PrvIf = False then begin
  Prv.font.Color := $000080;
end
end;

procedure TMainForm.PrvMouseLeave(Sender: TObject);
begin
If PrvIf = False then begin
  Prv.font.Color := $FFFFFF;
end
end;

procedure TMainForm.PrvButtonMouseLeave(Sender: TObject);
begin
If PrvIf = False then begin
  Prv.font.Color := $FFFFFF;
end
end;

procedure TMainForm.OpmMouseEnter(Sender: TObject);
begin
If OpmIf = False then begin
  Opm.font.Color := $000080;
end
end;

procedure TMainForm.OpmButtonMouseEnter(Sender: TObject);
begin
If OpmIf = False then begin
  Opm.font.Color := $000080;
end
end;

procedure TMainForm.OpmMouseLeave(Sender: TObject);
begin
If OpmIf = False then begin
  Opm.font.Color := $FFFFFF;
end
end;

procedure TMainForm.OpmButtonMouseLeave(Sender: TObject);
begin
If OpmIf = False then begin
  Opm.font.Color := $FFFFFF;
end
end;

procedure TMainForm.UpdMouseEnter(Sender: TObject);
begin
If UpdIf = False then begin
  Upd.font.Color := $000080;
end
end;

procedure TMainForm.UpdButtonMouseEnter(Sender: TObject);
begin
If UpdIf = False then begin
  Upd.font.Color := $000080;
end
end;

procedure TMainForm.UpdMouseLeave(Sender: TObject);
begin
If UpdIf = False then begin
  Upd.font.Color := $FFFFFF;
end
end;

procedure TMainForm.UpdButtonMouseLeave(Sender: TObject);
begin
If UpdIf = False then begin
  Upd.font.Color := $FFFFFF;
end
end;

procedure TMainForm.LsMouseEnter(Sender: TObject);
begin
If LsIf = False then begin
  Ls.font.Color := $000080;
end
end;

procedure TMainForm.LsButtonMouseEnter(Sender: TObject);
begin
If LsIf = False then begin
  Ls.font.Color := $000080;
end
end;

procedure TMainForm.LsMouseLeave(Sender: TObject);
begin
If LsIf = False then begin
  Ls.font.Color := $FFFFFF;
end
end;

procedure TMainForm.LsButtonMouseLeave(Sender: TObject);
begin
If LsIf = False then begin
  Ls.font.Color := $FFFFFF;
end
end;

procedure TMainForm.CcMouseEnter(Sender: TObject);
begin
If CcIf = False then begin
  Cc.font.Color := $000080;
end
end;

procedure TMainForm.CcButtonMouseEnter(Sender: TObject);
begin
If CcIf = False then begin
  Cc.font.Color := $000080;
end
end;

procedure TMainForm.CcMouseLeave(Sender: TObject);
begin
If CcIf = False then begin
  Cc.font.Color := $FFFFFF;
end
end;

procedure TMainForm.CcButtonMouseLeave(Sender: TObject);
begin
If CcIf = False then begin
  Cc.font.Color := $FFFFFF;
end
end;

procedure TMainForm.RTSStatMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  RTSStat.sellength := 0;
  CreateCaret(RTSStat.Handle,0,0,0);
end;

procedure TMainForm.RTSStatEnter(Sender: TObject);
begin
  RTSStat.sellength := 0;
  CreateCaret(RTSStat.Handle,0,0,0);
end;

procedure TMainForm.RTSStatMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  RTSStat.sellength := 0;
  CreateCaret(RTSStat.Handle,0,0,0);
end;

procedure TMainForm.RTSStatDblClick(Sender: TObject);
begin
  RTSStat.sellength := 0;
  CreateCaret(RTSStat.Handle,0,0,0);
end;

procedure TMainForm.RTSStatStartDrag(Sender: TObject;
  var DragObject: TDragObject);
begin
  RTSStat.sellength := 0;
  CreateCaret(RTSStat.Handle,0,0,0);
end;

procedure TMainForm.ScanStartClick(Sender: TObject);
var
	i: integer;
begin
  CancelIF := False;
  LoadEnd := False;
  ScanEnd := False;
  FileIndex := 0;
  ScanCount := 0;
  ScanFolder := '';
  For i := 0 to Drives.Count - 1 do
  begin
   If Drives.Selected[i] = True then
   begin
   	ScanFolder := Drives.Items.Strings[i];
  	end;
  end;
  For i := 0 to ScanList.Count - 1 do
  begin
   If ScanList.Selected[i] = True then
   begin
   	ScanFolder := ScanList.Items.Strings[i];
  	end;
  end;
  If MyFolder.Text <> '' then begin
  	ScanFolder := MyFolder.Text;
  end;
  If ScanFolder = '' then begin
  	Showmessage('Scan Error! (Nobody was selected)');
   exit;
  end;
  Cancel.Caption := copy(Utf8Decode(Lang.lines[26]), 10, Length(Utf8Decode(Lang.lines[26])));
  ScanList.Items.Add(ScanFolder);
  Pages.PageIndex := 6;
  LoadThread := TLoadThread.Create(True);
  LoadThread.Priority := tpLower;
  LoadThread.Resume;
  ScanThread := TScanThread.Create(True);
  ScanThread.Priority := tpLower;
  ScanThread.Resume;
end;

procedure TScanThread.Execute;
begin
  Scan;           
  MainForm.ScanProc.Visible := False;
end;

procedure TLoadThread.Execute;
begin
  FileNumber(ScanFolder, '*.*');
  LoadEnd := True;
  MainForm.LoadProc.Visible := False;
end;

Function TLoadThread.FileNumber(Folder, Extension: String): Boolean;
var
  SR: TSearchRec;
  FileFolder: String;
begin
MainForm.LoadProc.Caption := copy(Utf8Decode(MainForm.lang.lines[34]), 18, Length(Utf8Decode(MainForm.lang.lines[34]))) + copy(Utf8Decode(MainForm.lang.lines[36]), 10, Length(Utf8Decode(MainForm.lang.lines[36])));
MainForm.AllFile.Caption := copy(Utf8Decode(MainForm.Lang.lines[33]), 10, Length(Utf8Decode(MainForm.Lang.lines[33]))) + IntToStr(FileIndex);
  Try
    If Folder[Length(Folder)] <> '\' then
     Folder := Folder + '\';
    If FindFirst(Folder+Extension, faAnyFile, SR) = 0 then begin
    repeat
    If CancelIF = False then begin
       If (SR.Attr <> faDirectory) then begin
       	FileList.Add(Folder+SR.Name);
        FileIndex := FileIndex + 1;
        MainForm.AllFile.Caption := copy(Utf8Decode(MainForm.lang.lines[33]), 10, Length(Utf8Decode(MainForm.lang.lines[33]))) + IntToStr(FileIndex);
       end;
    end;
    Until (FindNext(SR)<>0);
    FindClose(SR);
    end;
    If FindFirst(Folder+Extension, faDirectory, SR) = 0 then begin
    repeat
    If CancelIF = False then begin
       If ((Sr.Attr and faDirectory) = faDirectory) and
          (SR.Name[1]<>'.')
       then begin
           FileFolder := Folder+SR.Name+'\';
           FileNumber(Folder+SR.Name+'\', Extension);
       end;
    end;
    until (FindNext(SR) <> 0);
    end;
    FindClose(SR);
    Result := True;
  Except
    Result := False;
    exit;
    MainForm.LoadProc.Visible := False;
  end;
If FileList.Count = 0 then begin
	MainForm.Cancel.Caption := copy(Utf8Decode(MainForm.Lang.lines[27]), 10, Length(Utf8Decode(MainForm.Lang.lines[27])));
	//MainForm..Items.Add('Error! (Wrong path or Empty folder)');
   Result := False;
   ScanEnd := True;
end;
end;

procedure TScanThread.Scan;
var
   OpenFile: Integer;
   FileSize: Integer;
   FSizeHigh: DWORD;
   FSizeLow: DWORD;
   FileFolder: String;
 	 Md5ChkFile: TFileStream;
	 Buffer: Array[0..511] of Char;
   BufferStr: String;
   k: integer;
   j: integer;
	 i: integer;
   ScanEndIf: Boolean;
   ScanCount: integer;
begin
MainForm.ScanProc.Caption := copy(Utf8Decode(MainForm.Lang.lines[35]), 18, Length(Utf8Decode(MainForm.Lang.lines[35]))) + copy(Utf8Decode(MainForm.lang.lines[36]), 10, Length(Utf8Decode(MainForm.lang.lines[36])));
MainForm.LoadFile.Caption := copy(Utf8Decode(MainForm.Lang.lines[32]), 11, Length(Utf8Decode(MainForm.Lang.lines[32]))) + IntToStr(ScanCount);
While ScanEndIf = False do begin
If CancelIF = False then begin
If ScanCount = FileIndex then begin
   If LoadEnd = False then begin
      While ScanCount = FileIndex do begin
            Sleep(1);
      end;
   end
   else begin
      ScanEndIf := True;
   end;
end;
If ScanEndIf = False then begin
    Try
    	 FileFolder := FileList.Strings[j];
       If FileFolder <> '' then begin
       If CanReadFile(FileFolder) = True then begin
           Buffer := '';
           BufferStr := '';
           OpenFile := FileOpen(FileFolder, fmOpenRead);
           FSizeLow := GetFileSize(OpenFile, @FSizehigh);
           FileSize := (FSizehigh shl 16) or FSizelow;
           FileClose(OpenFile);
           Md5ChkFile := TFileStream.Create(FileFolder, fmOpenRead);
           Md5ChkFile.Seek(FileSize div 2, 0);
           Md5ChkFile.Read(Buffer, Length(Buffer));
           For i:= 0 to 511 do
           begin
           	BufferStr := BufferStr + Buffer[i];
           end;
           If CDBLoad.Fields.Count - 1 > 0 then begin
          	 For i := 0 to CDBLoad.Fields.Count - 1 do
          	 begin
          	  CDBLoad.Read(CDBLoad.Fields.Strings[i], 0);
          	  For k := 0 to CDBLoad.Results.Count - 1 do
           	  begin
           	    If CDBLoad.Results.Strings[k] = Md5Print(Md5String(BufferStr)) then begin
                	InfectedFile.Add(FileFolder);
                  IFileType.Add(CDBLoad.Fields.Strings[i]);
          	     	MainForm.IFileList.Items.Add(FileFolder + ' : ' + CDBLoad.Fields.Strings[i]);
           	    end;
          	  end;
           	end;
           end
           else begin
              CDBLoad.Read(CDBLoad.Fields.Strings[0], 0);
           	  For k := 0 to CDBLoad.Results.Count - 1 do
           	  begin
           	    If CDBLoad.Results.Strings[k] = Md5Print(Md5String(BufferStr)) then begin
                	InfectedFile.Add(FileFolder);
                  IFileType.Add(CDBLoad.Fields.Strings[0]);
          	     	MainForm.IFileList.Items.Add(FileFolder + ' : ' + CDBLoad.Fields.Strings[0]);
           	    end;
          	  end;
           end;
           ScanCount := ScanCount + 1;
           MainForm.LoadFile.Caption := copy(Utf8Decode(MainForm.Lang.lines[32]), 11, Length(Utf8Decode(MainForm.Lang.lines[32]))) + IntToStr(ScanCount);
           Md5ChkFile.Free;
       	end
         else begin
         Try
           Buffer := '';
           BufferStr := '';
           OpenFile := FileOpen(FileFolder, fmOpenRead+fmShareDenyNone);
           FileSize := GetFileSize(OpenFile, nil);
           FileClose(OpenFile);
           Md5ChkFile := TFileStream.Create(FileFolder, fmOpenRead+fmShareDenyNone );
           Md5ChkFile.Seek(FileSize div 2, 0);
           Md5ChkFile.Read(Buffer, Length(Buffer));
           For i:= 0 to 511 do
           begin
           	BufferStr := BufferStr + Buffer[i];
           end;
           For i := 0 to CDBLoad.Fields.Count - 1 do
           begin
            CDBLoad.Read(CDBLoad.Fields.Strings[i], 0);
            For k := 0 to CDBLoad.Results.Count - 1 do
            begin
              If CDBLoad.Results.Strings[k] = Md5Print(Md5String(BufferStr)) then begin
              	InfectedFile.Add(FileFolder);
               	MainForm.IFileList.Items.Add(FileFolder + ' : ' + CDBLoad.Fields.Strings[i]);
              end;
            end;
           end;
           ScanCount := ScanCount + 1;
           MainForm.LoadFile.Caption := copy(Utf8Decode(MainForm.Lang.lines[32]), 11, Length(Utf8Decode(MainForm.Lang.lines[32]))) + IntToStr(ScanCount);
           Md5ChkFile.Free;
         Except
         ScanCount := ScanCount + 1;
         MainForm.LoadFile.Caption := copy(Utf8Decode(MainForm.Lang.lines[32]), 11, Length(Utf8Decode(MainForm.Lang.lines[32]))) + IntToStr(ScanCount);
         end;
       end
       end;
    Except
      MainForm.ScanProc.Caption := copy(Utf8Decode(MainForm.Lang.lines[37]), 18, Length(Utf8Decode(MainForm.Lang.lines[37]))) + copy(Utf8Decode(MainForm.Lang.lines[37]), 10, Length(Utf8Decode(MainForm.Lang.lines[37])));
      exit;
    end;
end;
end
else begin
  MainForm.Cancel.Caption := copy(Utf8Decode(MainForm.Lang.lines[27]), 10, Length(Utf8Decode(MainForm.Lang.lines[27])));
  FileList.Clear;
  ScanEnd := True;
  exit;
end;
end;
  MainForm.ScanProc.Visible := False;
  MainForm.Cancel.Caption := copy(Utf8Decode(MainForm.Lang.lines[27]), 10, Length(Utf8Decode(MainForm.Lang.lines[27])));
	FileList.Clear;
  ScanEnd := True;
end;

procedure TMainForm.CancelClick(Sender: TObject);
begin
FileIndex := 0;
ScanCount := 0;
  If ScanEnd = False then begin
    CancelIF := True;
    LoadThread.Free;
    LoadThread := nil;
    ScanThread.Free;
    ScanThread := nil;
    InfectedFile.Clear;
    IFileType.Clear;
    IFileList.Clear;
    MainForm.LoadFile.Caption := copy(Utf8Decode(MainForm.Lang.lines[32]), 11, Length(Utf8Decode(MainForm.Lang.lines[32]))) + IntToStr(ScanCount);
    MainForm.AllFile.Caption := copy(Utf8Decode(MainForm.lang.lines[33]), 10, Length(Utf8Decode(MainForm.lang.lines[33]))) + IntToStr(FileIndex);
	  Showmessage('Scan was interrupted by user');
    Pages.PageIndex := 1;
  end
  else begin       
    LoadThread.Free;
    LoadThread := nil;
    ScanThread.Free;
    ScanThread := nil;
    InfectedFile.Clear;
    IFileType.Clear;
    IFileList.Clear;
 	  Pages.PageIndex := 1;
  end;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	If ScanEnd = False then begin
		If Assigned(ScanThread) or Assigned(LoadThread) then begin
  			MessageDlg('Error! (Scan is running)', mtWarning, [mbOK], 0);
   		Action := caNone;
		end;
   end
   else if ScanEnd = True then begin
   	 FreeAndNil(ScanThread);   
   	 FreeAndNil(LoadThread);
      FileList.Free;
      IFileType.Free;
      InfectedFile.Free;
      CDBLoad.Fields.Free;
      CDBLoad.Results.Free;
      CDBLoad.FileLoad.Free;
      CDBLoad.Free;
   end;
   If UpdYeobu = True then begin
   	UpdtList.Free;
   end;
   Try
   Except
    Showmessage('Failed to save log');
   end;
end;

procedure TMainForm.CureClick(Sender: TObject);
var
	ScanReg: TRegistry;
   Folders: string;
	i: integer;
   j: integer;
   k: integer;
begin
ScanReg := TRegistry.Create;
	For i := 0 to IFileType.Count - 1 do
  begin
    CDBLoad.Connect;
    If IFileList.Checked[i] = True then begin
   	For j := 0 to CDBLoad.Fields.Count - 1 do
      begin
   		If IFileType.Strings[i] = CDBLoad.Fields.Strings[j] then begin
         	  CDBLoad.Read(CDBLoad.Fields.Strings[j], 1);
            CloseThat(InfectedFile.Strings[i]);
            DeleteFile(InfectedFile.Strings[i]);
            For k := 0 to CDBLoad.Results.Count - 1 do
            begin
              If copy(ExtractFilePath(InfectedFile.Strings[i]) + CDBLoad.Results.Strings[k], Length(ExtractFilePath(InfectedFile.Strings[i]) + CDBLoad.Results.Strings[k]) - 3, Length(ExtractFilePath(InfectedFile.Strings[i]) + CDBLoad.Results.Strings[k])) = '.exe' then begin
                CloseThat(ExtractFilePath(InfectedFile.Strings[i]) + CDBLoad.Results.Strings[k]);
              end;
            	DeleteFile(ExtractFilePath(InfectedFile.Strings[i]) + CDBLoad.Results.Strings[k]);
            end;
            CDBLoad.Read(CDBLoad.Fields.Strings[j], 2);
            k := 0;
   			While k < CDBLoad.Results.Count do
            begin
            	If CDBLoad.Results.Strings[k] = 'HKLM' then begin
            		ScanReg.RootKey := HKEY_LOCAL_MACHINE;
               end
               else if CDBLoad.Results.Strings[k] = 'HKCU' then begin
               	ScanReg.RootKey := HKEY_CURRENT_USER;
               end
               else if CDBLoad.Results.Strings[k] = 'HKCR' then begin
               	ScanReg.RootKey := HKEY_CLASSES_ROOT;
               end;
               ScanReg.OpenKey(CDBLoad.Results.Strings[k+1],False);
               If copy(CDBLoad.Results[k+2], 0, 7) = '#Value#' then begin
               	ScanReg.DeleteValue(copy(CDBLoad.Results.Strings[k+2], 8, Length(CDBLoad.Results.Strings[k+2])));
               end
               else begin
               	ScanReg.DeleteKey(CDBLoad.Results[k+2]);
               end;
               ScanReg.CloseKey;
            	k := k + 3;
   			end;
            CDBLoad.Read(CDBLoad.Fields.Strings[j], 3);
            For k := 0 to CDBLoad.Results.Count - 1 do
            begin
            	If copy(CDBLoad.Results.Strings[k], 0, 1) = '0' then begin
               	If copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) = '' then begin
               		ScanReg.RootKey := HKEY_CURRENT_USER;
                  	ScanReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
  	   	            Folders := ScanReg.ReadString('Desktop');
   	               DeleteFile(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) + '.lnk');
         	         ScanReg.RootKey := HKEY_LOCAL_MACHINE;
           	  		   ScanReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
           		      Folders := ScanReg.ReadString('Common Desktop');
                     DeleteFile(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) + '.lnk');
               	end;
               end
               else if copy(CDBLoad.Results.Strings[k], 0, 1) = '1' then begin
               	If copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) <> '' then begin
  		             	ScanReg.RootKey := HKEY_CURRENT_USER;
  		               ScanReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
      	            Folders := ScanReg.ReadString('AppData');
         	         DeleteFile(Folders + '\Microsoft\Internet Explorer\Quick Launch\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) + '.lnk');
            		end;
               end
               else if copy(CDBLoad.Results.Strings[k], 0, 1) = '2' then begin
               	If copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) <> '' then begin
               		ScanReg.RootKey := HKEY_CURRENT_USER;
             	      ScanReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
                     Folders := ScanReg.ReadString('Programs');
                     DeleteFile(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) + '.lnk');
                   	ScanReg.RootKey := HKEY_LOCAL_MACHINE;
                     ScanReg.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
                     Folders := ScanReg.ReadString('Common Programs');
                     DeleteFile(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) + '.lnk');
               	end;
               end
               else if copy(CDBLoad.Results.Strings[k], 0, 1) = '3' then begin
               	If copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) <> '' then begin
               		ScanReg.RootKey := HKEY_CURRENT_USER;
                 	   ScanReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
                     Folders := ScanReg.ReadString('Programs');
                    	ExRemoveDir(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])));
                  	ScanReg.RootKey := HKEY_LOCAL_MACHINE;
                     ScanReg.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
                     Folders := ScanReg.ReadString('Common Programs');
                     ExRemoveDir(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])));
               	end;
               end
               else if copy(CDBLoad.Results.Strings[k], 0, 1) = '4' then begin
               	If copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) <> '' then begin
            	   	ScanReg.RootKey := HKEY_CURRENT_USER;
       	            ScanReg.OpenKey('Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
          	         Folders := ScanReg.ReadString('Start Menu');
         	         DeleteFile(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) + '.lnk');
             	   	ScanReg.RootKey := HKEY_LOCAL_MACHINE;
            	      ScanReg.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders',False);
           	         Folders := ScanReg.ReadString('Common Start Menu');
                     DeleteFile(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])) + '.lnk');
              		end;
               end;
            end;
            CDBLoad.Read(CDBLoad.Fields.Strings[j], 4);
            For k := 0 to CDBLoad.Results.Count - 1 do
            begin
            	If copy(CDBLoad.Results.Strings[k], 0, 1) = '0' then begin
               	ScanReg.RootKey := HKEY_LOCAL_MACHINE;
                  ScanReg.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\ActiveX Cache',False);
                  Folders := ScanReg.ReadString('0');
                  DeleteFile(Folders + '\' + copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])));
               end
               else if copy(CDBLoad.Results.Strings[k], 0, 1) = '1' then begin
               	ScanReg.RootKey := HKEY_LOCAL_MACHINE;
                  ScanReg.OpenKey('SOFTWARE\Microsoft\Internet Explorer\ActiveX Compatibility',True);
                  ScanReg.DeleteKey(copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])));
                  ScanReg.CreateKey(copy(CDBLoad.Results.Strings[k], 2, Length(CDBLoad.Results.Strings[k])));
                  ScanReg.WriteInteger('Compatibility Flags', 1024);
               end;
            end;
         end;
   	end;
      end;
  		CDBLoad.Fields.Clear;
  		CDBLoad.FileLoad.Clear;
  		CDBLoad.Results.Clear;
      InfectedFile.Clear;
      IFileType.Clear;
   end;
ScanReg.Free;
end;
procedure TMainForm.DeleteClick(Sender: TObject);
var
	i: integer;
begin
	For i := 0 to IFileList.Count - 1 do
   begin
   	If IFileList.Selected[i] = True then begin
      	IFileList.Items.Delete(i);
         InfectedFile.Delete(i);
         IFileType.Delete(i);
      end;
   end;
end;

procedure TMainForm.DrivesClick(Sender: TObject);
var
	i: integer;
begin
	For i := 0 to ScanList.Count - 1 do
   begin
   	ScanList.Selected[i] := False;
   end;
   MyFolder.Text := '';
end;

procedure TMainForm.ScanListClick(Sender: TObject);
var
	i: integer;
begin
	For i := 0 to Drives.Count - 1 do
   begin
   	Drives.Selected[i] := False;
   end;
   MyFolder.Text := '';
end;

procedure TMainForm.MyFolderClick(Sender: TObject);
var
	i: integer;
begin
	For i := 0 to Drives.Count - 1 do
   begin
   	Drives.Selected[i] := False;
   end;
	For i := 0 to ScanList.Count - 1 do
   begin
   	ScanList.Selected[i] := False;
   end;
end;

procedure TMainForm.UpdClClick(Sender: TObject);
begin
If UpdYeobu = True then begin
	UrlDownloadToFile(nil,PChar('http://toheart123.com.ne.kr/Cecr/' + UpdtList.Strings[1]), PChar(ExtractFilePath(Application.ExeName + '\' + UpdtList.Strings[1])), 0, nil);
  UpdProg.Progress := 100;
  UpdYeobu := False;
	UpdtList.Free;       
  Pages.PageIndex := 0;
end
else begin
   Pages.PageIndex := 0;
end;
end;

procedure TMainForm.OKButtonClick(Sender: TObject);
begin
	 Ops.Clear;
   Ops.Lines.Insert(0, 'You mustn''t modify Boru''s own logo');
   Ops.Lines.Insert(1, '/////Option Settings/////');
	 Ops.Lines.Insert(2, 'Skin : ' + Skin.Text);
   Ops.Lines.Insert(3, 'Lang : ' + Language.Text);
   Ops.Lines.Insert(4, 'Engine : ' + Engine.Text);
	If ScanEnd = False then begin
		If Assigned(ScanThread) or Assigned(LoadThread) then begin
  			MessageDlg('Error! (Scan is running)', mtWarning, [mbOK], 0);
         Exit;
		end;
   end
   else if ScanEnd = True then begin
   	  FreeAndNil(ScanThread);
      FreeAndNil(LoadThread);
      FileList.Free;
      IFileType.Free;
      InfectedFile.Free;
      CDBLoad.Fields.Free;
      CDBLoad.Results.Free;
      CDBLoad.FileLoad.Free;
      CDBLoad.Free;
   	  Ops.Lines.SaveToFile(ExtractFilePath(Application.ExeName) + '\Option.cst');
      MessageDlg('You must restart the program to apply settings.', mtWarning, [mbOK], 0);
      Application.Terminate;
   end;
   If UpdYeobu = True then begin
   	UpdtList.Free;
   end;
end;

procedure TMainForm.ClickClick(Sender: TObject);
var
   OpenFile: Integer;
   FileSize: Integer;
   FSizeHigh: DWORD;
   FSizeLow: DWORD;
   FileFolder: String;
 	 Md5ChkFile: TFileStream;
	 Buffer: Array[0..511] of Char;
   BufferStr: String;
   i: integer;
   j: integer;
   k: integer;
begin 
     Try
           Md5Open.Execute;
     Finally
           Buffer := '';
           BufferStr := '';
           OpenFile := FileOpen(Md5Open.FileName, fmOpenRead+fmShareDenyNone);
           FileSize := GetFileSize(OpenFile, nil);
           FileClose(OpenFile);
           Md5ChkFile := TFileStream.Create(Md5Open.FileName, fmOpenRead+fmShareDenyNone );
           Md5ChkFile.Seek(FileSize div 2, 0);
           Md5ChkFile.Read(Buffer, Length(Buffer));
           For i:= 0 to 511 do
           begin
           	BufferStr := BufferStr + Buffer[i];
           end;
           MD5.Text := '<Md5>' + Md5Print(Md5String(BufferStr)) + '</Md5>';
           Md5ChkFile.Free;
     end;

end;

end.
