/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    public int handle;
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    Decorations parent;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).getShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void createHandle() {
        this.handle = (this.style & 2) != 0 ? (OS.IsPPC ? OS.CreatePopupMenu() : OS.CreateMenu()) : OS.CreatePopupMenu();
        if (this.handle == 0) {
            this.error(2);
        }
    }

    void createItem(MenuItem item, int index) {
        int count = this.GetMenuItemCount(this.handle);
        if (index < 0 || index > count) {
            this.error(6);
        }
        this.parent.add(item);
        boolean success = false;
        if (OS.IsWinCE) {
            int uFlags = 1024;
            TCHAR lpNewItem = null;
            if ((item.style & 2) != 0) {
                uFlags |= 0x800;
            } else {
                lpNewItem = new TCHAR(0, "", true);
            }
            success = OS.InsertMenu(this.handle, index, uFlags, item.id, lpNewItem);
            if (success) {
                MENUITEMINFO info = new MENUITEMINFO();
                info.cbSize = MENUITEMINFO.sizeof;
                info.fMask = 32;
                info.dwItemData = item.id;
                success = OS.SetMenuItemInfo(this.handle, index, true, info);
                if (OS.IsPPC && item.parent == this.parent.menuBar) {
                    TBBUTTON lpButton = new TBBUTTON();
                    lpButton.idCommand = item.id;
                    lpButton.fsStyle = (byte)-104;
                    lpButton.fsState = (byte)4;
                    lpButton.iBitmap = -2;
                    if ((item.style & 2) != 0) {
                        lpButton.fsStyle = 1;
                    }
                    success = OS.SendMessage(this.parent.hwndTB, OS.TB_INSERTBUTTON, index, lpButton) != 0;
                }
            }
        } else {
            int hHeap = OS.GetProcessHeap();
            int pszText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
            MENUITEMINFO info = new MENUITEMINFO();
            info.cbSize = MENUITEMINFO.sizeof;
            info.fMask = 50;
            info.wID = info.dwItemData = item.id;
            info.fType = item.widgetStyle();
            info.dwTypeData = pszText;
            success = OS.InsertMenuItem(this.handle, index, true, info);
            if (pszText != 0) {
                OS.HeapFree(hHeap, 0, pszText);
            }
        }
        if (!success) {
            this.parent.remove(item);
            this.error(14);
        }
        this.redraw();
    }

    void createWidget() {
        this.createHandle();
        this.parent.add(this);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_MENU);
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_MENUTEXT);
    }

    void destroyAcceleratorTable() {
        this.parent.destroyAcceleratorTable();
    }

    void destroyItem(MenuItem item) {
        if (OS.IsWinCE) {
            int index = 0;
            MENUITEMINFO info = new MENUITEMINFO();
            info.cbSize = MENUITEMINFO.sizeof;
            info.fMask = 32;
            while (OS.GetMenuItemInfo(this.handle, index, true, info)) {
                if (info.dwItemData == item.id) break;
                ++index;
            }
            if (info.dwItemData != item.id) {
                this.error(15);
            }
            if (!OS.RemoveMenu(this.handle, index, 1024)) {
                this.error(15);
            }
            if (this.parent.menuBar == this) {
                OS.SendMessage(this.parent.hwndTB, 1046, index, 0);
            }
        } else if (!OS.RemoveMenu(this.handle, item.id, 0)) {
            this.error(15);
        }
        this.redraw();
    }

    void destroyWidget() {
        int hMenu = this.handle;
        this.releaseHandle();
        if (hMenu != 0) {
            OS.DestroyMenu(hMenu);
        }
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return null;
        }
        int id = OS.GetMenuDefaultItem(this.handle, 0, 1);
        if (id == -1) {
            return null;
        }
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 2;
        if (OS.GetMenuItemInfo(this.handle, id, false, info)) {
            return this.parent.findMenuItem(info.wID);
        }
        return null;
    }

    public Display getDisplay() {
        Decorations parent = this.parent;
        if (parent == null) {
            this.error(24);
        }
        return parent.getDisplay();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x40) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        if (!OS.GetMenuItemInfo(this.handle, index, true, info)) {
            this.error(6);
        }
        return this.parent.findMenuItem(info.dwItemData);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.GetMenuItemCount(this.handle);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int index = 0;
        int length = OS.IsWinCE ? 4 : OS.GetMenuItemCount(this.handle);
        MenuItem[] items = new MenuItem[length];
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, index, true, info)) {
            if (index == items.length) {
                MenuItem[] newItems = new MenuItem[index + 4];
                System.arraycopy(items, 0, newItems, 0, index);
                items = newItems;
            }
            items[index++] = this.parent.findMenuItem(info.dwItemData);
        }
        if (index == items.length) {
            return items;
        }
        MenuItem[] result = new MenuItem[index];
        System.arraycopy(items, 0, result, 0, index);
        return result;
    }

    int GetMenuItemCount(int handle) {
        this.checkWidget();
        if (OS.IsWinCE) {
            int count = 0;
            MENUITEMINFO info = new MENUITEMINFO();
            info.cbSize = MENUITEMINFO.sizeof;
            while (OS.GetMenuItemInfo(handle, count, true, info)) {
                ++count;
            }
            return count;
        }
        return OS.GetMenuItemCount(handle);
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        return this == this.getShell().activeMenu;
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int index = 0;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        while (OS.GetMenuItemInfo(this.handle, index, true, info)) {
            if (info.dwItemData == item.id) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void redraw() {
        if (OS.IsPPC) {
            return;
        }
        if (OS.IsHPC) {
            OS.CommandBar_DrawMenuBar(this.parent.hwndCB, 0);
            return;
        }
        if ((this.style & 2) != 0) {
            OS.DrawMenuBar(this.parent.handle);
            return;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return;
        }
        boolean hasCheck = false;
        boolean hasImage = false;
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (item.getImage() != null) {
                hasImage = true;
                if (true && hasCheck) break;
            }
            if ((item.getStyle() & 0x30) != 0) {
                hasCheck = true;
                if (true && hasImage) break;
            }
            ++i;
        }
        MENUINFO lpcmi = new MENUINFO();
        lpcmi.cbSize = 28;
        lpcmi.fMask = 16;
        OS.GetMenuInfo(this.handle, lpcmi);
        lpcmi.dwStyle = hasImage && !hasCheck ? (lpcmi.dwStyle |= 0x4000000) : (lpcmi.dwStyle &= 0xFBFFFFFF);
        OS.SetMenuInfo(this.handle, lpcmi);
    }

    void releaseChild() {
        super.releaseChild();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseHandle() {
        this.handle = 0;
    }

    void releaseWidget() {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            if (!item.isDisposed()) {
                item.releaseWidget();
            }
            ++i;
        }
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        int command = -1;
        if (item != null) {
            if (item.isDisposed()) {
                this.error(5);
            }
            command = item.id;
        }
        if (OS.IsWinCE) {
            return;
        }
        OS.SetMenuDefaultItem(this.handle, command, 0);
        this.redraw();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state &= 0xFFFFFFBF;
        if (!enabled) {
            this.state |= 0x40;
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setVisible(boolean visible) {
        boolean success;
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        int hwndParent = this.parent.handle;
        if (!visible) {
            OS.SendMessage(hwndParent, 31, 0, 0);
            return;
        }
        int flags = 2;
        int nX = this.x;
        int nY = this.y;
        if (!this.hasLocation) {
            int pos = OS.GetMessagePos();
            nX = (short)(pos & 0xFFFF);
            nY = (short)(pos >> 16);
        }
        if (!(success = OS.TrackPopupMenu(this.handle, flags, nX, nY, 0, hwndParent, null)) && this.GetMenuItemCount(this.handle) == 0) {
            OS.SendMessage(hwndParent, 287, -65536, 0);
        }
    }
}

