/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.BROWSEINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    String directoryPath;

    public DirectoryDialog(Shell parent) {
        this(parent, 32768);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    int BrowseCallbackProc(int hwnd, int uMsg, int lParam, int lpData) {
        switch (uMsg) {
            case 1: {
                TCHAR buffer;
                if (this.filterPath != null && this.filterPath.length() != 0) {
                    buffer = new TCHAR(0, this.filterPath, true);
                    OS.SendMessage(hwnd, OS.BFFM_SETSELECTION, 1, buffer);
                }
                if (this.title == null || this.title.length() == 0) break;
                buffer = new TCHAR(0, this.title, true);
                OS.SetWindowText(hwnd, buffer);
                break;
            }
            case 3: 
            case 4: {
                TCHAR buffer = new TCHAR(0, 256);
                int byteCount = buffer.length() * TCHAR.sizeof;
                OS.MoveMemory(buffer, lParam, byteCount);
                this.directoryPath = buffer.toString(0, buffer.strlen());
            }
        }
        return 0;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        int[] ppMalloc;
        TCHAR buffer;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        OS.OleInitialize(0);
        int hHeap = OS.GetProcessHeap();
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        int lpszTitle = 0;
        if (this.message != null && this.message.length() != 0) {
            TCHAR buffer2 = new TCHAR(0, this.message, true);
            int byteCount = buffer2.length() * TCHAR.sizeof;
            lpszTitle = OS.HeapAlloc(hHeap, 8, byteCount);
            OS.MoveMemory(lpszTitle, buffer2, byteCount);
        }
        Callback callback = new Callback(this, "BrowseCallbackProc", 4);
        int address = callback.getAddress();
        this.directoryPath = null;
        BROWSEINFO lpbi = new BROWSEINFO();
        lpbi.hwndOwner = hwndOwner;
        lpbi.lpszTitle = lpszTitle;
        lpbi.ulFlags = 113;
        lpbi.lpfn = address;
        int lpItemIdList = OS.SHBrowseForFolder(lpbi);
        if (lpItemIdList != 0 && OS.SHGetPathFromIDList(lpItemIdList, buffer = new TCHAR(0, 256))) {
            this.directoryPath = buffer.toString(0, buffer.strlen());
        }
        callback.dispose();
        if (lpszTitle != 0) {
            OS.HeapFree(hHeap, 0, lpszTitle);
        }
        if (OS.SHGetMalloc(ppMalloc = new int[1]) == 0) {
            OS.VtblCall(5, ppMalloc[0], lpItemIdList);
        }
        OS.OleUninitialize();
        return this.directoryPath;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

