/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.image.GIFFileFormat;
import org.eclipse.swt.internal.image.JPEGFileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LEDataOutputStream;
import org.eclipse.swt.internal.image.PNGFileFormat;
import org.eclipse.swt.internal.image.WinBMPFileFormat;
import org.eclipse.swt.internal.image.WinICOFileFormat;

public abstract class FileFormat {
    LEDataInputStream inputStream;
    LEDataOutputStream outputStream;
    ImageLoader loader;

    byte[] bitInvertData(byte[] data, int startIndex, int endIndex) {
        int i = startIndex;
        while (i < endIndex) {
            data[i] = (byte)(255 - data[i - startIndex]);
            ++i;
        }
        return data;
    }

    abstract ImageData[] loadFromByteStream();

    public ImageData[] loadFromStream(LEDataInputStream stream) {
        try {
            this.inputStream = stream;
            return this.loadFromByteStream();
        }
        catch (Exception e) {
            SWT.error(39, e);
            return null;
        }
    }

    public static ImageData[] load(InputStream is, ImageLoader loader) {
        FileFormat fileFormat = null;
        LEDataInputStream stream = new LEDataInputStream(is);
        if (GIFFileFormat.isGIFFile(stream)) {
            fileFormat = new GIFFileFormat();
        } else if (WinBMPFileFormat.isBMPFile(stream)) {
            fileFormat = new WinBMPFileFormat();
        } else if (WinICOFileFormat.isICOFile(stream)) {
            fileFormat = new WinICOFileFormat();
        } else if (JPEGFileFormat.isJPEGFile(stream)) {
            fileFormat = new JPEGFileFormat();
        } else if (PNGFileFormat.isPNGFile(stream)) {
            fileFormat = new PNGFileFormat();
        } else {
            SWT.error(42);
        }
        fileFormat.loader = loader;
        return fileFormat.loadFromStream(stream);
    }

    public static void save(OutputStream os, int format, ImageLoader loader) {
        ImageData data = loader.data[0];
        LEDataOutputStream stream = new LEDataOutputStream(os);
        switch (format) {
            case 0: {
                WinBMPFileFormat f = new WinBMPFileFormat();
                f.unloadIntoStream(data, stream);
                break;
            }
            case 1: {
                WinBMPFileFormat f = new WinBMPFileFormat();
                if (data.depth == 8) {
                    f.compression = 1;
                }
                if (data.depth == 4) {
                    f.compression = 2;
                }
                f.unloadIntoStream(data, stream);
                break;
            }
            case 2: {
                GIFFileFormat g = new GIFFileFormat();
                g.unloadIntoStream(data, stream);
                break;
            }
            case 3: {
                WinICOFileFormat i = new WinICOFileFormat();
                i.unloadIntoStream(data, stream);
                break;
            }
            case 4: {
                JPEGFileFormat j = new JPEGFileFormat();
                j.unloadIntoStream(data, stream);
                break;
            }
            case 5: {
                PNGFileFormat p = new PNGFileFormat();
                p.unloadIntoStream(data, stream);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }

    abstract void unloadIntoByteStream(ImageData var1);

    public void unloadIntoStream(ImageData image, LEDataOutputStream stream) {
        try {
            this.outputStream = stream;
            this.unloadIntoByteStream(image);
            this.outputStream.close();
        }
        catch (Exception e) {
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {}
            SWT.error(39, e);
        }
    }
}

