/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledTextBidi;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

abstract class StyledTextRenderer {
    private Device device;
    private Font regularFont;
    private Font boldFont;
    private boolean isBidi;
    private int leftMargin;
    private int tabLength;
    private int tabWidth;
    private int lineHeight;
    private int lineEndSpaceWidth;

    StyledTextRenderer(Device device, Font regularFont, boolean isBidi, int leftMargin) {
        FontData fontData = regularFont.getFontData()[0];
        fontData.setStyle(fontData.getStyle() | 1);
        this.boldFont = new Font(device, fontData);
        this.device = device;
        this.regularFont = regularFont;
        this.isBidi = isBidi;
        this.leftMargin = leftMargin;
    }

    int bidiTextWidth(String text, int startOffset, int length, int startXOffset, StyledTextBidi bidi) {
        int endOffset = startOffset + length;
        int textLength = text.length();
        if (startOffset < 0 || startOffset >= textLength || endOffset > textLength) {
            return 0;
        }
        return bidi.getCaretPosition(endOffset, this.getLastCaretDirection()) - startXOffset;
    }

    void calculateLineHeight() {
        GC gc = this.getGC();
        this.lineHeight = gc.getFontMetrics().getHeight();
        this.lineEndSpaceWidth = gc.stringExtent((String)" ").x;
        this.disposeGC(gc);
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
    }

    protected abstract void disposeGC(GC var1);

    void drawLine(String line, int lineIndex, int paintY, GC gc, Color widgetBackground, Color widgetForeground, FontData currentFont, boolean clearBackground) {
        int lineOffset = this.getContent().getOffsetAtLine(lineIndex);
        int lineLength = line.length();
        Point selection = this.getSelection();
        int selectionStart = selection.x;
        int selectionEnd = selection.y;
        StyleRange[] styles = new StyleRange[]{};
        Color lineBackground = null;
        StyledTextEvent event = this.getLineStyleData(lineOffset, line);
        StyledTextBidi bidi = null;
        if (event != null) {
            styles = event.styles;
        }
        if (this.isBidi()) {
            this.setLineFont(gc, currentFont, 0);
            bidi = this.getStyledTextBidi(line, lineOffset, gc, styles);
        }
        if ((event = this.getLineBackgroundData(lineOffset, line)) != null) {
            lineBackground = event.lineBackground;
        }
        if (lineBackground == null) {
            lineBackground = widgetBackground;
        }
        if (clearBackground && (!this.isFullLineSelection() || selectionStart > lineOffset || selectionEnd <= lineOffset + lineLength)) {
            gc.setBackground(lineBackground);
            gc.setForeground(lineBackground);
            gc.fillRectangle(this.leftMargin, paintY, this.getClientArea().width, this.lineHeight);
        }
        if (selectionStart != selectionEnd) {
            this.drawLineSelectionBackground(line, lineOffset, styles, paintY, gc, currentFont, bidi);
        }
        if (selectionStart != selectionEnd && (selectionStart >= lineOffset && selectionStart < lineOffset + lineLength || selectionStart < lineOffset && selectionEnd > lineOffset)) {
            styles = this.mergeSelectionLineStyles(styles);
        }
        if (this.isBidi()) {
            int paintX = this.bidiTextWidth(line, 0, 0, 0, bidi);
            this.drawStyledLine(line, lineOffset, 0, styles, paintX, paintY, gc, lineBackground, widgetForeground, currentFont, bidi);
        } else {
            this.drawStyledLine(line, lineOffset, 0, styles, 0, paintY, gc, lineBackground, widgetForeground, currentFont, bidi);
        }
    }

    protected abstract void drawLineSelectionBackground(String var1, int var2, StyleRange[] var3, int var4, GC var5, FontData var6, StyledTextBidi var7);

    private void drawStyledLine(String line, int lineOffset, int renderOffset, StyleRange[] styles, int paintX, int paintY, GC gc, Color lineBackground, Color lineForeground, FontData currentFont, StyledTextBidi bidi) {
        int lineLength = line.length();
        int horizontalScrollOffset = this.getHorizontalPixel();
        Color background = gc.getBackground();
        Color foreground = gc.getForeground();
        StyleRange style = null;
        StyleRange[] filteredStyles = this.filterLineStyles(styles);
        int renderStopX = this.getClientArea().width + horizontalScrollOffset;
        int i = 0;
        while (i < styles.length && (paintX < renderStopX || bidi != null)) {
            block11: {
                int styleLineStart;
                int styleLineEnd;
                block10: {
                    block9: {
                        style = styles[i];
                        styleLineEnd = style.start + style.length - lineOffset;
                        styleLineStart = Math.max(style.start - lineOffset, 0);
                        if (styleLineStart <= renderOffset) break block9;
                        background = this.setLineBackground(gc, background, lineBackground);
                        foreground = this.setLineForeground(gc, foreground, lineForeground);
                        this.setLineFont(gc, currentFont, 0);
                        styleLineStart = Math.min(lineLength, styleLineStart);
                        paintX = this.drawText(line, renderOffset, styleLineStart - renderOffset, paintX, paintY, gc, bidi);
                        renderOffset = styleLineStart;
                        break block10;
                    }
                    if (styleLineEnd <= renderOffset) break block11;
                }
                if (styleLineStart >= lineLength) break;
                int styleLineLength = Math.min(styleLineEnd, lineLength) - renderOffset;
                if (style.background != null) {
                    background = this.setLineBackground(gc, background, style.background);
                    foreground = this.setLineForeground(gc, foreground, style.background);
                    if (bidi != null) {
                        bidi.fillBackground(renderOffset, styleLineLength, this.leftMargin - horizontalScrollOffset, paintY, this.lineHeight);
                    } else {
                        int fillWidth = this.textWidth(line, lineOffset, renderOffset, styleLineLength, filteredStyles, paintX, gc, currentFont);
                        gc.fillRectangle(paintX - horizontalScrollOffset + this.leftMargin, paintY, fillWidth, this.lineHeight);
                    }
                } else {
                    background = this.setLineBackground(gc, background, lineBackground);
                }
                foreground = style.foreground != null ? this.setLineForeground(gc, foreground, style.foreground) : this.setLineForeground(gc, foreground, lineForeground);
                this.setLineFont(gc, currentFont, style.fontStyle);
                paintX = this.drawText(line, renderOffset, styleLineLength, paintX, paintY, gc, bidi);
                renderOffset += styleLineLength;
            }
            ++i;
        }
        if (!(style != null && renderOffset >= lineLength || paintX >= renderStopX && bidi == null)) {
            this.setLineBackground(gc, background, lineBackground);
            this.setLineForeground(gc, foreground, lineForeground);
            this.setLineFont(gc, currentFont, 0);
            this.drawText(line, renderOffset, lineLength - renderOffset, paintX, paintY, gc, bidi);
        }
    }

    private int drawText(String text, int startOffset, int length, int paintX, int paintY, GC gc, StyledTextBidi bidi) {
        int endOffset = startOffset + length;
        int textLength = text.length();
        int horizontalScrollOffset = this.getHorizontalPixel();
        if (startOffset < 0 || startOffset >= textLength || startOffset + length > textLength) {
            return paintX;
        }
        int i = startOffset;
        while (i < endOffset) {
            int tabIndex = text.indexOf(9, i);
            if (tabIndex == -1 || tabIndex > endOffset) {
                tabIndex = endOffset;
            }
            if (tabIndex != i) {
                String tabSegment = text.substring(i, tabIndex);
                if (bidi != null) {
                    bidi.drawBidiText(i, tabIndex - i, this.leftMargin - horizontalScrollOffset, paintY);
                } else {
                    gc.drawString(tabSegment, paintX - horizontalScrollOffset + this.leftMargin, paintY, true);
                    paintX += gc.stringExtent((String)tabSegment).x;
                    if (tabIndex != endOffset && this.tabWidth > 0) {
                        paintX = this.getTabStop(paintX);
                    }
                }
                i = tabIndex;
            } else if (this.tabWidth > 0 && !this.isBidi()) {
                paintX = this.getTabStop(paintX);
            }
            ++i;
        }
        return paintX;
    }

    StyleRange[] filterLineStyles(StyleRange[] styles) {
        if (styles != null) {
            int styleIndex = 0;
            while (styleIndex < styles.length && styles[styleIndex].fontStyle == 0) {
                ++styleIndex;
            }
            if (styleIndex == styles.length) {
                styles = null;
            }
        }
        return styles;
    }

    protected abstract Rectangle getClientArea();

    protected abstract StyledTextContent getContent();

    Device getDevice() {
        return this.device;
    }

    private StyleRange[] getFontStyleRanges(StyleRange[] styles, int lineOffset, int lineLength) {
        StyleRange style;
        int count = 0;
        StyleRange[] ranges = null;
        if (styles == null) {
            return null;
        }
        int i = 0;
        while (i < styles.length) {
            style = styles[i];
            if (style.start - lineOffset < lineLength && style.fontStyle == 1) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            ranges = new StyleRange[count];
            count = 0;
            i = 0;
            while (i < styles.length) {
                style = styles[i];
                int styleLineStart = style.start - lineOffset;
                if (styleLineStart < lineLength && style.fontStyle == 1) {
                    StyleRange newStyle = new StyleRange();
                    newStyle.start = Math.max(0, styleLineStart);
                    newStyle.length = Math.min(styleLineStart + style.length, lineLength) - newStyle.start;
                    ranges[count] = newStyle;
                    ++count;
                }
                ++i;
            }
        }
        return ranges;
    }

    protected abstract int[] getBidiSegments(int var1, String var2);

    protected abstract GC getGC();

    protected abstract int getHorizontalPixel();

    protected abstract int getLastCaretDirection();

    int getLeftMargin() {
        return this.leftMargin;
    }

    int getLineEndSpaceWidth() {
        return this.lineEndSpaceWidth;
    }

    protected abstract StyledTextEvent getLineBackgroundData(int var1, String var2);

    int getLineHeight() {
        return this.lineHeight;
    }

    StyledTextEvent getLineStyleData(StyledTextEvent event, int lineOffset, String line) {
        int lineLength = line.length();
        if (event.styles != null && this.getWordWrap()) {
            event.styles = this.getVisualLineStyleData(event.styles, lineOffset, lineLength);
        }
        if (event.styles == null) {
            event.styles = new StyleRange[0];
        } else if (this.isBidi()) {
            GC gc = this.getGC();
            if (StyledTextBidi.isLigated(gc)) {
                int[] nArray = new int[2];
                nArray[1] = lineLength;
                StyledTextBidi bidi = new StyledTextBidi(gc, line, nArray);
                int i = 0;
                while (i < event.styles.length) {
                    int endLigature;
                    int rangeEnd;
                    int relativeEnd;
                    int startLigature;
                    StyleRange range = event.styles[i];
                    StyleRange newRange = null;
                    int relativeStart = range.start - lineOffset;
                    if (relativeStart >= 0 && (startLigature = bidi.getLigatureStartOffset(relativeStart)) != relativeStart) {
                        range = event.styles[i] = (newRange = (StyleRange)range.clone());
                        range.start -= relativeStart - startLigature;
                        range.length += relativeStart - startLigature;
                    }
                    if ((relativeEnd = (rangeEnd = range.start + range.length) - lineOffset - 1) < lineLength && (endLigature = bidi.getLigatureEndOffset(relativeEnd)) != relativeEnd) {
                        if (newRange == null) {
                            range = event.styles[i] = (newRange = (StyleRange)range.clone());
                        }
                        range.length += endLigature - relativeEnd;
                    }
                    ++i;
                }
            }
            this.disposeGC(gc);
        }
        return event;
    }

    protected abstract StyledTextEvent getLineStyleData(int var1, String var2);

    protected abstract Point getSelection();

    protected abstract StyleRange[] mergeSelectionLineStyles(StyleRange[] var1);

    StyledTextBidi getStyledTextBidi(String lineText, int lineOffset, GC gc, StyleRange[] styles) {
        StyleRange[] fontStyles = null;
        if (styles == null) {
            StyledTextEvent event = this.getLineStyleData(lineOffset, lineText);
            if (event != null) {
                fontStyles = this.getFontStyleRanges(event.styles, lineOffset, lineText.length());
            }
        } else {
            fontStyles = this.getFontStyleRanges(styles, lineOffset, lineText.length());
        }
        return new StyledTextBidi(gc, this.tabWidth, lineText, fontStyles, this.boldFont, this.getBidiSegments(lineOffset, lineText));
    }

    private int getTabStop(int x) {
        int spaceWidth = this.tabWidth / this.tabLength;
        if (this.tabWidth - x % this.tabWidth < spaceWidth) {
            x += this.tabWidth;
        }
        x += this.tabWidth;
        x -= x % this.tabWidth;
        return x;
    }

    StyleRange[] getVisualLineStyleData(StyleRange[] logicalStyles, int lineOffset, int lineLength) {
        int lineEnd = lineOffset + lineLength;
        int oldStyleCount = logicalStyles.length;
        int newStyleCount = 0;
        int i = 0;
        while (i < oldStyleCount) {
            StyleRange style = logicalStyles[i];
            if (style.start < lineEnd && style.start + style.length > lineOffset) {
                ++newStyleCount;
            }
            ++i;
        }
        if (newStyleCount != oldStyleCount) {
            StyleRange[] newStyles = new StyleRange[newStyleCount];
            int i2 = 0;
            int j = 0;
            while (i2 < oldStyleCount) {
                StyleRange style = logicalStyles[i2];
                if (style.start < lineEnd && style.start + style.length > lineOffset) {
                    newStyles[j++] = logicalStyles[i2];
                }
                ++i2;
            }
            logicalStyles = newStyles;
        }
        return logicalStyles;
    }

    protected abstract boolean getWordWrap();

    boolean isBidi() {
        return this.isBidi;
    }

    protected abstract boolean isFullLineSelection();

    private Color setLineBackground(GC gc, Color currentBackground, Color newBackground) {
        if (!currentBackground.equals(newBackground)) {
            gc.setBackground(newBackground);
        }
        return newBackground;
    }

    private void setLineFont(GC gc, FontData currentFont, int style) {
        if (currentFont.getStyle() != style) {
            if (style == 1) {
                currentFont.setStyle(style);
                gc.setFont(this.boldFont);
            } else if (style == 0) {
                currentFont.setStyle(style);
                gc.setFont(this.regularFont);
            }
        }
    }

    private Color setLineForeground(GC gc, Color currentForeground, Color newForeground) {
        if (!currentForeground.equals(newForeground)) {
            gc.setForeground(newForeground);
        }
        return newForeground;
    }

    void setTabLength(int tabLength) {
        GC gc = this.getGC();
        StringBuffer tabBuffer = new StringBuffer(tabLength);
        this.tabLength = tabLength;
        int i = 0;
        while (i < tabLength) {
            tabBuffer.append(' ');
            ++i;
        }
        this.tabWidth = gc.stringExtent((String)tabBuffer.toString()).x;
        this.disposeGC(gc);
    }

    private int styledTextWidth(String text, int textStartOffset, StyleRange[] lineStyles, int paintX, GC gc, FontData fontData) {
        String textSegment;
        int textLength = text.length();
        int textIndex = 0;
        int styleIndex = 0;
        while (styleIndex < lineStyles.length) {
            StyleRange style = lineStyles[styleIndex];
            int styleSegmentStart = style.start - textStartOffset;
            if (styleSegmentStart + style.length >= 0) {
                if (styleSegmentStart >= textLength) break;
                if (textIndex < styleSegmentStart) {
                    this.setLineFont(gc, fontData, 0);
                    textSegment = text.substring(textIndex, styleSegmentStart);
                    paintX += gc.stringExtent((String)textSegment).x;
                    textIndex = styleSegmentStart;
                }
                int textEnd = Math.min(textLength, styleSegmentStart + style.length);
                this.setLineFont(gc, fontData, style.fontStyle);
                textSegment = text.substring(textIndex, textEnd);
                paintX += gc.stringExtent((String)textSegment).x;
                textIndex = textEnd;
            }
            ++styleIndex;
        }
        if (textIndex < textLength) {
            this.setLineFont(gc, fontData, 0);
            textSegment = text.substring(textIndex, textLength);
            paintX += gc.stringExtent((String)textSegment).x;
        }
        return paintX;
    }

    int textWidth(String text, int lineOffset, int startOffset, int length, StyleRange[] lineStyles, int startXOffset, GC gc, FontData fontData) {
        int paintX = 0;
        int endOffset = startOffset + length;
        int textLength = text.length();
        if (startOffset < 0 || startOffset >= textLength || endOffset > textLength) {
            return paintX;
        }
        int i = startOffset;
        while (i < endOffset) {
            int tabIndex = text.indexOf(9, i);
            if (tabIndex == -1 || tabIndex > endOffset) {
                tabIndex = endOffset;
            }
            if (tabIndex != i) {
                String tabSegment = text.substring(i, tabIndex);
                if (lineStyles != null) {
                    paintX = this.styledTextWidth(tabSegment, lineOffset + i, lineStyles, paintX, gc, fontData);
                } else {
                    this.setLineFont(gc, fontData, 0);
                    paintX += gc.stringExtent((String)tabSegment).x;
                }
                if (tabIndex != endOffset && this.tabWidth > 0) {
                    paintX = this.getTabStop(startXOffset + paintX) - startXOffset;
                }
                i = tabIndex;
            } else if (this.tabWidth > 0) {
                paintX = this.getTabStop(startXOffset + paintX) - startXOffset;
            }
            ++i;
        }
        return paintX;
    }
}

