/*
 * Decompiled with CFR 0.152.
 */
package yeoupooh.scrapper;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import yeoupooh.scrapper.ScrapperHelper;
import yeoupooh.scrapper.ScrapperLauncherLogger;

public class ScrapperLauncher
implements SelectionListener {
    private String m_scrapperHome = null;
    private ScrapperHelper m_helper = null;
    private Display display = new Display();
    private Shell shell = new Shell(this.display);
    private static final String BUTTON_RUNALL = "\ubaa8\ub450 \uc2e4\ud589\ud558\uae30";
    private static final String BUTTON_RUN = "\uc2e4\ud589\ud558\uae30";
    private static final String BUTTON_HELP = "\ub3c4\uc6c0\ub9d0";
    private static final String BUTTON_EXIT = "\ub05d";
    private Button buttonRunAll = null;
    private Button buttonRun = null;
    private Button buttonHelp = null;
    private Button buttonExit = null;
    private List listSite = null;
    private Text m_textLog = null;

    public ScrapperLauncher() {
        this.m_scrapperHome = System.getProperty("scrapper.home", "..");
        this.m_helper = new ScrapperHelper();
        this.m_helper.setScriptDir(this.m_scrapperHome + "/scripts");
        this.m_helper.setOutputDir(this.m_scrapperHome + "/output");
    }

    public void buildUI() {
        String string;
        this.shell.setText("Scraper Launcher (E:v" + this.m_helper.getScraper().getEngineVersion() + ", S:v" + this.m_helper.getScraper().getScriptVersion() + ")");
        try {
            this.shell.setImage(new Image((Device)this.display, this.m_scrapperHome + "/images/TOpooh6.ico"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.shell.setLayout((Layout)gridLayout);
        this.listSite = new List((Composite)this.shell, -1);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 4;
        this.listSite.setLayoutData((Object)gridData);
        this.listSite.addSelectionListener((SelectionListener)this);
        String[] stringArray = this.m_helper.getSiteFileList();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                this.listSite.add(string);
                ++n;
            }
        }
        this.buttonRunAll = new Button((Composite)this.shell, 8);
        this.buttonRunAll.setText(BUTTON_RUNALL);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 100;
        gridData2.heightHint = 30;
        this.buttonRunAll.setLayoutData((Object)gridData2);
        this.buttonRunAll.addSelectionListener((SelectionListener)this);
        this.buttonRun = new Button((Composite)this.shell, 8);
        this.buttonRun.setText(BUTTON_RUN);
        string = new GridData();
        ((GridData)string).horizontalAlignment = 4;
        ((GridData)string).widthHint = 100;
        ((GridData)string).heightHint = 30;
        this.buttonRun.setLayoutData((Object)string);
        this.buttonRun.addSelectionListener((SelectionListener)this);
        this.buttonHelp = new Button((Composite)this.shell, 8);
        this.buttonHelp.setText(BUTTON_HELP);
        GridData gridData3 = new GridData();
        gridData3.widthHint = 100;
        gridData3.heightHint = 30;
        this.buttonHelp.setLayoutData((Object)gridData3);
        this.buttonHelp.addSelectionListener((SelectionListener)this);
        this.buttonExit = new Button((Composite)this.shell, 8);
        this.buttonExit.setText(BUTTON_EXIT);
        GridData gridData4 = new GridData();
        gridData4.widthHint = 100;
        gridData4.heightHint = 30;
        this.buttonExit.setLayoutData((Object)gridData4);
        this.buttonExit.addSelectionListener((SelectionListener)this);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.shell, 2816);
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 2;
        gridData5.heightHint = 50;
        gridData5.widthHint = 300;
        scrolledComposite.setLayoutData((Object)gridData5);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        FillLayout fillLayout = new FillLayout();
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        composite.setLayout((Layout)fillLayout);
        this.m_textLog = new Text(composite, 522);
        this.m_textLog.append("Welcome.\r\n");
        this.m_textLog.setBackground(new Color((Device)this.display, 255, 255, 255));
        this.m_helper.setScrapperLogger(new ScrapperLauncherLogger(this.m_textLog));
        composite.setSize(composite.computeSize(-1, -1));
        this.shell.pack();
        this.shell.open();
    }

    public void run() {
        this.buildUI();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    public static void main(String[] stringArray) {
        ScrapperLauncher scrapperLauncher = new ScrapperLauncher();
        scrapperLauncher.run();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.getSource().equals(this.buttonExit)) {
            System.exit(1);
        } else if (selectionEvent.getSource().equals(this.buttonRunAll)) {
            try {
                this.m_helper.scrapAllSite();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (selectionEvent.getSource().equals(this.buttonRun)) {
            try {
                if (this.listSite.getSelectionIndex() > -1) {
                    this.m_helper.scrapSite(this.listSite.getItem(this.listSite.getSelectionIndex()));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (selectionEvent.getSource().equals(this.buttonHelp)) {
            System.out.println("help");
        } else if (selectionEvent.getSource().equals(this.listSite)) {
            System.out.println("bingo!!");
        }
    }
}

