/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Display
extends Device {
    public MSG msg = new MSG();
    Event[] eventQueue;
    Callback windowCallback;
    int windowProc;
    int threadId;
    int processId;
    TCHAR windowClass;
    static int windowClassCount = 0;
    static final String WindowName = "SWT_Window";
    EventTable eventTable;
    Callback messageCallback;
    int messageProc;
    int hHook;
    MSG hookMsg = new MSG();
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    int timerCount;
    int[] timerIds;
    Runnable[] timerList;
    boolean lastVirtual;
    boolean lockActiveWindow;
    int lastKey;
    int lastAscii;
    int lastMouse;
    byte[] keyboard = new byte[256];
    boolean accelKeyHit;
    boolean mnemonicKeyHit;
    int hwndShell;
    int[] systemFonts;
    ImageList[] imageList;
    ImageList[] toolImageList;
    ImageList[] toolHotImageList;
    ImageList[] toolDisabledImageList;
    int lpCustColors;
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {38, 0x1000001}, {40, 0x1000002}, {37, 0x1000003}, {39, 0x1000004}, {33, 0x1000005}, {34, 0x1000006}, {36, 0x1000007}, {35, 0x1000008}, {45, 0x1000009}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}};
    static Display Default;
    static Display[] Displays;
    Shell[] ModalWidgets;
    static boolean TrimEnabled;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";

    static {
        Displays = new Display[4];
        TrimEnabled = false;
        Device.DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        Device.CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    int asciiKey(int key) {
        if (OS.IsWinCE) {
            return 0;
        }
        int i = 0;
        while (i < this.keyboard.length) {
            this.keyboard[i] = 0;
            ++i;
        }
        if (!OS.GetKeyboardState(this.keyboard)) {
            return 0;
        }
        if (OS.IsUnicode) {
            char[] result = new char[1];
            if (OS.ToUnicode(key, key, this.keyboard, result, 1, 0) == 1) {
                return result[0];
            }
        } else {
            short[] result = new short[1];
            if (OS.ToAscii(key, key, this.keyboard, result, 0) == 1) {
                return result[0];
            }
        }
        return 0;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.MessageBeep(0);
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    protected void checkDevice() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] != null && Display.Displays[i].thread == thread) {
                SWT.error(22);
            }
            ++i;
        }
    }

    void clearModal(Shell shell) {
        if (this.ModalWidgets == null) {
            return;
        }
        int index = 0;
        int length = this.ModalWidgets.length;
        while (index < length) {
            if (this.ModalWidgets[index] == shell) break;
            if (this.ModalWidgets[index] == null) {
                return;
            }
            ++index;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.ModalWidgets, index + 1, this.ModalWidgets, index, --length - index);
        this.ModalWidgets[length] = null;
        if (index == 0 && this.ModalWidgets[0] == null) {
            this.ModalWidgets = null;
        }
        if (!TrimEnabled) {
            return;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    int controlKey(int key) {
        short upper = OS.CharUpper((short)key);
        if (64 <= upper && upper <= 95) {
            return upper & 0xBF;
        }
        return key;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
    }

    static synchronized void deregister(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (display == Displays[i]) {
                Display.Displays[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterMessage(MSG msg) {
        Control control;
        int message = msg.message;
        if (256 <= message && message <= 264 && (control = this.findControl(msg.hwnd)) != null) {
            if (this.translateAccelerator(msg, control)) {
                return true;
            }
            if (this.translateMnemonic(msg, control)) {
                return true;
            }
            if (this.translateTraversal(msg, control)) {
                return true;
            }
        }
        return false;
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return WidgetTable.get(handle);
    }

    Control findControl(int handle) {
        if (handle == 0) {
            return null;
        }
        do {
            Control control;
            if ((control = WidgetTable.get(handle)) == null || control.handle != handle) continue;
            return control;
        } while ((handle = OS.GetParent(handle)) != 0);
        return null;
    }

    public static synchronized Display findDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Control control = this.findControl(OS.GetActiveWindow());
        if (control instanceof Shell) {
            return (Shell)control;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            int width = OS.GetSystemMetrics(0);
            int height = OS.GetSystemMetrics(1);
            return new Rectangle(0, 0, width, height);
        }
        int x = OS.GetSystemMetrics(76);
        int y = OS.GetSystemMetrics(77);
        int width = OS.GetSystemMetrics(78);
        int height = OS.GetSystemMetrics(79);
        return new Rectangle(x, y, width, height);
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            RECT rect = new RECT();
            OS.SystemParametersInfo(48, 0, rect, 0);
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            return new Rectangle(rect.left, rect.top, width, height);
        }
        int x = OS.GetSystemMetrics(76);
        int y = OS.GetSystemMetrics(77);
        int width = OS.GetSystemMetrics(78);
        int height = OS.GetSystemMetrics(79);
        return new Rectangle(x, y, width, height);
    }

    public Control getCursorControl() {
        this.checkDevice();
        POINT pt = new POINT();
        if (!OS.GetCursorPos(pt)) {
            return null;
        }
        return this.findControl(OS.WindowFromPoint(pt));
    }

    public Point getCursorLocation() {
        this.checkDevice();
        POINT pt = new POINT();
        OS.GetCursorPos(pt);
        return new Point(pt.x, pt.y);
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDoubleClickTime();
    }

    public Control getFocusControl() {
        this.checkDevice();
        return this.findControl(OS.GetFocus());
    }

    public int getIconDepth() {
        this.checkDevice();
        TCHAR buffer1 = new TCHAR(0, "Control Panel\\Desktop\\WindowMetrics", true);
        int[] phkResult = new int[1];
        int result = OS.RegOpenKeyEx(-2147483647, buffer1, 0, 131097, phkResult);
        if (result != 0) {
            return 4;
        }
        int depth = 4;
        TCHAR buffer2 = new TCHAR(0, "Shell Icon BPP", true);
        int[] lpcbData = new int[]{128};
        TCHAR lpData = new TCHAR(0, lpcbData[0]);
        result = OS.RegQueryValueEx(phkResult[0], buffer2, 0, null, lpData, lpcbData);
        if (result == 0) {
            try {
                depth = Integer.parseInt(lpData.toString(0, lpData.strlen()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        OS.RegCloseKey(phkResult[0]);
        return depth;
    }

    ImageList getImageList(Point size) {
        ImageList list;
        if (this.imageList == null) {
            this.imageList = new ImageList[4];
        }
        int i = 0;
        int length = this.imageList.length;
        while (i < length) {
            list = this.imageList[i];
            if (list == null) break;
            if (list.getImageSize().equals(size)) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.imageList, 0, newList, 0, length);
            this.imageList = newList;
        }
        this.imageList[i] = list = new ImageList();
        list.addRef();
        return list;
    }

    ImageList getToolImageList(Point size) {
        ImageList list;
        if (this.toolImageList == null) {
            this.toolImageList = new ImageList[4];
        }
        int i = 0;
        int length = this.toolImageList.length;
        while (i < length) {
            list = this.toolImageList[i];
            if (list == null) break;
            if (list.getImageSize().equals(size)) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.toolImageList, 0, newList, 0, length);
            this.toolImageList = newList;
        }
        this.toolImageList[i] = list = new ImageList();
        list.addRef();
        return list;
    }

    ImageList getToolHotImageList(Point size) {
        ImageList list;
        if (this.toolHotImageList == null) {
            this.toolHotImageList = new ImageList[4];
        }
        int i = 0;
        int length = this.toolHotImageList.length;
        while (i < length) {
            list = this.toolHotImageList[i];
            if (list == null) break;
            if (list.getImageSize().equals(size)) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.toolHotImageList, 0, newList, 0, length);
            this.toolHotImageList = newList;
        }
        this.toolHotImageList[i] = list = new ImageList();
        list.addRef();
        return list;
    }

    ImageList getToolDisabledImageList(Point size) {
        ImageList list;
        if (this.toolDisabledImageList == null) {
            this.toolDisabledImageList = new ImageList[4];
        }
        int i = 0;
        int length = this.toolDisabledImageList.length;
        while (i < length) {
            list = this.toolDisabledImageList[i];
            if (list == null) break;
            if (list.getImageSize().equals(size)) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.toolDisabledImageList, 0, newList, 0, length);
            this.toolDisabledImageList = newList;
        }
        this.toolDisabledImageList[i] = list = new ImageList();
        list.addRef();
        return list;
    }

    Shell getModalShell() {
        if (this.ModalWidgets == null) {
            return null;
        }
        int index = this.ModalWidgets.length;
        while (--index >= 0) {
            Shell shell = this.ModalWidgets[index];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int count = 0;
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                ++count;
            }
            ++i;
        }
        if (count == shells.length) {
            return shells;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Shell shell = shells[i2];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                result[index++] = shell;
            }
            ++i2;
        }
        return result;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        int pixel = 0x2000000;
        switch (id) {
            case 17: {
                pixel = OS.GetSysColor(OS.COLOR_3DDKSHADOW);
                break;
            }
            case 18: {
                pixel = OS.GetSysColor(OS.COLOR_3DSHADOW);
                break;
            }
            case 19: {
                pixel = OS.GetSysColor(OS.COLOR_3DLIGHT);
                break;
            }
            case 20: {
                pixel = OS.GetSysColor(OS.COLOR_3DHIGHLIGHT);
                break;
            }
            case 22: {
                pixel = OS.GetSysColor(OS.COLOR_3DFACE);
                break;
            }
            case 23: {
                pixel = OS.GetSysColor(OS.COLOR_WINDOWFRAME);
                break;
            }
            case 21: 
            case 24: {
                pixel = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
                break;
            }
            case 25: {
                pixel = OS.GetSysColor(OS.COLOR_WINDOW);
                break;
            }
            case 26: {
                pixel = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                break;
            }
            case 27: {
                pixel = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                break;
            }
            case 28: {
                pixel = OS.GetSysColor(OS.COLOR_INFOTEXT);
                break;
            }
            case 29: {
                pixel = OS.GetSysColor(OS.COLOR_INFOBK);
                break;
            }
            case 30: {
                pixel = OS.GetSysColor(OS.COLOR_CAPTIONTEXT);
                break;
            }
            case 31: {
                pixel = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 32: {
                pixel = OS.GetSysColor(OS.COLOR_GRADIENTACTIVECAPTION);
                if (pixel != 0) break;
                pixel = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 33: {
                pixel = OS.GetSysColor(OS.COLOR_INACTIVECAPTIONTEXT);
                break;
            }
            case 34: {
                pixel = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            case 35: {
                pixel = OS.GetSysColor(OS.COLOR_GRADIENTINACTIVECAPTION);
                if (pixel != 0) break;
                pixel = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        return Color.win32_new(this, pixel);
    }

    public Font getSystemFont() {
        this.checkDevice();
        int hFont = this.systemFont();
        return Font.win32_new(this, hFont);
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    public int internal_new_GC(GCData data) {
        int hDC;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((hDC = OS.GetDC(0)) == 0) {
            SWT.error(2);
        }
        if (data != null) {
            data.device = this;
            data.hFont = this.systemFont();
        }
        return hDC;
    }

    protected void init() {
        int lpszClassName;
        WNDCLASS lpWndClass;
        super.init();
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.threadId = OS.GetCurrentThreadId();
        this.processId = OS.GetCurrentProcessId();
        this.windowClass = new TCHAR(0, WindowName + windowClassCount++, true);
        int hHeap = OS.GetProcessHeap();
        int hInstance = OS.GetModuleHandle(null);
        if (OS.GetClassInfo(hInstance, this.windowClass, lpWndClass = new WNDCLASS())) {
            OS.UnregisterClass(this.windowClass, hInstance);
        }
        lpWndClass.hInstance = hInstance;
        lpWndClass.lpfnWndProc = this.windowProc;
        lpWndClass.style = 8200;
        lpWndClass.hCursor = OS.LoadCursor(0, 32512);
        int byteCount = this.windowClass.length() * TCHAR.sizeof;
        lpWndClass.lpszClassName = lpszClassName = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(lpszClassName, this.windowClass, byteCount);
        OS.RegisterClass(lpWndClass);
        int systemFont = 0;
        if (!OS.IsWinCE) {
            NONCLIENTMETRICS info = new NONCLIENTMETRICS();
            info.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, info, 0)) {
                systemFont = OS.CreateFontIndirect(info.lfMessageFont);
            }
        }
        if (systemFont == 0) {
            systemFont = OS.GetStockObject(17);
        }
        if (systemFont == 0) {
            systemFont = OS.GetStockObject(13);
        }
        if (systemFont != 0) {
            this.systemFonts = new int[]{systemFont};
        }
        this.hwndShell = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0, 0, hInstance, null);
        if (!OS.IsWinCE) {
            this.messageCallback = new Callback(this, "messageProc", 3);
            this.messageProc = this.messageCallback.getAddress();
            if (this.messageProc == 0) {
                this.error(3);
            }
            this.hHook = OS.SetWindowsHookEx(-1, this.messageProc, 0, this.threadId);
        }
    }

    public void internal_dispose_GC(int hDC, GCData data) {
        OS.ReleaseDC(0, hDC);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    boolean isVirtualKey(int key) {
        switch (key) {
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 27: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    int messageProc(int code, int wParam, int lParam) {
        if (code >= 0) {
            OS.MoveMemory(this.hookMsg, lParam, 28);
            if (this.hookMsg.message == 0) {
                this.runAsyncMessages();
            }
        }
        return OS.CallNextHookEx(this.hHook, code, wParam, lParam);
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        if (OS.PeekMessage(this.msg, 0, 0, 0, 1)) {
            if (!this.filterMessage(this.msg)) {
                OS.TranslateMessage(this.msg);
                OS.DispatchMessage(this.msg);
            }
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages();
    }

    static synchronized void register(Display display) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] == null) {
                Display.Displays[i] = display;
                return;
            }
            ++i;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = display;
        Displays = newDisplays;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                shell.dispose();
            }
            ++i;
        }
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        if (!OS.IsWinCE) {
            if (this.hHook != 0) {
                OS.UnhookWindowsHookEx(this.hHook);
            }
            this.hHook = 0;
            this.messageCallback.dispose();
            this.messageCallback = null;
        }
        if (this.hwndShell != 0) {
            OS.DestroyWindow(this.hwndShell);
        }
        this.hwndShell = 0;
        int hHeap = OS.GetProcessHeap();
        int hInstance = OS.GetModuleHandle(null);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, this.windowClass, lpWndClass);
        OS.UnregisterClass(this.windowClass, hInstance);
        OS.HeapFree(hHeap, 0, lpWndClass.lpszClassName);
        this.windowClass = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        if (this.systemFonts != null) {
            int i = 0;
            while (i < this.systemFonts.length) {
                if (this.systemFonts[i] != 0) {
                    OS.DeleteObject(this.systemFonts[i]);
                }
                ++i;
            }
        }
        this.systemFonts = null;
        if (this.lpCustColors != 0) {
            OS.HeapFree(hHeap, 0, this.lpCustColors);
        }
        this.lpCustColors = 0;
        this.thread = null;
        this.msg = null;
        this.keyboard = null;
        this.ModalWidgets = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    void releaseImageList(ImageList list) {
        int i = 0;
        int length = this.imageList.length;
        while (i < length) {
            if (this.imageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.imageList, i + 1, this.imageList, i, --length - i);
                this.imageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.imageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.imageList = null;
                return;
            }
            ++i;
        }
    }

    void releaseToolImageList(ImageList list) {
        int i = 0;
        int length = this.toolImageList.length;
        while (i < length) {
            if (this.toolImageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.toolImageList, i + 1, this.toolImageList, i, --length - i);
                this.toolImageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.toolImageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.toolImageList = null;
                return;
            }
            ++i;
        }
    }

    void releaseToolHotImageList(ImageList list) {
        int i = 0;
        int length = this.toolHotImageList.length;
        while (i < length) {
            if (this.toolHotImageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.toolHotImageList, i + 1, this.toolHotImageList, i, --length - i);
                this.toolHotImageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.toolHotImageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.toolHotImageList = null;
                return;
            }
            ++i;
        }
    }

    void releaseToolDisabledImageList(ImageList list) {
        int i = 0;
        int length = this.toolDisabledImageList.length;
        while (i < length) {
            if (this.toolDisabledImageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.toolDisabledImageList, i + 1, this.toolDisabledImageList, i, --length - i);
                this.toolDisabledImageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.toolDisabledImageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.toolDisabledImageList = null;
                return;
            }
            ++i;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    boolean runAsyncMessages() {
        return this.synchronizer.runAsyncMessages();
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    void runTimer(int id) {
        if (this.timerList != null && this.timerIds != null) {
            int index = 0;
            while (index < this.timerIds.length) {
                if (this.timerIds[index] == id) {
                    OS.KillTimer(this.hwndShell, this.timerIds[index]);
                    this.timerIds[index] = 0;
                    Runnable runnable = this.timerList[index];
                    this.timerList[index] = null;
                    if (runnable == null) break;
                    runnable.run();
                    break;
                }
                ++index;
            }
        }
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = OS.IsWinCE ? OS.GetTickCount() : OS.GetMessageTime();
        }
        this.eventTable.sendEvent(event);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        OS.SetCursorPos(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public static void setAppName(String name) {
    }

    void setModal(Shell shell) {
        if (this.ModalWidgets == null) {
            this.ModalWidgets = new Shell[4];
        }
        int index = 0;
        int length = this.ModalWidgets.length;
        while (index < length) {
            if (this.ModalWidgets[index] == shell) {
                return;
            }
            if (this.ModalWidgets[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalWidgets = new Shell[length + 4];
            System.arraycopy(this.ModalWidgets, 0, newModalWidgets, 0, length);
            this.ModalWidgets = newModalWidgets;
        }
        this.ModalWidgets[index] = shell;
        if (!TrimEnabled) {
            return;
        }
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].updateModal();
            ++i;
        }
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages();
        }
        this.synchronizer = synchronizer;
    }

    int shiftedKey(int key) {
        if (OS.IsWinCE) {
            return 0;
        }
        int i = 0;
        while (i < this.keyboard.length) {
            this.keyboard[i] = 0;
            ++i;
        }
        this.keyboard[16] = (byte)(this.keyboard[16] | 0x80);
        if (OS.IsUnicode) {
            char[] result = new char[1];
            if (OS.ToUnicode(key, key, this.keyboard, result, 1, 0) == 1) {
                return result[0];
            }
        } else {
            short[] result = new short[1];
            if (OS.ToAscii(key, key, this.keyboard, result, 0) == 1) {
                return result[0];
            }
        }
        return 0;
    }

    public boolean sleep() {
        this.checkDevice();
        if (OS.IsWinCE) {
            OS.GetMessage(this.msg, 0, 0, 0);
            if (!this.filterMessage(this.msg)) {
                OS.TranslateMessage(this.msg);
                OS.DispatchMessage(this.msg);
            }
            this.runDeferredEvents();
            return true;
        }
        return OS.WaitMessage();
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    int systemFont() {
        int length;
        int hFont = 0;
        if (this.systemFonts != null && (length = this.systemFonts.length) != 0) {
            hFont = this.systemFonts[length - 1];
        }
        if (hFont == 0) {
            hFont = OS.GetStockObject(17);
        }
        if (hFont == 0) {
            hFont = OS.GetStockObject(13);
        }
        return hFont;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int newTimerID;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        int timerId = 0;
        if (index != this.timerList.length) {
            timerId = this.timerIds[index];
            if (milliseconds < 0) {
                OS.KillTimer(this.hwndShell, timerId);
                this.timerList[index] = null;
                this.timerIds[index] = 0;
                return;
            }
        } else {
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            ++this.timerCount;
            timerId = this.timerCount;
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((newTimerID = OS.SetTimer(this.hwndShell, timerId, milliseconds, 0)) != 0) {
            this.timerList[index] = runnable;
            this.timerIds[index] = newTimerID;
        }
    }

    boolean translateAccelerator(MSG msg, Control control) {
        this.accelKeyHit = true;
        boolean result = control.translateAccelerator(msg);
        this.accelKeyHit = false;
        return result;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    boolean translateMnemonic(MSG msg, Control control) {
        switch (msg.message) {
            case 258: 
            case 262: {
                return control.translateMnemonic(msg);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG msg, Control control) {
        if (msg.message == 256) {
            switch (msg.wParam) {
                case 9: 
                case 13: 
                case 27: 
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    return control.translateTraversal(msg);
                }
            }
        }
        return false;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.getDisplay()) {
                shell.update();
            }
            ++i;
        }
    }

    void updateFont() {
        if (OS.IsWinCE) {
            return;
        }
        Font oldFont = this.getSystemFont();
        int systemFont = 0;
        NONCLIENTMETRICS info = new NONCLIENTMETRICS();
        info.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, info, 0)) {
            systemFont = OS.CreateFontIndirect(info.lfMessageFont);
        }
        if (systemFont == 0) {
            systemFont = OS.GetStockObject(17);
        }
        if (systemFont == 0) {
            systemFont = OS.GetStockObject(13);
        }
        if (systemFont == 0) {
            return;
        }
        int length = this.systemFonts == null ? 0 : this.systemFonts.length;
        int[] newFonts = new int[length + 1];
        if (this.systemFonts != null) {
            System.arraycopy(this.systemFonts, 0, newFonts, 0, length);
        }
        newFonts[length] = systemFont;
        this.systemFonts = newFonts;
        Font newFont = this.getSystemFont();
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.updateFont(oldFont, newFont);
            }
            ++i;
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        OS.PostThreadMessage(this.threadId, 0, 0, 0);
    }

    int windowProc(int hwnd, int msg, int wParam, int lParam) {
        Control control = WidgetTable.get(hwnd);
        if (control != null) {
            return control.windowProc(msg, wParam, lParam);
        }
        if (hwnd == this.hwndShell) {
            switch (msg) {
                case 22: {
                    if (wParam == 0) break;
                    this.dispose();
                    break;
                }
                case 17: {
                    Event event = new Event();
                    this.sendEvent(21, event);
                    if (event.doit) break;
                    return 0;
                }
                case 26: {
                    this.updateFont();
                    break;
                }
                case 275: {
                    this.runTimer(wParam);
                }
            }
        }
        return OS.DefWindowProc(hwnd, msg, wParam, lParam);
    }

    static String withCrLf(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        int i = string.indexOf(10, 0);
        if (i == -1) {
            return string;
        }
        if (i > 0 && string.charAt(i - 1) == '\r') {
            return string;
        }
        ++i;
        int count = 1;
        while (i < length) {
            if ((i = string.indexOf(10, i)) == -1) break;
            ++count;
            ++i;
        }
        i = 0;
        StringBuffer result = new StringBuffer(count += length);
        while (i < length) {
            int j = string.indexOf(10, i);
            if (j == -1) {
                j = length;
            }
            result.append(string.substring(i, j));
            i = j;
            if (i >= length) continue;
            result.append("\r\n");
            ++i;
        }
        return result.toString();
    }
}

