/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMREBARCHEVRON;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.REBARBANDINFO;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;

public class CoolBar
extends Composite {
    CoolItem[] items;
    CoolItem[] originalItems;
    boolean locked;
    static final int ReBarProc;
    static final TCHAR ReBarClass;
    static final int MAX_WIDTH = Short.MAX_VALUE;

    static {
        ReBarClass = new TCHAR(0, "ReBarWindow32", true);
        INITCOMMONCONTROLSEX icex = new INITCOMMONCONTROLSEX();
        icex.dwSize = 8;
        icex.dwICC = 1024;
        OS.InitCommonControlsEx(icex);
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, ReBarClass, lpWndClass);
        ReBarProc = lpWndClass.lpfnWndProc;
    }

    public CoolBar(Composite parent, int style) {
        super(parent, CoolBar.checkStyle(style));
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ReBarProc, this.handle, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        return (style |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int rowWidth = 0;
        int height = 0;
        int rowHeight = 0;
        RECT rect = new RECT();
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 545;
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i, rbBand);
            OS.SendMessage(this.handle, 1058, i, rect);
            if ((rbBand.fStyle & 1) != 0) {
                width = Math.max(width, rowWidth);
                height += rowHeight;
                rowHeight = 0;
                rowWidth = 0;
            }
            rowWidth += rbBand.cxIdeal + rect.left + rect.right + 2;
            rowHeight = Math.max(rowHeight, rbBand.cyMinChild + rect.top + rect.bottom);
            ++i;
        }
        width = Math.max(width, rowWidth);
        height += rowHeight - rect.top - rect.bottom;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFEFFF;
        int hFont = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, hFont, 0);
    }

    void createItem(CoolItem item, int index) {
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            CoolItem[] newItems = new CoolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        int hHeap = OS.GetProcessHeap();
        int lpText = OS.HeapAlloc(hHeap, 8, TCHAR.sizeof);
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 261;
        rbBand.fStyle = 192;
        if ((item.style & 4) != 0) {
            rbBand.fStyle |= 0x200;
        }
        rbBand.lpText = lpText;
        rbBand.wID = id;
        int lastIndex = this.getLastIndexOfRow(index - 1);
        if (index == lastIndex + 1) {
            this.resizeToPreferredWidth(lastIndex);
            rbBand.fMask |= 0x40;
            rbBand.cx = Short.MAX_VALUE;
        }
        if (OS.SendMessage(this.handle, OS.RB_INSERTBAND, index, rbBand) == 0) {
            this.error(14);
        }
        OS.HeapFree(hHeap, 0, lpText);
        item.id = id;
        this.items[item.id] = item;
        int length = this.originalItems.length;
        CoolItem[] newOriginals = new CoolItem[length + 1];
        System.arraycopy(this.originalItems, 0, newOriginals, 0, index);
        System.arraycopy(this.originalItems, index, newOriginals, index + 1, length - index);
        newOriginals[index] = item;
        this.originalItems = newOriginals;
    }

    void createWidget() {
        super.createWidget();
        this.items = new CoolItem[4];
        this.originalItems = new CoolItem[0];
    }

    void destroyItem(CoolItem item) {
        boolean wasVisible;
        int index = OS.SendMessage(this.handle, 1040, item.id, 0);
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        if (count != 0) {
            int lastIndex = this.getLastIndexOfRow(index);
            if (index == lastIndex) {
                this.resizeToMaximumWidth(lastIndex - 1);
            } else if (index != 0) {
                REBARBANDINFO rbBand = new REBARBANDINFO();
                rbBand.cbSize = REBARBANDINFO.sizeof;
                rbBand.fMask = 1;
                OS.SendMessage(this.handle, OS.RB_GETBANDINFO, index, rbBand);
                if ((rbBand.fStyle & 1) != 0) {
                    this.resizeToPreferredWidth(index - 1);
                }
            }
        }
        Control control = item.control;
        boolean wasWrap = item.getWrap();
        boolean bl = wasVisible = control != null && !control.isDisposed() && control.getVisible();
        if (OS.SendMessage(this.handle, 1026, index, 0) == 0) {
            this.error(15);
        }
        this.items[item.id] = null;
        item.id = -1;
        index = 0;
        while (index < this.originalItems.length) {
            if (this.originalItems[index] == item) break;
            ++index;
        }
        int length = this.originalItems.length - 1;
        CoolItem[] newOriginals = new CoolItem[length];
        System.arraycopy(this.originalItems, 0, newOriginals, 0, index);
        System.arraycopy(this.originalItems, index + 1, newOriginals, index, length - index);
        this.originalItems = newOriginals;
        if (wasWrap && index >= 0 && index < this.getItemCount()) {
            this.getItem(index).setWrap(true);
        }
        if (wasVisible) {
            control.setVisible(true);
        }
    }

    public CoolItem getItem(int index) {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        if (index < 0 || index >= count) {
            this.error(6);
        }
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 256;
        OS.SendMessage(this.handle, OS.RB_GETBANDINFO, index, rbBand);
        return this.items[rbBand.wID];
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1036, 0, 0);
    }

    public int[] getItemOrder() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        int[] indices = new int[count];
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 256;
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i, rbBand);
            CoolItem item = this.items[rbBand.wID];
            int index = 0;
            while (index < this.originalItems.length) {
                if (this.originalItems[index] == item) break;
                ++index;
            }
            if (index == this.originalItems.length) {
                this.error(8);
            }
            indices[i] = index;
            ++i;
        }
        return indices;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        CoolItem[] result = new CoolItem[count];
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 256;
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i, rbBand);
            result[i] = this.items[rbBand.wID];
            ++i;
        }
        return result;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        Point[] sizes = new Point[count];
        int i = 0;
        while (i < count) {
            RECT rect = new RECT();
            OS.SendMessage(this.handle, 1033, i, rect);
            sizes[i] = new Point(rect.right - rect.left, rect.bottom - rect.top);
            ++i;
        }
        return sizes;
    }

    int getLastIndexOfRow(int index) {
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        if (count == 0) {
            return -1;
        }
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 1;
        int i = index + 1;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i, rbBand);
            if ((rbBand.fStyle & 1) != 0) {
                return i - 1;
            }
            ++i;
        }
        return count - 1;
    }

    public boolean getLocked() {
        this.checkWidget();
        return this.locked;
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        int[] indices = new int[count];
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 1;
        int wrapCount = 0;
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i, rbBand);
            if ((rbBand.fStyle & 1) != 0) {
                indices[wrapCount++] = i;
            }
            ++i;
        }
        int[] answer = new int[wrapCount];
        System.arraycopy(indices, 0, answer, 0, wrapCount);
        return answer;
    }

    public int indexOf(CoolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        return OS.SendMessage(this.handle, 1040, item.id, 0);
    }

    void resizeToPreferredWidth(int index) {
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        if (index < 0 || index >= count) {
            return;
        }
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 512;
        OS.SendMessage(this.handle, OS.RB_GETBANDINFO, index, rbBand);
        RECT rect = new RECT();
        OS.SendMessage(this.handle, 1058, index, rect);
        rbBand.cx = rbBand.cxIdeal + rect.left + rect.right;
        rbBand.fMask = 64;
        OS.SendMessage(this.handle, OS.RB_SETBANDINFO, index, rbBand);
    }

    void resizeToMaximumWidth(int index) {
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 64;
        rbBand.cx = Short.MAX_VALUE;
        OS.SendMessage(this.handle, OS.RB_SETBANDINFO, index, rbBand);
    }

    void releaseWidget() {
        int i = 0;
        while (i < this.items.length) {
            CoolItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.releaseWidget();
            }
            ++i;
        }
        this.items = null;
        super.releaseWidget();
    }

    void setBackgroundPixel(int pixel) {
        if (this.background == pixel) {
            return;
        }
        this.background = pixel;
        if (pixel == -1) {
            pixel = this.defaultBackground();
        }
        OS.SendMessage(this.handle, 1043, 0, pixel);
        this.setItemColors(OS.SendMessage(this.handle, 1046, 0, 0), pixel);
    }

    void setForegroundPixel(int pixel) {
        if (this.foreground == pixel) {
            return;
        }
        this.foreground = pixel;
        if (pixel == -1) {
            pixel = this.defaultForeground();
        }
        OS.SendMessage(this.handle, 1045, 0, pixel);
        this.setItemColors(pixel, OS.SendMessage(this.handle, 1044, 0, 0));
    }

    void setItemColors(int foreColor, int backColor) {
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 2;
        rbBand.clrFore = foreColor;
        rbBand.clrBack = backColor;
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, i, rbBand);
            ++i;
        }
    }

    public void setItemLayout(int[] itemOrder, int[] wrapIndices, Point[] sizes) {
        this.checkWidget();
        this.setItemOrder(itemOrder);
        this.setWrapIndices(wrapIndices);
        this.setItemSizes(sizes);
    }

    void setItemOrder(int[] itemOrder) {
        int itemCount;
        if (itemOrder == null) {
            this.error(4);
        }
        if (itemOrder.length != (itemCount = OS.SendMessage(this.handle, 1036, 0, 0))) {
            this.error(5);
        }
        boolean[] set = new boolean[itemCount];
        int i = 0;
        while (i < itemOrder.length) {
            int index = itemOrder[i];
            if (index < 0 || index >= itemCount) {
                this.error(6);
            }
            if (set[index]) {
                this.error(5);
            }
            set[index] = true;
            ++i;
        }
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        int i2 = 0;
        while (i2 < itemOrder.length) {
            int id = this.originalItems[itemOrder[i2]].id;
            int index = OS.SendMessage(this.handle, 1040, id, 0);
            if (index != i2) {
                int lastItemSrcRow = this.getLastIndexOfRow(index);
                int lastItemDstRow = this.getLastIndexOfRow(i2);
                if (index == lastItemSrcRow) {
                    this.resizeToPreferredWidth(index);
                }
                if (i2 == lastItemDstRow) {
                    this.resizeToPreferredWidth(i2);
                }
                OS.SendMessage(this.handle, 1063, index, i2);
                if (index == lastItemSrcRow && index - 1 >= 0) {
                    this.resizeToMaximumWidth(index - 1);
                }
                if (i2 == lastItemDstRow) {
                    this.resizeToMaximumWidth(i2);
                }
            }
            ++i2;
        }
    }

    void setItemSizes(Point[] sizes) {
        int count;
        if (sizes == null) {
            this.error(4);
        }
        if (sizes.length != (count = OS.SendMessage(this.handle, 1036, 0, 0))) {
            this.error(5);
        }
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 256;
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i, rbBand);
            this.items[rbBand.wID].setSize(sizes[i].x, sizes[i].y);
            ++i;
        }
    }

    public void setLocked(boolean locked) {
        this.checkWidget();
        this.locked = locked;
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 1;
        int i = 0;
        while (i < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i, rbBand);
            rbBand.fStyle = locked ? (rbBand.fStyle |= 0x100) : (rbBand.fStyle &= 0xFFFFFEFF);
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, i, rbBand);
            ++i;
        }
    }

    public void setWrapIndices(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            indices = new int[]{};
        }
        int count = OS.SendMessage(this.handle, 1036, 0, 0);
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= count) {
                this.error(6);
            }
            ++i;
        }
        REBARBANDINFO rbBand = new REBARBANDINFO();
        rbBand.cbSize = REBARBANDINFO.sizeof;
        rbBand.fMask = 1;
        int i2 = 0;
        while (i2 < count) {
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, i2, rbBand);
            if ((rbBand.fStyle & 1) != 0) {
                this.resizeToPreferredWidth(i2 - 1);
                rbBand.fStyle &= 0xFFFFFFFE;
                OS.SendMessage(this.handle, OS.RB_SETBANDINFO, i2, rbBand);
            }
            ++i2;
        }
        this.resizeToMaximumWidth(count - 1);
        i2 = 0;
        while (i2 < indices.length) {
            rbBand.fMask = 1;
            OS.SendMessage(this.handle, OS.RB_GETBANDINFO, indices[i2], rbBand);
            rbBand.fStyle |= 1;
            OS.SendMessage(this.handle, OS.RB_SETBANDINFO, indices[i2], rbBand);
            this.resizeToMaximumWidth(indices[i2] - 1);
            ++i2;
        }
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x40 | 4;
        return bits |= 0x8600;
    }

    TCHAR windowClass() {
        return ReBarClass;
    }

    int windowProc() {
        return ReBarProc;
    }

    LRESULT WM_COMMAND(int wParam, int lParam) {
        LRESULT result = super.WM_COMMAND(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_ERASEBKGND(int wParam, int lParam) {
        this.drawBackground(wParam);
        return null;
    }

    LRESULT WM_NOTIFY(int wParam, int lParam) {
        LRESULT result = super.WM_NOTIFY(wParam, lParam);
        if (result != null) {
            return result;
        }
        return LRESULT.ZERO;
    }

    LRESULT wmNotifyChild(int wParam, int lParam) {
        NMHDR hdr = new NMHDR();
        OS.MoveMemory(hdr, lParam, 12);
        switch (hdr.code) {
            case -831: {
                Point size = this.getSize();
                int border = this.getBorderWidth();
                int height = OS.SendMessage(this.handle, 1051, 0, 0);
                this.setSize(size.x, height + border * 2);
                break;
            }
            case -841: {
                NMREBARCHEVRON lpnm = new NMREBARCHEVRON();
                OS.MoveMemory(lpnm, lParam, NMREBARCHEVRON.sizeof);
                CoolItem child = this.items[lpnm.wID];
                if (child == null) break;
                Event event = new Event();
                event.detail = 4;
                event.x = lpnm.left;
                event.y = lpnm.bottom;
                child.postEvent(13, event);
            }
        }
        return super.wmNotifyChild(wParam, lParam);
    }
}

