/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class FormLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;

    int computeHeight(FormData data) {
        FormAttachment top = data.getTopAttachment();
        FormAttachment bottom = data.getBottomAttachment();
        FormAttachment height = bottom.minus(top);
        if (height.numerator == 0) {
            if (bottom.numerator == 0) {
                return bottom.offset;
            }
            if (bottom.numerator == bottom.denominator) {
                return -top.offset;
            }
            if (bottom.offset <= 0) {
                return -top.offset * top.denominator / bottom.numerator;
            }
            int divider = bottom.denominator - bottom.numerator;
            return bottom.denominator * bottom.offset / divider;
        }
        return height.solveY(data.cacheHeight);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = this.layout(composite, false, 0, 0, 0, 0, flushCache);
        size.x += this.marginWidth * 2;
        size.y += this.marginHeight * 2;
        return size;
    }

    int computeWidth(FormData data) {
        FormAttachment left = data.getLeftAttachment();
        FormAttachment right = data.getRightAttachment();
        FormAttachment width = right.minus(left);
        if (width.numerator == 0) {
            if (right.numerator == 0) {
                return right.offset;
            }
            if (right.numerator == right.denominator) {
                return -left.offset;
            }
            if (right.offset <= 0) {
                return -left.offset * left.denominator / left.numerator;
            }
            int divider = right.denominator - right.numerator;
            return right.denominator * right.offset / divider;
        }
        return width.solveY(data.cacheWidth);
    }

    Point getSize(Control control, boolean flushCache) {
        int wHint = -1;
        int hHint = -1;
        FormData data = (FormData)control.getLayoutData();
        if (data != null) {
            wHint = data.width;
            hHint = data.height;
        }
        return control.computeSize(wHint, hHint, flushCache);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        int x = rect.x + this.marginWidth;
        int y = rect.y + this.marginHeight;
        int width = Math.max(0, rect.width - 2 * this.marginWidth);
        int height = Math.max(0, rect.height - 2 * this.marginHeight);
        this.layout(composite, true, x, y, width, height, flushCache);
    }

    Point layout(Composite composite, boolean move, int x, int y, int width, int height, boolean flushCache) {
        Control child;
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            Point pt = this.getSize(child, false);
            FormData data = (FormData)child.getLayoutData();
            if (data == null) {
                data = new FormData();
                child.setLayoutData(data);
            }
            data.cacheWidth = pt.x;
            data.cacheHeight = pt.y;
            ++i;
        }
        i = 0;
        while (i < children.length) {
            child = children[i];
            FormData data = (FormData)child.getLayoutData();
            if (move) {
                int x1 = data.getLeftAttachment().solveX(width);
                int y1 = data.getTopAttachment().solveX(height);
                int x2 = data.getRightAttachment().solveX(width);
                int y2 = data.getBottomAttachment().solveX(height);
                child.setBounds(x + x1, y + y1, x2 - x1, y2 - y1);
            } else {
                width = Math.max(this.computeWidth(data), width);
                height = Math.max(this.computeHeight(data), height);
            }
            ++i;
        }
        return move ? null : new Point(width, height);
    }
}

