import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.image.*;
import com.sun.image.codec.jpeg.*;

class RemoteMoniterClient extends JFrame implements ActionListener, Runnable{
	private final int port = 9098;
	private BufferedReader in;
	private OutputStream out;	
	private Socket s;
	
	private JButton btnConnect;
	private JTextArea tfView;
	private JScrollPane pane;
	private JLabel lblServer;
	protected JTextField tfIP;
	
	String ip;

	RemoteMoniterClient(){
		super("Ʈ  Ŭ̾Ʈ");
		make();
		
	}

	public void make(){
		Container c = getContentPane();
		c.setLayout(new BorderLayout(5,3));
		
		JPanel pnTop = new JPanel(new FlowLayout());
		lblServer = new JLabel("Server IP: ");
		pnTop.add(lblServer);
		pnTop.add(tfIP = new JTextField("127.0.0.1",10));
		pnTop.add(btnConnect = new JButton("Connect"));
				
		tfView = new JTextArea();
		tfView.setEditable(false);
		pane = new JScrollPane(tfView);

		c.add(pnTop, BorderLayout.NORTH);
		c.add(pane, BorderLayout.CENTER);
		tfIP.addActionListener(this);
		btnConnect.addActionListener(this);

		setSize(350,250);
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation((dim.width - getWidth())/2,(dim.height - getHeight())/2);
		setVisible(true);

		addWindowListener(new WindowAdapter(){
			public void windowClosing(WindowEvent e){
				try{
					if(out != null)
						out.write(("600\n").getBytes());
					else
						dispose();
						System.exit(0);
				}catch(IOException ioe){
					print("Ŭ̾Ʈ ݴ ",ioe.getMessage());
					//System.out.println(ioe.getMessage());
				}
				//System.exit(0);				
			}
		});
		
	}
	
	public void alert(String title, String str){
		JLabel lblStr = new JLabel(str);
		JOptionPane.showMessageDialog(this,lblStr,title,JOptionPane.INFORMATION_MESSAGE);
	}
	
	public void print(String title, String str){
		tfView.append(">> "+title+": " +str+"\n");
	}
	
	public void connect(){
		try{
				ip = tfIP.getText().trim();
				s = new Socket(ip,port);
				in = new BufferedReader(new InputStreamReader(s.getInputStream()));
				out = s.getOutputStream();

				out.write(("100\n").getBytes());
				btnConnect.setEnabled(false);
				System.out.println(""+ip+"   ߽ϴ.");
			}catch(IOException io){
				print(" "," Ǿ ִ! ּҰ ùٸ ȮϽʽÿ");
				//System.out.println(io.getMessage());
				btnConnect.setEnabled(true);
			}
	}
	
	public void actionPerformed(ActionEvent e){
		Object ob = e.getSource();

		if(ob == btnConnect || ob== tfIP){
			connect();
			new Thread(this).start();
		}
	}
	
	public void run(){
		
		boolean flag = true;
		String str;
		while(flag){
			try{
				String msg = in.readLine();
				if(msg == null)	return;

				StringTokenizer st = new StringTokenizer(msg,"|");
				int protocol = Integer.parseInt(st.nextToken());
				
				switch(protocol){
				
					case 100:
						str = st.nextToken();
						print(str,"");
						System.out.println(str);
						break;

					case 200:
						str = st.nextToken();
						print(str,"");
						System.out.println(str);
						new FileSend(this);
						out.write(("200\n").getBytes());
						break;

					case 300:
						str = st.nextToken();
						print(str,"");
						out.write(("300| ǻ͸ α׿ ޽ ޾ҽϴ.\nα׿ մϴ!").getBytes());
						Runtime rt1 = Runtime.getRuntime(); 
						rt1.exec( System.getProperty( "user.dir" ) + 
							System.getProperty( "file.separator" ) +"exe"+
							System.getProperty( "file.separator" ) +"LogOff.exe" ); 
						break;

					case 400:
						str = st.nextToken();
						print(str,"");

						out.write(("400| ǻ͸  ޽ ޾ҽϴ.\nḦ մϴ!").getBytes());
						Runtime rt2 = Runtime.getRuntime(); 
						rt2.exec( System.getProperty( "user.dir" ) + 
							System.getProperty( "file.separator" ) +"exe"+
							System.getProperty( "file.separator" ) +"ShutDown.exe" ); 
						break;

					case 500:
						str = st.nextToken();
						print(str,"");
						out.write(("500| ǻ͸  ޽ ޾ҽϴ.\n մϴ!").getBytes());
						Runtime rt3 = Runtime.getRuntime(); 
						rt3.exec( System.getProperty( "user.dir" ) + 
							System.getProperty( "file.separator" ) +"exe"+
							System.getProperty( "file.separator" ) +"ReBoot.exe" ); 
						//System.out.println(str);
						break;
					case 600:
						flag = false;
						
						in.close();
						out.close();
						//s.close();
						dispose();
						System.exit(0);
						break;

					case 700:
						str = st.nextToken();
						print(str,"");
						out.write(("700\n").getBytes());
						break;
					
					case 800:
						String title = st.nextToken();
						str = st.nextToken();
						alert(title,str);
						out.write(("800\n").getBytes());
					default:
						break;
				}


			}catch(IOException io){
				System.out.println(io.getMessage());
				flag = false;
			}
		}
	}
	
	public static void main(String[] args){
		RemoteMoniterClient client = new RemoteMoniterClient();
		
	}
		
}



class FileSend {
	final int port_f =9099;
	//ServerSocket ss_f;
	Socket socket_f;
	boolean fileflag = true;

	File file = new File("shot.jpg");;
	
	FileSend(RemoteMoniterClient client){
		try{
			String ip = client.tfIP.getText();
			socket_f = new Socket(ip,port_f);
			//ss_f = new ServerSocket(port_f);
		}catch(IOException e){
			client.print(" ϻ  Ȯ: ",e.getMessage());
		}
				
		try{
			saveJPEG(file);
			sendImage();
		}catch(IOException e){
			client.print("̹  : ",e.getMessage());
		}
	}
	
	public void sendImage(){
		FileInputStream fis;
		BufferedOutputStream bos;
		int c;
		try{
			fis = new FileInputStream(file);
			bos = new BufferedOutputStream(socket_f.getOutputStream());
			while((c =fis.read()) !=-1){
				bos.write(c);
			}
			bos.flush();
			fis.close();
			bos.close();
		}catch(Exception e){
			System.out.println("Send Image: "+e.getMessage());
		}
		finally{
			file.delete();
		}
	}

	public BufferedImage screenshot(){
		BufferedImage bufferedImage =null;
		try {
			Robot robot = new Robot();	
			Rectangle area = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
			bufferedImage = robot.createScreenCapture(area);
			
		}catch (AWTException e) {}

		return bufferedImage;
	}

	public void saveJPEG( File file ) throws IOException{
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(bos);
		
		encoder.encode(screenshot());
		
		FileOutputStream fos = new FileOutputStream(file);
		bos.writeTo( fos );
		fos.flush();
		fos.close();
	}
}
