
#include "misc.h"
#include "proc.h"

extern SearchBox 	*search_box;
extern bool 	flag_show_thread;	extern int 	flag_thread_ok;

#include "./icon/x1.xpm" 
#include "./icon/x2.xpm" 

#include <QToolTip>
#include <QAction>

#include <stdio.h>
#include <time.h>
#include <errno.h>

//move to Proc.cpp
#include <sys/utsname.h>    // uname 
int get_kernel_version()
{
	int version = 0;
	char *p;
	struct utsname uname_info;
	if(uname (&uname_info)==0)		
	{
	    //printf("sysname =%s \n",uname_info.sysname);
	    if(strcasecmp(uname_info.sysname,"linux")==0)
	    {
			uname_info.release[0];
	    }
		p=uname_info.release;
		char str[32];
	    int major, minor, patch;
	    int result;

        result = sscanf(p, "%d.%d.%d", &major, &minor, &patch);
        if(result < 3) {
			fprintf(stderr, "Qps: can't determine version, read %s \n",	p);
			fprintf(stderr, "please report this bug.\n");
			exit(1);
        }
        version = major * 10000 + minor * 100  + patch;
		//ex) 2.6.17 == 20617 , 2.4.8  == 20408
        //printf("DEBUG: version = %d\n", version);
    } else {
		fprintf(stderr, "Qps: uname() failed. (%d) \n",version);
		fprintf(stderr, "please report this bug.\n");
		exit(1);
    }
	return version;
}

// 300% faster than glibc (by fasthyun@magicn.com) 
int x_atoi(const char *sstr)
{
	register const char *str=sstr;
	register int val=0;
	while(*str)
	{
		val*=10;
		val+=*str-48;
		str++;
	}
	return val;
}

QWidget * getQpsWidget()
{
	QWidgetList list=QApplication::topLevelWidgets();
	for (int i = 0; i < list.size(); ++i) {
		QWidget *w=list.at(i);
     	if (w->objectName() == "qps")
	 		return w;
    }
	return 0;
}


#include <stdarg.h>
/* Read formatted input from S, according to the format string FORMAT.   
  %s %d %ld %u %x %n? %lu %*s %f 
 */
int mini_sscanf (const char *s, const char *format, ...)
{
  	va_list varg;
  	int done; 

	va_start (varg, format);
  //done = __vsscanf (s, format, arg);
  	//va_arg(arg,?)
  	va_end (varg);

  	return done;
}

int vsscanf3(const char *s,const char *fmt, va_list va)
{
    // A simplified vsscanf implementation, 
    // solely for cStatistic::freadvarsf.
    // Only recognizes %s %f,%d, %u, %ld, %lu, %lg and 
    // whitespace. '#' terminates scanning.

	int k=0;
	while (1)
	{
		if (*fmt=='%')
		{
			int n;
			if (fmt[1]=='s')
			{
				k+=sscanf(s,"%s%n",va_arg(va,char *),&n);
				s+=n; fmt+=2;
			}
			else if (fmt[1]=='f')
			{
				k+=sscanf(s,"%f%n",va_arg(va,float*),&n);
				s+=n; fmt+=2;
			}
			else if (fmt[1]=='d')
			{
				k+=sscanf(s,"%d%n",va_arg(va,int*),&n);
				s+=n; fmt+=2;
			}
			else if (fmt[1]=='u')
			{
				k+=sscanf(s,"%u%n",va_arg(va,int*),&n);
				s+=n; fmt+=2;
			}
			else if (fmt[1]=='l' && fmt[2]=='d')
			{
				k+=sscanf(s,"%ld%n",va_arg(va,long*),&n);
				s+=n; fmt+=3;
			}
			else if (fmt[1]=='l' && fmt[2]=='u')
			{
				k+=sscanf(s,"%lu%n",va_arg(va,long*),&n);
				s+=n; fmt+=3;
			}
			else if (fmt[1]=='l' && fmt[2]=='g')
			{
				k+=sscanf(s,"%lg%n",va_arg(va,double*),&n);
				s+=n; fmt+=3;
			}
			else
			{
			//	system_error("opp_vsscanf: unsupported"" format '%s'",fmt);
				return k;
			}
		}
		else if (isspace(*fmt))
		{
			while (isspace(*s)) s++;
			fmt++;
		}
		else if (*fmt=='\0' || *fmt=='#')
		{
			return k;
		}
		else
		{ 
			//system_error("opp_vsscanf: unexpected ""char in format '%s'",fmt);
			return k;
		}
	}
}

#include <sys/stat.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

// return /proc/* file size 
int fsize(char *fname)
{
	int size=0;
	if(0)
	{
		// !!! important !! not works with [/proc] , because [/proc/*] always zero
		int fd = open(fname, O_RDONLY);
		if(fd < 0) return -1;
		size=lseek(fd,0, SEEK_END);
		printf("size=%d\n",size);
		close(fd);
		return size;
	}
	
	int buf[1024];
	int r;
	int fd = open(fname, O_RDONLY);
	if(fd < 0) return -1;
	do{
		r = read(fd, buf, 1024);
		size+=r;
	//	printf("r_size=%d\n",size);
	} while(r);
	// printf("size=%d\n",size);
	close(fd);
	return size;
}

// sleep for mili seconds
void msleep(long msec)
{
#ifdef LINUX
	timespec req,remain;
	timeval tv;
	req.tv_sec=0;
	req.tv_nsec=msec*1000000;
	//int  	nanosleep(const struct timespec *req, struct timespec *remain)
	/*while (nanosleep(&req, &req))
	{
		if (errno != EINTR)
			break;
	} */

	tv.tv_sec=0;
	tv.tv_usec=msec*1000;                
	select(0,NULL,NULL,NULL,&tv);
	return;
#endif

}

void mem_string(int kbytes, char *buf)
{
	if(kbytes >= 1024) {
		int meg = kbytes >> 10;
		if(meg >= 1024*100)
			sprintf(buf, "%uGb", meg >> 10);
		else
			sprintf(buf, "%uMb", meg);
	} else
		sprintf(buf, "%uKb", kbytes);
}


//DEL
CheckMenu::CheckMenu(QWidget *parent)
          : QMenu(parent)
{}


// ???
CrossBox::CrossBox(const char *text, QWidget *parent)
         : QCheckBox(text, parent)
{
}

void CrossBox::drawButton(QPainter *p)
{ 
	/////	QCheckBox::drawButton(p);
}

TFrame::TFrame(QWidget *parent):QLabel(parent)
//TFrame::TFrame(QWidget *parent):QFrame(parent)
{
	//setAutoFillBackground(false);
	//setGeometry(50,50,100,100);
	text="this is Tframe widget";
//	setAttribute(Qt::WA_OpaquePaintEvent);
//	setFrameShape(QFrame::StyledPanel);
//	setFrameShadow(QFrame::Sunken);
	//setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);
	//setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
	//setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum);
	//setSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
//
 	setStyleSheet(  "QLabel { "    
						//"border-width: 1px; border-style: solid;  border-color: rgb(150,45,100); border-radius: 5px ;"
						"border-width: 1px; border-style: solid;  border-color: rgb(210,50,130); border-radius: 5px ;"
						"background-color : rgba(0,0,0,70%); padding: 3px; color: rgb(0,255,150); }");
	hide();
}

/*
void TFrame::move(int x,int y)
{


} */

void TFrame::showText(QPoint pos,QString str)
{

}

void TFrame::setText(QString str)
{
	if(str.size()==0) 
	{
		hide();
		return;
	}
	show();

	QLabel::setText(str);
	text=str;
	//setFixedSize(w,h);
	//setFixedSize(sizeHint());
	//setMinimumSize(w,h);
	//setFixedSize(minimumSizeHint());
	//resize(minimumSizeHint());
	resize(sizeHint());
	
}

// to avoid ~
void TFrame::draw( QPainter &p )
{
//	if(!isVisible()) 	return;
	return;	
	int h=fontMetrics ().height() + 3;
	int w=fontMetrics ().width(text) + 9;
	setFixedSize(w,h);
//	QFont font("Adobe Helvetica"); // helvetica & No-Antialias
// 	font.setPixelSize(10);
//	setFont(font);
//	p.drawRoundRect(rect(),10,10);
//	p.fillRect ( cr,QColor(0,0,0));
	QColor bg=QColor(0,0,0,120);
#if QT_VERSION < 0x040400 	
	p.fillRect(rect(),QColor(0,0,0,120));
#else
	//p.fillRect(rect(),QColor(0,0,0,90));
  	
//	p.setPen(QColor(0,255,155)); // less visually obtrusive than black
//	p.setBrush(QBrush(bg));
//	p.drawRoundedRect(0,0,w,h, 4, 4);

	p.fillRect(rect(),bg);

#endif
    
	p.setPen(QColor(0,255,155)); // less visually obtrusive than black
	p.drawText(0, 0,w, h, Qt::AlignVCenter | Qt::AlignHCenter,text);
}


void TFrame::paintEvent(  QPaintEvent * event ) 
{
	QCursor::pos();
//	if(x()+width() >  ) ;
		
//	QFrame::paintEvent(event);
	QLabel::paintEvent(event);
//	QPainter p(this); draw(p);
	 //p.setBackgroundMode (Qt::TransparentMode);
     //p.setRenderHint(QPainter::Antialiasing);
     //painter.translate(width() / 2, height() / 2);
     //painter.scale(side / 200.0, side / 200.0);
	 //
}

UFrame::UFrame(QWidget *parent):QFrame(parent)
//TFrame::TFrame(QWidget *parent):QFrame(parent)
{
//	setAttribute(Qt::WA_OpaquePaintEvent);
//	setFrameShape(QFrame::StyledPanel);
//	setFrameShadow(QFrame::Sunken);
//	setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);
 	setStyleSheet(  "QLabel { "    
						//"border-width: 1px; border-style: solid;  border-color: rgb(150,45,100); border-radius: 5px ;"
						"border-width: 1px; border-style: solid;  border-color: rgb(210,50,130); border-radius: 5px ;"
						"background-color : rgba(0,0,0,70%); padding: 3px; color: rgb(0,255,150); }");
	hide();
		
	QVBoxLayout *vlayout = new QVBoxLayout;
	QLabel *label=new QLabel("title");	
	vlayout->addWidget(label);
	
	setLayout(vlayout);
	QWidget *qps=getQpsWidget();
	if(qps)
	{
		int w=qps->width();
		int h= qps->height();
		printf("qps w=%d h=%d\n",qps->width(),qps->height());
		move(w/2,h/2);
	}

}

void UFrame::setTitle(QString str)
{
//	QLabel::setText(str);
	title=str;
}


void UFrame::paintEvent(  QPaintEvent * event ) 
{

}
/*
//void SearchBox::event_cursor_moved(QMouseEvent *e)
{
	move(e->x(),e->y());
	//printf("xxxxxxxxxxxxxk\n");
}

*/

QPixmap *letters;
int pf_height=9;
int pf_width=6;

void init_xpm()
{
	letters=new QPixmap(":/icon/letters.png");
	pf_height=9;
	pf_width=6;
}

void init_misc(QWidget *main)
{


}


int  pf_str_width(char *str)
{
	int len;
	len=strlen(str)*pf_width;
	return len;
}
int  pf_char_height()
{
	return pf_height;
}

int pf_write(QPainter *p,int x,int y,const char *str)
{
	int i,len,n;
	int ch;
	int sx,sy;
	int x0=x;
	len=strlen(str);
	for(i=0;i<len;i++)
	{
		ch=str[i];
		
		if(ch=='\n')
		{
			//y+=pf_height;
			continue;
		}
		//if(ch>96) ch-=(97-65);
		n=ch-32;		
		p->drawPixmap ( x ,  y, *letters, n*pf_width , 0 , pf_width+1, pf_height);
		x+=pf_width;
	}
	return x-x0;
}


QPixmap *x1,*x2;
XButton::XButton(QWidget *parent):QAbstractButton(parent)
{
	setFocusPolicy(Qt::NoFocus);
	x1=new QPixmap( (const char**)x1_xpm);
	x2=new QPixmap( (const char**)x2_xpm);
	int w=x1->width();
	setGeometry(0,0,w,w);
}


void XButton::resizeEvent(QResizeEvent *p)
{
	int i,h;
	i=height()%2;

	if(i!=0)
		h=height()+1;
	else h=height();	
	setFixedSize(h,h);
}

void XButton::paintEvent(  QPaintEvent * event ) 
{ 
	QPainter p(this);
	int w,h,m;

	if(isDown())
		p.drawPixmap(0,0,*x2);	
	else	p.drawPixmap(0,0,*x1);

	return;
}

//DRAFT
void Qt_make_shadow(QPixmap *pix)
{
	QPixmap tp=pix->scaled(19,18);
//	QBitmap QPixmap::createMaskFromColor ( const QColor & maskColor, Qt::MaskMode mode ) ;
//	QBitmap mask;
//	mask=tp.createMaskFromColor(QColor(0,0,0),Qt::MaskOutColor); // mask which color trasparent.
}

SearchBox::SearchBox(QWidget *parent):QLineEdit(parent)
{
	setToolTip("PID,COMMAND,USER..." );
	left_time=0;
	setMaximumWidth (300) ;
	setMinimumWidth (250) ;
//	setContentsMargins(0,3,1,0);
//	setLineWidth( 1 );
//	setMargin(2);
	xb=new XButton(this);
	connect(xb, SIGNAL(clicked()), SLOT(event_xbutton_clicked()));
	setFocus (Qt::ActiveWindowFocusReason  ); //good
}

void SearchBox::event_cursor_moved(QMouseEvent *e)
{
	move(e->x(),e->y());
}

void SearchBox::resizeEvent(QResizeEvent *p)
{
	int w,h,margin;
	//setMinimumHeight(height()-4);
	//setMaximumHeight(p->size().height()-1);
	//setFixedHeight(p->size().height()-5);
	//setMaximumHeight(height()-2);
	w=width();
	h=height();
	margin=(h - xb->width())/2;
	xb->move(w-h+margin-1,margin);
	return;	
}

void SearchBox::event_xbutton_clicked()
{
	QKeyEvent ke(QEvent::KeyPress,Qt::Key_Escape,0 ); // temp..
	keyPressEvent (&ke );
}

//public
/*void SearchBox::keyPress( QKeyEvent * e )
{

} */

void SearchBox::timerEvent( QTimerEvent *e )
{
 //       qDebug( "timer event, id %d", e->timerId() );
}

LogBox::LogBox( QWidget *p):QLabel(p)
{
	text=new QTextEdit(p);
	text->setFocusPolicy(Qt::NoFocus);
}

// Location: bottom
StatusBar::StatusBar(QWidget *parent)  : QStatusBar(parent)
{
	setSizeGripEnabled (true);
//	QWidget *le = new QLabel(this);//QButton *button = new QButton(this);
//	QLineEdit *le=new QLineEdit(this);


//	showMessage ( const QString & message, int timeout = 0 )	
//	showMessage("aaaaaa");
	label = new QLabel(this);//QButton *button = new QButton(this);
	//label->setText ("") ;
	label->setFrameShape(QFrame::NoFrame);
	//label->setFrameShape (QFrame::StyledPanel);
	//label->setFrameShape (QFrame::Panel);
	//label->setFrameShape (QFrame::WinPanel);
	//label->setFrameShadow(QFrame::Sunken);
//	button2 = new QToolButton(this);//QButton *button = new QButton(this);
//	button2->setTextLabel ("") ;
//	button2->setUsesTextLabel ( true );
//	button2->setAutoRaise(true); 
//	button3 = new QLabel(this);//QButton *button = new QButton(this);
//	button3->setText ("") ;
//	addPermanentWidget(label);
	addWidget(label);
//	addPermanentWidget(le,1);
}

void StatusBar::refresh()
{

}

extern	int num_opened_files;
void StatusBar::update(int total_n)
{
	QString str;
	int 	x=0;
	label->setText("Process count: " + str.setNum(total_n) ) ;
//	button2->setTextLabel ("Network Process(testing): "+ str.setNum(Procinfo::num_network_process));
//	button3->setText ("Opened files : "+ str.setNum(num_opened_files));
}

#include <QHBoxLayout> 

// Pstable or Procview 
// Location : 
ControlBar::ControlBar(QWidget *parent)  : QFrame(parent)
{
	int h;
	
//	setFrameStyle(Panel | Raised);
	setFrameStyle(Panel ); // better 
	layout = new QHBoxLayout(this);
	layout->addSpacing(4);
	layout->setMargin(0);

//	setStyleSheet(" QFrame,QCheckBox,QRadioButton { color: rgb(244, 244, 244);\
	border-image: url(:/icon/vista.png); } "); 
  /*  Frame { background-color: yellow } 
   *  border: 2px solid #8f8f91;
   min-width: 80px; */
	/* image: url(:/icon/vista.png);*/

	b_linear = new QRadioButton("Linear", this);
	b_linear->setFocusPolicy(Qt::NoFocus);

	b_tree = new QRadioButton("Tree", this);
	b_tree->setFocusPolicy(Qt::NoFocus);

	search_box=new SearchBox(this);
	connect(b_linear, SIGNAL(clicked()), SLOT(linear_clicked()));
	connect(b_tree, SIGNAL(clicked()), SLOT(tree_clicked()));
	connect(search_box, SIGNAL(textChanged ( const QString & ) ), SLOT(event_search_box_changed()));
	//search_box->setFocusPolicy(Qt::NoFocus);
	//search_box->setFocus (Qt::ActiveWindowFocusReason);
	//search_box->setFocusProxy ( parent );
	
	view=new QComboBox(this);
	view->insertItem(0,"All Processes", Procview::ALL);
	view->insertItem(1,"Your Processes", Procview::OWNED);
	view->insertItem(2,"Non-Root Processes", Procview::NROOT );
	view->insertItem(3,"Running Processes", Procview::RUNNING);
	connect(view, SIGNAL(activated( int ) ), SLOT(view_changed(int)));
	view->setFocusPolicy(Qt::NoFocus);
	//PAUSED view->insertItem("Hidden Processes", Procview::HIDDEN);

	layout->addWidget( b_linear);
	layout->addWidget( b_tree);
	if(flag_thread_ok){
		check_thread=new QCheckBox ("Thread",this);
		check_thread->setFocusPolicy(Qt::NoFocus);
		connect(check_thread, SIGNAL(clicked()), SLOT(show_thread_clicked()));
		check_thread->setChecked (flag_show_thread) ;
		layout->addWidget(check_thread);
	}
	layout->addWidget( search_box);
	layout->addWidget( view);
	layout->addStretch();
	


	/*
	QPushButton *mb=new QPushButton;
	mb->setContentsMargins(0,0,0,0);
	//mb->setDown(true);
	mb->setCheckable(true);
	mb->setText("pause");
	mb->setFixedWidth(32);
	mb->setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Minimum);
	layout->addWidget(mb);
	*/

     pauseButton = new QToolButton;
     //QPushButton *pauseButton = new QPushButton;
     pauseButton->setCheckable(true);
     pauseButton->setIcon(QIcon(":/icon/pause.png"));
     pauseButton->setIconSize(QSize(19,19));
     pauseButton->setToolTip(tr("Pause (Ctrl+Space)"));
	 pauseButton->setFocusPolicy(Qt::NoFocus);
	 //pauseButton->setFlat(true);
	 pauseButton->setAutoRaise(true);
	 layout->addWidget(pauseButton);
	 connect(pauseButton, SIGNAL(clicked(bool)), SLOT(setPaused(bool)));
	
	 setLayout(layout);
}


void PSTABLE_SETTREEMODE(bool mode);
void ControlBar::setMode(bool treemode) // just.. interface function
{
	b_linear->setChecked(!treemode);
	b_tree->setChecked(treemode);
	
	PSTABLE_SETTREEMODE(treemode);	//	pstable->setTreeMode(treemode);
}

void ControlBar::view_changed(int idx)
{
	QAction act(this);
	act.setData(QVariant(idx));
	emit viewChange(&act);
}

extern bool flag_refresh;
void ControlBar::setPaused(bool b)
{
	flag_refresh=!b;
//	if(!pauseButton->isDown()) pauseButton->setDown(true);
}

void ControlBar::linear_clicked()
{
	setMode(FALSE); 
//	emit modeChange(FALSE);
}

void ControlBar::tree_clicked()
{
	setMode(TRUE);
//	emit modeChange(TRUE);
}

void ControlBar::show_thread_clicked()
{
	flag_show_thread=check_thread->isChecked ();
	emit need_refresh();
}

void ControlBar::event_search_box_changed()
{
	//printf("search_box changed!\n");
}

void ControlBar::event_command_pressed()
{
	//printf("command!\n");
}

void ControlBar::update_bar() // trick for Command 
{
//	resize(width()-1,height());
//	resize(width()+1,height());
}

// called after resize()
// simplified by fasthyun@magicn.com
/* 
void ControlBar::resizeEvent(QResizeEvent *r)
{
	int i,w,h;
	int x;

	return;	
	setMaximumHeight (b_tree->sizeHint().height()+2);
	search_box->setMaximumHeight(height()-4);
	//search_box->setMinimumHeight(height()-5);
	
	for(i=0;i< commands.size();i++)
	{
		QToolButton *b;
		b=commands[i]->toolbutton;
		if(commands[i]->toolbar==true)
		{
			if (layout->findWidget(b)<0)
				layout->addWidget(b);
			b->show();
		}
		else 
			if(b!=NULL)
				b->hide();
	}

} */

