// infobar.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

// 13,245,200
#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include <QBitmap>
#include "infobar.h"
#include "proc.h"
#include "qps.h"
#include "misc.h"

//#define SIMUL
extern 	ControlBar 	*controlbar;
extern	TFrame 		*infobox;  // testing
extern	Qps 		*qps;  // testing
float cpu_total=0;
float cpu_idle=0;
float cpu_used=0;

QMenu *m_popup ;
CPUbar	*cpubar=0; // extra CPU_window 
//#define SIMUL

// ============================ 
gwidget *x_cpu;
gwidget *x_mem;
gwidget *x_swap;
gwidget *x_utime;
gwidget *x_load_avg;


void Infobar::hideEvent( QHideEvent * event ) 
{
	//printf("Infobar::hideEvent()\n");
	cpubar->hide();
}

// return true if the swap meter is redlined
bool Infobar::swaplim_exceeded()
{
	if(Qps::swaplim_percent) {
		if(Proc::swap_total > 0) {
			int free_p = 100 * Proc::swap_free / Proc::swap_total;
			return free_p < Qps::swaplimit;
		} else
			return FALSE;
	} else {
		return Proc::swap_free < Qps::swaplimit;
	}
}

char rotate_str[]="|/-\\|/-\\";
int rotate_idx=0;
char rotate_char='|';
// refresh status bar; if step_load is true, add a point to the load graph
void Infobar::refresh()
{
	QString s;
   

	if(rotate_str[++rotate_idx]==0)	rotate_idx=0;
	rotate_char=rotate_str[rotate_idx];

	
	if(Qps::show_load_graph) 
		update();
		
}

// public 
// called by  Qps::refresh()
void Infobar::update_load()
{	
	// Add current load (the 1 min average) as a data point
	//add_history_point((unsigned)(Procinfo::loadavg[0] * history_scale));//
	//add_history_point2(cpu_used);
	if (Proc::dt_total != 0) 
		add_history_point((unsigned)(Proc::dt_user* history_scale/Proc::dt_total));

	// NEED SOLUTION!!!!!!!!
  	//if(isVisible())
		drawPixmap();
}

void Infobar::drawPixmap()
{
//	if(isVisible()==false) return;
	if(size()!=pixmap.size())
	{
		///printf("icon_pm changed!!\n");
		pixmap=QPixmap(size()); //pm.resize(w, h);
		pixmap.setMask(QBitmap());	// clear the mask for drawing
	} 
	QPainter p(&pixmap);
	//p.fill(Qt::black);
	p.fillRect(rect(),QBrush(Qt::black));
	
	for(int i=0;i<wlist.size();i++)
		wlist[i]->draw(&p);
	
	make_graph(width(), height(),&p);
}

// if p, then show A and hide B; otherwise do the opposite
void Infobar::showup()
{
	if(cpubar->isVisible())
		cpubar->raise();
}

//DEL?
void Infobar::show_and_hide(bool p, QWidget *a, QWidget *b)
{
	if(!p) {
		QWidget *c = a;
		a = b;
		b = c;
	}
	if(!a->isVisible()) {
		b->hide();
		a->show();
	}
}



#define TOTAL_BAR 50
QColor total_color;
QColor part1_color;
QColor part2_color;
QColor part3_color;
// DRAFT CODE : DRAFT CODE : DRAFT CODE : DRAFT CODE :  DRAFT CODE !!
// return width
int drawSPECTRUM(QPainter *p,int x,int y,char *name,
		int total, int part1,int part2=0,int part3=0,int h=0) 
{
	int total_width;
	//bluelay  0,180,255 
	//Move to Infor::Inforbar()
	total_color.setRgb(0,67,75);
	part1_color.setRgb(0,255,210);
	part2_color.setRgb(0,220,175);
	part3_color.setRgb(0,180,150);

	int i,w;
	int tx,ty,bar_xoffset,bar_h;
	int bar;
	
	char buff[32]="NO";
	
	if(total==0){
		name=strcat(buff,name);
	}
	
	if(h==0)
		h=pf_char_height();
	
	w=2+pf_write(p,x+2,y+2,name)+3;
	bar_xoffset= x + w ;

	if(total==0) 
		return w; //**

	// draw total_null line
	bar_h=h-1;
	ty=y+2;
	tx=0;
	p->setPen(total_color);
	for(i=0; i < TOTAL_BAR; i++)	
	{	
		p->drawLine(bar_xoffset+tx,ty,bar_xoffset+tx,ty+bar_h);
		tx++;
		tx++;
	}
	total_width = w+ tx;

	if (total==0) total=1;
	tx=0;
	// draw part1 
	p->setPen(part1_color);
	bar=part1*TOTAL_BAR/total;
	if(bar==0 and part1!=0 ) bar=1;
	for(i=0; i < bar ; i++ )
	{	
		p->drawLine(bar_xoffset+tx,ty,bar_xoffset+tx,ty+bar_h);
		tx+=2;
		//tx++;
	}

	if( part2 >= 0 )
	{
		p->setPen(part2_color);
		bar=part2*TOTAL_BAR/total;
		if(bar==0 and part2!=0 ) bar=1;
		for(i=0; i < bar ; i++ )
		{	
			p->drawLine(bar_xoffset+tx,ty,bar_xoffset+tx,ty+bar_h);
			tx+=2;
			//tx++;
		}
	}
	if( part3 >= 0 )
	{
		p->setPen(part3_color);
		bar=part3*(TOTAL_BAR)/total;
		for(i=0; i < bar ; i++ )
		{	
			p->drawLine(bar_xoffset+tx,ty,bar_xoffset+tx,ty+bar_h);
			tx+=2;
		}
	}
	// this occured by reporter. 
	// if(tx>TOTAL_BAR*2 ) printf("Error: %s total =%d, part1=%d, part2=%d part3=%d\n",name,total,part1,part2,part3);
	return total_width;
}

char 	str_buff[512];
class w_cpu: public gwidget
{
	private:
		int cpu_n;
		unsigned long total, user, system, idle,nice, wait;

	public:
	virtual void draw(QPainter *p)
	{
		x=0;
		char buff[32];
		int cpu_id;
		int cpu_n;
		int graph_height=10;
		int w;

		user=0, system=0, idle=0,nice=0, wait=0;
		
		//if(Proc::num_cpus>=4) // temporaly... 
		//else 
        cpu_n=Proc::num_cpus;
 
//#define SIMUL
#ifdef SIMUL
		cpu_n=2;
#endif
 		width=0;
		//if(cpubar->isVisible() and cpu_n>3)  
		if(true)  
		{
#define TIMEDIFF(kind) (Proc::cpu_times(cpu_id, Proc::kind) - Proc::old_cpu_times(cpu_id, Proc::kind))
				// show Total CPU 
			#ifdef SIMUL
				cpu_id=0;
			#else
				cpu_id=cpu_n;
			#endif
				user = TIMEDIFF(CPUTIME_USER);
#ifdef LINUX
				nice = TIMEDIFF(CPUTIME_NICE);
#endif
				system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = TIMEDIFF(CPUTIME_WAIT);
#endif
				idle = TIMEDIFF(CPUTIME_IDLE);
#undef TIMEDIFF
				total=user+system+wait+nice+idle;
				width=drawSPECTRUM(p,0,0,"CPU",total,user,system,nice,graph_height-1);
				
		}

#ifdef SIMUL
#define TIMEDIFF(kind) (Proc::cpu_times(0, Proc::kind) - Proc::old_cpu_times(0, Proc::kind))
#else
#define TIMEDIFF(kind) (Proc::cpu_times(cpu_id, Proc::kind) - Proc::old_cpu_times(cpu_id, Proc::kind))
#endif

		for(cpu_id = 0; cpu_id < cpu_n; cpu_id++) {

			if(Proc::num_cpus == Proc::old_num_cpus) {
				user = TIMEDIFF(CPUTIME_USER);
#ifdef LINUX
				nice = TIMEDIFF(CPUTIME_NICE);
#endif
				system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = TIMEDIFF(CPUTIME_WAIT);
#endif
				idle = TIMEDIFF(CPUTIME_IDLE);
#undef TIMEDIFF
			} 
			total=user+system+wait+nice+idle;

			// show only less 2 cpu-s
			if(0 and cpu_n<=2)  
			{
				sprintf(buff,"CPU%d",cpu_id);
//			if(idle<0)
//			printf("xx idle=%d , old =%d \n",Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_IDLE),Procinfo::old_cpu_times(cpu_id, Procinfo::CPUTIME_IDLE));
			//if(total == 1 or total ==0)	printf(":total=%ld user=%ld system=%d wait=%d ,nice=%d idle=%ld\n",total,user,system,wait,nice,idle);
				#ifdef LINUX
				width=drawSPECTRUM(p,0,cpu_id*graph_height,buff,total,user,system,nice,graph_height-1);
				#endif			
				#ifdef SOLARIS
				width=drawSPECTRUM(p,0,cpu_id*10,buff,total,user,system,wait);
				#endif
			}
			
			if(cpu_n>1 and cpu_n<5) // 2~4 
			{
				sprintf(buff,"%d",cpu_id);
//			if(idle<0)
//			printf("xx idle=%d , old =%d \n",Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_IDLE),Procinfo::old_cpu_times(cpu_id, Procinfo::CPUTIME_IDLE));
			//if(total == 1 or total ==0)	printf(":total=%ld user=%ld system=%d wait=%d ,nice=%d idle=%ld\n",total,user,system,wait,nice,idle);
				#ifdef LINUX
				width=drawSPECTRUM(p,4*3 + cpu_id*0,graph_height+ 1 + cpu_id*graph_height - cpu_id*1,buff,total,user,system,nice,graph_height-2);
				#endif
				width+=15;
				
			}
	
		}	
		p->fillRect(0,graph_height+2,4*5+width,graph_height*cpu_n +10,QColor(0,0,0,148));
		height=graph_height * 1;
	}

	virtual char *info()
	{
		char str[80];
		float f_user,f_nice,f_system,f_wait;
	
		f_user=(float)user/total *100;
		f_nice=(float)nice/total *100;
		f_wait=(float)wait/total *100;
		f_system=(float)system/total *100;
#ifdef LINUX
		sprintf(str_buff,"user: %1.1f%%  system:%1.1f%%  nice:%1.1f%% "
			,f_user,f_system,f_nice);
#endif

		return str_buff;
	};

};


class w_mem: public gwidget
{
	private :
		int used;
	public:
	virtual void draw(QPainter *p)
	{
		height=pf_char_height()+4;
		x=x_cpu->xpluswidth()+10;
#ifdef LINUX
		used = Proc::mem_total -  Proc::mem_free - Proc::mem_buffers -Proc::mem_cached;
		width=drawSPECTRUM(p,x,0,"MEM",Proc::mem_total,used, Proc::mem_cached,Proc::mem_buffers);
#endif

#ifdef SOLARIS
		used = Proc::mem_total -  Proc::mem_free;
		width=drawSPECTRUM(p,x,0,"MEM",Proc::mem_total,used);
#endif

	}
	virtual char *info()
	{
		char str[80];

		strcpy(str_buff,"Total: ");
		mem_string(Proc::mem_total,str);
		strcat(str_buff,str);
	
		strcat(str_buff,"  used: ");
		mem_string(used,str);
		strcat(str_buff,str);

#ifdef LINUX
		strcat(str_buff,"  cached: ");
		mem_string(Proc::mem_cached,str);
		strcat(str_buff,str);
		strcat(str_buff,"  buffer: ");
		mem_string(Proc::mem_buffers,str);
		strcat(str_buff,str);
#endif

	
	//	sprintf(str_buff,"Total: %dKb , cache: %dKb , buffer: %dKb",
	//		Proc::mem_total,Proc::mem_cached,Proc::mem_buffers);
		return str_buff;
	};

};

class w_swap: public gwidget
{
	private:
		int used;
	public:
	virtual void draw(QPainter *p)
	{	
		x=x_mem->xpluswidth()+10;
		used=Proc::swap_total-Proc::swap_free;
		width=drawSPECTRUM(p,x,0,"SWAP",Proc::swap_total,used);
		height=pf_char_height()+4;
	}
	virtual char *info()
	{	
		char str[80];
		
		strcpy(str_buff,"Total: ");
		mem_string(Proc::swap_total,str);
		strcat(str_buff,str);
		strcat(str_buff,"  Free: ");
		mem_string(Proc::swap_free,str);
		strcat(str_buff,str);
		strcat(str_buff,"  Used: ");
		mem_string(used,str);
		strcat(str_buff,str);

		//sprintf(str_buff,"Total: %d Kbyte , used %d Kbyte",
		//		Proc::swap_total,Proc::swap_free);
		return str_buff;
	};
};

// DRAFT CODE  !!
int drawUTIME(QPainter *p,int x,int y,long boot_time)
{
	char buff[1024]; 
	//printf("size of long=%d, size of time_t=%d \n",sizeof(long),sizeof(time_t));
	long u = (long)time(NULL) - (long)boot_time;
	int up_days = u / (3600 * 24);
	u %= (3600 * 24);
	int up_hrs = u / 3600;
	u %= 3600;
	int up_mins = u / 60;
	int sec = u % 60;
	if(up_days == 0) {
		if(up_hrs == 0)
			sprintf(buff,"UPTIME %d:%02d", up_mins,sec);
		else
			sprintf(buff,"UPTIME %d:%02d:%02d", up_hrs, up_mins,sec);
	} else
		sprintf(buff,"UPTIME %dDAY%s,%d:%02d:%02d", up_days, (up_days == 1) ? "" : "s", up_hrs, up_mins,sec);
	return pf_write(p,x,y,buff );
}

class w_utime: public gwidget
{
	public:
	virtual void draw(QPainter *p)
	{
		height=pf_char_height()+4;
		x=x_swap->xpluswidth()+10;
		width=drawUTIME(p,x,2,Proc::boot_time);
	}
	virtual char *info()
	{
		return "passed time after system booting";
	};
};

class w_load_avg : public gwidget
{
	virtual void draw(QPainter *p)
	{
		char buff[64];
		//printf("w_load_avg\n");
		//sprintf(buff,"QPS %3.02f%%", Procinfo::loadQps);
		sprintf(buff," 1m:%1.02f 5m:%1.02f 15m:%1.02f",		 
					Proc::loadavg[0],Proc::loadavg[1], Proc::loadavg[2]);

		width=pf_str_width(buff);

		x=parent->width()-width-6;
		
		int w=x_utime->xpluswidth()+15;
		if (x<w)
			x=w;
		
		pf_write(p,x,2,buff);

		//
		x=parent->width()-8;
		y=parent->height()-9;

		char str[2]={0,0};
		str[0]=rotate_char;
		pf_write(p,x,y,str);

	}
	virtual char *info()
	{
		return "Average CPU%% each 1, 5 ,15 minutes";
	};

};

Infobar::Infobar(QWidget *parent,Procview *pv): QFrame(parent)
{
	procview=pv;
	official_hegiht=50;

	{
	npoints=0,peak=0,h_index=0, dirty=true;
	//setCursor ( QCursor(Qt::CrossCursor) ) ;
	hist_size=1280;
	history=new float[hist_size];

	// setBackgroundRole (QPalette::WindowText);
	setAutoFillBackground ( false );	
	setAttribute(Qt::WA_OpaquePaintEvent);
	//setFrameShape(QFrame::Panel);
	setFrameShadow(QFrame::Sunken);
	setMinimumHeight(official_hegiht);
	setSizePolicy ( QSizePolicy::Expanding, QSizePolicy::Fixed);
	//setStyleSheet("QFrame { background-color: yellow }");	
	x_cpu=new w_cpu();
	x_cpu->setParent(this);
	x_mem=new w_mem();
	x_mem->setParent(this);
	x_swap=new w_swap();
	x_swap->setParent(this);
	x_utime=new w_utime();
	x_utime->setParent(this);
	x_load_avg=new w_load_avg();	
	x_load_avg->setParent(this);
	
	wlist.append(x_cpu);
	wlist.append(x_mem);
	wlist.append(x_swap);
	wlist.append(x_utime);
	wlist.append(x_load_avg);
	
	QWidget::setMouseTracking(true);
}
	int i = 0;
	//is_vertical = Qps::vertical_cpu_bar; //DEL 
	

	cpubar=new CPUbar(parent);	
	
    if(0 and Proc::num_cpus>4)
	{	
		// useless
		//printf("num_cpus=%d",Proc::num_cpus);
		//cpubar->setWindowTitle("ddd");
		//cpubar->setMinimumSize(100,200);
		cpubar->setFixedSize(114,11*Proc::num_cpus+12);
		//cpubar->setFixedSize(114,10*8+14);
	//	QPoint p=window()->pos();
	//	cpubar->move(p.x()-119,p.y() + pos().y());
		cpubar->show();	
	}
	else 
		cpubar->hide();
	
	m_popup = new QMenu("popup",this);
	QAction *act=new QAction("Under Development",this);
	act->setDisabled(true);
	m_popup->addAction(act);

}

Infobar::~Infobar()
{
	delete[] history;
}

// old style : relative method  
// add value to the history, updating peak.
void Infobar::add_history_point(unsigned int value)
{	
	static unsigned int last_val=0;
	
//	if(value==last_val) return;
	
// simul circular buffer
	history[h_index++] = value; //float 
	if(h_index >= hist_size)
		h_index = 0;
	if(npoints < hist_size)
		npoints++;

	/*
	if(value > peak)
		peak = value;
	else {
		peak = 0;	// no negative values?
		
		//for(int i = 0; i < npoints; i++)
		//	if(history[i] > peak)
				peak = history[i];
	} */
	last_val=value;
}


//BACKUP: add value to the history, updating peak.
void Infobar::add_history_point2(float value)
{
	static float v[3]={0,0,0};
	static float last_val=0;
	
	float f;
	f=last_val-value;
	//if (f > 0)
	//	value+=f/1.15;  // slow up ,slow down
	//else 
		value+=f/1.5;  // slow up ,slow down
	history[h_index++] = value;
	if(h_index >= hist_size)
		h_index = 0;
	if(npoints < hist_size)
		npoints++;
	if(value > peak)
		peak = value;
	else {
		peak = 0;		// no negative values
		for(int i = 0; i < npoints; i++)
			if(history[i] > peak)
				peak = history[i];
	}
	// printf("hist_size=%d h_index=%d  val=%f\n",hist_size,h_index,value);
			
	last_val=value;
}




// return updated pixmap for use as an icon
QPixmap *Infobar::make_icon(int w, int h)
{
	if(w != icon_pm.width() or h != icon_pm.height()) {
		///printf("icon_pm changed!!!!!!!!!!!!!!!!!!11\n");
		icon_pm=QPixmap(w,h); //pm.resize(w, h);
		icon_pm.setMask(QBitmap());	// remove the mask for drawing
	} 
	QPainter pt(&icon_pm);
	pt.fillRect(0,0,w,h,QBrush(Qt::black));
	make_graph(w, h,&pt);
	return &icon_pm;
}

void Infobar::mousePressEvent(QMouseEvent *e)
{
	emit clicked();
	if(e->button()==Qt::RightButton)
		m_popup->popup(e->globalPos());
}

QString testF(Proclist procs)
{
	QString str;
	Procinfo *p;
	int max=0;
	foreach(p,procs)
	{
	//	if(p->command.size()>max)	max=p->command.size();
	}

	if(false and max>0)
	{	
		str+="\n";
		for(int i=0;i<max;i++)
			str+="-";
	}
	
	char buf[128];
	foreach(p,procs)
	{
		if(p->pcpu==0) continue;
		sprintf(buf," (%.02f%%)",p->pcpu);
		str+="\n"+ p->command + QString::fromAscii(buf);
	}
	return str;
}

// only works if mouse cursor in this area 
void Infobar::mouseMoveEvent(QMouseEvent *e)
{
	if(0 and controlbar and controlbar->isVisible())
	{	
		int h=controlbar->height();
		controlbar->hide();
		setMinimumHeight(official_hegiht+h);
	}

	int x=0,y=0;
	int half_height=height()/2;
	int dy;
	int gap;


	px=e->pos().x() ; //pointer x
	py=e->pos().y() ;
	

	dy=py-half_height;
	dy/=2;
	
	//printf("py=%d  y=%d h=%d , dy=%d\n",py,y,height(),dy);
	//gap=infobox->width() + px  - width();
	
	int i;
	int setinfo=0;
	for(i=0;i<wlist.size();i++)
		if(wlist[i]->intersect(px,py)) 
		{
			setinfo=1;
			infobox->setText(wlist[i]->info());
			break;
		}

	
	QString text;
	if(px<npoints) //h_index, npoints
	{	
		text="miniHISTORY alpha";
		
		if(procview) 
		{
			Proclist pl=procview->getHistory(npoints-px);
			text+=testF(pl);
			//printf("procview h_idx=%d px=%d\n",h_index,px);
			
		}
		//	qps->procview->setHistory(npoints-px);
		//	qps->pstable->refresh();
	}
	else 
	{
		text ="";
	}

	if (setinfo==0)
		infobox->setText(text);

	x=8+pos().x();
	
	if(py<13) y=pos().y() - dy;
	else	y=pos().y() - dy;
	
	infobox->move(px+x+5,py+y+6);

}

void Infobar::leaveEvent ( QEvent * ) 
{
//	qps->procview->setHistory(-1);
//	qps->pstable->refresh();
	if(controlbar and controlbar->isHidden())
	{
		controlbar->show();
		setMinimumHeight(official_hegiht);
	}
	infobox->hide();

}


// USING NOW, DRAFT
// draw the load graph on the internal pixmap, if needed
// called by 
// 		1.make_icon(int w, int h)
// 		2.paintEvent()
void Infobar::make_graph(int w, int h,QPainter *p )
{
    //QPainter p(this);
	//p.setBackgroundMode (Qt::OpaqueMode);	p.setBackground(QBrush(Qt::black));
	//p->fillRect(0,0,w,h,QBrush(Qt::black));
	//p->fill(Qt::black);

	int npts = qMin(npoints, w);
	int ofs = h_index - npts;
	if(ofs < 0)
		ofs += hist_size;

	QPolygon pa(npts);  //QVector<> pa(npts);
	
	// make the scale slightly over the peak since a constant load is quite
	// common and makes it hard to see the graph otherwise
	//unsigned int scale =(unsigned int) QMAX(peak + history_scale * 1 / 8 ,history_scale * 9 / 8);
	
	int vh=h;
	if(h==official_hegiht)
	{
		h=h-10;
	}

	float mul = (float)h / history_scale;

	// drawing
	for(int i = 0; i < npts; i++) {
		int j = ofs + i;
		if(j >= hist_size) j -= hist_size; // circular 
		pa[i] = QPoint(i, vh - 1 - (int)(history[j] * mul));
	}
	//draw scale lines
	p->setPen(QColor(0,210,100));	//p.setPen(QColor(0,70,54));
	p->drawPolyline(pa);
	dirty = FALSE;
}


void Infobar::resizeEvent ( QResizeEvent * e )
{
	//static int first=0; if(first==0){	drawPixmap(); first=1;}
	drawPixmap(); 
}
// DRAFT CODE  !!!
void Infobar::paintEvent ( QPaintEvent *e )
{
	//printf("Infobar()\n");
	QRect ur = e->rect();	// update rectangle
    QPainter p(this);
	
	//from update_load()  
	p.drawPixmap(ur,pixmap,ur);
	
	//drww VCursor
	p.setPen(QColor(80,195,80));
	//p.drawLine (px,0,px,height());	


	// cpubar window
	if(cpubar and  Proc::num_cpus>4 )//cpubar->isVisible())
	{
		if(parentWidget()->isVisible())
			cpubar->show();
		else 
			cpubar->hide();

		cpubar->setFixedSize(114,11*Proc::num_cpus+12);
		//cpubar->setFixedSize(114,10*8+14);
		//QPoint p=window()->pos();
		QRect p=window()->geometry();
		cpubar->move(p.x()-119,p.y() + pos().y());
	
		if(cpubar->isVisible())
			cpubar->update();
	}
	
}

CPUbar::CPUbar(QWidget *p): QWidget(p)
{
	parent=p;
	//setWindowFlags(Qt::FramelessWindowHint | Qt::ToolTip);
	setWindowFlags(Qt::FramelessWindowHint |Qt::Tool );
	
//	setParent(p);	
 //Qt::Window 
//	QTabWidget *tbar = new QTabWidget(this);
	setAttribute(Qt::WA_OpaquePaintEvent);
	QPalette pal;
	pal.setColor(QPalette::Window,QColor(0,0,0));
	setPalette(pal);
	QWidget::setMouseTracking(true);
}

void CPUbar::refresh()
{

}

void CPUbar::mousePressEvent(QMouseEvent *e)
{
	m_popup->popup(e->globalPos());
	//hide();
}


// DRAFT CODE  !!!
void CPUbar::paintEvent ( QPaintEvent *e )
{
	//static QPaint *p=// QPainter *p=new QPainter(this);
    QPainter p(this);
	char buff[128];
	int w;
	int width;
	int x,y;
	int i;
	///printf("Infobar()\n");
	//QRect cr = contentsRect();
	//QRect cr = p->viewport();
	QRect cr = p.window(); // rect.
	p.fillRect(cr,QBrush(Qt::black));
	//p.fillRect(cr,QBrush(QColor(255,255,255,50)));

//	for(i=0;i<wlist.size();i++)
//		wlist[i]->draw(&p);
//	p.drawPixmap(cr.x(), cr.y(), pm);

	unsigned long	total=0,user=0, system=0, idle=0,nice=0, wait=0;
		
		//if(Proc::num_cpus>=4) // temporaly... 
		//else 
    int cpu_n=Proc::num_cpus;
    int cpu_id;
	w=2+pf_write(&p,2,2,"SUB CPU");
#ifdef SIMUL
	 cpu_n=4;
#define TIMEDIFF(kind) (Proc::cpu_times(0, Proc::kind) - Proc::old_cpu_times(0, Proc::kind))
#else
#define TIMEDIFF(kind) (Proc::cpu_times(cpu_id, Proc::kind) - Proc::old_cpu_times(cpu_id, Proc::kind))
#endif

		for(cpu_id = 0; cpu_id < cpu_n; cpu_id++) {
			if(Proc::num_cpus == Proc::old_num_cpus) {
				user = TIMEDIFF(CPUTIME_USER);
#ifdef LINUX
				nice = TIMEDIFF(CPUTIME_NICE);
#endif
				system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = TIMEDIFF(CPUTIME_WAIT);
#endif
				idle = TIMEDIFF(CPUTIME_IDLE);
#undef TIMEDIFF
			} else {
				// number of cpus just changed
				// FIXME: this is not enough to support dynamic addition/removal
				// of cpus at runtime; the number of graphs should be dynamic
				// as well.
				user = Proc::cpu_times(cpu_id, Proc::CPUTIME_USER);
#ifdef LINUX
				nice = Proc::cpu_times(cpu_id, Proc::CPUTIME_NICE);
#endif
				system = Proc::cpu_times(cpu_id, Proc::CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = Proc::cpu_times(cpu_id, Proc::CPUTIME_WAIT);
#endif
				idle = Proc::cpu_times(cpu_id, Proc::CPUTIME_IDLE);
			}

			total=user+system+wait+nice+idle;
			int graph_height=10;	
		//	height=graph_height*cpu_n;
			sprintf(buff,"%d",cpu_id);
			#ifdef LINUX
			width=drawSPECTRUM(&p,0,10+cpu_id*graph_height,buff,total,user,system,nice,graph_height-1)+w;
			#endif			
		}

}
