// pstable.cpp 
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

// ** toooo complex,so need new Design ... should be more simple.. (by fasthyun@magicn.com) 

#include <limits.h>

#include "proc.h"
#undef	QHash
#include "pstable.h"
#include "global.h"
#include <qpixmap.h>
#include <qpainter.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <QHeaderView>
#include <QTreeView>
#include <QToolTip>

// MOVE TO Procview
// slot: called when a title is clicked

//void Pstable::set_sortcol() 
//	setSortedCol(i);
void Pstable::setSortColumn(int col)
{

	if(col == sortColumn) {
		procview->reversed = !procview->reversed;
		// if(!procview->treeview) {
			// just reverse the lines
			/*
			int n = procview->procs.size();
			for(int i = 0; i < n / 2; i++) {
				Procinfo *p = procview->linear_procs[i];
				procview->linear_procs[i] = procview->linear_procs[n - 1 - i];
				procview->linear_procs[n - 1 - i] = p;
			} 	*/
	} 
	else 
	{
		procview->reversed = false;
		procview->sortcat = procview->cats[col];
		procview->sort_column = col;
		sortColumn=col;
	}
	setSortedCol(col);	//void HeadedTable::setSortedCol(int col)
	refresh();
}

// sync Procview and HeadedTable
// set sorted column of table to procview->sortcol
void Pstable::set_sortcol() 
{
	for(int i = 0; i < procview->cats.size(); i++)
	{
		if(procview->cats[i] == procview->sortcat) {
			setSortedCol(i);	// HeadedTable
			return;
		}
	}
	setSortedCol(-1);
}


// for Speed Optimize
int Pstable::sizeHintForColumn(int col) const
{
	//int aw=fontMetrics().averageCharWidth();
 	int aw=fontMetrics ().width("0");
	//int title_witdh=fontMetrics().width(procview->cats[col]->name);
 	//static int z5=fontMetrics ().width("00000");
 	//static int z6=fontMetrics ().width("000000");
	int cat_idx=procview->cats[col]->index;
	switch(cat_idx)
	{	
// 	only COMMON Field
//		case F_PID :
		case F_RSS :
		case F_NICE :
		case F_SIZE :
		case F_TIME :
			return aw*6;
		case F_TTY :
		case F_MEM :
		case F_CPU :
			//return aw*7;
			return fontMetrics().width("%MEM")+10;
		case F_WCPU :
			return fontMetrics().width("%WCPU") +10;
			//return aw*4; 
		case F_USER :
		case F_COMM :
//		case F_CMDLINE:	return 300;
		default:
			return -1;
			//return HeadedTable::sizeHintForColumn(col);
			;
	}
	return -1;
}

// inner 
QString Pstable::title(int col)
{
	if(col>=procview->cats.size())
		{
				printf("Qps Bug!: over col !! %d\n",col);
				return "";
		}
	return procview->cats[col]->name;
}

QString Pstable::text(int row, int col)
{
		if(col>=procview->cats.size())
		{
				printf("Qps Bug!: over col !! %d\n",col);
				return "";
		}
	return procview->cats[col]->string(procview->linear_procs[row]);
}

int Pstable::totalRow()
{
	return procview->linear_procs.size();
}

int Pstable::colWidth(int col)
{
	if(col>=procview->cats.size())
		{
				printf("Qps Bug!: over col !! %d\n",col);
				return 0;
		}
///	return 30;
	// this is -1 for variable width fields, htable keeps track of it
	return procview->cats[col]->width();
}

int Pstable::alignment(int col)
{
	//printf("debug:alignment()\n");
	Category *cat = procview->cats[col];
	return cat->alignment();
}



// virtual of HeadedTable 
void Pstable::setSelected(int row, bool sel)
{
///	printf("debug:setSelected()\n");
	Procinfo *pi= procview->linear_procs[row];
	if(pi->selected!=sel)
	{
		pi->selected=sel; 
		body->repaintRow(row);  // TEMP trick..
	}
}

// virtual 
bool Pstable::isSelected(int row) 
{ 
	Procinfo *pi= procview->linear_procs[row];
	return pi->selected; 
}

int Pstable::rowDepth(int row)
{
//	if(row < procview->linear_procs.size())
	Procinfo *pi= procview->linear_procs[row];
	if(pi)
		return pi->level;
	
	printf("Qps bug: over row  %d!!!\n",row);
	return 0;
}

bool Pstable::lastChild(int row)
{
	Procinfo *pi= procview->linear_procs[row];
	if(pi)
		return pi->lastchild;
	printf("Qps bug: over row  %d!!!\n",row);
	return 0;
}

// Segfault !!!!
// return parent PID?
int Pstable::parentRow(int row)
{
	return procview->linear_procs[row]->parent_row;
	/* int ppid= procview->linear_procs[row]->ppid;
	Procinfo *pi= procview->getProcinfoByPID(ppid);
	if(pi) return ppid;
	else return -1; */
}

//DRAFT
QString Pstable::tipText(int col)
{
	Category *cat = procview->cats[col];
	QString s(cat->help);
	
	// trick
	if(cat->index == F_STAT)
		s.append("\n(R =Running, S =Sleeping, T =sTopped, Z=Zombie)");
	if(cat->index == F_PLCY)
		s.append("\n(TS =Time Sharing)");
	if(cat->index == F_RSS);
		//s.append("\nRSS = CODE + DATA + SHARE\n"
		//	   "RSS = TRS  + DRS  + SHARE\n");
		///s.append("\n(RSS = TRS + DRS)");
	if(cat == procview->sortcat)
		s.append(procview->reversed ? "\n(sorted backwards)" : "\n(sorted)");
	return s;
}

void Pstable::showTip(QPoint p,int idx)
{
	static QPoint op;

  	//printf("showTip %d,%d\n",p.x(),p.y());//QToolTip::hideText()	
   // QToolTip::hideText();
   // QToolTip::showText(op, "");
    ///QToolTip::showText(p, procview->cats[idx]->help);
    QToolTip::showText(p, tipText(idx));
	op=p;
}

//DRAFT  who call?
char* Pstable::total_selectedRow(int col)
{
	static char buff[48];
	char mem_str[48];
	char *name;
	int	index;
	
	if(procview->cats.size()<=col or col<0 ) return 0;  // col == -1 
	index=procview->cats[col]->index;

	switch(index)
	{
		case F_SIZE:
			name="total SIZE: ";
			break;
		case F_RSS:
			name="total RSS: ";
			break;
#ifdef LINUX
		case F_TRS:
			name="total Text: ";
			break;
		case F_DRS:
			name="total Data: ";
			break;
		case F_STACK:
			name="total STACK: ";
			break;
#endif
		default:
			return 0;
	}
	
	int total=0;
	int rows = procview->linear_procs.size();
	for(int i = 0; i < rows; i++)
		if(procview->linear_procs[i]->selected)
		{
			switch(index)
			{
				case F_SIZE:
					total+=procview->linear_procs[i]->size;break;
				case F_RSS:
					total+=procview->linear_procs[i]->resident;break;
#ifdef LINUX
				case F_TRS:
					total+=procview->linear_procs[i]->trs;break;
				case F_DRS:
					total+=procview->linear_procs[i]->drs;break;
				case F_STACK:
					total+=procview->linear_procs[i]->stack;break;
#endif			
			}
		}

	mem_string(total,mem_str);
	strcpy(buff,name);
	strcat(buff,mem_str);
	//sprintf(buff,"total:%s",total);
	return buff;
}





//#include <qclipboard.h>

Pstable::Pstable(QWidget *parent,Procview *pv)
	: HeadedTable(parent,	HTBL_ROW_SELECTION
			| HTBL_ROW_DOUBLE_CLICK
			| HTBL_ROW_CONTEXT_MENU
			| HTBL_HEADING_TOOLTIPS
			| HTBL_HEADING_CONTEXT_MENU
			| HTBL_HEADING_CLICK
			| HTBL_REORDER_COLS)
{
	procview=pv;
	sortColumn=-1;
	connect(this, SIGNAL(selectionChanged(const Svec<int> *)),SLOT(selection_update(const Svec<int> *))); //DEL?
	connect(this, SIGNAL(titleClicked(int)), SLOT(setSortColumn(int)));
	connect(this, SIGNAL(foldSubTree(int)), SLOT(subtree_folded(int)));
	
	connect(head,SIGNAL(toolTip(QPoint ,int)),this,SLOT(showTip(QPoint,int)) );
}

// who call this ? : from qps.cpp
void Pstable::setProcview(Procview *pv)
{
	procview = pv;
	// DEL ?set_sortcol();
}

HeadedTable::NodeState Pstable::folded(int row)
{
	Procinfo *p = procview->linear_procs[row];
	///return (p->children && p->children->size() > 0)	? (p->hidekids ? Closed : Open) : Leaf;
	return ( p->children.size() > 0) ? (p->hidekids ? Closed : Open) : Leaf;
	//return p->children->size() ? (p->hidekids ? Closed : Open) : Leaf;
}


// slot: called when selection changes
//	called by 
//		1.void HeadedTable::selectionNotify()
void Pstable::selection_update(const Svec<int> *rows)
{
	//printf("debug:selection_update()\n")
	for(int i = 0; i < rows->size(); i++) {
		int row = (*rows)[i];
		procview->linear_procs[row]->selected = isSelected(row);
	}
	
	qps->update_menu_selection_status();
	if(numSelected() > 0 && qps->pids_to_selection) {
		// set the X11 selection to "PID1 PID2 PID3 ..."
		QString s, num;
		int n = numRows();
		for(int i = 0; i < n; i++) {
			if(isSelected(i)) {
				num.setNum(procview->linear_procs[i]->pid);
				s.append(num);
				if(i < n - 1)
					s.append(" ");
			}
		}

		// important: this mustn't be called non-interactively since Qt uses
		// the selection time of the last mouse or keyboard event
		QApplication::clipboard()->setText(s);
	}

}
// When a subtree is folded away, selections inside it disappear to prevent
// unexpected behaviour
static void clear_subtree_selections(Procinfo *p)
{
	for(int i = 0; i < p->children.size(); i++) {
		Procinfo *c = p->children[i];
		c->selected = FALSE;
		////if(c->children)
			clear_subtree_selections(c);
	}
}

// slot: changes table mode
// call by 
// 	1.void Qps::set_table_mode(bool treemode)
void Pstable::setTreeMode(bool treemode)

{
	/// printf("Pstable setTreeMode\n");
	procview->treeview = treemode;
	procview->fieldArrange();
	set_sortcol();
	HeadedTable::setTreeMode(treemode);  

	// need new sort and new linear tree
	refresh();	// update();
}


bool Pstable::columnMovable(int col)
{
	if(treemode) 
	{
		if(col==0) return false;

	}
	if(procview->cats[col]->index==F_CMDLINE)
		return false;

	return true;
}

// called by HeadedTable
// Description : FIELD movement by mouse drag 
//	 				To place From col
//	virtual HeadedTable::moveCol(col,place);
void Pstable::moveCol(int col, int place) 
{
	//printf("Pstable::moveCol\n");
	procview->moveColumn(col,place);
	set_sortcol() ;
//	update();
	refresh(); // width size changed ,...
	return;
	//updateColWidth(place); updateColWidth(col);// TEMP
	///update_customfield();
}


// NEED Check !!
// Slot: called when a subtree is opened or closed
// row = row number of sheet
void Pstable::subtree_folded(int row)
{
					
	Procinfo *p = procview->linear_procs[row];
	p->hidekids = !p->hidekids;
	
	if(p->hidekids)	
		clear_subtree_selections(p);  // *** important 
	
	refresh();
	return ;	
	// ???
	Procinfo *nextp = (row < numRows() - 1) ? procview->linear_procs[row + 1] : 0;
	if(!p->hidekids) {
		// Show as much as possible of the opened subtree
		int r = row + 1;
		while(r < numRows() && procview->linear_procs[r] != nextp)
			r++;
		setAutoUpdate(FALSE);
		showRange(row, r - 1);
		setAutoUpdate(TRUE);
	}
	// This is a stopgap solution; it would be better to have htable
	// take care of the hiding of subtrees and repaint only the rows under
	// the line hidden
	
}

// DRAFT CODE:
// 1.procview->refresh: proc.refresh, rebuild
// 2.resetwidth
// 3.repaint

// called by 
// 	1.void Qps::refresh()
void Pstable::refresh()
{
	//void HeadedTable::updateCols(int deltacols, int place, bool update)
    //printf("Pstable:refresh()\n");
	procview->refresh();
//	setAutoUpdate(false); 
	setNumRows(procview->linear_procs.size()); 	//1.
	setNumCols(procview->cats.size());  		//2. resetWidths() 
//	setAutoUpdate(true);
	//if(update)	
	//repaintAll(); //	update();
	repaint_changed();
	return;
}


#include "details.h"
// declaration of static members
bool Netable::have_services = FALSE;
QHash<int,char*> Netable::servdict;
//Lookup *Netable::lookup = 0;
/*
TableField Netable::fields[] = {
	{"Fd", 5, 8, Qt::AlignRight, "File descriptor"},
	{"Proto", 4, 8, Qt::AlignLeft, "Protocol (TCP or UDP)"},
	{"Recv-Q", 9, 8, Qt::AlignRight, "Bytes in receive queue"},
	{"Send-Q", 9, 8, Qt::AlignRight, "Bytes in send queue"},
	{"Local Addr", -1, 8, Qt::AlignLeft, "Local IP address"},
	{"Port", 6, 8, Qt::AlignLeft, "Local port"},
	{"Remote Addr", -1, 8, Qt::AlignLeft, "Remote IP address"},
	{"Port", 6, 8, Qt::AlignLeft, "Remote port"},
	{"State", 18, 8, Qt::AlignLeft, "Connection state"}
};
*/
			//| HTBL_REORDER_COLS)

Netable::Netable(QWidget *parent,Procview *pv=0)
	//: HeadedTable(parent)
	: HeadedTable(parent,	HTBL_ROW_SELECTION
					| HTBL_ROW_CONTEXT_MENU 
					| HTBL_ROW_DOUBLE_CLICK
					)
{
	procview=pv;

    doing_lookup=false;		// if table painted with host lookup
//	if(!lookup)
//		lookup = new Lookup();
//	connect(lookup, SIGNAL(resolved(unsigned)),	SLOT(update_hostname(unsigned)));
//	doing_lookup = Qps::hostname_lookup;
//	refresh();
}

Netable::~Netable()
{
}

static const char *tcp_states[] = {
	"ESTABLISHED",		// 1
	"SYN_SENT",
	"SYN_RECV",
	"FIN_WAIT1",
	"FIN_WAIT2",
	"TIME_WAIT",
	"CLOSE",
	"CLOSE_WAIT",
	"LAST_ACK",
	"LISTEN",
	"CLOSING"			// 11
};

static inline const char *tcp_state_name(int st)
{
	return (st < 1 || st > 11) ? "UNKNOWN" : tcp_states[st - 1];
}

QString Netable::title(int col)
{
	QString s;
	switch(col) {
		case COMMAND:
			s="COMMAND";
			break;
		case FD:
			s="FD inode";//s.setNum(sock_ino->fd);
			break;

		case PROTO:
			s = "Protocol";
			break;

		case RECVQ:
			s = "recv q";
			break;

		case SENDQ:
			s = "sendq";
			break;

		case LOCALADDR:
			s = "local";
			break;

		case LOCALPORT:
			s = "localport";
			break;

		case REMOTEADDR:
			s = "remote addr";
			break;

		case REMOTEPORT:
			s = "remote port";
			break;

		case STATE:
			s = "State";
			break;
	}
	return s;
}

int Netable::colWidth(int col)
{
	return 30;
//	return procview->cats[col]->width();
}


QString Netable::text(int row, int col)
{
	QString s="null";
	//return procview->cats[col]->string(procview->linear_procs[row]);
	Sockinfo *si=procview->linear_socks[row];
	if(si==NULL)	return s;

	Procinfo *pi=procview->getProcinfoByPID(si->pid);
	if(pi==NULL) return s;

//	enum {	FD, PROTO, RECVQ, SENDQ, LOCALADDR, LOCALPORT, REMOTEADDR, REMOTEPORT,
//		STATE,	SOCKFIELDS };
	
	//return s.setNum(pid);
	//if(pid<0) 		return s;
	
	
	if(pi)	
	{
		//SockInode *sock_ino = pi->sock_inodes[row];
	// Sockinfo *si = Procinfo::socks[sock_ino->inode];
	}

	switch(col) {
		case COMMAND:
			return pi->command;
			break;

		case FD:
			//s="nnn";//s.setNum(sock_ino->fd);
			s.setNum(si->inode);
			break;

		case PROTO:
			s = (si->proto == Sockinfo::TCP) ? "tcp" : "udp";
			break;

		case RECVQ:
			s.setNum(si->rx_queue);
			break;

		case SENDQ:
			s.setNum(si->tx_queue);
			break;

		case LOCALADDR:
			s = ipAddr(si->local_addr);
			break;

		case LOCALPORT:
			if(Qps::service_lookup)	{
				const char *serv = servname(si->local_port);
				if(serv) {
					s = serv;
					break;
				}
			}
			s.setNum(si->local_port);
			break;

		case REMOTEADDR:
			s = ipAddr(si->rem_addr);
			break;

		case REMOTEPORT:
			if(Qps::service_lookup) {
				const char *serv = servname(si->rem_port);
				if(serv) {
					s = serv;
					break;
				}
			}
			s.setNum(si->rem_port);
			break;

		case STATE:
			s = tcp_state_name(si->st);
			break;
	}
	return s;
}

#include <netdb.h>
#include <netinet/in.h>
QString Netable::ipAddr(unsigned addr)
{
	unsigned a = htonl(addr);
	QString s;
	if(doing_lookup) {
		//s = lookup->hostname(addr);
		if(s.isNull()) {
			s.sprintf("(%d.%d.%d.%d)",
					(a >> 24) & 0xff,
					(a >> 16) & 0xff,
					(a >> 8) & 0xff,
					a & 0xff);
		}
	} else {
		if(a == 0)
			s = "*";
		else
			s.sprintf("%d.%d.%d.%d",
					(a >> 24) & 0xff,
					(a >> 16) & 0xff,
					(a >> 8) & 0xff,
					a & 0xff);
	}
	return s; 
}
//	int rows = p->sock_inodes->size();
///resetWidths();

// FD, PROTO, RECVQ, SENDQ, LOCALADDR, LOCALPORT, REMOTEADDR, REMOTEPORT,
void Netable::refresh()
{
	procview->refresh();
	//int row=Procinfo::socks.size();

	int row=procview->linear_socks.size();
	setNumRows(row);
	setNumCols(SOCKFIELDS);
	Procinfo::read_sockets();
	update();
}

// react to changes in preferences
void Netable::config_change()
{
	if(doing_lookup != Qps::hostname_lookup) {
		doing_lookup = Qps::hostname_lookup;
		////setNumCols(SOCKFIELDS);
		//for(int col = 0; col < SOCKFIELDS; col++)
		//	widthChanged(col);
		////updateTableSize();
		////repaintAll();
	}
}

// slot: called when a host name has been looked up
void Netable::update_hostname(unsigned addr)
{
	//if(widthChanged(REMOTEADDR) || widthChanged(LOCALADDR)) {
	if(1)
	{
	////	updateTableSize();
	///	repaintAll();
	} else 
	{
		// just repaint some rows
/*		Procinfo *p = procinfo();
		if(!p->sock_inodes) {
			Procinfo::read_sockets();
			p->read_fds();
		}
		int rows = p->sock_inodes->size();
		for(int i = 0; i < rows; i++) {
			int inode = (*p->sock_inodes)[i]->inode;
			Sockinfo *si = Procinfo::socks[inode];
			///if(si->local_addr == addr) updateCell(i, LOCALADDR);
			///if(si->rem_addr == addr)	updateCell(i, REMOTEADDR);
*/		
	}
}

const char *Netable::servname(unsigned port)
{

	if(!have_services) {
		have_services = TRUE;
		// fill servdict from /etc/services (just try once)
		setservent(1);
		struct servent *s;
		while((s = getservent()) != 0) {
			unsigned short hport = ntohs((unsigned short)s->s_port);
			if(!servdict.value(hport,NULL)) {
				servdict.insert(hport, strdup(s->s_name));
			}
		}
		endservent();
	}
	return servdict.value(port,NULL);
}

