#include <QtGui>
#include <QSizeGrip>
#include "screenshot.h"
 #include <QStatusBar>

/*
SizeGrip::SizeGrip()
{

	setWindowFlags( Qt::FramelessWindowHint);
} */

QSizeGrip *sg;
int window_width=320;
int window_height=400;

TitleBar::TitleBar()
{
	setWindowFlags( Qt::FramelessWindowHint);
    resize(window_width,32);
}

void TitleBar::mousePressEvent(QMouseEvent *)
{
//	press_pos = e->pos();
//	printf("x=%d y=%d\n",press_pos.x(),press_pos.y());
}

void TitleBar::mouseMoveEvent(QMouseEvent *e)
{
	if(e->buttons()==Qt::LeftButton)  //  Button state )	
	{
		//move(e->globalX()-e->x(), e->globalY()-e->y());// coe->x(),e->y());
//		move(e->globalX() - press_pos.x(), e->globalY()- press_pos.y());// coe->x(),e->y());
//		sg->move(x()-100,y()-100);
	}
}

ShotArea::ShotArea()
{
	setAttribute(Qt::WA_OpaquePaintEvent);
	setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
}

void ShotArea::resizeEvent(QResizeEvent * /* event */)
{
	printf("ShotArea::resizeEvent()\n");
	//QPixmap pixmap = QPixmap(screenshotLabel->size());
//	QPixmap pixmap = QPixmap(size());
//	QPainter painter(&pixmap);
	//painter.fillRect(10, 10, 80, 80, QColor(255,255,255));
//	painter.fillRect(0,0,width(), height(), QColor(255,255,255));
//	setMask(pixmap.createMaskFromColor(QColor(255,255,255), Qt::MaskInColor));
}

void ShotArea::paintEvent ( QPaintEvent * event )
{
	printf("ShotArea::paintEvent\n");
//	QPainter painter(this);
//	painter.fillRect(10, 10, 80, 80, QColor(255,255,255));
}

void ShotArea::mousePressEvent(QMouseEvent *e)
{
	press_pos = e->pos();
	printf("x=%d y=%d\n",press_pos.x(),press_pos.y());
}

void ShotArea::mouseMoveEvent(QMouseEvent *e)
{
	if(e->buttons()==Qt::LeftButton)  //  Button state )	
	{
		//move(e->globalX()-e->x(), e->globalY()-e->y());// coe->x(),e->y());
//		move(e->globalX() - press_pos.x(), e->globalY()- press_pos.y());// coe->x(),e->y());
//		sg->move(x()-100,y()-100);
	}
}

Screenshot::Screenshot(QWidget *p):QWidget(p)
{
//	setAttribute(Qt::WA_OpaquePaintEvent);
//	QWidget *titlebar=	new TitleBar();
	QStatusBar *statusbar=new QStatusBar(this);
	shotarea=new ShotArea();
	setWindowFlags(Qt::WindowStaysOnTopHint);
//	titlebar->show();
	sg=new QSizeGrip(NULL);
//	sg->show();
//	sg->move(100,100);
//	sg=new QSizeGrip(NULL);
//	sg=new QSizeGrip(NULL);
//	sg=new QSizeGrip(NULL);

    screenshotLabel = new QLabel;
    screenshotLabel->setSizePolicy(QSizePolicy::Expanding,
                                   QSizePolicy::Expanding);
    screenshotLabel->setAlignment(Qt::AlignCenter);
    screenshotLabel->setMinimumSize(240, 160);
	//screenshotLabel->hide();
	//pixmap.fill(Qt::transparent);

	//QStyle::PE_Frame
    //createOptionsGroupBox(); 
    //createButtonsLayout();

    mainLayout = new QVBoxLayout;
	mainLayout->setContentsMargins (0,0,0,0);
	mainLayout->setSpacing(0);
 //   mainLayout->addWidget(titlebar);
  //  mainLayout->addWidget(screenshotLabel);
  //  mainLayout->addWidget(optionsGroupBox);
	//void Screenshot::createButtonsLayout()
    mainLayout->addWidget(shotarea);
    //mainLayout->addLayout(buttonsLayout);
	
    mainLayout->addWidget(statusbar);

    saveScreenshotButton = createButton(tr("Save Screenshot"),this, SLOT(saveScreenshot()));
	statusbar->addWidget(saveScreenshotButton);
//	statusbar->addWidget( quitScreenshotButton);
	statusbar->setSizePolicy (QSizePolicy::Expanding , QSizePolicy::Maximum );
    setLayout(mainLayout);
    //delaySpinBox->setValue(5);

    setWindowTitle(tr("Screenshot"));

	setMouseTracking (true);
	
	if(QApplication::desktop()->winId()==NULL)
		printf("Null Desktop\n");
//	setWindowFlags( Qt::FramelessWindowHint);
    resize(300, 200);
}


static QPoint init_pos;
void Screenshot::mousePressEvent(QMouseEvent *e)
{

	press_pos = e->globalPos();
	init_pos=pos();
	//printf("x=%d y=%d\n",press_pos.x(),press_pos.y());
}

void Screenshot::mouseMoveEvent(QMouseEvent *e)
{
	if(e->buttons()==Qt::LeftButton)  //  Button state )	
	{
		move(init_pos+ e->globalPos() - press_pos);
		//move(x() + e->globalX() - press_pos.x(), y()+e->globalY()- press_pos.y());// coe->x(),e->y());
		//sg->move(x()-100,y()-100);
	}
}


void Screenshot::paintEvent ( QPaintEvent * e )
{

	QPainter p(this);	
	QStyleOptionFrame opt;
	QRect rectR(shotarea->x()-1,shotarea->y()-1, 
			shotarea->width()+2,shotarea->height()+2);
    opt.rect=rectR;
	opt.lineWidth=2;
	opt.midLineWidth=1;
	opt.state= opt.state | QStyle::State_Sunken;
	//style()->drawControl(QStyle::CE_Header, &opt, p, this);
	style()->drawPrimitive (QStyle::PE_Frame ,&opt, &p,0);
}

void Screenshot::resizeEvent(QResizeEvent *e /* event */)
{
//	printf("Screenshot::resizeEvent()\n");
//	QWidget::resizeEvent(e);
	QPixmap pixmap = QPixmap(size());
	QPainter painter(&pixmap);
	//painter.eraseRect(0,0,width(),height());
	painter.fillRect(0,0,width(),height(),QColor(0,0,0));
	painter.fillRect(shotarea->x(),shotarea->y(), shotarea->width(), shotarea->height()
					, QColor(255,255,255));
	setMask(pixmap.createMaskFromColor(QColor(255,255,255), Qt::MaskInColor));

//  QSize scaledSize = originalPixmap.size();
//    scaledSize.scale(screenshotLabel->size(), Qt::KeepAspectRatio);
//   if (!screenshotLabel->pixmap()|| scaledSize != screenshotLabel->pixmap()->size())
//    updateScreenshotLabel();
}

void Screenshot::newScreenshot()
{
//    newScreenshotButton->setDisabled(true);
//		shootScreen();
//    QTimer::singleShot(delaySpinBox->value() * 1000, this, SLOT(shootScreen()));
}

void Screenshot::saveScreenshot()
{
	shootScreen();
    QString format = "png";
    QString path = QDir::homePath() + "/Desktop";
	if(QFile::exists(path))
    	path = path + tr("/untitled.") + format;
	else 
		path= QDir::homePath();

    QString fileName = QFileDialog::getSaveFileName(this, tr("Save As"),
                               path,
                               tr("%1 Files (*.%2);;All Files (*)")
                               .arg(format.toUpper())
                               .arg(format));
    if (!fileName.isEmpty())
        originalPixmap.save(fileName, format.toAscii());
}

void Screenshot::shootScreen()
{
		
//    if (delaySpinBox->value() != 0)  qApp->beep();
    originalPixmap = QPixmap::grabWindow(QApplication::desktop()->winId()
			,geometry().x() + shotarea->x() 
			,geometry().y() + shotarea->y()
			,shotarea->width()
			,shotarea->height()
			);
 ///   updateScreenshotLabel();
}

void Screenshot::updateCheckBox()
{
    if (delaySpinBox->value() == 0)
        hideThisWindowCheckBox->setDisabled(true);
    else
        hideThisWindowCheckBox->setDisabled(false);
}

void Screenshot::createOptionsGroupBox()
{
    optionsGroupBox = new QGroupBox(tr("Options"));

    delaySpinBox = new QSpinBox;
    delaySpinBox->setSuffix(tr(" s"));
    delaySpinBox->setMaximum(60);
    connect(delaySpinBox, SIGNAL(valueChanged(int)), this, SLOT(updateCheckBox()));

    delaySpinBoxLabel = new QLabel(tr("Screenshot Delay:"));

    hideThisWindowCheckBox = new QCheckBox(tr("Hide This Window"));

    optionsGroupBoxLayout = new QGridLayout;
    optionsGroupBoxLayout->addWidget(delaySpinBoxLabel, 0, 0);
    optionsGroupBoxLayout->addWidget(delaySpinBox, 0, 1);
    optionsGroupBoxLayout->addWidget(hideThisWindowCheckBox, 1, 0, 1, 2);
    optionsGroupBox->setLayout(optionsGroupBoxLayout);
}

void Screenshot::createButtonsLayout()
{
    newScreenshotButton = createButton(tr("New Screenshot"),
                                       this, SLOT(newScreenshot()));
    quitScreenshotButton = createButton(tr("Quit"), this, SLOT(close()));

    buttonsLayout = new QHBoxLayout;
    buttonsLayout->addStretch();
    buttonsLayout->addWidget(newScreenshotButton);
    buttonsLayout->addWidget(saveScreenshotButton);
    buttonsLayout->addWidget(quitScreenshotButton);
}

QPushButton *Screenshot::createButton(const QString &text, QWidget *receiver,
                                      const char *member)
{
    QPushButton *button = new QPushButton(text);
    button->connect(button, SIGNAL(clicked()), receiver, member);
    return button;
}

// preview
void Screenshot::updateScreenshotLabel()
{
    screenshotLabel->setPixmap(originalPixmap.scaled(screenshotLabel->size(),
                                                    Qt::KeepAspectRatio,
                                                    Qt::SmoothTransformation));
}
