// infobar.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

// 13,245,200
#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include <QtGui>

#include "global.h"
#include "infobar.h"
#include "proc.h"
#include "qps.h"
#include "misc.h"

float cpu_total=0;
float cpu_idle=0;
float cpu_used=0;

QMenu *m_popup ;
CPUbar	*cpubar=0; // extra CPU_window 
//#define SIMUL

Infobar::Infobar(QWidget *parent) : LoadGraph2(parent,1280)
{
	int i = 0;
	is_vertical = Qps::vertical_cpu_bar; //DEL 
	//load_graph = new LoadGraph2(this, 1280);
	//load_graph->setFrameShape(QFrame::Panel);
	//load_graph->setFrameShadow(QFrame::Sunken);
	
	//hl->addWidget(load_graph);
	setSizePolicy ( QSizePolicy::Expanding, QSizePolicy::Fixed);

	cpubar=new CPUbar(parent);	
	//setMinimumHeight( is_vertical ? 97 : 49);
	setMinimumHeight( 49);
	
    if(Procinfo::num_cpus>3)
	{
		printf("num_cpus=%d",Procinfo::num_cpus);
		//cpubar->setWindowTitle("ddd");
		//cpubar->setMinimumSize(100,200);
		cpubar->setFixedSize(114,11*Procinfo::num_cpus+12);
		//cpubar->setFixedSize(114,10*8+14);
	//	QPoint p=window()->pos();
	//	cpubar->move(p.x()-119,p.y() + pos().y());
		cpubar->show();	
	}
	else cpubar->hide();
	//QMenu();
	m_popup = new QMenu("popup",this);
	QAction *act=new QAction("Under Development",this);
	act->setDisabled(true);
	m_popup->addAction(act);
	//m_headpopup->addMenu(m_fields);

}

void Infobar::hideEvent( QHideEvent * event ) 
{
	//printf("Infobar::hideEvent()\n");
	cpubar->hide();
}

// return true if the swap meter is redlined
bool Infobar::swaplim_exceeded()
{
	if(Qps::swaplim_percent) {
		if(Procinfo::swap_total > 0) {
			int free_p = 100 * Procinfo::swap_free / Procinfo::swap_total;
			return free_p < Qps::swaplimit;
		} else
			return FALSE;
	} else {
		return Procinfo::swap_free < Qps::swaplimit;
	}
}

char rotate_str[]="|/-\\|/-\\";
//char rotate_str[]="REFRESH.*^__-\\|-/|-\\|";
int rotate_idx=0;
char rotate_char='|';
// refresh status bar; if step_load is true, add a point to the load graph
void Infobar::refresh()
{
	QString s;
   

	if(rotate_str[++rotate_idx]==0)	rotate_idx=0;
	rotate_char=rotate_str[rotate_idx];

	
	if(Qps::show_load_graph) 
		//load_graph->update();
		update();
		
}

void Infobar::update_load()
{	
	add_load_point();
}

// if p, then show A and hide B; otherwise do the opposite
void Infobar::showup()
{
	if(cpubar->isVisible())
		cpubar->raise();
}

//DEL?
void Infobar::show_and_hide(bool p, QWidget *a, QWidget *b)
{
	if(!p) {
		QWidget *c = a;
		a = b;
		b = c;
	}
	if(!a->isVisible()) {
		b->hide();
		a->show();
	}
}



#define TOTAL_BAR 50
QColor total_color;
QColor part1_color;
QColor part2_color;
QColor part3_color;
// DRAFT CODE : DRAFT CODE : DRAFT CODE : DRAFT CODE :  DRAFT CODE !!
// return width
int drawSPECTRUM(QPainter *p,int x,int y,char *name,
		int total, int part1,int part2=0,int part3=0,int h=0) 
{
	int total_width;
	//bluelay  0,180,255
	total_color.setRgb(0,85,90);
	part1_color.setRgb(0,255,210);
	part2_color.setRgb(0,220,175);
	part3_color.setRgb(0,180,150);
	int i,w;
	int tx,ty,bar_x_offset,bar_h;
	int bar;
	
	char buff[32]="NO";
	
	if(total==0){
		name=strcat(buff,name);
	}
	
	if(h==0)
		h=pf_char_height();
	
	w=2+pf_write(p,x+2,y+2,name)+3;
	bar_x_offset= x + w ;

	if(total==0) 
		return w;

	bar_h=h-1;
	ty=y+2;
	tx=0;
	p->setPen(total_color);
	for(i=0; i < TOTAL_BAR; i++)	
	{	
		p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
		tx++;
		tx++;
	}
	total_width = w+ tx;

	// draw part1 
	p->setPen(part1_color);
	if (total==0) total=1;
	bar=part1*TOTAL_BAR/total;
	tx=0;
	if(bar==0 and part1!=0 ) bar=1;
	for(i=0; i < bar ; i++ )
	{	
		p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
		tx+=2;
		//tx++;
	}

	if( part2 >= 0 )
	{
		p->setPen(part2_color);
		bar=part2*TOTAL_BAR/total;
		if(bar==0 and part2!=0 ) bar=1;
		for(i=0; i < bar ; i++ )
		{	
			p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
			tx+=2;
			//tx++;
		}
	}
	if( part3 >= 0 )
	{
		p->setPen(part3_color);
		bar=part3*(TOTAL_BAR)/total;
		for(i=0; i < bar ; i++ )
		{	
			p->drawLine(bar_x_offset+tx,ty,bar_x_offset+tx,ty+bar_h);
			tx+=2;
		}
	}

	if(tx>TOTAL_BAR*2) printf(" total =%d , part1=%d , part2=%d\n",total,part1,part2);
	return total_width;
}

// DRAFT CODE  !!
int drawUTIME(QPainter *p,int x,int y,long boot_time)
{
	char buff[1024]; 
	//printf("size of long=%d, size of time_t=%d \n",sizeof(long),sizeof(time_t));
	long u = (long)time(NULL) - (long)boot_time;
	int up_days = u / (3600 * 24);
	u %= (3600 * 24);
	int up_hrs = u / 3600;
	u %= 3600;
	int up_mins = u / 60;
	if(up_days == 0) {
		if(up_hrs == 0)
			sprintf(buff,"UPTIME %d min", up_mins);
		else
			sprintf(buff,"UPTIME %d:%02d", up_hrs, up_mins);
	} else
		sprintf(buff,"UPTIME %d DAY%s, %d:%02d", up_days, (up_days == 1) ? "" : "s", up_hrs, up_mins);
	return pf_write(p,x,y,buff );
}

// ============================ 
gwidget *x_cpu;
gwidget *x_mem;
gwidget *x_swap;
gwidget *x_utime;
gwidget *x_load_avg;

char 	str_buff[512];
class w_cpu: public gwidget
{
	private:
		int cpu_n;
		unsigned long total, user, system, idle,nice, wait;

	public:
	virtual void draw(QPainter *p)
	{
		x=0;
		char buff[32];
		int cpu_id;
		int cpu_n;
		int graph_height=10;
		int w;

		user=0, system=0, idle=0,nice=0, wait=0;
		
		//if(Procinfo::num_cpus>=4) // temporaly... 
		//else 
        cpu_n=Procinfo::num_cpus;
 
 		width=0;
		if(cpubar->isVisible())
		{
#define TIMEDIFF(kind) (Procinfo::cpu_times(cpu_id, Procinfo::kind) - Procinfo::old_cpu_times(cpu_id, Procinfo::kind))
				// show Total CPU 
				cpu_id=cpu_n;
				user = TIMEDIFF(Procinfo::CPUTIME_USER);
#ifdef LINUX
				nice = TIMEDIFF(CPUTIME_NICE);
#endif
				system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = TIMEDIFF(CPUTIME_WAIT);
#endif
				idle = TIMEDIFF(CPUTIME_IDLE);
#undef TIMEDIFF
				total=user+system+wait+nice+idle;
				width=drawSPECTRUM(p,0,0,"CPU",total,user,system,nice,graph_height-1);
				
			return;
		}	
		
		// show only less 2 cpu-s
		for(cpu_id = 0; cpu_id < cpu_n; cpu_id++) {
#define TIMEDIFF(kind) (Procinfo::cpu_times(cpu_id, Procinfo::kind) - Procinfo::old_cpu_times(cpu_id, Procinfo::kind))
			if(Procinfo::num_cpus == Procinfo::old_num_cpus) {
				user = TIMEDIFF(Procinfo::CPUTIME_USER);
#ifdef LINUX
				nice = TIMEDIFF(CPUTIME_NICE);
#endif
				system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = TIMEDIFF(CPUTIME_WAIT);
#endif
				idle = TIMEDIFF(CPUTIME_IDLE);
#undef TIMEDIFF
			} 
			total=user+system+wait+nice+idle;
			{
				sprintf(buff,"CPU%d",cpu_id);
//			if(idle<0)
//			printf("xx idle=%d , old =%d \n",Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_IDLE),Procinfo::old_cpu_times(cpu_id, Procinfo::CPUTIME_IDLE));
			//if(total == 1 or total ==0)	printf(":total=%ld user=%ld system=%d wait=%d ,nice=%d idle=%ld\n",total,user,system,wait,nice,idle);
				#ifdef LINUX
				width=drawSPECTRUM(p,0,cpu_id*graph_height,buff,total,user,system,nice,graph_height-1);
				#endif			
				#ifdef SOLARIS
				width=drawSPECTRUM(p,0,cpu_id*10,buff,total,user,system,wait);
				#endif
			}
			
			height=graph_height*cpu_n;
		}	
	}

	virtual char *info()
	{
		char str[80];
		float f_user,f_nice,f_system,f_wait;
	
		f_user=(float)user/total *100;
		f_nice=(float)nice/total *100;
		f_wait=(float)wait/total *100;
		f_system=(float)system/total *100;
#ifdef LINUX
		sprintf(str_buff,"user: %1.1f%%  system:%1.1f%%  nice:%1.1f%% "
			,f_user,f_system,f_nice);
#endif

		return str_buff;
	};

};


class w_mem: public gwidget
{
	private :
		int used;
	public:
	virtual void draw(QPainter *p)
	{
		height=pf_char_height()+4;
		x=x_cpu->xpluswidth()+10;
#ifdef LINUX
		used = Procinfo::mem_total -  Procinfo::mem_free - Procinfo::mem_buffers -Procinfo::mem_cached;
		width=drawSPECTRUM(p,x,0,"MEM",Procinfo::mem_total,used, Procinfo::mem_cached,Procinfo::mem_buffers);
#endif

#ifdef SOLARIS
		used = Procinfo::mem_total -  Procinfo::mem_free;
		width=drawSPECTRUM(p,x,0,"MEM",Procinfo::mem_total,used);
#endif

	}
	virtual char *info()
	{
		char str[80];

		strcpy(str_buff,"Total: ");
		mem_string(Procinfo::mem_total,str);
		strcat(str_buff,str);
	
		strcat(str_buff,"  used: ");
		mem_string(used,str);
		strcat(str_buff,str);

#ifdef LINUX
		strcat(str_buff,"  cached: ");
		mem_string(Procinfo::mem_cached,str);
		strcat(str_buff,str);
		strcat(str_buff,"  buffer: ");
		mem_string(Procinfo::mem_buffers,str);
		strcat(str_buff,str);
#endif

	
	//	sprintf(str_buff,"Total: %dKb , cache: %dKb , buffer: %dKb",
	//		Procinfo::mem_total,Procinfo::mem_cached,Procinfo::mem_buffers);
		return str_buff;
	};

};

class w_swap: public gwidget
{
	private:
		int used;
	public:
	virtual void draw(QPainter *p)
	{	
		x=x_mem->xpluswidth()+10;
		used=Procinfo::swap_total-Procinfo::swap_free;
		width=drawSPECTRUM(p,x,0,"SWAP",Procinfo::swap_total,used);
		height=pf_char_height()+4;
	}
	virtual char *info()
	{	
		char str[80];
		
		strcpy(str_buff,"Total: ");
		mem_string(Procinfo::swap_total,str);
		strcat(str_buff,str);
		strcat(str_buff,"  Free: ");
		mem_string(Procinfo::swap_free,str);
		strcat(str_buff,str);
		strcat(str_buff,"  Used: ");
		mem_string(used,str);
		strcat(str_buff,str);

		//sprintf(str_buff,"Total: %d Kbyte , used %d Kbyte",
		//		Procinfo::swap_total,Procinfo::swap_free);
		return str_buff;
	};
};

class w_utime: public gwidget
{
	public:
	virtual void draw(QPainter *p)
	{
		height=pf_char_height()+4;
		x=x_swap->xpluswidth()+10;
		width=drawUTIME(p,x,2,Procinfo::boot_time);
	}
	virtual char *info()
	{
		return "passed time after system booting";
	};
};

class w_load_avg : public gwidget
{
	virtual void draw(QPainter *p)
	{
		char buff[64];
		//printf("w_load_avg\n");
		//sprintf(buff,"QPS %3.02f%%", Procinfo::loadQps);
		sprintf(buff," 1m:%1.02f%% 5m:%1.02f%% 15m:%1.02f%%",		 
					Procinfo::loadavg[0],Procinfo::loadavg[1], Procinfo::loadavg[2]);

		width=pf_str_width(buff);

		x=parent->width()-width-6;
		
		int w=x_utime->xpluswidth()+15;
		if (x<w)
			x=w;
		
		pf_write(p,x,2,buff);

		x=parent->width()-8;
		y=parent->height()-9;

		char str[2]={0,0};
		str[0]=rotate_char;
		pf_write(p,x,y,str);
	}
	virtual char *info()
	{
		//return "Average CPU%% each 1, 5 ,15minutes";
		return "Average CPU%% each 1, 5 ,15minutes";
	};

};

LoadGraph2::LoadGraph2(QWidget *parent, int history_size) : QFrame(parent),
	npoints(0),peak(0),h_index(0), dirty(TRUE)
{
	//setCursor ( QCursor(Qt::CrossCursor) ) ;
	//setCursor ( Qt::CrossCursor );
	hist_size=history_size;
	history=new float[history_size];
	// setBackgroundRole (QPalette::WindowText);
	setAutoFillBackground ( false );	
	setAttribute(Qt::WA_OpaquePaintEvent);
	QPalette pal;
	pal.setColor(QPalette::Window,QColor(0,0,0));
	setPalette(pal);

	x_cpu=new w_cpu();
	x_cpu->setParent(this);
	x_mem=new w_mem();
	x_mem->setParent(this);
	x_swap=new w_swap();
	x_swap->setParent(this);
	x_utime=new w_utime();
	x_utime->setParent(this);
	x_load_avg=new w_load_avg();	
	x_load_avg->setParent(this);
	
	wlist.add(x_cpu);
	wlist.add(x_mem);
	wlist.add(x_swap);
	wlist.add(x_utime);
	wlist.add(x_load_avg);
	
	QWidget::setMouseTracking(true);
}

LoadGraph2::~LoadGraph2()
{
	delete[] history;
}

// add value to the history, updating peak.
void LoadGraph2::add_history_point2(float value)
{
	static float v[3]={0,0,0};
	static float last_val=0;
	
	float f;
	f=last_val-value;
	//if (f > 0)
	//	value+=f/1.15;  // slow up ,slow down
	//else 
		value+=f/1.5;  // slow up ,slow down
	history[h_index++] = value;
	if(h_index >= hist_size)
		h_index = 0;
	if(npoints < hist_size)
		npoints++;
	if(value > peak)
		peak = value;
	else {
		peak = 0;		// no negative values
		for(int i = 0; i < npoints; i++)
			if(history[i] > peak)
				peak = history[i];
	}
	// printf("hist_size=%d h_index=%d  val=%f\n",hist_size,h_index,value);
			
	
	last_val=value;
}



// Add current load (the 1 min average) as a data point
void LoadGraph2::add_load_point()
{
	add_history_point((unsigned)(Procinfo::loadavg[0] * history_scale));
	//add_history_point2(cpu_used);
	dirty = TRUE;
}

// draw the load graph on the internal pixmap, if needed
void LoadGraph2::make_graph2(int w, int h)
{
	// removed 
}

// return updated pixmap for use as an icon
QPixmap *LoadGraph2::make_icon(int w, int h)
{
	if(w != icon_pm.width() or h != icon_pm.height()) {
		///printf("icon_pm changed!!!!!!!!!!!!!!!!!!11\n");
		icon_pm=QPixmap(w,h); //pm.resize(w, h);
		icon_pm.setMask(QBitmap());	// remove the mask
	} 
	QPainter pt(&icon_pm);
	make_graph(w, h,&pt);
	return &icon_pm;
}

void LoadGraph2::mousePressEvent(QMouseEvent *e)
{
	emit clicked();
	if(e->button()==Qt::RightButton)
		m_popup->popup(e->globalPos());
}


// only works if mouse cursor in this area 
void LoadGraph2::mouseMoveEvent(QMouseEvent *e)
{
	int x=0,y=0;
	int px,py;
	int half_height;
	int dy,a_y;
	int gap;


	px=e->pos().x() ;
	py=e->pos().y() ;

	
	half_height=height()/2;
	
	dy=py-half_height;
	dy/=2;
	dy+=5;

	x=8+pos().x();
	y=pos().y()-dy;
		
	//printf("py=%d  y=%d h=%d , dy=%d\n",py,y,height(),dy);

	//gap=infobox->width() + px  - width();
	//if(gap > 0)	x-= gap;

	gap= py - infobox->height();
	if(gap < 0)
		y-= gap;

	//
	int i;
	int setinfo=0;
	for(i=0;i<wlist.size();i++)
		if(wlist[i]->intersect(px,py)) 
		{
			setinfo=1;
			infobox->setText(wlist[i]->info());
		}

	if (setinfo==0)
		infobox->setText("UNDER DEVELOPMENT");

	infobox->move(px+x,py+y);
	infobox->show();
}

void LoadGraph2::leaveEvent ( QEvent * ) 
{
	infobox->hide();
}

// old style : relative method  
// add value to the history, updating peak.
void LoadGraph2::add_history_point(unsigned value)
{	
	static unsigned last_val=0;
	
	if(value==last_val) return;
	
	history[h_index++] = value;
	if(h_index >= hist_size)
		h_index = 0;
	if(npoints < hist_size)
		npoints++;
	if(value > peak)
		peak = value;
	else {
		peak = 0;		// no negative values
		for(int i = 0; i < npoints; i++)
			if(history[i] > peak)
				peak = history[i];
	}
	last_val=value;
}


// USING NOW
// draw the load graph on the internal pixmap, if needed
void LoadGraph2::make_graph(int w, int h,QPainter *p )
{
	/*
	if(w != pm.width() || h != pm.height()) {
		pm=QPixmap(w,h); //pm.resize(w, h);
		pm.setMask(QBitmap());	// remove the mask
	} 
	else 
		if(!dirty)
			return;
	*/

    //QPainter p(this);
	//p.fill(Qt::black);
	//p.setBackgroundMode (Qt::OpaqueMode);	p.setBackground(QBrush(Qt::black));
	p->fillRect(0,0,w,h,QBrush(Qt::black));

	int npts = qMin(npoints, w);
	int ofs = h_index - npts;
	if(ofs < 0)
		ofs += hist_size;

	QPolygon pa(npts);  //QPointArray pa(npts);
	
	// make the scale slightly over the peak since a constant load is quite
	// common and makes it hard to see the graph otherwise
	unsigned int scale =(unsigned int)history_scale * 9 / 8;
	/////unsigned int scale =(unsigned int) QMAX(peak + history_scale * 1 / 8 ,history_scale * 9 / 8);
	float mul = (float)h / scale;
	for(int i = 0; i < npts; i++) {
		int j = ofs + i;
		if(j >= hist_size) j -= hist_size;
		pa[i] = QPoint(i, h - 1 - (int)(history[j] * mul));
	}
	//draw scale lines
	//p.setPen(QColor(0,70,54));
	p->setPen(QColor(0,195,80));
	p->drawPolyline(pa);
	dirty = FALSE;
}


// DRAFT CODE  !!!
void LoadGraph2::paintEvent ( QPaintEvent *e )
{
	//static QPaint *p=// QPainter *p=new QPainter(this);
    QPainter p(this);
	char buff[128];
	int w;
	int width;
	int x,y;
	int i;
	///printf("LoadGraph2()\n");
	//QRect cr = contentsRect();
	//QRect cr = p->viewport();
	QRect cr = p.window();
	make_graph(cr.width(), cr.height(),&p);
	for(i=0;i<wlist.size();i++)
		wlist[i]->draw(&p);

	if(cpubar and  Procinfo::num_cpus>3 )//cpubar->isVisible())
	{
		if(parentWidget()->isVisible())
			cpubar->show();
		else 
			cpubar->hide();

		cpubar->setFixedSize(114,11*Procinfo::num_cpus+12);
		//cpubar->setFixedSize(114,10*8+14);
		//QPoint p=window()->pos();
		QRect p=window()->geometry();
		cpubar->move(p.x()-119,p.y() + pos().y());
	
		if(cpubar->isVisible())
			cpubar->update();
	}
	
}

CPUbar::CPUbar(QWidget *p): QWidget(p)
{
	parent=p;
	//setWindowFlags(Qt::FramelessWindowHint | Qt::ToolTip);
	setWindowFlags(Qt::FramelessWindowHint |Qt::Tool );
	
//	setParent(p);	
 //Qt::Window 
//	QTabWidget *tbar = new QTabWidget(this);
	setAttribute(Qt::WA_OpaquePaintEvent);
	QPalette pal;
	pal.setColor(QPalette::Window,QColor(0,0,0));
	setPalette(pal);
	QWidget::setMouseTracking(true);
}

void CPUbar::refresh()
{

}

void CPUbar::mousePressEvent(QMouseEvent *e)
{
	m_popup->popup(e->globalPos());
	//hide();
}


// DRAFT CODE  !!!
void CPUbar::paintEvent ( QPaintEvent *e )
{
	//static QPaint *p=// QPainter *p=new QPainter(this);
    QPainter p(this);
	char buff[128];
	int w;
	int width;
	int x,y;
	int i;
	///printf("LoadGraph2()\n");
	//QRect cr = contentsRect();
	//QRect cr = p->viewport();
	QRect cr = p.window();
	p.fillRect(cr,QBrush(Qt::black));
	//p.fillRect(cr,QBrush(QColor(255,255,255,50)));

//	for(i=0;i<wlist.size();i++)
//		wlist[i]->draw(&p);
//	p.drawPixmap(cr.x(), cr.y(), pm);

	unsigned long	total=0,user=0, system=0, idle=0,nice=0, wait=0;
		
		//if(Procinfo::num_cpus>=4) // temporaly... 
		//else 
    int cpu_n=Procinfo::num_cpus;
    int cpu_id;
	w=2+pf_write(&p,2,2,"SUB CPU");

#ifdef SIMUL
	 cpu_n=8;
#define TIMEDIFF(kind) (Procinfo::cpu_times(0, Procinfo::kind) - Procinfo::old_cpu_times(0, Procinfo::kind))
#else
#define TIMEDIFF(kind) (Procinfo::cpu_times(cpu_id, Procinfo::kind) - Procinfo::old_cpu_times(cpu_id, Procinfo::kind))
#endif

		for(cpu_id = 0; cpu_id < cpu_n; cpu_id++) {
			if(Procinfo::num_cpus == Procinfo::old_num_cpus) {
				user = TIMEDIFF(CPUTIME_USER);
#ifdef LINUX
				nice = TIMEDIFF(CPUTIME_NICE);
#endif
				system = TIMEDIFF(CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = TIMEDIFF(CPUTIME_WAIT);
#endif
				idle = TIMEDIFF(CPUTIME_IDLE);
#undef TIMEDIFF
			} else {
				// number of cpus just changed
				// FIXME: this is not enough to support dynamic addition/removal
				// of cpus at runtime; the number of graphs should be dynamic
				// as well.
				user = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_USER);
#ifdef LINUX
				nice = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_NICE);
#endif
				system = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_SYSTEM);
#ifdef SOLARIS
				wait = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_WAIT);
#endif
				idle = Procinfo::cpu_times(cpu_id, Procinfo::CPUTIME_IDLE);
			}

			total=user+system+wait+nice+idle;
			int graph_height=10;	
		//	height=graph_height*cpu_n;
			sprintf(buff,"%d",cpu_id);
			#ifdef LINUX
			width=drawSPECTRUM(&p,0,10+cpu_id*graph_height,buff,total,user,system,nice,graph_height-1)+w;
			#endif			
		}

}
