// prefs.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

#include "prefs.h"
#include "qps.h"
#include "global.h"

#include <qcombobox.h>
#include <qpushbutton.h>
#include <qaccel.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qvalidator.h>
#include <qvgroupbox.h> 
#include <qhgroupbox.h> 
#include <qapplication.h>
#include <qfontdatabase.h>
#include <qvaluelist.h> 
#include <qhbox.h> 

#include <qstylefactory.h>
#include <qapplication.h>
#include <qstyle.h>


// class that validates input for the "swap warning limit" field
class Swapvalid : public QValidator
{
public:
    Swapvalid(QWidget *parent) : QValidator(parent) {}
    virtual State validate(QString &s, int &)const;
};

struct Boxvar
{
    const char *text;
    bool *variable;
    //CrossBox *cb;
    QCheckBox *cb;
};

static Boxvar statbar_boxes[] = {
   // {"Graphic Load Display", &Qps::show_load_graph, 0},
   // {"Graphic CPU Display", &Qps::show_cpu_bar, 0},
   // {"Graphic Memory Display", &Qps::show_mem_bar, 0},
   // {"Graphic Swap Display", &Qps::show_swap_bar, 0},
    {"Load Graph in Icon", &Qps::load_in_icon, 0},
  //   {"Vertical CPU Bar (under development)", &Qps::vertical_cpu_bar, 0},
    {0, 0, 0}
};

#ifdef LINUX
static Boxvar sockinfo_boxes[] = {
    {"Host Name Lookup", &Qps::hostname_lookup, 0},
    {"Service Name Lookup", &Qps::service_lookup, 0},
    {0, 0, 0}
};
#endif

static Boxvar tree_boxes[] = {
    {"Disclosure Triangles", &Qps::tree_gadgets, 0},
    {"Branch Lines", &Qps::tree_lines, 0},
    {0, 0, 0}
};

static Boxvar misc_boxes[] = {
    //{"Start Minimized && Minimized on Close Button", &Qps::flag_systray, 0},
    //{"Minimized on Close Button", &Qps::flag_systray, 0},
    {"Auto Save Settings on Exit", &Qps::auto_save_options, 0},
    {"Selection: Copy PIDs to Clipboard", &Qps::pids_to_selection, 0},
#ifdef SOLARIS
    {"Normalize NICE", &Qps::normalize_nice, 0},
    {"Use pmap for Map Names", &Qps::use_pmap, 0},
#endif
    {0, 0, 0}
};

struct Cbgroup
{
    const char *caption;
    Boxvar *boxvar;
};

static Cbgroup groups[] = {
    {"Status Bar", statbar_boxes},
#ifdef LINUX
//    {"Socket Info Window", sockinfo_boxes},
#endif
//   {"Tree View", tree_boxes},
    {"Miscellaneous", misc_boxes},
    {0, 0}
};

struct fontsets {
    const char *set;
    //const char *name;
    QString name;//const char *name;
    int size;
    int avail;
};


static fontsets  recommend_fontset[] = {
    {"System Default", "system_default",10,0},
    {"screen, 10 point (Solaris)","screen",10,0},  // non-antialis !
    {"Luxi Sans, 9 point", "Luxi Sans",9,0},
    {"Bitstream Vera Sans, 8 point","Bitstream Vera Sans",8,0},
    {"Bitstream Vera Sans Mono, 8 point","Bitstream Vera Sans Mono",8,0},
    {"Courier 10 Pitch, 9 point","Courier 10 Pitch",9,0},
    {"Verdana, 8 point","Verdana",8,0},
    {"LucidaTypewriter, 9 point","LucidaTypewriter",9,0},  // non-anti-alias
    {"Lucida, 10 point","Lucida",10,0},			// non-antialias
    {"Helvetica, 10 point","Helvetica",10,0},	// non-anti
    {0, 0,0,0}
};

void getDefaultFont(QFont f)
{
	recommend_fontset[0].name=f.family();
	recommend_fontset[0].size=f.pointSize();
}

void find_fontsets();
// dual use function: both validate and apply changes
QValidator::State Swapvalid::validate(QString &s, int &) const
{
	// only accept /^[0-9]*[%kKmM]?$/
	int len = s.length();
	int i = 0;
	while(i < len && s[i] >= '0' && s[i] <= '9') i++;
	if(i < len && QString("kKmM%").contains(s[i]) == 0 || i < len - 1)
		return Invalid;
	if(s[i] == 'k')
		s[i] = 'K';
	if(s[i] == 'm')
		s[i] = 'M';
	int val = atoi((const char *)s);
	bool percent;
	if(s[i] == '%') {
		percent = TRUE;
	} else {
		percent = FALSE;
		if(s[i] == 'M')
			val <<= 10;
	}
	Qps::swaplimit = val;
	Qps::swaplim_percent = percent;
	return Acceptable;
}


Preferences::Preferences(): QDialog()
{
    setCaption("Preferences");
    setModal ( true);
    
    QVBoxLayout *v_layout = new QVBoxLayout(this, 5);
    const int border_x = 10;
    int min_x = 0;
    int top_margin = (int)(fontMetrics().lineSpacing() * 1.5);

    for(Cbgroup *g = groups; g->caption; g++) {
        QVGroupBox *grp = new QVGroupBox(g->caption, this);
        for(Boxvar *b = g->boxvar; b->text; b++) 
        {
            b->cb = new QCheckBox(b->text, grp);		
            connect(b->cb, SIGNAL(clicked()), SLOT(update_reality())); 
            // -> EMIT prefs_change()
        }
        v_layout->addWidget(grp);
    }

    update_boxes();

	QGroupBox *wgrp = new QHGroupBox("Swap Warning", this);
	QLabel *lbl = new QLabel("Warn when free swap below", wgrp);
	QLineEdit *swaped = new QLineEdit(wgrp);
	//swaped->setAlignment (  Qt::AlignRight );
	QString s;
	if(Qps::swaplim_percent) {
		s.sprintf("%d%%", Qps::swaplimit);
	} else {
		if(Qps::swaplimit >= 1024 && (Qps::swaplimit & 0x7ff) == 0)
			s.sprintf("%dM", Qps::swaplimit >> 10);
		else
			s.sprintf("%dK", Qps::swaplimit);
	}
	swaped->setText(s);
	swaped->setValidator(new Swapvalid(this));
	connect(swaped, SIGNAL(textChanged(const QString &)), SIGNAL(prefs_change()));
	v_layout->addWidget(wgrp);


	// Appearance ====================================
	QVGroupBox *font_grp = new QVGroupBox("Appearance", this);

	QLabel *label1 = new QLabel("Current Font", font_grp);
	QHBox *hbox=new QHBox(font_grp);
	hbox->setSpacing (5);
	familycombo = new QComboBox(hbox);
	psizecombo = new QComboBox(hbox);
	
	QLabel *label2 = new QLabel("Recommended Font Set ", font_grp);
	fontset_combo = new QComboBox(font_grp);

	/*
	// Style, Themes ==================================
	QLabel *label3 = new QLabel("Themes", font_grp);	
	QComboBox *theme_combo = new QComboBox(font_grp);

	QStringList styles = QStyleFactory::keys();
    styles.sort();
    theme_combo->insertStringList(styles);

	QString currentstyle;
	currentstyle = QApplication::style().className();
*/
	
	v_layout->addWidget(font_grp);
	
	QPushButton *closebut = new QPushButton("Save", this);
   // closebut->setFocusPolicy(QWidget::NoFocus);
    closebut->setFocus();

	closebut->setDefault(TRUE);
	v_layout->addWidget(closebut);
	v_layout->freeze();
	
	connect(closebut, SIGNAL(clicked()), SLOT(closed()));
	connect(familycombo, SIGNAL(activated( int)),this, SLOT(font_changed(int)));
	connect(psizecombo, SIGNAL(activated ( int )), SLOT(font_changed(int )));
	connect(fontset_combo, SIGNAL(activated ( int )), SLOT(fontset_changed(int )));

	remove_bad_fonts();
	font_changed(0); //*** important  need -> makes font not "null" 
	
	find_fontsets();
	for(int i=0;recommend_fontset[i].name!=0;i++)
	{
		if(recommend_fontset[i].avail>0)
			fontset_combo->insertItem(recommend_fontset[i].set);
	}

}

void removeFromQStringList(QStringList &a,QStringList &b)
{
	QStringList::Iterator sit = b.begin();
	
	while (sit != b.end()) {
		QStringList::Iterator si=a.find(*sit);
		a.remove(si);
		sit++;
	}
}

void removeFromQStringListGrep(QStringList &a,QStringList &b)
{
	QStringList::Iterator sit = b.begin();
	
	while (sit != b.end()) {
		QStringList c=a.grep(*sit,false);
		removeFromQStringList(a,c);	
		sit++;
	}
}

void addsFromQStringListGrep(QStringList &a,QStringList &b)
{
 	QFontDatabase db;
	QStringList families = db.families(QFont::Latin);
	QStringList::Iterator sit = b.begin();
	QStringList c;
	while (sit != b.end()) {
		QStringList c=a.grep(*sit,false);
		removeFromQStringList(a,c);	
		sit++;
	}
}


// available ?  recommended fonts 
void find_fontsets()
{
	int i;
	QFontDatabase db;
	QStringList families = db.families(QFont::Latin);
	
	for(i=0;recommend_fontset[i].name!=0;i++)
	{
		QStringList l=families.grep(recommend_fontset[i].name,false);
		if(l.size()>0)
		{
			//if(l.size()==1)
				recommend_fontset[i].avail=1;
		}

	}
}


// DRAFT CODE : 
// update font list
void Preferences::remove_bad_fonts()
{
 	QFontDatabase db;
	QStringList families = db.families(QFont::Latin);
	QStringList extra;

//	QStringList adds;
//	adds.append("bitstream");

	extra.append("math");
	extra.append("symbol");
	extra.append("extra");
	extra.append("webdi");
	extra.append("msam");
	extra.append("msbm");
	extra.append("wasy");
	extra.append("cmbx");
	extra.append("cmex");
	extra.append("cmmi");
	extra.append("cmr");
	extra.append("cmsy");
	
	removeFromQStringListGrep(families,extra);
	
	familycombo->clear();
	psizecombo->clear();

	familycombo->insertStringList(families);
	
	QValueList<int> sizes = db.standardSizes();
	QValueList<int>::Iterator it = sizes.begin();
	while (it != sizes.end())
	{	
		if( *it <20 && *it > 7 )	
			psizecombo->insertItem(QString::number(*it++));
		else it++;
	}
	
	// find the default family
	QStringList::Iterator sit = families.begin();
	int i = 0, possible = -1;
	while (sit != families.end()) {
		if (*sit == QApplication::font().family())
			break;
		if ((*sit).contains(QApplication::font().family()))
			possible = i;

		i++;
		sit++;
	}
	if (sit == families.end())
		i = possible;
	if (i == -1) // no clue about the current font
		i = 0;

	familycombo->setCurrentItem(i);
	i = 0;
	
	for (int psize = QApplication::font().pointSize(); i < psizecombo->count(); ++i) 
	{
		const int sz = psizecombo->text(i).toInt();
		if (sz == psize) {
			psizecombo->setCurrentItem(i);
			break;
		}
	}

}


// slot: update check boxes to reflect current status
void Preferences::update_boxes()
{
    for(Cbgroup *g = groups; g->caption; g++)
	for(Boxvar *b = g->boxvar; b->text; b++)
	    b->cb->setChecked(*b->variable);
}

// slot: update flags and repaint to reflect state of check boxes
void Preferences::update_reality()
{
	for(Cbgroup *g = groups; g->caption; g++)
		for(Boxvar *b = g->boxvar; b->text; b++)
			*b->variable = b->cb->isChecked();
	emit prefs_change();
}

void Preferences::closed()
{
   	hide();
	qps->write_settings();
}

//?? DRAFT
void Preferences::font_changed(int i)
{
	QString family=familycombo->currentText();
	int size=psizecombo->currentText().toInt();
	QFont font;
	font.setStyleStrategy (QFont::PreferAntialias); 
	//font.setStyleStrategy (QFont::NoAntialias);
	font.setFamily(family);
	font.setPointSize(size);
	
 	QApplication::setFont(font,true);
	qps->font_name=family;
	qps->font_size=size;

}
//DRAFT CODE:
void Preferences::fontset_changed(int i)
{
	QString fontset=fontset_combo->currentText();
	
	for(i=0;recommend_fontset[i].name!=0;i++)
	{
		if( fontset==recommend_fontset[i].set)
		{
			QFont font(recommend_fontset[i].name,recommend_fontset[i].size);
	 		QApplication::setFont(font,true);
			remove_bad_fonts();
			font_changed(0);
		}
	}
}
