//	very dirty and too complex code ( fasthyun@magicn.com) 

// htable.cpp 
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

// TODO:
// * autoscroll speed proportional to distance from edge  
// * interface to add/remove rows (for disclosure triangles)
// * interface to display pixmaps in cells (for disclosure triangles etc)
// * include sorting functionality here for more generality

#include <stdlib.h>

#include <qbitmap.h>
#include <qpainter.h>
#include <qpixmap.h>

#include "htable.h"
#include "svec.cpp"
#include "qps.h"
#include <QShortcut>


// TableHead: the horizontally scrollable table head
TableHead::TableHead(HeadedTable *parent)
	: QtTableView(parent),
	htable(parent),
	left_pressed(FALSE),
	dragging(FALSE)
{
	setSizePolicy(QSizePolicy (QSizePolicy::Minimum,QSizePolicy::Minimum));
	//setSizePolicy(QSizePolicy (QSizePolicy::Minimum,QSizePolicy::Expanding));
	//setTableFlags(Tbl_smoothHScrolling | Tbl_scrollLastHCell);
	setTableFlags(Tbl_scrollLastHCell);
	setNumRows(1);
	setMouseTracking (true);
//	setMinimumHeight(cellHeight()); //ZERO!!
}

QString TableHead::text(int row,int col)
{ 
    return htable->title(col); 
}


// Description : draw a field name of table  when DRAGGing !!
// 		called by paintHeading()
// 		called by QtTableView::repaint() 
void TableHead::paintCell(QPainter *p, int row, int col,bool update)
{
	static int count=0;
	/// printf(" paintcell %d,%d\n",row,col);
	int w = htable->max_widths[col]; 
	
    if( htable->isCellContentsChanged(row,col,true)==false)
	{
		if(update==true)  // check cached value
			return;
	}

	//if( col ==11 )	printf("head: %d  (%d) \n",col,count++);
	//w = cellUpdateR.width();
	{
		QStyleOptionHeader opt;
		QRect rectR(0,0,w,height());
    	opt.rect=rectR;
		opt.text=htable->title(col);
		opt.state=QStyle::State_Enabled;
		if(htable->sortedCol()==col) opt.state= opt.state | QStyle::State_Sunken;
		//CE_Header, CE_HeaderSection, CE_HeaderLabel
        style()->drawControl(QStyle::CE_Header, &opt, p, this);
	}
}

void TableHead::eraseRight(QPainter *p,QRect &r)
{
		QStyleOptionHeader opt;
    	opt.rect=r;
		opt.text="";
        style()->drawControl(QStyle::CE_Header, &opt, p, this);
}

// paint a (unsunken) heading of physical column at offset x
void TableHead::paintHeading(int x, int col)
{
	int w = htable->max_widths[col];
	int h = height();
	QPainter p(this);
	p.setClipRect(x, 0, w+1, h);	// +1 (by fasthyun@magicn.com) 
	p.translate(x, 0);				// ???(by fasthyun@magicn.com) 
//	int oldsorted = htable->sorted_col;
//	htable->sorted_col = -1;
	//repaint(x, 0, w+1, h);	// +1 (by fasthyun@magicn.com) 
	paintCell(&p, 0, col,false);
//	htable->sorted_col = oldsorted;
}


//virtual !
int TableHead::cellWidth(int col)
{
	return htable->max_widths[col];
}

void TableHead::scrollSideways(int val)
{
	setXOffset(val);
}

void TableHead::mousePressEvent(QMouseEvent *e)
{
	int col = findCol(e->x());
	if(col == -1) return;
	
	click_col = col;

	if(e->button() == Qt::RightButton && htable->options & HTBL_HEADING_CONTEXT_MENU) 
	{
		emit rightClicked(e->globalPos(), col);
		return;

	}

	if(e->button() == Qt::LeftButton ) {
		left_pressed = TRUE;
		press = e->pos();
	}
}


void TableHead::mouseMoveEvent(QMouseEvent *e)
{
	if(e->buttons()==Qt::LeftButton) {
		if(htable->options & HTBL_REORDER_COLS
				&& (dragging || abs(e->x() - press.x()) > drag_threshold)) {
			if(click_col < 0)
				click_col = findCol(press.x());

			int w = cellWidth(click_col);
			if(!dragging) {
				dragging = TRUE;
				drag_offset = press.x() - htable->colOffset(click_col) + xOffset();
			} else {
				repaint(drag_pos - drag_offset, 0, w, height()); // need
			//	htable->body->drawGhostCol(drag_pos - drag_offset, w);
			}
			//htable->body->drawGhostCol(e->x() - drag_offset, w);
			paintHeading(e->x() - drag_offset, click_col);
			//paintHeading(e->x() - 5, click_col);
			drag_pos = e->x();
			return;
		}
		int col = findCol(e->x());
		if(col == findCol(press.x())) {
			if(click_col < 0) {
				click_col = col;
			}
		} else {
			if(click_col >= 0) {
				click_col = -1;
			}
		}
	}
	int col = findCol(e->x());
	if(col>0) 
	{
		QString s = htable->tipText(col);
		if(!s.isEmpty()) 
    		QToolTip::showText(e->globalPos(), s);
		//tip(e->pos());
	}

}

void TableHead::mouseReleaseEvent(QMouseEvent *e)
{
	if(left_pressed) {
		left_pressed = FALSE;
		if(dragging) {
			int w = cellWidth(click_col);
			repaint(drag_pos - drag_offset, 0, w, height());
			//htable->body->drawGhostCol(drag_pos - drag_offset, w);
			dragging = FALSE;
			int col = findCol(e->x());
			if(col < 0)
				col = (e->x() < 0) ? 0 : htable->ncols - 1;
			htable->moveCol(click_col, col);
			return;
		}
	}
	if(e->button()==Qt::LeftButton)
	{
		int col = findCol(e->x());
		if(col == findCol(press.x())) {
			htable->emit_click_signal(col);
		} else 
			if(click_col >= 0)
				;//updateCell(0, click_col);
	}
}

void TableHead::tip(const QPoint &pos)
{
	int col = findCol(pos.x());
	if(col != -1) {
		QString s = htable->tipText(col);
		if(!s.isEmpty()) {
			int x;
    		QToolTip::showText(pos, s);
		}
	}
}

// TableBody: the table body, scrollable in all ways
TableBody::TableBody(HeadedTable *parent) : 
	QtTableView(parent), htable(parent)
{
	//setTableFlags(Tbl_autoScrollBars | Tbl_smoothScrolling); 
	setTableFlags(Tbl_autoScrollBars); 
	setSizePolicy(QSizePolicy (QSizePolicy::Expanding,QSizePolicy::Expanding));
	((QScrollBar *)horizontalScrollBar())->setTracking(TRUE);
	first_drag_row = prev_drag_row = -1;
	autoscrolling = FALSE;
	gadget_click = FALSE;
	setMouseTracking (true);
}

QString TableBody::text(int row, int col)
{
    return htable->text(row,col);
}

class CellAttribute 
{
	public:
	QString text;
	bool selected;
	bool sorted;
	
	QColor	backColor;
	QColor  foreColor;
	int xpos;
	int ypos;
	int	w;
	int depth;
	int	folded;
};

// 1. text
// 2. forColor,BackColor
// 3. 
bool HeadedTable::isCellContentsChanged(int row,int col,bool head)
{
	CellAttribute *attr;
	int idx;
	int xpos;
	int	ypos;
	int	w;
	bool sorted = ( sortedCol()==col );
	bool selected,fold;
	int dep;
	QString str;
	w=max_widths[col];
	xpos=colXPos(col);

	if(head) 
	{
		str=title(col);
		selected=false;
		dep=0;
		fold=false;
		idx=0+col;
	}
	else
	{
		dep=rowDepth(row); //level
		fold=folded(row);
		str=text(row,col);
		selected =isSelected(row);
		idx=(row<<16)+col + 64;
	}
	//int yoffrel= body->yOffsetRel();  // check func
	//printf("yoffrel=%d\n",yoffrel);
	//printf("yoff=%d\n",body->yOffset());
	//ypos-=yoffrel;
	//ypos+=body->yOffset();
	
	/*
	if(last_row!=row)
	{
		//printf("row=%d ypos=%d yoff=%d\n",row,ypos,body->yOffset());
		last_row=row;
	}
	*/
	//convert2view(row,col);
	//int left = leftCell();
	//int top	 = topCell();
	//int vrow= row-top;
	//int vcol= col-left;	
	//if(vrow<0) printf("kkk-row=%d \n",vrow); //idx=(vrow<<16)+vcol;

	attr=cached_attr.value(idx,NULL);
	if(attr==NULL)
	{
		attr=new CellAttribute();
		attr->text=str;
		attr->selected=selected;
		attr->sorted=sorted;
		attr->xpos=xpos;
		//attr->ypos=ypos;
		attr->w=w;
		attr->depth=dep; //level
		attr->folded=fold;
		cached_attr.insert(idx,attr);
		////if(cached_attr.count() >= cached_attr.size()) cached_attr.resize(cached_attr.count()*2);
		
		return true;
	}
	else
	{
		bool result=false;
		if(		attr->text==str
				and attr->selected==selected 
				and attr->sorted==sorted
				and attr->xpos==xpos
		//		and attr->ypos==ypos
				and attr->w==w
			)
		{

		}
		else
		{
			attr->text=str;
			attr->selected=selected;
			attr->sorted=sorted;
			attr->xpos=xpos;
		//	attr->ypos=ypos;
			attr->w=w;
			result=true;
		}

		if(col==0)
		{
			if( attr->depth==dep
				and attr->folded==fold)
				;
			else
			{
				attr->depth=dep;
				attr->folded=fold;
				result=true;
			}
		}

		return result;
	}		
	return false;
}


// DRAFT CODE !!  BOTTLENECK !!!
// Description : draw a cell of table  
// 		1. draw the background of a cell
// 		2. draw the text of a cell
//
// called by
// 		1.QtTableView::paintEvent()
//				
void TableBody::paintCell(QPainter *p, int row, int col,bool update)
{
	int real_w=htable->max_widths[col];
	int w,h;
	bool sort;
 

	QColor normal_back=palette().brush(QPalette::Base).color();
	
	// *** sequence important !!!
	if(htable->isCellContentsChanged(row,col,false)==false)
	{
		if(update==true)	return;
	}

	w=real_w;
	sort = col == htable->sortedCol();
	
	p->setPen(normal_back.dark(105));
	p->drawLine(0, cellHeight() - 1, w, cellHeight() - 1); // underline

	h = cellHeight()- 1;
	if(htable->isSelected(row)) {  
		//if(sort)
		//	p->fillRect(0 , 0 , real_w , h ,colorGroup().highlight().light(100*0xd7/0xee) );
		//else
			p->fillRect(0 , 0 , real_w , h ,palette().brush(QPalette::Highlight));
		
		p->setPen(palette().brush(QPalette::HighlightedText).color()); // text 
	} 
	else 
	{
		if(sort){ 
			p->fillRect(0, 0 , real_w ,h , normal_back.dark(107) );
		}
		else {
			p->fillRect(0, 0 , real_w,h , normal_back );
		}
		p->setPen(palette().brush(QPalette::Text).color());
	}
	//real_w=cellUpdateR.width();	
	//real_w=p->clipRegion().boundingRect().width();
	htable->drawCellContents(row, col,real_w, cellHeight(), p);
}


// called by TableBody::wheelEvent ( QWheelEvent * e )
void TableBody::scrollUp()
{
	setYOffset(yOffset() - cellHeight());
}

void TableBody::scrollDown()
{
	setYOffset(yOffset() + cellHeight());
}

void TableBody::pageUp()
{
	setYOffset(yOffset() - viewHeight());
}

void TableBody::pageDown()
{
	setYOffset(yOffset() + viewHeight());
}

void TableBody::scrollLeft()
{	
	setXOffset(xOffset() - cellHeight());
}

void TableBody::scrollRight()
{
	// Qt bug: setXOffset() doesn't clamp to maximum offset
	setXOffset(qMin(xOffset() + cellHeight(), maxXOffset()));
}

//DEL , Home key 
void TableBody::jumpTop()
{
	setYOffset(0);
}

//DEL, End Key
void TableBody::jumpBottom()
{
	setYOffset(maxYOffset());
}

void TableBody::centerVertically(int row)
{
	int topcell = row - viewHeight() / (cellHeight()* 2);
	setTopCell(qMax(topcell, 0));
	update();
}

//??
void TableBody::showRange(int from, int to)
{
	int h = viewHeight() / cellHeight();
	if(to >= topCell() + h)
		setTopCell(qMax(0, qMin(from, to - h + 1)));
}

//virtual
//called by 
//	1.
int TableBody::cellWidth(int col)
{
	return htable->max_widths[col];
}

// **** fix !!
void TableBody::updateRow(int row)
{
	for(int col = 0; col < htable->ncols; col++)
		//updateCell(row, col,false);
		updateCell(row, col);
}

void TableBody::wheelEvent ( QWheelEvent * e )
{
	int i, count; 
	int vrows;
	vrows=viewHeight()/cellHeight();
	count=htable->nrows/vrows;
	count*=2;

	if( count > vrows) 
		count=vrows;

	if(e->delta() > 0)
	{
		for(i=0;i<count;i++)
			scrollUp();
			///setYOffset(yOffset() - cellheight);
	}
	else 
	{
		for(i=0;i<count;i++)
			scrollDown();
	}
}


void TableBody::mousePressEvent(QMouseEvent *e)
{
	if(numRows()==0) return;  // *** prevent out of range 

	int row = findRow(e->y());
	
	if(e->button() == Qt::LeftButton) {
		if(row == -1) {
			htable->clearAllSelections();
			if(e->y() >= 0)
				row = numRows();
			first_drag_row = prev_drag_row = row;
		} else {
			if(e->buttons() & Qt::ShiftModifier) {
				int col = findCol(e->x());
				if(col >= 0) {
					QString s = htable->text(row, col);
					for(int i = 0; i < numRows(); i++) {
						if(s == htable->text(i, col))
							htable->setSelected(i, TRUE);
						else if(!(e->buttons() & Qt::ShiftModifier))
							htable->setSelected(i, FALSE);
					}
				}
			} else {
				if(htable->treemode && htable->folding
						&& e->x() < htable->gadget_space
						+ htable->treestep * htable->rowDepth(row)
						&& htable->folded(row) != HeadedTable::Leaf) {
					htable->emit_fold(row);
					gadget_click = TRUE;
					return;
				}
				if(e->buttons() & Qt::ControlModifier)
					htable->setSelected(row, !htable->isSelected(row));
				else
					htable->selectOnly(row);
				first_drag_row = prev_drag_row = row;
			}
		}
		htable->selectionNotify();

	} else if((htable->options & HTBL_ROW_CONTEXT_MENU)
			&& e->button() == Qt::RightButton && row != -1) {
		if((htable->options & HTBL_ROW_SELECTION) && !htable->isSelected(row))
			htable->selectOnly(row);
		htable->selectionNotify();
		htable->emit_right_click_signal(e->globalPos());
	}
}

void TableBody::mouseDoubleClickEvent(QMouseEvent *e)
{
	if(htable->options & HTBL_ROW_DOUBLE_CLICK && e->button() == Qt::LeftButton) {
		int row = findRow(e->y());
		if(row != -1) {
			if(htable->options & HTBL_ROW_SELECTION
					&& !htable->isSelected(row))
				htable->selectOnly(row);
			htable->selectionNotify();
			htable->emit_double_click_signal(row);
		}
	}
}

#include "global.h"
#include "misc.h"
void TableBody::mouseMoveEvent(QMouseEvent *e)
{
	if(numRows()==0) return;  // *** prevent out of range 
	
	//DRAFT CODE !
	if(infobox!=NULL)
	{	
		if(htable->numSelected()>=2)
		{
			infobox->show();
			infobox->move(10+e->x(),htable->y()+e->y());
			int col=findCol(e->x());
			char *str=htable->total_selectedRow(col);
			
			if(str>0)
			{
				infobox->setText(str);
			}
			else
				infobox->hide();
		}
		else 
			infobox->hide();
	}
	
	if(e->buttons()== Qt::NoButton)	return;

	if(!(htable->options & HTBL_ROW_SELECTION)
			|| e->buttons() & Qt::ControlModifier || gadget_click)
		return;
	int row = findRow(e->y());
	if(row != prev_drag_row) {
		if(row == -1) {
			if(!autoscrolling) {
				// dragging outside table, cause scrolling
				scrolldir = (e->y() < 0) ? UP : DOWN;
			//	killTimers();
			//	startTimer(scroll_delay);
				autoscrolling = TRUE;
			}
		} else {
			////killTimers();
			autoscrolling = FALSE;
			dragSelectTo(row);
		}
	}
}

void TableBody::mouseReleaseEvent(QMouseEvent *)
{
	gadget_click = FALSE;
	if(autoscrolling) {
		////killTimers();		// no more autoscrolling
		first_drag_row = prev_drag_row = -1;
		autoscrolling = FALSE;
	}
}

void TableBody::timerEvent(QTimerEvent *)
{
	printf("timer\n");
	if(!autoscrolling) return;
	
	////killTimers();
	if(scrolldir == UP) {
		int top = topCell();
		setTopCell((top > 1) ? top - 1 : 0);
		dragSelectTo(topCell());
	} else {
		setTopCell(topCell() + 1);
		int bottom = lastRowVisible();
		dragSelectTo((bottom < numRows()) ? bottom : numRows() - 1);
	}
	startTimer(scroll_delay);
}

// change drag selection point from previous drag position to row
void TableBody::dragSelectTo(int row)
{
	int dir = (row > prev_drag_row) ? 1 : -1;
	if((prev_drag_row - first_drag_row) * dir >= 0) {
		// moving away from start point
		for(int i = prev_drag_row + dir; i - dir != row; i += dir)
			htable->setSelected(i, TRUE);
	} else {
		// moving towards start point
		for(int i = prev_drag_row; i != row; i += dir)
			htable->setSelected(i, FALSE);
	}
	prev_drag_row = row;
	htable->selectionNotify();
}

// heuristic for determining a good XOR color: This is in general a hard
// problem but since we know (most of) the background and the foreground,
// we can try. Note that this function might not return an allocated QColor,
// so it is only useful for XOR drawing.

QColor TableBody::getXorColor()
{
	QColor fg=palette().brush(QPalette::Base).color();

	return fg;/// QColor(0, fg.pixel() ^ backgroundColor().pixel());
}

void TableBody::drawGhostCol(int x, int w)
{
	static QColor xorcol = getXorColor();

	QPainter p(this);

	p.setPen(xorcol);
	//p.setRasterOp(XorROP);
	///p.drawLine(x, 0, x, height());
	////p.drawLine(x + w, 0, x + w, height());
}

// HeadedTable: the actually useable class
HeadedTable::HeadedTable(QWidget *parent, int opts): QWidget(parent), options(opts)
{
	head = new TableHead(this);
	body = new TableBody(this);
	head->setObjectName("head");
	body->setObjectName("body");

	sorted_col = -1;
	nrows = ncols = -1;
	nrows_prev=ncols_prev=-1;
	treemode	= false;
	lines		= true;
	folding 	= true;
	gadget_space = 0;
	
	//fontmetric=fontMetrics(); //static 

	setAttribute(Qt::WA_OpaquePaintEvent);
	setAttribute(Qt::WA_PaintOnScreen);
	head->setAttribute(Qt::WA_PaintOutsidePaintEvent);	
	
	QVBoxLayout *vlayout = new QVBoxLayout;
	//QHBoxLayout *hlayout = new QHBoxLayout;
	QScrollBar *vert=body->verticalScrollBar();
//	body->setAttribute(Qt::WA_OpaquePaintEvent);
//	body->setAttribute(Qt::WA_PaintOnScreen);
	body->setAttribute(Qt::WA_NoSystemBackground);
	body->setAutoFillBackground (false);

	vert->setAttribute(Qt::WA_OpaquePaintEvent);
	vert->setAutoFillBackground (false);

	//DEL	body->setAttribute(Qt::WA_PaintOutsidePaintEvent);	
//	hlayout->addWidget(body);
//	hlayout->addWidget(vert);
	vlayout->setSpacing (0);
	vlayout->setContentsMargins (0,0,0,0);
	//vlayout->setMainWidget (0);
 	vlayout->addWidget(head);
 	vlayout->addWidget(body);
	//vlayout->addLayout(hlayout);
    setLayout(vlayout);
	
	// connect keyboard shortcuts
/*	QAccel *acc = new QAccel(this);
	acc->connectItem(acc->insertItem(Key_Left),body, SLOT(scrollLeft()));
	acc->connectItem(acc->insertItem(Key_Right),body, SLOT(scrollRight()));
	acc->connectItem(acc->insertItem(Key_Home),body, SLOT(jumpTop()));
	acc->connectItem(acc->insertItem(Key_End),body, SLOT(jumpBottom()));
*/
	QShortcut *c;
	c=new QShortcut ( Qt::Key_Up, body, SLOT(scrollUp()) );
	c=new QShortcut ( Qt::Key_Down, body, SLOT(scrollDown()) );
	c=new QShortcut ( Qt::Key_PageUp, body, SLOT(pageUp()) );
	c=new QShortcut ( Qt::Key_PageDown, body, SLOT(pageDown()) );
	c=new QShortcut ( Qt::CTRL+Qt::Key_A, this, SLOT(selectAll()) );
    // synchronize horizontal scrolling of head and body
	connect(body->horizontalScrollBar(), SIGNAL(valueChanged(int)),head, SLOT(scrollSideways(int)));
	fontChange( font()) ; // *** need for init 
}

HeadedTable::~HeadedTable()
{
}

//ok
void HeadedTable::fontChange( const QFont & oldFont ) 
{
	printf("fontChange()\n");
	//int cellH=fontMetrics().lineSpacing();
	int cellH=fontMetrics().height();
	head->setCellHeight(cellH+5);
	head->setMinimumHeight(head->cellHeight());

	body->setCellHeight(cellH);
	treestep = cellH;
	gadget_space = folding ? cellH+ (cellH>> 1) : 0;
//	QWidget::fontChange ( oldFont );
}

void HeadedTable::setNumRows(int rows)
{
	nrows_prev=nrows;
	nrows = rows;
	body->setNumRows(rows);
}

// DRAFT
void HeadedTable::moveCol(int col, int place)
{
	//if(treemode && (place == 0 || oldplace == 0)) {
	//	resetWidth(col);
	//	resetWidth(place);
	//}
	//updateColWidths();
	//if(treemode && (place == 0 || oldplace == 0))
	//	repaintAll();
	//else
	//	repaintColumns(QMIN(place, oldplace), QMAX(place, oldplace));
	emit colMoved(col, place);
}


// distance (in table coords) from left table edge of physical column
int HeadedTable::colOffset(int col)
{
	int x = 0;
	for(int c = 0; c < col; c++)
		x += max_widths[c];
	return x;
}

inline int HeadedTable::colXPos(int col)
{
	int x = 0;
	for(int c = 0; c < col; c++)
		x += max_widths[c];
	return x;
}



// repaint columns from col0 to col1. If col1 is -1, repaint all
// the way to the right edge of the table.
// called by 
//          1.void Qps::update_table(int col)
void HeadedTable::repaintColumns(int col0, int col1)
{
	QRect bvr = body->viewRect();
	QRect hvr = head->viewRect();
	int x0 = colOffset(col0) - body->xOffset();
	if(x0 > hvr.width())
		return;
	if(x0 < 0)
		x0 = 0;
	bvr.setLeft(x0);
	hvr.setLeft(x0);
	if(col1 >= 0) {
		int x1 = colOffset(col1) + max_widths[col1] - body->xOffset();
		if(x1 < hvr.width()) {
			hvr.setRight(x1);
			bvr.setRight(x1);
		}
	}
	head->repaint(hvr);
	body->repaint(bvr);
}

//DEL ? 
void HeadedTable::setTreeMode(bool tm)
{
	if(tm != treemode) {
		treemode = tm;
		if(ncols >= 1)
			resetWidth(0);
	}
}


void HeadedTable::enableFolding(bool enable)
{
	if(folding != enable) {
		folding = enable;
		int c = body->cellHeight();
		gadget_space = folding ? c + (c >> 1) : 0;
		if(treemode) {
			if(ncols >= 1)
				resetWidth(0);
			topAndRepaint();
		}
	}
}

void HeadedTable::enableLines(bool enable)
{
	if(lines != enable) {
		lines = enable;
		if(treemode) {
			// repaint  column 0
			QRect r = body->viewRect();
			r.setLeft(body->xOffset());
			r.setRight(max_widths[0] - body->xOffset());
			//body->repaint(r);
			body->update(r);
		}
	}
}


// set sorted  column
void HeadedTable::setSortedCol(int col)
{

	if(col != sorted_col) {
		int old_sorted = sorted_col;
		sorted_col = col;
//		printf("old_sorted=%d\n",old_sorted);
//		printf("sorted_col=%d\n",sorted_col);
		if(old_sorted != -1 && old_sorted < ncols)  // ncols bug
			updateHeading(old_sorted);
		if(col != -1 && col < ncols)
			updateHeading(col);
	}
}


void HeadedTable::selectionNotify()
{
	///if(!affected_rows.size()) return;
	//emit selectionChanged(&affected_rows);
	//emit selectionChanged(1);
	///affected_rows.clear();
}

void HeadedTable::clearAllSelections()
{
	for(int row = 0; row < nrows; row++)
		setSelected(row, FALSE);
}

void HeadedTable::selectOnly(int row)
{
	for(int r = 0; r < nrows; r++)
		setSelected(r, r == row);
}

void HeadedTable::selectAll()
{
	for(int r = 0; r < nrows; r++)
		setSelected(r, true);
	selectionNotify();
}

//DEL
void HeadedTable::resizeEvent(QResizeEvent *e)
{
	printf("resizeEvent() HeadedTable %d\n",head->cellHeight());
	//head->setMinimumHeight(head->cellHeight());
	//head->setMinimumWidth(wid);
	//head->setGeometry(0, 0, width(), head->cellHeight());
	//int ybody = head->height();
	//body->setGeometry(0, ybody, width(), height() - ybody);
	QWidget::resizeEvent(e);
}


void HeadedTable::emit_click_signal(int col)
{
	emit titleClicked(col);
}

void HeadedTable::emit_double_click_signal(int row)
{
	emit doubleClicked(row);
}

void HeadedTable::emit_right_click_signal(QPoint where)
{
	emit rightClicked(where);
}

void HeadedTable::emit_fold(int row)
{
	emit foldSubTree(row);
}

// default implementation returns a null string (no tip displayed)
QString HeadedTable::tipText(int)
{
	return "";
}
char* HeadedTable::total_selectedRow(int col)
{
	return 0;
}

// Descrition :	draw the content of a cell of table 
// 		This is called after cell background has been painted
//
// called by
// 		1.void TableBody::paintCell(QPainter *p, int row, int col)
void HeadedTable::drawCellContents(int row, int col, int w, int h, QPainter *p)
{

	int c = body->cellHeight();
	int gap=c/4;
	if(treemode==true and col == 0) {
		QStyleOption opt;
		int d = rowDepth(row);

		if(lines) {
			///int dx = folding ? gadget_space : 6;
			for(int level = d, prow = row; level >= 0 and prow >= 0;level--, prow = parentRow(prow)) 
            {
				if(level==d) continue;
				int x = c/4 + level * treestep;
				QRect branchR(x,0,treestep,h);
				opt.rect=branchR;
				if(lastChild(prow)==false)
				{
					opt.state = QStyle::State_Sibling; // vertical line
         			style()->drawPrimitive(QStyle::PE_IndicatorBranch, &opt, p, this);
				}
			} 
			
			QRect branchR(c/4+d*treestep,0,treestep,h);
			opt.rect=branchR;
			opt.state = QStyle::State_Item ; //  "L" 
			if(!lastChild(row)) opt.state = opt.state | QStyle::State_Sibling ; //  "|" 
		}

		if(folding) {
			NodeState fs = folded(row);
			if(fs != Leaf) {
				opt.state = opt.state  | QStyle::State_Children;
				if(fs!=Closed) opt.state = opt.state  | QStyle::State_Open;
			}
		}
        style()->drawPrimitive(QStyle::PE_IndicatorBranch, &opt, p, this);
		gap =  gadget_space + d * treestep + c/5;
	} 

    QString s=text(row,col);
	if(alignment_col[col] == Qt::AlignRight)
		//p->drawText(0, 1, w - gap, h, Qt::AlignVCenter | alignment_col[col],s,&p->clipRegion().boundingRect());
		p->drawText(0, 1, w - gap, h, Qt::AlignVCenter | alignment_col[col],s);
	else 
		//p->drawText(gap, 1, w , h, Qt::AlignVCenter | alignment_col[col],s,&p->clipRegion().boundingRect());
		p->drawText(gap, 1, w , h, Qt::AlignVCenter | alignment_col[col],s);
	
}


// updates the table size of the table (size and presence of scrollbars)
void HeadedTable::updateTableSize()
{	
	//printf("updateTableSize\n");
	if(body->xOffset() > body->maxXOffset())
		body->setXOffset(body->maxXOffset());

	head->updateTableSize();
	body->updateTableSize();
	updateColWidths();
}

// move to top and repaint 
void HeadedTable::topAndRepaint()
{
	body->setAutoUpdate(FALSE);
	body->setYOffset(0);
	body->setAutoUpdate(TRUE);
	repaintAll();
}

// compute width of text in body cell with current font
int HeadedTable::bodyTextWidth(const char *s)
{
	return body->fontMetrics().width(s);
}

// compute width of text in heading with current font
int HeadedTable::headTextWidth(const char *s)
{
	return head->fontMetrics().width(s) + 4;
}

//virtual
int HeadedTable::sizeHintForColumn(int col) const
{
	return -1;
}	

//virtual
int  HeadedTable::alignment(int cols)
{
	return 0;
}

void HeadedTable::setNumCols(int cols)
{
	//printf("cols=%d\n",cols);
	ncols_prev=ncols;
	ncols = cols;
	
	resetWidths();
	for(int i = 0; i < cols; i++)
	{
		alignment_col[i]=alignment(i);
		updateColWidth(i);
	}

	/*
	int w=head->width()- head->totalWidth();
	if(w>0)
	{	
		//printf("ddddddddddd\n");
		virtual_last_column=false;
		max_widths[ncols] =w;
		//ncols++;
	}
	else virtual_last_column=false;
	*/
//	printf("ncols=%d\n",ncols);
	head->setNumCols(ncols);
	body->setNumCols(ncols);
}
//???
// Update the QtTableView's notion of horizontal offset in case column
// widths have changed. Nothing is repainted.
void HeadedTable::updateColWidths()
{
	// Updating the internal state is only done in QtTableView::setOffset(),
	// so we are forced to the following contortion. The bug has been
	// reported (QtTableView::updateTableSize() should have done it but
	// doesn't).

	//printf("DEBUG : updateColWidths !!! check this function\n");
	int xo = head->xOffset();
	setAutoUpdate(FALSE);
	head->setOffset(0, head->yOffset(), FALSE);
	head->setOffset(xo, head->yOffset(), FALSE);
	body->setOffset(0, body->yOffset(), FALSE);
	body->setOffset(xo, body->yOffset(), FALSE);
	setAutoUpdate(TRUE);
}

//virtual
/*
int HeadedTable::colWidth(int col)
{
//	int r = numRows(); 
//	for(int i=0;i<r;i++)	text(i,col);
} */

// BOTTLENECK
// find Max width of a column 
// called by 
//		1.  void HeadedTable::setNumCols(int cols)
int HeadedTable::updateColWidth(int col)
{
	int w = 0;
	int sw= 0;
	int hw= 0;
	int i = 0;
	int r = numRows(); 
	bool treecol = treemode && col == 0;
	
	static int max_treecol=30;
	
		
	if((w=sizeHintForColumn(col))>0)
	{
		max_widths[col] = w;
		return 0;
	}

	// harsh, if procs more than 1000 
	for(i = 0; i < r; i++) {
		sw = fontMetrics().width(text(i,col))+10;
		if(treecol)	sw += treestep * rowDepth(i);
		if(sw > w) w = sw;
	}

	if(treecol) 
	{
		w += gadget_space;
		int d=max_treecol- w;

		if (d>0)
		{
			if (d>100)
			max_treecol=w;
			else
				w=max_treecol;
		}
		else
			max_treecol=w;
	
	}
	// don't forget the width of the heading
	hw = fontMetrics().width(title(col))+12;
	//return 0;
	if(hw > w) w = hw;
	
	//sw=fontmetric.width("0") * colWidth(col);
	//if(sw>w) w=sw;
	
	max_widths[col] = w;
	return 0;
}

void HeadedTable::resetWidths()
{
	for(int i = 0; i < numCols()+1; i++)
		max_widths[i]=0;
}

// called by 
// dont use cached text
void HeadedTable::repaintAll()
{
	body->update();
	head->update(); 
}


// DRAFT CODE !!! DRAFT CODE !!!
// 1. paintEvent()
// 2. 
// tmp:: drawCellContents()
// updateColWidth(int col)
//
// problem : update() call  +  repaint() will be draw twice !!!
//
void HeadedTable::repaint_changed()
{
	
	if(1)
	{
		if(numRows()>nrows_prev)
		{
		
		}
		else 
		{
			body->flag_update=true;
			head->flag_update=true;
		}
		head->repaint();
		body->repaint();
		body->flag_update=false;
		head->flag_update=false;
		
	return;
	}
	// view_port range
	/* 
	 *		+----------------------------+
	 *		|							 |
	 *		|							 |
	 *		+----------------------------+
	 */
	int rows = numRows();
	int cols = numCols();
	int left = leftCell(), right = lastColVisible();
	int top	 = topCell(), bottom = lastRowVisible();
	
	if(right	>= cols) right = cols - 1; //???
	if(bottom	>= rows) bottom = rows - 1;
	// if width[col] be changed ,then the right of [col] should be repainted !
	// repaintColumns(c,-1);
	//printf("left=%d \n",left);

	for(int c = left ; c <= right; c++)
	{
        head->updateCell(0, c,false); 
		if(c>=ncols_prev)	head->updateCell(0, c,true); 
	}

	for(int r = top; r <= bottom; r++) {
		for(int c = left; c <= right; c++) {
			body->updateCell(r, c,false);
			if(c>=ncols_prev)
				body->updateCell(r, c,true); // forced rewrite
		}
		if( r>=nrows_prev  ) 
			body->updateRow(r);
	}
	//body->update();
	head->setXOffset(body->xOffset()); //  Temporary test(by fasthyun@magicn.com) 
	return;
}


