/*
 * trayicon.h - system-independent trayicon class (adapted from Qt example)
 * Copyright (C) 2003  Justin Karneges
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef CS_TRAYICON_H
#define CS_TRAYICON_H


#include <QWidget>
#include <QMenu>

#include	<X11/Xlib.h>
///#include	<X11/Xutil.h>
#include	<X11/Xatom.h>

//----------------------------------------------------------------------------
// TrayIconPrivate
//----------------------------------------------------------------------------

class TrayIconPrivate;

class TrayIcon : public QWidget
{
	Q_OBJECT
public:
	TrayIcon( const QPixmap &, const QString &, QMenu *popup = 0, QWidget *parent = 0, const char *name = 0 );
	~TrayIcon();
	
	// use WindowMaker dock mode.  ignored on non-X11 platforms
	void setWMDock(bool use)  { v_isWMDock = use; }
	bool isWMDock() { return v_isWMDock; }
	bool hasSysTray() { return boolSysTray; }
	void setSysTray(bool val) { boolSysTray=val; }

	// Set a popup menu to handle RMB
	void setPopup( QMenu * );
	QMenu* popup() const;

	QPixmap icon() const;

	void sysInstall();
	void sysRemove();
	
	bool checkNewTrayEvent ( XEvent *xev );
	void init_TrayIconFreeDesktop();
	void init_WindowMakerDock();
	void test_xapp();

public slots:
	void setIcon( const QPixmap &icon );
	void setToolTip( const QString &tip );
	void newTrayOwner();
signals:
	void clicked( const QPoint& );
	void clicked( const QPoint&, int);
	void doubleClicked( const QPoint& );
	void closed();

protected:	
//	bool event( QEvent *e );
	virtual void mouseMoveEvent( QMouseEvent *e );
	virtual void mousePressEvent( QMouseEvent *e );
	virtual void mouseReleaseEvent( QMouseEvent *e );
	virtual void mouseDoubleClickEvent( QMouseEvent *e );
	virtual void leaveEvent ( QEvent * );

	void paintEvent(QPaintEvent *);
	void resizeEvent ( QResizeEvent *e );
//	void hideEvent ( QHideEvent *e ); // called after hide()
	bool x11Event(XEvent*);
	void closeEvent ( QCloseEvent * e );

private:
	QMenu *pop;
	QPixmap pm;
	QString tip;
	QPoint	tip_pos;

	bool v_isWMDock;
	bool boolSysTray;
	bool inTray;
	bool flag_systray_ready;
	bool flag_show_tip;

	Window systray_window;
	Atom manager_atom;
	Atom selection_atom; 
	Window	dummy_window;

	//DEL void sysUpdateToolTip();
};



#endif // CS_TRAYICON_H
