// dialogs.h			emacs, this is a -*-c++-*- file
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997-1999

// misc. handy dialogs for use everywhere

#ifndef DIALOGS_H
#define DIALOGS_H

#include <qdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qslider.h>

#include "misc.h"

class IntervalDialog : public QDialog {
	Q_OBJECT
	public:
		IntervalDialog(const char *ed_txt, bool toggle_state);

	protected slots:
		void done_dialog();
		void event_label_changed();
	public:
		QString ed_result;
		CrossBox *toggle;

	protected:
		QPushButton *ok, *cancel;
		QLabel *label;
		QLineEdit *lined;
};

class SliderDialog : public QDialog {
    Q_OBJECT
public:
    SliderDialog(int defaultval, int minval, int maxval);

    QString ed_result;

protected slots:
    void slider_change(int val);
    void done_dialog();

protected:
    QPushButton *ok, *cancel;
    QLabel *label;
    QLineEdit *lined;
    QSlider *slider;
};

#endif	// DIALOGS_H
