#include <eter/__py_tinker_property.h>

namespace py_tinker {

extern PyTypeObject PyCppProperty_Type;

struct PyCppProperty_SObject
{
	PyObject_HEAD
	IProperty*	pr_cpp_property;
};

PyObject* PyCppProperty_FromProperty(IProperty* cpp_Property)
{
	PyCppProperty_SObject* ret_property = (PyCppProperty_SObject*)PyType_GenericAlloc(&PyCppProperty_Type, 0);	
	ret_property->pr_cpp_property = cpp_Property;
	return (PyObject*)ret_property;	
}

void PyCppProperty_Destruct(PyCppProperty_SObject* Property)
{
	if (Property->pr_cpp_property)
	{
		delete Property->pr_cpp_property;
		Property->pr_cpp_property = NULL;
	}
}

extern "C"
{

static int
PyCppProperty_DescrSet(PyObject* self, PyObject* obj, PyObject* value)
{	
	PyCppProperty_SObject* property = (PyCppProperty_SObject*)self;

	property->pr_cpp_property->set_value(obj, value);
	return 0;
}

static PyObject *
PyCppProperty_DescrGet(PyObject* self, PyObject* obj, PyObject* cls)
{
	PyCppProperty_SObject* property = (PyCppProperty_SObject*)self;

	// UnboundCppProperty
	if (!obj)
	{
		Py_INCREF(self);
		return self;
	}

    return property->pr_cpp_property->get_value(obj);
}

static PyObject *
PyCppProperty_Repr(PyCppProperty_SObject* property)
{
	char repr[256];
	snprintf(repr, sizeof(repr)-1, "<%s %s at 0x%p>", property->ob_type->tp_name, property->pr_cpp_property->GetName().c_str(), property);
	return PyString_FromString(repr);
}

static void
PyCppProperty_Dealloc(PyCppProperty_SObject* property)
{
	PyCppProperty_Destruct(property);
	
	property->ob_type->tp_free(property);	
}

PyTypeObject PyCppProperty_Type = {
    PyObject_HEAD_INIT(&PyType_Type)
    0,
    "py_tinker.cpp.Property",
    sizeof(PyCppProperty_Type),
    0,
    (destructor)PyCppProperty_Dealloc,       /* tp_dealloc */
    0,                                  /* tp_print */
    0,                                  /* tp_getattr */
    0,                                  /* tp_setattr */
    0,                                  /* tp_compare */
    (reprfunc)PyCppProperty_Repr,    /* tp_repr */
    0,                                  /* tp_as_number */
    0,                                  /* tp_as_sequence */
    0,                                  /* tp_as_mapping */
    0,                                  /* tp_hash */
    0,                              /* tp_call */
    0,                                  /* tp_str */
    0,						          /* tp_getattro */
    0,								   /* tp_setattro */
    0,                                  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT /* | Py_TPFLAGS_HAVE_GC */,/* tp_flags */
    0,                                  /* tp_doc */
    0, // (traverseproc)func_traverse,          /* tp_traverse */
    0,                                  /* tp_clear */
    0,                                  /* tp_richcompare */
    0, //offsetof(PyFunctionObject, func_weakreflist), /* tp_weaklistoffset */
    0,                                  /* tp_iter */
    0,                                  /* tp_iternext */
    0,                                  /* tp_Propertys */
    0, // func_memberlist,              /* tp_members */
    0,                /* tp_getset */
    0,                                  /* tp_base */
    0,                                  /* tp_dict */
    PyCppProperty_DescrGet,                 /* tp_descr_get */
    PyCppProperty_DescrSet,                                  /* tp_descr_set */
    0, //offsetof(PyFunctionObject, func_dict),      /* tp_dictoffset */
    0,                                      /* tp_init */
    0,									/* tp_alloc */
    0,							/* tp_new */
    PyObject_Del,									/* tp_free */                                       
};


} // end of extern "C"


} // py_tinker




















