// py_ex_except.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <eter/py_tinker.h>

struct data
{
	int m_x;
	int m_y;
	int m_z;
	data(int x, int y, int z)
	{
		m_x = x;
		m_y = y;
		m_z = z;
	}
};

void show_data_ref(const data& d)
{
	printf("ref %d %d %d\n", d.m_x, d.m_y, d.m_z);
}

py_tinker::class_<data> builddata()
{
	using namespace py_tinker;
	return class_<data>("data", construct3<data, int, int, int>())
		;
}

impl_arg_class_(data)

void initeter()
{
	py_tinker::module_("eter")
		.defv("show_data", show_data_ref)
		.def(builddata())		
		;
}


int main(int argc, char* argv[])
{
	Py_Initialize();
	Py_SetProgramName((char*)"py_test");
			
	initeter();
	py_tinker::PyEmbed_RunMainFile("ex_except.py");
	Py_Finalize();	

	return 0;
}
