#pragma once

#define WIN32_LEAN_AND_MEAN

#include <windows.h>

class ELGameWindow_MessageHandler
{
public:
	ELGameWindow_MessageHandler() {}
	virtual ~ELGameWindow_MessageHandler() {}

	virtual void	OnIdle() = 0;
	virtual LRESULT OnDispatchMessage(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
};

bool	ELGameWindow_Startup();
void	ELGameWindow_Cleanup();
void	ELGameWindow_Show();
void	ELGameWindow_Hide();
void	ELGameWindow_Loop();
void	ELGameWindow_SetMessageHandler(ELGameWindow_MessageHandler& msgHandler);
void	ELGameWindow_AdjustWindowSize(int width, int height);

ELGameWindow_MessageHandler& ELGameWindow_GetDefaultMessageHandler();

HWND	ELGameWindow_GetHandle();
HDC		ELGameWindow_GetDC();
void	ELGameWindow_ReleaseDC(HDC hDC);