from devil import *

import gwnd
import raw
import dib

gwnd.startup()
gwnd.adjust_size(320, 240)

ilInit()

img = ilGenImage()
ilBindImage(img)
ilLoad(IL_TYPE_UNKNOWN, "test.tga")
ilConvertImage(IL_BGRA, IL_UNSIGNED_BYTE)

src_data = ilGetData()
src_width = ilGetInteger(IL_IMAGE_WIDTH)
src_height = ilGetInteger(IL_IMAGE_HEIGHT)

dc = gwnd.get_dc()

dst = dib.dib()
dst.create(dc, 100, 100)
print dst.width(), dst.height()

gwnd.release_dc(dc)

src_iter = raw.raw32_iterator(src_data, src_width, src_width, src_height)
dst_iter = raw.raw32_iterator(dst.data(), dst.width(), dst.width(), dst.height())

for n in range(0, src_height):
	dst_iter.puts(src_width, src_iter.quick_peeks(src_width))
	dst_iter.next_line()	
	src_iter.next_line()
	
ilDeleteImage(img)

gwnd.show()

dc = gwnd.get_dc()
dst.draw(dc, 0, 0)
gwnd.release_dc(dc)


gwnd.loop()
gwnd.cleanup()
