'''
'''
import re
import sys, os
import StringIO
import config

templateTag = re.compile('<:(.*?(<:.*?:>.*?)*):>', re.DOTALL)

def templateProcessor(template, globalNS = None, localNS=None):
    if globalNS == None:
        globalNS = {}
    if localNS == None:
        localNS = {}
    def repl(match):
        try:
            stdout = sys.stdout
            block = match.group(1).strip()
            if not block:
                return ''
            if block[0] != '#':
                return templateProcessor(str(eval(block, globalNS, localNS)), globalNS, localNS)
            lines = block.split('\n')
            line = lines[0]
            if line.strip() == '#statements':
                sbuf = StringIO.StringIO()
                codeBlock = '\n'.join(lines[1:]) + '\n'
                sys.stdout = sbuf
                exec codeBlock in globalNS, localNS
                sys.stdout = stdout
                return templateProcessor(sbuf.getvalue(), globalNS, localNS)
            elif line.startswith('#include'):
                fname = line.split()[1]
                path = os.path.join(config.skinPath, fname)
                return templateProcessor(getTemplate(path), globalNS, localNS)
        except Exception, errMsg:
            sys.stdout = stdout
            return 'ERROR:%s (%s)' % (str(errMsg), block)
    html = templateTag.sub(repl, template)
    return html

tempCache = {}
def getTemplate(path):
    path = os.path.normpath(path)
    template = tempCache.get(path)
    #if template:
    #    return template
    template = open(path).read()
    tempCache[path] = template
    return template
