'''
'''
import MySQLdb
import config

debug = 0
g_conn = None
g_cursor = None


def extractNames(T):
    if isinstance(T, (tuple, list)):
        L = []
        for ele in T:
            L.extend(extractNames(ele))
        return L
    else:
        return [T]

def getTableNames(cursor, obj='tables'):
    cursor.execute('show %s' % obj)
    return extractNames(cursor.fetchall())

def getFieldInfo(tableName):
    cursor = getCursor()
    cursor.execute('DESCRIBE %s' % tableName)
    return cursor.fetchall()

def getFieldNames(tableName):
    L = getFieldInfo(tableName)
    return [f[0] for f in L]

def connectDB():
    global g_conn
    if g_conn:
        return g_conn
    g_conn = MySQLdb.connect(host=config.dbhost, user=config.dbuser,
                             passwd=config.dbpassword, db=config.dbname)
    return g_conn

def disconnectDB(connect):
    connect.close()

def getCursor():
    global g_cursor
    if g_cursor:
        return g_cursor
    conn = connectDB()
    g_cursor = conn.cursor()
    return g_cursor

def removeDB():
    db = MySQLdb.connect(host=config.dbhost, user=config.dbuser, passwd=config.dbpassword)
    cursor = db.cursor()
    registeredDBNames = getTableNames(cursor, 'databases')
    if config.dbname in registeredDBNames:
        cursor.execute('DROP DATABASE %s' % config.dbname)
    
def makeDB():
    db = MySQLdb.connect(host=config.dbhost, user=config.dbuser, passwd=config.dbpassword)
    cursor = db.cursor()
    registeredDBNames = getTableNames(cursor, 'databases')
    if config.dbname in registeredDBNames:
        if debug:
            print 'WARNING : DATABASE %s is already defined' % config.dbname
        return False
    else:
        if debug:
            print 'Creating DATABASE %s' % config.dbname
        cursor.execute('create database %s' % config.dbname)
        return True

def makeArticleTable(cursor, tableName):
    cursor.execute('''CREATE TABLE %s (
        id INT NOT NULL AUTO_INCREMENT,
        threadId INT NOT NULL,
        offset INT NOT NULL,
        ip VARCHAR(30),
        date DATETIME,
        mdate DATETIME,
        readCount INT,
        uid VARCHAR(32) NOT NULL,
        upload1 VARCHAR(255),
        downCount1 INT,
        htmltag BIT DEFAULT 0,
        emoticon BIT DEFAULT 0,
        bbcode BIT DEFAULT 1,
        notify BIT DEFAULT 0,
        subject VARCHAR(%s),
        body TEXT,
        PRIMARY KEY(id),
        INDEX (threadId, offset)
        )''' % (tableName, config.subjectLength))

def makeThreadTable(cursor, tableName):
    cursor.execute('''CREATE TABLE %s (
        threadId INT NOT NULL AUTO_INCREMENT,
        type INT,
        mdate DATETIME,
        readCount INT,
        starter VARCHAR(32) NOT NULL,
        lastPoster VARCHAR(32) NOT NULL,
        replies INT,
        subject VARCHAR(%s),
        PRIMARY KEY(threadId),
        INDEX (threadId, type),
        INDEX (subject, type),
        INDEX (starter, type),
        INDEX (replies, type),
        INDEX (readCount, type),
        INDEX (mdate, type),
        INDEX (type)
        )''' % (tableName, config.subjectLength))

def makeTables():
    cursor = getCursor()
    registeredTableNames = map(lambda name: name.lower(), getTableNames(cursor))
    cnt = 0
    for category in config.dbTables:
        categoryName = category[0]
        forums = category[1:]
        for forum in forums:
            tableName = forum[0]
            if tableName not in registeredTableNames:
                makeArticleTable(cursor, tableName)
                makeThreadTable(cursor, tableName+'Thread')
                if debug:
                    print 'TABLE %s %s created' % (tableName, tableName+'Thread')
                cnt += 1
    return cnt

def removeTables():
    cursor = getCursor()
    registeredTableNames = map(lambda name: name.lower(), getTableNames(cursor))
    cnt = 0
    for category in config.dbTables:
        categoryName = category[0]
        forums = category[1:]
        for forum in forums:
            tableName = forum[0]
            if tableName.lower() in registeredTableNames:
                cursor.execute('DROP TABLE %s' % tableName)
                cursor.execute('DROP TABLE %s' % tableName+'Thread')
                if debug:
                    print 'TABLE %s removed' % tableName
                cnt += 1
    return cnt

def makeUserTable():
    cursor = getCursor()
    registeredTableNames = map(lambda name: name.lower(), getTableNames(cursor))
    if config.userTableName.lower() not in registeredTableNames:
        cursor.execute('''CREATE TABLE %s (
                    uid VARCHAR(32) NOT NULL,
                    name VARCHAR(32) NOT NULL,
                    email VARCHAR(128) NOT NULL,
                    passwd CHAR(32) NOT NULL,
                    level TINYINT UNSIGNED NOT NULL,
                    mType1 VARCHAR(24),
                    mId1 VARCHAR(128),
                    mType2 VARCHAR(24),
                    mId2 VARCHAR(128),
                    homepage VARCHAR(128), 
                    location VARCHAR(32),
                    occupation VARCHAR(32),
                    interests VARCHAR(64), 
                    signature VARCHAR(255), 
                    viewOnline BIT,
                    threadEmailNotice BIT,
                    memoEmailNotice BIT,
                    loginCount INT UNSIGNED, 
                    totalPosts INT UNSIGNED, 
                    lastLoginTime DATETIME,
                    registeredTime DATETIME,                   
                    PRIMARY KEY(uid),
                    INDEX (uid),
                    INDEX (registeredTime),
                    INDEX (location),
                    INDEX (occupation)
            )''' % config.userTableName)
        if debug:
            print 'TABLE %s created' % config.userTableName
        return True
    else:
        if debug:
            print 'WARNING : TABLE %s was not created' % config.userTableName
        return False

def removeTable(tableName):
    cursor = getCursor()
    registeredTableNames = map(lambda name: name.lower(), getTableNames(cursor))
    if tableName.lower() in registeredTableNames:
        cursor.execute('DROP TABLE %s' % tableName)
        return True
    return False

def removeUserTable():
    return removeTable(config.userTableName)

def makeMemoTable():
    cursor = getCursor()
    registeredTableNames = map(lambda name: name.lower(), getTableNames(cursor))
    if config.memoTableName.lower() not in registeredTableNames:
        cursor.execute('''CREATE TABLE %s (
                    id INT NOT NULL AUTO_INCREMENT,
                    fromId VARCHAR(20) NOT NULL,
                    toId VARCHAR(20) NOT NULL,
                    receivedLink BIT DEFAULT 1,
                    sentLink BIT DEFAULT 1,
                    ip VARCHAR(30),
                    date DATETIME,
                    rdate DATETIME,
                    subject VARCHAR(%s) NOT NULL,
                    body TEXT,
                    PRIMARY KEY(id)
            )''' % (config.memoTableName, config.subjectLength))
        if debug:
            print 'TABLE %s created' % config.memoTableName
        return True
    else:
        if debug:
            print 'WARNING : TABLE %s was not created' % config.memoTableName
        return False    

def removeMemoTable():
    return removeTable(config.memoTableName)

def makeEmoticonTable():
    cursor = getCursor()
    tableName = config.emoticonTableName
    registeredTableNames = map(lambda name: name.lower(), getTableNames(cursor))
    if tableName.lower() not in registeredTableNames: 
        cursor.execute('''CREATE TABLE %s (
                    id INT NOT NULL AUTO_INCREMENT,
                    code varchar(20) NOT NULL,
                    filename varchar(100) NOT NULL,
                    PRIMARY KEY (id)
            )''' % tableName)
        if debug:
            print 'TABLE %s created' % tableName
        return True
    else:
        if debug:
            print 'WARNING : TABLE %s was not created' % tableName         
        return False  

def removeEmoticonTable():
    return removeTable(config.emoticonTableName)
