'''
'''
import os
import cgi
import config
import dblib
import users
import htmlValidate
from bbslib import *

class MemoBox(list, Tree):
    standard_html = 'memoBox.teul'
    def __init__(self, uid, sentMemo=False, order='desc'):
        self.cursor = dblib.getCursor()
        self.uid = uid
        if sentMemo:
            self.where = 'fromId'
        else:
            self.where = 'toId'
        self.order = order
        self.parent = None

    def getNotReadMemoCount(self):
        self.cursor.execute("SELECT count(*) FROM %s WHERE toId='%s' and rdate='0000-00-00 00:00:00'" % (config.memoTableName, self.uid))
        return self.cursor.fetchone()[0]
    	
    def refresh(self):
        if self.where == 'fromId':
            self.cursor.execute("SELECT * FROM %s WHERE fromId='%s' and sentLink=1" % (config.memoTableName, self.uid))
        else:
            self.cursor.execute("SELECT * FROM %s WHERE toId='%s' and receivedLink=1" % (config.memoTableName, self.uid))
        memoList = list(self.cursor.fetchall())
        self[:] = []
        for fields in memoList:
            self.append(Memo(*fields))

    def sortSendDate(self):  # FIXME
        if self.order == 'asc':
            self.sort(lambda b, a: cmp(a.date, b.date))
        else:
            self.sort(lambda a, b: cmp(a.date, b.date))

    def sortReadDate(self):  # FIXME
        if self.order == 'asc':
            self.sort(lambda b, a: cmp(a.rdate, b.rdate))
        else:
            self.sort(lambda a, b: cmp(a.rdate, b.rdate))

    def sortSubject(self):  # FIXME
        if self.order == 'asc':
            self.sort(lambda a, b: cmp(a.subject.lower(), b.subject.lower()))
        else:
            self.sort(lambda b, a: cmp(a.subject.lower(), b.subject.lower()))

    def sortUser(self):  # FIXME
        if self.order == 'asc':
            if self.where == 'toId':
                self.sort(lambda a, b: cmp(a.fromId.lower(), b.fromId.lower()))
            else:
                self.sort(lambda a, b: cmp(a.toId.lower(), b.toId.lower()))
        else:
            if self.where == 'toId':
                self.sort(lambda b, a: cmp(a.fromId.lower(), b.fromId.lower()))
            else:
                self.sort(lambda b, a: cmp(a.toId.lower(), b.toId.lower()))

class Memo(Message, Tree):
    standard_html = 'memo.teul'
    def __init__(self, id=None, fromId='', toId='', receivedLink=1, sentLink=1, ip='',
                 date='0000-00-00 00:00:00',
                 rdate='0000-00-00 00:00:00', subject='', body=''):
        self.parent = None
        self.id = id
        self.fromId = fromId
        self.toId = toId
        self.ip = ip and ip or os.environ.get('REMOTE_ADDR', 'localhost')
        self.date = date
        self.rdate = rdate
        self.subject = subject
        self.body = body
        self.receivedLink = receivedLink
        self.sentLink = sentLink
        self.escapeSubjectAndBody()
        self.escapeBodyHtml()
        if rdate=='0000-00-00 00:00:00':
            self.notRead = True
        else:
            self.notRead = False
        self.getUsers()

    def getUsers(self):
        try:
            self.sender = users.getUser(self.fromId)
            self.receiver = users.getUser(self.toId)
        except Exception, errMsg:
            pass
        
    def escapeSubjectAndBody(self):
        self.escapedSubjectForDb = escapeTextForDb(self.subject)
        self.escapedBodyForDb = escapeTextForDb(self.body)
        
    def escapeBodyHtml(self):
        self.escapedHtmlBody = bbcode.bbCodeProcessor(escapeWhiteSpace(cgi.escape(self.body)))
        
    def checkRead(self, uid):
        if self.id and uid == self.toId and self.rdate == '0000-00-00 00:00:00':
            cursor = dblib.getCursor()
            cursor.execute("UPDATE %s SET rdate='%s' WHERE id=%s and toId='%s'"\
              % ( config.memoTableName, time.strftime('%Y-%m-%d %H:%M:%S'), self.id, uid))
            return True
        return False

    def send(self):
        if not users.getUser(self.toId):
            raise users.InvalidUser
        cursor = dblib.getCursor()
        self.setCurrentDateAndTime()
        cursor.execute("INSERT INTO %s VALUES %s" % (config.memoTableName, self.toSQL()))
        return cursor.insert_id()

    def toSQL(self):
        self.escapeSubjectAndBody()
        return "('%(id)s','%(fromId)s', '%(toId)s', 1, 1, '%(ip)s', "\
            "'%(date)s', '%(rdate)s', "\
            "'%(escapedSubjectForDb)s', '%(escapedBodyForDb)s')" % self.__dict__

    def __repr__(self):
        return """fromId : %(fromId)s
toId : %(toId)s
ip : '%(ip)s'
date : '%(date)s'
subject : '%(subject)s'
body : '%(body)s'
""" % self.__dict__
        
def readMemo(uid, id):
    cursor = dblib.getCursor()
    cursor.execute("SELECT * FROM %s WHERE id=%s and (toId='%s' or fromId='%s')" % (config.memoTableName, id, uid, uid))
    if cursor.rowcount:
        return Memo(*cursor.fetchone())
    else:
        return False

def sendMemo(memo):
    if not users.getUser(memo.toId):
        return False
    cursor = dblib.getCursor()
    memo.setCurrentDateAndTime()
    cursor.execute("INSERT INTO %s VALUES %s" % (config.memoTableName, memo.toSQL()))
    return cursor.insert_id()

def deleteMemo(id, uid, isSent=False):
    cursor = dblib.getCursor()
    dmemo = readMemo(uid, id)
    if isSent and dmemo.sentLink == 1:
        dmemo.sentLink = 0
    if not isSent and dmemo.receivedLink == 1:
        dmemo.receivedLink = 0
    if dmemo.sentLink == 0 and dmemo.receivedLink == 0:
        cursor.execute("DELETE FROM %s WHERE id=%s and (toId='%s' or fromId='%s')" % ( config.memoTableName, id, uid, uid))
    else:
        # update link fields
        cursor.execute("UPDATE %s SET sentLink=%s, receivedLink=%s WHERE id=%s" %
                       (config.memoTableName, dmemo.sentLink, dmemo.receivedLink, id))
    return True
