'''
'''

from __future__ import generators
import os, sys
import time
import re

ERROR_LOG_FILE = 'errlog.txt'
LOG_FILE = 'log.txt'

class ErrorLogger:
    def __init__(self, logging=True):
        self.logging = logging

    def log(self, fileName, errMsg):
        if self.logging:
            f = open(ERROR_LOG_FILE, 'a')
            f.write('[%s], [%s], %s, [%s], [%s], [%s]\n' % (
                        time.strftime('%Y/%m/%d:%H:%M:%S'),
                        fileName,
                        errMsg,
                        os.environ['REMOTE_ADDR'],
                        os.environ['REQUEST_URI'],
                        os.environ['HTTP_USER_AGENT']))

def log(uid, msg, arg=''):
    '''Log Information
    user, action, (action parameters), ip, url, time, agnet
    '''
    #f = open('%s%s' % (LOG_FILE, time.strftime('%Y%m%d')), 'a')   # daily log
    f = open(LOG_FILE, 'a')
    f.write('%s %s %s (%s) [%s] [%s] [%s]\n' % (
                uid,
                os.environ['REMOTE_ADDR'],
                msg,
                arg,
                os.environ['REQUEST_URI'],
                time.strftime('%Y/%m/%d:%H:%M:%S'),
                os.environ['HTTP_USER_AGENT']))


def reverseLineGenerator(fname):
    f = open(fname)
    f.seek(0, 2)
    size = f.tell()
    L = []
    k = 1
    while k <= size:
        f.seek(-k, 2)
        ch = f.read(1)
        if ch == '\n':
            if L:
                L.reverse()
                yield ''.join(L)
                L = []
        else:
            L.append(ch)
        k += 1
    if L:
        L.reverse()
        yield ''.join(L)

class LogInfo:
    paramp = re.compile('\((.*?)\)')
    bracketp = re.compile('\[(.*?)\]')
    def __init__(self, line):
        L = line.split()
        self.uid, self.ip, self.action = L[:3]
        self.params = self.paramp.findall(line)[0]
        if self.action == 'do_reply':
            self.forumId, self.threadId, tmp, self.articleId = \
                self.params.split()
        elif self.action == 'do_editArticle':
            self.forumId, self.threadId, self.articleId = \
                self.params.split()
        elif self.action == 'do_deleteArticle':
            self.forumId, self.threadId, self.articleId = \
                self.params.split()
        elif self.action == 'do_newThread':
            self.forumId, self.threadId = \
                self.params.split()
        self.url, self.time, self.browser = self.bracketp.findall(line)
    def __repr__(self):
        return '%s %s %s (%s) [%s] [%s] [%s]' % (self.uid, self.ip, self.action,
                                                 self.params, self.url, self.time, self.browser)
        
class WebLogAnalyzer:
    def getRecentLogsForModifiedArticles(self, N):
        count = 0
        deletedArticleList = []
        for line in reverseLineGenerator(LOG_FILE):
            log = LogInfo(line)
            #uid, ip, action = line.split()[:3]
            if log.action in ('do_editArticle', 'do_reply'):
                if (log.forumId, log.articleId) in deletedArticleList:
                    continue
                yield log
                count += 1
                if count >= N:
                    break
            elif log.action in ('do_deleteArticle', 'deleteArticle'):
                deletedArticleList.append((log.forumId, log.articleId))

    def getRecentModifiedArticles(self, N):
        import bbslib
        groups = bbslib.getGroups()
        for log in self.getRecentLogsForModifiedArticles(N):
            yield groups.getArticle(log.forumId, log.threadId, log.articleId)
        
    def getRecentLogsForNewThreads(self, N):
        count = 0
        deletedArticleList = []
        for line in reverseLineGenerator(LOG_FILE):
            log = LogInfo(line)
            if log.action in ('do_newThread',):
                if (log.forumId, log.threadId) in deletedArticleList:
                    continue
                yield log
                count += 1
                if count >= N:
                    break
            elif log.action in ('do_deleteThread', ):
                deletedArticleList.append((log.forumId, log.threadId))

    def getRecentNewThreads(self, N):
        import bbslib
        groups = bbslib.getGroups()
        for log in self.getRecentLogsForNewThreads(N):
            yield groups.getThread(log.forumId, log.threadId)
