import re

linkPattern = re.compile('([\w\-_\.]+@[\w\-_\.]+)|(http://\S+)', re.I)

def linkProcessor(text):
    def linkReplace(match):
        link = match.group()
        pos = match.start()
        spos = max(pos-15, 0)
        if text[spos:pos].lower().find('href=') >= 0 or text[spos:pos].lower().find('src=') >= 0:
            return link
        if link.lower().startswith('http'):
            return '<a href="%s" target="_blank">%s</a>' % (link, link)
        return '<a href="mailto:%s">%s</a>' % (link, link)
    return linkPattern.sub(linkReplace, text)
