'''
'''

def i16(c):
    return ord(c[1]) + (ord(c[0])<<8)

def i32(c):
    return ord(c[3]) + (ord(c[2])<<8) + (ord(c[1])<<16) + (ord(c[0])<<24)



def gifSize(fileValue): # FIXME
    x = ord(fileValue[6]) + (ord(fileValue[7])<<8)
    y = ord(fileValue[8]) + (ord(fileValue[9])<<8)
    return x, y

def pngSize(fileValue): # FIXME
    len = i32(fileValue[8:12])
    s = fileValue[16:16+len]
    x, y = i32(s), i32(s[4:])
    return x, y


NONE = [65480, 65488, 65489, 65490, 65491, 65492, 65493, 65494, 65495, 65496, 65497, 65520, 65521, 65522, 65523, 65524, 65525, 65526, 65527, 65528, 65529, 65530, 65531, 65532, 65533]
SKIP = [65476, 65484, 65498, 65499, 65500, 65501, 65503, 65504, 65505, 65506, 65507, 65508, 65509, 65510, 65511, 65512, 65513, 65514, 65515, 65516, 65517, 65518, 65519, 65534]
SOF = [65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487, 65502]

def moveMarker(fileValue, pos):
    len = fileValue[pos:pos+2]
    pos += i16(len)
    return pos

def jpegSize(fileValue):
    pos = 0
    s = fileValue[0]
    pos += 1
    while 1:
        s = s + fileValue[pos]
        pos += 1
        i = i16(s)
        if i in SKIP or i in SOF or i in NONE:
            if i in SKIP:
                pos = moveMarker(fileValue, pos)
            elif i in SOF:
                len = fileValue[pos:pos+2]
                pos += 2
                len = i16(len)
                s2 = fileValue[pos:pos+len]
                pos += len
                x, y = i16(s2[3:]), i16(s2[1:])
                return x, y
            elif i in NONE:
                pass
            elif i == 0xFFDA:
                break
            s = fileValue[pos]
            pos += 1
        elif i == 0xffff:
            s = "\xff"
        else:
            break
    return False
    
def imageSize(fileValue):
    if fileValue[:3] == 'GIF':
        return gifSize(fileValue)
    elif fileValue[1:4] == 'PNG':
        return pngSize(fileValue)
    elif fileValue[:2] == '\xff\xd8':
        return jpegSize(fileValue)
    else:
        return False
    
    
    
