'''
'''

from xml.sax import handler, make_parser, parseString
import sgmllib
import StringIO
import re
from i18n import _

class WellFormednessChecker(sgmllib.SGMLParser):
    notCloseingAllowedTagList = ['br', 'p', 'hr', 'ul', 'ol', 'li', 'td', 'tr', 'dd', 'dt', 'layer', 'ilayer', 'img', 'area', 'embed', 'input', 'option']
    def __init__(self, file=None):
        sgmllib.SGMLParser.__init__(self)
        self.tags = []
        if file:
            self.load(file)

    def load(self, file):
        for line in file:
            self.feed(line)
        self.close()

    def feed(self, data):
        """Feed some data to the parser.

        Call this as often as you want, with as little or as much text
        as you want (may include '\n').  (This just saves the text,
        all the processing is done by goahead().)
        """

        self.rawdata = self.rawdata + data
        self.updatepos(0, len(self.rawdata))
        self.goahead(0)
        
    def close(self):
        sgmllib.SGMLParser.close(self)
        self.tags.reverse()
        for tag, pos in self.tags:
            if tag.lower() not in self.notCloseingAllowedTagList:
                raise SyntaxError, ('ERROR in body (%s, %s)' % pos) + _("start tag &lt;%s&gt; not closed") % self.tags[-1][0]

    def unknown_starttag(self, start, attrs):
        row, col = self.getpos()
        if row > 1:
            row -= 1
        self.tags.append((start, (row, col)))

    def unknown_endtag(self, end):
        start, pos = self.tags.pop()
        while end != start:
            if start not in self.notCloseingAllowedTagList:
                raise SyntaxError, ('ERROR in body (%s, %s)' % self.getpos()) + _("end tag &lt;/%s&gt; doesn't match start tag &lt;%s&gt;") % (end, start)
            start, pos = self.tags.pop()
    
def validate(s):
    c = WellFormednessChecker()
    c.load(StringIO.StringIO(s))
