from __future__ import generators
import cgi
import os
import glob
import types
import time
import string

import pyConfigParser
from templateProcessor import templateProcessor, getTemplate
import logger

class Configuration:
    intList = ['HTTP_PORT', 'numberOfArticlesInAPage', 'numberOfTitlesInAPage', 'numberOfUsersInAPage'
        'anonymousLevel', 'waitingLevel', 'memberLevel', 'adminLevel',
        'sessionRemoveProbability', 'sessionLife', 'maxFileSize', 
        'maxUserCache', 'maxUserListCache', 'maxArticleCache', 'maxThreadCachePerForum',
        'maxUserListPages',
        ]

    def __init__(self):
        self.dict = {}
        self.load()
        
    def load(self):
        cfg = pyConfigParser.CookedConfigParser()
        cfg.readfp(open(os.path.join('.', 'setup.cfg')))
        for section in cfg.sections():
            for option in cfg.options(section):
                if option in self.intList:
                    value = cfg.getint(section, option)
                else:
                    value = cfg.get(section, option)
                if section.lower() == 'paths':
                    while value and value[0] == '/':
                        value = value[1:]
                    value = os.path.normpath(value)
                self.dict[option] = value
        self.sections = cfg.sections()
    def __getattr__(self, name):
        return self.dict[name]
        
    def makeItGlobal(self):
        d = globals()
        d.update(self.dict)

    def updateOne(self, section, option, value):
        cfg = pyConfigParser.CookedConfigParser()
        cfg.readfp(open(os.path.join('.', 'setup.cfg')))
        if not (cfg.has_section(section) and cfg.has_option(section, option)):
            return False
        cfg.set(section, option, value)
        cfg.write(open(os.path.join('.', 'setup.cfg'), 'w'))
        self.load()
        return True
    
    def toHTML(self, globalNS):
        html = 'pybbsConfig.teul'
        template = getTemplate(os.path.join(skinPath, html))
        sections = self.sections.copy()
        theseSectionsDoNotPrint = ['DB setup', 'paths']
        sections = pyConfigParser.MyDict()
        for section in self.sections:
#            if section in theseSectionsDoNotPrint:
#                continue
            sections[section] = pyConfigParser.MyDict()
            for option in self.sections[section]:
                if option != '__name__':
                    sections[section][option] = self.sections[section][option]
        sections['site information']['skinPath'] = self.sections['paths']['skinPath']
        for section in theseSectionsDoNotPrint:
            del sections[section]
        return templateProcessor(template, globalNS, locals())
    

fields = '''ForumName ForumDescription Lock Moderator
            View Read Post Reply Edit Delete Sort Order UserGroupList'''.split()
def loadCategory(conf):
    iniList = open(os.path.join('.', conf.groupDescFileName)).readlines()
    iniList = filter(None, iniList)
    global dbTables
    dbTables = []
    pos = 0
    for fname in iniList:
        fname = fname.strip()
        cfg = pyConfigParser.CookedConfigParser()
        cfg.readfp(open(os.path.join('.', fname)))
        dbTables.append(CategoryConfig( [decode2Str(os.path.splitext(fname)[0])] ))
        for section in cfg.sections():
            forumCfg = []
            forumCfg.append(section)
            for field in fields:
                if cfg.has_option(section, field):
                    forumCfg.append(cfg.get(section, field))
            dbTables[pos].append(ForumConfig(forumCfg))
        pos += 1

def saveGroupDescFile():
    newIniList = []
    for category in dbTables:
        categoryName = category[0]
        forums = [x for x in category if type(x) == types.TupleType]
        cfg = pyConfigParser.CookedConfigParser()
        for forum in forums:
            forumId = forum[0]
            cfg.add_section(forumId)
            for key, value in zip(fields, forum[1:]):
                cfg.set(forumId, key, value)
        cfg.write(open(os.path.join('.', encode2Hex(categoryName)+'.ini'), 'w'))
        newIniList.append(encode2Hex(categoryName)+'.ini')
    open(os.path.join('.', groupDescFileName), 'w').write('\n'.join(newIniList))


class CategoryConfig(list):
    def getName(self):
        return self[0]
    def getForumConfigs(self):
        for forum in self[1:]:
            yield forum
    __iter__ = getForumConfigs

class ForumConfig(list):
    attrList = 'id name description lock moderator view read post reply edit delete sortby order'.split()
    def __getattr__(self, name):
        return self[self.attrList.index(name)]
    
def getCategories():
    for category in dbTables:
        yield category

def getForumNameById(forumId):
    for category in dbTables:
        for forum in category:
            if forum.id == forumId:
                return forum.name
    return False

def getForumConfigById(forumId):
    for category in dbTables:
        for forum in category:
            if forum.id == forumId:
                return forum
    return False


cfg_defaults = {
    'dbhost' : 'localhost',
    'dbuser' : 'dbuser',
    'dbpassword' : 'dbpassword',
    'dbname' : 'dbname',

    'databaseEngine':'mysql',
    'dbTables' : [],
    'tablePrefix' : 'PyBB',
    'userTableName': 'user',
    'memoTableName' : 'memo',
    'emoticonTableName': 'emoticons',
    'subjectLength' : 90,
    
    'userGroupConfigFile':'userGroup.ini',
    'groupDescFileName': 'groupDesc.txt',
    'maxUserCache': 30,
    'UserIdLengthMin':3,
    'UserIdLengthMax':32,

    'siteName':'Python Forum',
    'smtpHOST' : 'localhost',
    'smtpCharset' : 'euc-kr',

    'sessionLife' : 1000,
    'sessionRemoveProbability' : 100,
    'sessionDir' : './Session/',

    'adminLevel' : 10,
    'memberLevel' : 2,
    'waitingLevel' : 1,
    'anonymousLevel' : 0,
    
    'avatarFilePath': 'images/avatars',
    'avatarExts': ['.jpg', '.jpeg', '.gif', '.png'],
    'skinPath': 'skins/standard1',
    'emoticonPath': 'emoticons',
    'uploadPath': 'upload',
    'maxFileSize':1048576,

    'numberOfArticlesInAPage': 10,
    'numberOfTitlesInAPage': 10,

    'maxUserCache' : 20,
    'maxUserListCache' : 5,
    'maxArticleCache' : 100,
    'maxThreadCachePerForum' : 200,
}

def makeDefaultConfigGlobal():
    for key, val in cfg_defaults.items():
        if key not in globals():
            if key.endswith('TableName'):
                val = globals().get('tablePrefix', cfg_defaults['tablePrefix']) +'_' + val
            globals()[key] = val
    globals()['skinImagePath'] = skinPath + '/images'

######################        
def reload():
    conf.load()
    loadCategory(conf)
    conf.makeItGlobal()

######################        
allowedChars = string.ascii_letters + string.digits
def encode2Hex(s):
    L = []
    for ch in s:
        if ch not in allowedChars:
            ch = '_%x' % ord(ch)
        L.append(ch)
    return ''.join(L)

def decode2Str(s):
    chList = s.split('_')
    if len(chList) < 2:
        return s
    res = ''
    isStart = True
    for ch in chList:
        if len(ch) < 2:
            res += ch
        else:
            if isStart and chList:
                res += ch
            else:
                res += chr(int(ch[:2], 16))
                res += ch[2:]
        isStart = False
    return res

conf = Configuration()
errlogger = logger.ErrorLogger(conf.errorLogging)
reload()
makeDefaultConfigGlobal()
