# -*- Mode: Python -*-

import re, sys, os
import StringIO
from cgi import FieldStorage as cgiFieldStorage
import cgi
import urlparse
import asyncore
from medusa import http_server
from medusa import default_handler
from medusa import logger
from medusa import script_handler
from medusa import filesys

import pybbs
from bbs import config
from bbs import exceptionLib

CONTENT_LENGTH = re.compile ('Content-Length: ([0-9]+)', re.IGNORECASE)
g_request = None

header2env= {
        'Content-Length'        : 'CONTENT_LENGTH',
        'Content-Type'          : 'CONTENT_TYPE',
        'Referer'               : 'HTTP_REFERER',
        'User-Agent'            : 'HTTP_USER_AGENT',
        'Accept'                : 'HTTP_ACCEPT',
        'Accept-Charset'        : 'HTTP_ACCEPT_CHARSET',
        'Accept-Language'       : 'HTTP_ACCEPT_LANGUAGE',
        'Host'                  : 'HTTP_HOST',
        'Connection'            : 'CONNECTION_TYPE',
        'Authorization'         : 'HTTP_AUTHORIZATION',
        'Cookie'                : 'HTTP_COOKIE',
        }

class sample_input_collector:
    def __init__ (self, request, length):
        self.request = request
        self.length = length

    def collect_incoming_data (self, data):
        print 'data from %s: <%s>' % (self.request, repr(data))

class my_default_handler(default_handler.default_handler):
    def handle_request(self, request):
        path = request.split_uri()[0]
        dirPath, fname = os.path.split(path)
        if dirPath == '/' and (fname.endswith('.ini') or fname.endswith('.cfg')):
            request.error (404)
            return
        default_handler.default_handler.handle_request(self, request)
        
class post_script_handler (script_handler.script_handler):
    extension = 'py'
    script_regex = re.compile (
		r'.*/([^/]+\.%s)' % extension,
		re.IGNORECASE
	)

    def __init__(self, *args):
        script_handler.script_handler.__init__(self, *args)
        cgi.FieldStorage = FieldStorage

    def handle_request (self, request):
        global g_request
        request.version = '1.1'
        os.environ['REMOTE_ADDR'] = request.channel.addr[0]
        os.environ['HTTP_COOKIE'] = ''
        for item in request.header:
            left, right = item.split(': ')
            if left in header2env:
                os.environ[header2env[left]] = right
        for key, value in os.environ.items():
            if not value:
                del os.environ[key]
        if request.command == 'POST':
            cl = default_handler.get_header(CONTENT_LENGTH, request.header)
            ic = sample_input_collector(request, cl)
            request.collector = ic
            print request.header

        g_request = request
        [path, params, query, fragment] = request.split_uri()

        while path and path[0] == '/':
            path = path[1:]
        if '%' in path:
            path = default_handler.unquote (path)

        os.environ['REQUEST_URI'] = "/" + path
        if not self.filesystem.isfile (path):
            request.error (404)
            return
        else:
            self.hits.increment()

            request.script_filename = self.filesystem.translate (path)

            if request.command in ('PUT', 'POST'):
                # look for a Content-Length header.
                cl = request.get_header ('content-length')
                length = int(cl)
                script_handler.collector (self, length, request)
                if not cl:
                    request.error (411)
                elif length > int(config.maxFileSize):
                    if length <  config.maxFileSize * 1.5:
                        script_handler.collector (self, length, request)
                    request.reply_code = 200
                    request['Content-Type'] = 'text/html'
                    s = '''
<HTML><HEAD>
<TITLE>ERROR : Too Big File</TITLE>
</HEAD><BODY>
<b>The file you tried to upload exceeds maximum size. Try smaller one.</b>
</BODY></HTML>
'''
                    request['Content-Length'] = len(s)
                    request.push (s)
                    request.done()
                    return
                else:
                    script_handler.collector (self, length, request)
            else:
                self.continue_request (
                        request,
                        StringIO.StringIO() # empty stdin
                        )

    def continue_request (self, request, stdin):
        temp_files = stdin, StringIO.StringIO(), StringIO.StringIO()
        old_files = sys.stdin, sys.stdout, sys.stderr

        if self.restricted:
            r = rexec.RExec()

        try:
            sys.request = request
            sys.stdin, sys.stdout, sys.stderr = temp_files
            try:
                if request.script_filename.endswith('pybbs.py'):
                    pybbs.run()
                elif self.restricted:
                    r.s_execfile (request.script_filename)
                else:
                    execfile (request.script_filename)
                request.reply_code = 200
            except exceptionLib.Redirect, msg:
                request.reply_code = 302
                newUri = msg[0]
            except Exception, msg:
                request.reply_code = 500
                self.exceptions.increment()
        finally:
            sys.stdin, sys.stdout, sys.stderr = old_files
            del sys.request

        i,o,e = temp_files

        if request.reply_code in (301, 302):
            newUri = urlparse.urljoin('http://%s:%s' % (config.HOST_URL, config.HTTP_PORT), newUri)
            header = o.getvalue()
            for line in header.split('\n'):
                if not line.strip():
                    continue
                fields = line.split(':')
                request[fields[0]] = ':'.join(fields[1:]).strip()
            request['Location'] = newUri
            request['Content-Type'] = 'text/html'
            s = '''
<HTML><HEAD>
<TITLE>%s Found</TITLE>
</HEAD><BODY>
<H1>Found</H1>
The document has moved to <A HREF="%s">here</A>.<P>
</BODY></HTML>
''' % (request.reply_code, newUri)

        elif request.reply_code != 200:
            s = e.getvalue()
            print 'ERROR:', msg
            print
        else:
            s = o.getvalue()
            blocks = s.split('\r\n\r\n')
            header = blocks[0]
            for line in header.split('\n'):
                line = line.rstrip()
                tokens = line.split(':')
                key = tokens[0]
                value = ':'.join(tokens[1:])
                request[key] = value
            s = '\r\n\r\n'.join(blocks[1:])

        request['Content-Length'] = len(s)
        request.push (s)
        request.done()

def FieldStorage():
    '''simulation of FieldStorage in standard cgi module'''
    request = g_request
    if not request: return cgiFieldStorage()
    dicHeader = {}
    for varPart in request.header:
        varKeyValuePair= varPart.split(": ")
        dicHeader[varKeyValuePair[0].lower()]=varKeyValuePair[1]
    if 'content-type' not in dicHeader:
        dicHeader['content-type'] = "application/x-www-form-urlencoded"

    dicEnvir = {}
    dicEnvir['REQUEST_METHOD'] = request.command

    [path, params, query, fragment] = request.split_uri()

    if query:
        dicEnvir['QUERY_STRING'] = query[1:]
    form = cgiFieldStorage(fp=sys.stdin,headers=dicHeader,environ=dicEnvir)
    return form

pid = os.getpid()
open('pid.log', 'w').write('%s\n' % pid)
lg = logger.file_logger (open('http.log', 'a'))
fs = filesys.os_filesystem ('.')
#dh = default_handler.default_handler (fs)
dh = my_default_handler (fs)
ph = post_script_handler (fs)
hs = http_server.http_server ('', config.HTTP_PORT, logger_object = lg)

hs.install_handler (dh)
hs.install_handler (ph)

asyncore.loop()
