%include "init.inc"

[org 0]
	jmp 07C0h:start

start:
	mov ax, cs
	mov ds, ax
	mov es, ax
;-----------added-------;
reset:
	mov ax, 0
	mov dl, 0
	int 13h
	jc reset
;-----------------------;
	mov ax, 0xB800
	mov es, ax
	mov di, 0
	mov ax, word[msgBack]
	mov cx, 0x7FF

paint:
	mov word [es:di], ax
	add di, 2
	dec cx
	jnz paint

read:
	mov ax, 0x1000
	mov es, ax
	mov bx, 0

	mov ah, 2
	mov al, 1
	mov ch, 0
	mov cl, 2
	mov dh, 0
	mov dl, 0
	int 13h

	jc read

	mov dx, 0x3F2
	xor al, al
	out dx, al

	cli
;---------added--------;
	mov al, 0x11	; init PIC
	out 0x20, al	; master PIC
	dw 0x00EB, 0x00EB ; jmp $+2, jmp $+2
	out 0xA0, al	; slave PIC
	dw 0x00EB, 0x00EB

	mov al, 0x20	; start point of interrupt : master PIC
	out 0x21, al
	dw 0x00EB, 0x00EB
	mov al, 0x28	; start point of interrupt : slave PIC
	out 0xA1, al
	dw 0x00Eb, 0x00EB

	mov al, 0x04	; IRQ pin number 2 of master PIC
	out 0x21, al	; connected slave PIC
	dw 0x00EB, 0x00EB
	mov al, 0x02	; slave PIC is connected
	out 0xA1, al	; IRQ pin number 2 of master PIC
	dw 0x00EB, 0x00EB

	mov al, 0x01	; mode 8086
	out 0x21, al
	dw 0x00EB, 0x00EB
	out 0xA1, al
	dw 0x00EB, 0x00EB
	mov al, 0xFF	; cut all of interrupt of slace PIC
	out 0xA1, al
	dw 0x00EB, 0x00EB
	mov al, 0xFB	; cut all of interrupt of master PIC except IRQ pin number 2
	out 0x21, al
;------------------------;
	lgdt[gdtr]

	mov eax, cr0
	or eax, 0x00000001
	mov cr0, eax

	jmp $+2
	nop
	nop

	mov bx, SysDataSelector
	mov ds, bx
	mov es, bx
	mov fs, bx
	mov gs, bx
	mov ss, bx

	jmp dword SysCodeSelector:0x10000

	msgBack db '.', 0x67

gdtr:
	dw gdt_end - gdt -1
	dd gdt+0x7C00

gdt:
	dd 0, 0
	dd 0x0000FFFF, 0x00CF9A00
	dd 0x0000FFFF, 0x00CF9200
	dd 0x8000FFFF, 0x0040920B

gdt_end:

times 510-($-$$) db 0
dw 0AA55h
