/*
 * Decompiled with CFR 0.152.
 */
package org.codemaru;

import java.io.PrintStream;
import org.codemaru.ConfigFactory;
import org.codemaru.Log;
import org.codemaru.util.DateUtil;

public class ConsoleLog
implements Log {
    static Log instance = null;
    int logLevel = ConfigFactory.getInstance().getLogLevel();
    static final int DEBUG = 0;
    static final int INFO = 1;
    static final int WARNING = 2;
    static final int ERROR = 3;
    static final int FATAL = 4;

    private ConsoleLog() {
    }

    public static Log getInstance() {
        if (instance == null) {
            instance = new ConsoleLog();
        }
        return instance;
    }

    private synchronized void log(int type, String log) {
        if (type < this.logLevel) {
            return;
        }
        PrintStream out = type == 2 | type == 3 ? System.err : System.out;
        switch (type) {
            case 0: {
                out.print("[D][");
                break;
            }
            case 1: {
                out.print("[I][");
                break;
            }
            case 2: {
                out.print("[W][");
                break;
            }
            case 3: {
                out.print("[E][");
                break;
            }
            case 4: {
                out.print("[F][");
            }
        }
        out.print(DateUtil.getDateFormat());
        out.print("] ");
        out.println(log);
    }

    public void debug(String log) {
        this.log(0, log);
    }

    public void error(String log) {
        this.log(3, log);
    }

    public void fatal(String log) {
        this.log(4, log);
    }

    public void info(String log) {
        this.log(1, log);
    }
}

